/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPTextSequenceUtilities {
    private static final Pattern COMMENT_END_PATTERN = Pattern.compile("[*]/");
    private static final String START_LINE_COMMENT = "//";
    private static final String START_BLOCK_COMMENT = "/*";
    private static final char END_LINE = '\n';
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("function\\s", 2);
    private static final Pattern CLASS_PATTERN = Pattern.compile("(class|interface)\\s", 2);
    private static final String LBRACE = "{";
    private static final String RBRACE = "}";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String COMMA = ",";
    private static final String LBRACKET = "[";
    private static final String RBRACKET = "]";

    private PHPTextSequenceUtilities() {
    }

    public static TextSequence getStatement(int offset, IStructuredDocumentRegion sdRegion, boolean removeComments) {
        int documentOffset = offset;
        if (documentOffset == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPhpToken(0) : phpScriptRegion.getPhpToken(offset - startOffset - 1);
                while (startTokenRegion.getStart() != 0) {
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE" || startTokenRegion.getType() == "PHP_CURLY_OPEN" || startTokenRegion.getType() == "PHP_SEMICOLON") {
                        startOffset += startTokenRegion.getEnd();
                        break;
                    }
                    startTokenRegion = phpScriptRegion.getPhpToken(startTokenRegion.getStart() - 1);
                }
                TextSequence textSequence = TextSequenceUtilities.createTextSequence(sdRegion, startOffset, offset - startOffset);
                if (removeComments) {
                    textSequence = PHPTextSequenceUtilities.removeComments(textSequence);
                }
                textSequence = textSequence.subTextSequence(PHPTextSequenceUtilities.readForwardSpaces(textSequence, 0), textSequence.length());
                return textSequence;
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private static TextSequence removeComments(TextSequence textSequence) {
        List<IRegion> comments = PHPTextSequenceUtilities.collectComments(textSequence);
        int i = comments.size() - 1;
        while (i >= 0) {
            IRegion commentStartRegion = comments.get(i);
            textSequence = textSequence.cutTextSequence(commentStartRegion.getOffset(), commentStartRegion.getOffset() + commentStartRegion.getLength());
            --i;
        }
        return textSequence;
    }

    private static List<IRegion> collectComments(TextSequence textSequence) {
        StringBuffer buffer = new StringBuffer(textSequence);
        ArrayList<IRegion> commentRegions = new ArrayList<IRegion>();
        int start = 0;
        int foundIndex = 0;
        while ((foundIndex = buffer.indexOf("/", start)) != -1) {
            int commentStartPosition = foundIndex;
            String currentType = TextSequenceUtilities.getType(textSequence, commentStartPosition);
            if (PHPPartitionTypes.isPHPCommentState(currentType) && !PHPPartitionTypes.isPHPQuotesState(currentType) && commentStartPosition + 2 < textSequence.length()) {
                String startCommentString = textSequence.subSequence(commentStartPosition, commentStartPosition + 2).toString();
                if (startCommentString.equals(START_BLOCK_COMMENT)) {
                    Matcher commentEndMatcher = COMMENT_END_PATTERN.matcher(textSequence);
                    boolean foundEnd = commentEndMatcher.find(commentStartPosition);
                    if (foundEnd) {
                        int commentEndPosition = commentEndMatcher.end();
                        Region range = new Region(commentStartPosition, commentEndPosition - commentStartPosition);
                        commentRegions.add((IRegion)range);
                        start = commentEndPosition;
                        continue;
                    }
                    start = commentStartPosition + 2;
                    continue;
                }
                if (startCommentString.equals(START_LINE_COMMENT)) {
                    int commentEndPosition = commentStartPosition + 2;
                    while (commentEndPosition < textSequence.length()) {
                        if (textSequence.charAt(commentEndPosition) == '\n') {
                            Region range = new Region(commentStartPosition, commentEndPosition - commentStartPosition);
                            commentRegions.add((IRegion)range);
                            start = commentEndPosition;
                            break;
                        }
                        ++commentEndPosition;
                    }
                    start = commentStartPosition + 2;
                    continue;
                }
                start = commentStartPosition + 1;
                continue;
            }
            start = commentStartPosition + 2;
        }
        return commentRegions;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static int getMethodEndIndex(CharSequence textSequence, int offset) {
        int length = textSequence.length();
        while (offset < length && Character.isWhitespace(textSequence.charAt(offset))) {
            ++offset;
        }
        if (offset >= length) return -1;
        if (textSequence.charAt(offset) != '(') return -1;
        ++offset;
        while (offset < length && textSequence.charAt(offset) != ')') {
            ++offset;
        }
        if (textSequence.length() <= offset) return -1;
        if (textSequence.charAt(offset) != ')') return -1;
        return offset + 1;
    }

    public static int isInFunctionDeclaration(TextSequence textSequence) {
        Matcher matcher = FUNCTION_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            String type;
            int functionStart = matcher.start();
            if (functionStart != 0 && Character.isJavaIdentifierStart(textSequence.charAt(functionStart - 1)) || !PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, functionStart + 1))) continue;
            int offset = matcher.end();
            while (offset < textSequence.length()) {
                if (textSequence.charAt(offset) == ')' && PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, offset))) break;
                ++offset;
            }
            if (offset != textSequence.length()) continue;
            return functionStart;
        }
        return -1;
    }

    public static int isInClassDeclaration(TextSequence textSequence) {
        Matcher matcher = CLASS_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            int endOffset;
            String type;
            int startOffset = matcher.start();
            if (startOffset != 0 && Character.isJavaIdentifierStart(textSequence.charAt(startOffset - 1)) || !PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, startOffset + 1))) continue;
            int offset = endOffset = matcher.end();
            while (offset < textSequence.length()) {
                if (textSequence.charAt(offset) == '}' && PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, offset))) break;
                ++offset;
            }
            if (offset != textSequence.length()) continue;
            return endOffset;
        }
        return -1;
    }

    public static int readNamespaceStartIndex(CharSequence textSequence, int startPosition, boolean includeDollar) {
        boolean onBackslash = false;
        boolean onWhitespace = false;
        int oldStartPosition = startPosition;
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                if (ch == '\\') {
                    if (onBackslash) break;
                    onBackslash = true;
                    onWhitespace = false;
                } else {
                    if (!Character.isWhitespace(ch)) break;
                    onWhitespace = true;
                    onBackslash = false;
                }
            } else {
                if (onWhitespace) break;
                onBackslash = false;
                onWhitespace = false;
            }
            --startPosition;
        }
        if (includeDollar && startPosition > 0 && textSequence.charAt(startPosition - 1) == '$') {
            --startPosition;
        }
        int n = startPosition = startPosition >= 0 ? PHPTextSequenceUtilities.readForwardSpaces(textSequence, startPosition) : startPosition;
        if (startPosition > oldStartPosition) {
            startPosition = oldStartPosition;
        }
        return startPosition;
    }

    public static int readNamespaceEndIndex(CharSequence textSequence, int startPosition, boolean includeDollar) {
        boolean onBackslash = false;
        boolean onWhitespace = false;
        int length = textSequence.length();
        if (includeDollar && startPosition < length && textSequence.charAt(startPosition) == '$') {
            ++startPosition;
        }
        while (startPosition < length) {
            char ch = textSequence.charAt(startPosition);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                if (ch == '\\') {
                    if (onBackslash) break;
                    onBackslash = true;
                    onWhitespace = false;
                } else {
                    if (!Character.isWhitespace(ch)) break;
                    onWhitespace = true;
                    onBackslash = false;
                }
            } else {
                if (onWhitespace) break;
                onBackslash = false;
                onWhitespace = false;
            }
            ++startPosition;
        }
        return startPosition >= 0 ? PHPTextSequenceUtilities.readBackwardSpaces(textSequence, startPosition) : startPosition;
    }

    public static int readIdentifierStartIndex(CharSequence textSequence, int startPosition, boolean includeDolar) {
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != '_') break;
            --startPosition;
        }
        if (includeDolar && startPosition > 0 && textSequence.charAt(startPosition - 1) == '$') {
            --startPosition;
        }
        return startPosition;
    }

    public static int readIdentifierEndIndex(CharSequence textSequence, int startPosition, boolean includeDolar) {
        int length = textSequence.length();
        if (includeDolar && startPosition < length && textSequence.charAt(startPosition) == '$') {
            ++startPosition;
        }
        while (startPosition < length) {
            char ch = textSequence.charAt(startPosition);
            if (!Character.isLetterOrDigit(ch) && ch != '_') break;
            ++startPosition;
        }
        return startPosition;
    }

    public static int readIdentifierStartIndex(PHPVersion phpVersion, CharSequence textSequence, int startPosition, boolean includeDollar) {
        if (phpVersion.isLessThan(PHPVersion.PHP5_3)) {
            return PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, startPosition, includeDollar);
        }
        return PHPTextSequenceUtilities.readNamespaceStartIndex(textSequence, startPosition, includeDollar);
    }

    public static int readIdentifierEndIndex(PHPVersion phpVersion, CharSequence textSequence, int startPosition, boolean includeDollar) {
        if (phpVersion.isLessThan(PHPVersion.PHP5_3)) {
            return PHPTextSequenceUtilities.readIdentifierEndIndex(textSequence, startPosition, includeDollar);
        }
        return PHPTextSequenceUtilities.readNamespaceEndIndex(textSequence, startPosition, includeDollar);
    }

    public static ISourceRange getEnclosingIdentifier(CharSequence textSequence, int pos) {
        int end;
        if (pos < 0 || pos >= textSequence.length()) {
            return null;
        }
        int start = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, pos, true);
        if (start > (end = PHPTextSequenceUtilities.readIdentifierEndIndex(textSequence, pos, true))) {
            return null;
        }
        return new SourceRange(start, end - start + 1);
    }

    public static int readBackwardSpaces(CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        while (rv > 0) {
            if (!Character.isWhitespace(textSequence.charAt(rv - 1))) break;
            --rv;
        }
        return rv;
    }

    public static int readForwardSpaces(CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        while (rv < textSequence.length()) {
            if (!Character.isWhitespace(textSequence.charAt(rv))) break;
            ++rv;
        }
        return rv;
    }

    public static int readForwardUntilDelim(CharSequence textSequence, int startPosition, char[] delims) {
        int rv = startPosition;
        while (rv < textSequence.length()) {
            char c = textSequence.charAt(rv);
            if (PHPTextSequenceUtilities.isDelimiter(c, delims)) break;
            ++rv;
        }
        return rv;
    }

    private static boolean isDelimiter(char c, char[] delims) {
        char[] cArray = delims;
        int n = delims.length;
        int n2 = 0;
        while (n2 < n) {
            char curr = cArray[n2];
            if (curr == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getPrivousTriggerIndex(CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        int bracketsNum = 0;
        char inStringMode = '\u0000';
        boolean inWhiteSpaceBeforeLiteral = false;
        boolean inLiteral = false;
        while (rv > 0) {
            char currChar = textSequence.charAt(rv - 1);
            if (currChar == '\'' || currChar == '\"') {
                char c = inStringMode == '\u0000' ? currChar : (inStringMode = inStringMode == currChar ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode == '\u0000') {
                if (Character.isLetterOrDigit(currChar) || currChar == '$') {
                    if (inWhiteSpaceBeforeLiteral && bracketsNum == 0) {
                        return -1;
                    }
                    inLiteral = true;
                } else {
                    if (inLiteral && Character.isWhitespace(currChar)) {
                        inWhiteSpaceBeforeLiteral = true;
                    }
                    if (!Character.isWhitespace(currChar)) {
                        inWhiteSpaceBeforeLiteral = false;
                    }
                    inLiteral = false;
                }
                if (!Character.isLetterOrDigit(currChar) && currChar != '_' && currChar != '$' && !Character.isWhitespace(currChar)) {
                    switch (currChar) {
                        case '(': 
                        case '[': 
                        case '{': {
                            if (--bracketsNum >= 0) break;
                            return -1;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            ++bracketsNum;
                            break;
                        }
                        case ':': {
                            if (bracketsNum != 0 || rv < 2) break;
                            if (textSequence.charAt(rv - 2) == ':') {
                                return rv - 2;
                            }
                            return -1;
                        }
                        case '>': {
                            if (bracketsNum != 0 || rv < 2) break;
                            if (textSequence.charAt(rv - 2) == '-') {
                                return rv - 2;
                            }
                            return -1;
                        }
                        default: {
                            if (bracketsNum != 0) break;
                            return -1;
                        }
                    }
                }
            }
            --rv;
        }
        return -1;
    }

    public static int readIdentifierListStartIndex(CharSequence textSequence, int endPosition) {
        int startPosition;
        int listStartPosition = startPosition = endPosition;
        boolean beforeWhitespace = false;
        boolean beforeComma = false;
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                if (beforeWhitespace) {
                    return --listStartPosition;
                }
                listStartPosition = startPosition;
                beforeComma = false;
            } else if (ch == ',') {
                if (beforeComma) {
                    return endPosition;
                }
                beforeComma = true;
                beforeWhitespace = false;
            } else if (Character.isWhitespace(ch) && !beforeComma) {
                beforeWhitespace = true;
            } else {
                return --listStartPosition;
            }
            --startPosition;
        }
        return listStartPosition;
    }

    public static String[] getArgNames(PHPVersion phpVersion, CharSequence textSequence) {
        ArrayList<String> args = new ArrayList<String>();
        if (textSequence != null && textSequence.length() > 2) {
            if (textSequence.charAt(textSequence.length() - 1) == ')') {
                textSequence = textSequence.subSequence(0, textSequence.length() - 1);
            }
            if (textSequence.charAt(0) == '(') {
                textSequence = textSequence.subSequence(1, textSequence.length());
            }
            if (phpVersion == null) {
                phpVersion = PHPVersion.getLatestVersion();
            }
            AbstractPhpLexer lexer = PhpLexerFactory.createLexer(new StringReader(textSequence.toString()), phpVersion);
            lexer.initialize(lexer.getScriptingState());
            String symbol = null;
            int level = 0;
            int argIndex = 0;
            do {
                try {
                    symbol = lexer.getNextToken();
                    if (symbol == null) continue;
                    CharSequence text = textSequence.subSequence(lexer.getTokenStart(), lexer.getTokenStart() + lexer.getLength());
                    if (symbol.equals("PHP_TOKEN")) {
                        if (text.equals(LPAREN) || text.equals(LBRACE) || text.equals(LBRACKET)) {
                            ++level;
                            continue;
                        }
                        if (text.equals(RPAREN) || text.equals(RBRACE) || text.equals(RBRACKET)) {
                            --level;
                            continue;
                        }
                        if (level != 0 || !text.equals(COMMA)) continue;
                        ++argIndex;
                        continue;
                    }
                    if (level == 0 && symbol.equals("PHP_CONSTANT_ENCAPSED_STRING")) {
                        if (args.size() >= argIndex + 1) continue;
                        args.add(text.toString());
                        continue;
                    }
                    if (level != 0 || symbol.equals("WHITESPACE")) continue;
                    if (args.size() < argIndex + 1) {
                        args.add(null);
                        continue;
                    }
                    args.set(argIndex, null);
                }
                catch (IOException iOException) {
                    symbol = null;
                }
            } while (symbol != null);
        }
        return args.toArray(new String[args.size()]);
    }
}

