/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.format.IProfile;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.formatter.core.Logger;
import org.eclipse.php.formatter.core.tests.Activator;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.formatter.ui.preferences.ProfileStore;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.ui.format.PHPFormatProcessorProxy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.Bundle;

public class FormatterTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static Map<PdttFile, IFile> filesMap;
    protected static IProject project;
    protected static int count;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/formatter/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/formatter/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/formatter/php55"});
        filesMap = new LinkedHashMap<PdttFile, IFile>();
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("FormatterTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        for (PdttFile pdttFile : filesMap.keySet()) {
            IFile file = FormatterTests.createFile(pdttFile.getFile().trim());
            filesMap.put(pdttFile, file);
        }
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        IScopeContext scopeContext = InstanceScope.INSTANCE;
        ProfileManager profileManager = new ProfileManager(new ArrayList(), scopeContext);
        profileManager.clearAllSettings(scopeContext);
        profileManager.commitChanges(scopeContext);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public FormatterTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Formatter Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            Bundle bundle = Activator.getDefault().getBundle();
            String xmlConfigurationFile = null;
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] testingDirectories;
                String testingDirectory = stringArray[n2];
                TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
                String[] stringArray2 = testingDirectories = FormatterTests.getTestingDirectories(bundle, testingDirectory);
                int n3 = testingDirectories.length;
                int n4 = 0;
                while (n4 < n3) {
                    String testsDirectory = stringArray2[n4];
                    TestSuite formatterConfigurationSuite = new TestSuite(testsDirectory);
                    String[] formatterConfigurationFile = FormatterTests.getFiles((String)testsDirectory, (Bundle)bundle, (String)".xml");
                    xmlConfigurationFile = formatterConfigurationFile.length > 0 ? formatterConfigurationFile[0] : null;
                    boolean filesFound = false;
                    String[] stringArray3 = FormatterTests.getPDTTFiles((String)testsDirectory, (Bundle)bundle);
                    int n5 = stringArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String fileName = stringArray3[n6];
                        filesFound = true;
                        try {
                            final PdttFile pdttFile = new PdttFile(Activator.getDefault().getBundle(), fileName);
                            filesMap.put(pdttFile, null);
                            formatterConfigurationSuite.addTest((Test)new FormatterTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                                protected void setUp() throws Exception {
                                    PHPCoreTests.setProjectPhpVersion((IProject)project, (PHPVersion)phpVersion);
                                }

                                protected void runTest() throws Throwable {
                                    IFile file = (IFile)filesMap.get(pdttFile);
                                    IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
                                    try {
                                        IStructuredDocument document = modelForEdit.getStructuredDocument();
                                        String beforeFormat = document.get();
                                        new Region(0, document.getLength());
                                        PHPFormatProcessorProxy formatter = new PHPFormatProcessorProxy();
                                        formatter.formatDocument((IDocument)document, 0, document.getLength());
                                        this.assertContents(pdttFile.getExpected(), document.get());
                                        document.set(beforeFormat);
                                        modelForEdit.save();
                                    }
                                    finally {
                                        if (modelForEdit != null) {
                                            modelForEdit.releaseFromEdit();
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            phpVerSuite.addTest((Test)new TestCase(fileName){

                                protected void runTest() throws Throwable {
                                    throw e;
                                }
                            });
                        }
                        ++n6;
                    }
                    if (filesFound) {
                        ConfigurableTestSetup setup = new ConfigurableTestSetup((Test)formatterConfigurationSuite, xmlConfigurationFile);
                        phpVerSuite.addTest((Test)setup);
                    }
                    ++n4;
                }
                suite.addTest((Test)phpVerSuite);
                ++n2;
            }
        }
        return suite;
    }

    private static void setDefaultFormatter(IScopeContext scopeContext, ProfileManager profileManager) {
        profileManager.clearAllSettings(scopeContext);
        if (profileManager.getSelected().getID() != "org.eclipse.php.formatter.ui.default") {
            profileManager.setSelected((IProfile)profileManager.getProfile("org.eclipse.php.formatter.ui.default"));
        }
        profileManager.commitChanges(scopeContext);
    }

    protected static IFile createFile(String data) throws Exception {
        IFile testFile = project.getFile("test" + ++count + ".php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }

    protected static String[] getTestingDirectories(Bundle bundle, String testsDirectory) {
        Enumeration entryPaths = bundle.getEntryPaths(testsDirectory);
        LinkedList<String> files = new LinkedList<String>();
        if (entryPaths != null) {
            while (entryPaths.hasMoreElements()) {
                String path = (String)entryPaths.nextElement();
                bundle.getEntry(path);
                try {
                    files.add(path);
                }
                catch (Exception exception) {}
            }
        }
        return files.toArray(new String[files.size()]);
    }

    static class ConfigurableTestSetup
    extends TestSetup {
        private String xmlFile;
        private ProfileManager profileManager;
        IScopeContext scopeContext;

        public ConfigurableTestSetup(Test test, String xmlFile) {
            super(test);
            this.xmlFile = xmlFile;
        }

        protected void setUp() throws Exception {
            FormatterTests.setUpSuite();
            if (this.xmlFile != null) {
                this.scopeContext = InstanceScope.INSTANCE;
                this.profileManager = new ProfileManager(new ArrayList(), this.scopeContext);
                String abcolutXmlFilePath = null;
                try {
                    URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(this.xmlFile), null);
                    URL resolved = FileLocator.resolve((URL)url);
                    IPath path = Path.fromOSString((String)resolved.getFile());
                    abcolutXmlFilePath = path.toString();
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
                File file = new File(abcolutXmlFilePath);
                ConfigurableTestSetup.assertTrue((String)("Formatter Configuration Not Found " + file.toString()), (boolean)file.exists());
                List profiles = null;
                try {
                    profiles = ProfileStore.readProfilesFromFile((File)file);
                }
                catch (CoreException e) {
                    Logger.logException((String)"Error while reading profile configuration xml file", (Throwable)e);
                }
                if (profiles != null && profiles.size() > 0) {
                    ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
                    this.profileManager.addProfile(profile);
                    this.profileManager.setSelected((IProfile)profile);
                    this.profileManager.commitChanges(this.scopeContext);
                }
            }
        }

        protected void tearDown() throws Exception {
            if (this.xmlFile != null) {
                FormatterTests.setDefaultFormatter(this.scopeContext, this.profileManager);
            }
            FormatterTests.tearDownSuite();
        }
    }
}

