/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.actions.FoldingMessages;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.ISavePolicy;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.documentModel.dom.IImplForPhp;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.OccurrencesFinderFactory;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.EditExternalBreakpointAction;
import org.eclipse.php.internal.ui.actions.GotoMatchingBracketAction;
import org.eclipse.php.internal.ui.actions.ManageExternalBreakpointAction;
import org.eclipse.php.internal.ui.actions.OpenCallHierarchyAction;
import org.eclipse.php.internal.ui.actions.OpenDeclarationAction;
import org.eclipse.php.internal.ui.actions.OpenFunctionsManualAction;
import org.eclipse.php.internal.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.php.internal.ui.actions.PHPSearchActionGroup;
import org.eclipse.php.internal.ui.actions.ToggleExternalBreakpointAction;
import org.eclipse.php.internal.ui.autoEdit.TabAutoEditStrategy;
import org.eclipse.php.internal.ui.editor.IPhpScriptReconcilingListener;
import org.eclipse.php.internal.ui.editor.LocalStorageModelProvider;
import org.eclipse.php.internal.ui.editor.OverrideIndicatorManager;
import org.eclipse.php.internal.ui.editor.PHPPairMatcher;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.RefactorableFileEditorInput;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.php.internal.ui.editor.selectionactions.SelectionHistory;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectEnclosingAction;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectHistoryAction;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectNextAction;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectPreviousAction;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderProxy;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.php.internal.ui.text.PHPWordIterator;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.php.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorDropTargetListener;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StorageModelProvider;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;

public class PHPStructuredEditor
extends StructuredTextEditor
implements IPhpScriptReconcilingListener {
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION = "org.eclipse.php.ui.actions.OpenFunctionsManualAction";
    private IContentOutlinePage fPHPOutlinePage;
    protected PHPPairMatcher fBracketMatcher = new PHPPairMatcher(BRACKETS);
    private CompositeActionGroup fContextMenuGroup;
    private CompositeActionGroup fActionGroups;
    private long fLastActionsUpdate;
    protected boolean isExternal;
    protected ISavePolicy fSavePolicy = null;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private Point fCachedSelectedRange;
    private ISelection fForcedMarkOccurrencesSelection;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkMethodOccurrences;
    private boolean fMarkFunctionOccurrences;
    private boolean fMarkConstantOccurrences;
    private boolean fMarkGlobalVariableOccurrences;
    private boolean fMarkLocalVariableOccurrences;
    private boolean fMarkExceptions;
    private boolean fMarkMethodExitPoints;
    private boolean fMarkBreakContinueTargets;
    private boolean fMarkImplementors;
    protected volatile boolean fReconcileSelection = false;
    private boolean saveActionsEnabled = false;
    private boolean saveActionsIgnoreEmptyLines = false;
    protected OverrideIndicatorManager fOverrideIndicatorManager;
    private boolean fIsTextDragAndDropInstalled = false;
    private Object fTextDragAndDropToken;
    private PHPFoldingStructureProviderProxy fProjectionModelUpdater;
    private boolean projectionSupportInstalled = false;
    private SelectionHistory fSelectionHistory;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private IPreferencesPropagatorListener fPhpVersionListener;
    private IEclipsePreferences.IPreferenceChangeListener fPreferencesListener;
    private final List<String> fCursorActions = new ArrayList<String>(5);
    protected InformationPresenter fInformationPresenter;
    private ISourceReconcilingListener fEditorReconcilingListener = new EditorReconcilingListener();
    OutlineSelectionChangedListener fPHPOutlinePageListener;
    private ListenerList fReconcilingListeners = new ListenerList(1);

    private void doSelectionChanged(ISelection selection) {
        ISourceReference reference = null;
        for (Object o : (IStructuredSelection)selection) {
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && PHPUiPlugin.getActivePage() != null) {
            PHPUiPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(reference, !this.isActivePart());
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.doSelectionChanged(selection);
    }

    protected void doSelectionChanged(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        this.doSelectionChanged(selection);
    }

    private void initPHPVersionsListener() {
        if (this.fPhpVersionListener != null) {
            return;
        }
        this.fPhpVersionListener = new IPreferencesPropagatorListener(){

            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                try {
                    IDocument doc = PHPStructuredEditor.this.getDocumentProvider().getDocument((Object)PHPStructuredEditor.this.getEditorInput());
                    if (doc instanceof IStructuredDocument) {
                        IStructuredDocumentRegion[] sdRegions;
                        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdRegions = ((IStructuredDocument)doc).getStructuredDocumentRegions();
                        int n = sdRegions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStructuredDocumentRegion element = iStructuredDocumentRegionArray[n2];
                            Iterator regionsIt = element.getRegions().iterator();
                            PHPStructuredEditor.this.reparseRegion(doc, regionsIt, element.getStartOffset());
                            ++n2;
                        }
                        PHPStructuredTextViewer textViewer = (PHPStructuredTextViewer)PHPStructuredEditor.this.getTextViewer();
                        textViewer.reconcile();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }

            public IProject getProject() {
                IScriptProject scriptProject = PHPStructuredEditor.this.getProject();
                if (scriptProject != null) {
                    return scriptProject.getProject();
                }
                return null;
            }
        };
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.fPhpVersionListener);
        this.fPreferencesListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                PHPStructuredTextViewerConfiguration configuration;
                ISourceViewer sourceViewer;
                String property = event.getKey();
                if (("contentAssistAutoactivation".equals(property) || "contentAssistAutoactivationDelay".equals(property) || "contentAssistAutoinsert".equals(property)) && (sourceViewer = PHPStructuredEditor.this.getSourceViewer()) != null && (configuration = (PHPStructuredTextViewerConfiguration)PHPStructuredEditor.this.getSourceViewerConfiguration()) != null) {
                    StructuredContentAssistant contentAssistant = (StructuredContentAssistant)configuration.getPHPContentAssistant(sourceViewer);
                    IPreferencesService preferencesService = Platform.getPreferencesService();
                    contentAssistant.enableAutoActivation(preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoactivation", false, null));
                    contentAssistant.setAutoActivationDelay(preferencesService.getInt("org.eclipse.php.core", "contentAssistAutoactivationDelay", 0, null));
                    contentAssistant.enableAutoInsert(preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoinsert", false, null));
                }
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.php.core").addPreferenceChangeListener(this.fPreferencesListener);
    }

    private void reparseRegion(IDocument doc, Iterator regionsIt, int offset) throws BadLocationException {
        while (regionsIt.hasNext()) {
            ITextRegion region = (ITextRegion)regionsIt.next();
            if (region instanceof ITextRegionContainer) {
                this.reparseRegion(doc, ((ITextRegionContainer)region).getRegions().iterator(), offset + region.getStart());
            }
            if (!(region instanceof IPhpScriptRegion)) continue;
            IPhpScriptRegion phpRegion = (IPhpScriptRegion)region;
            try {
                phpRegion.completeReparse(doc, offset + region.getStart(), region.getLength());
            }
            catch (Error e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    public PHPStructuredEditor() {
        boolean foldingEnabled = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("foldingEnabled");
        SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", foldingEnabled);
        this.setDocumentProvider((IDocumentProvider)DLTKUIPlugin.getDocumentProvider());
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.setDocumentProvider((IDocumentProvider)DLTKUIPlugin.getDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            input = new RefactorableFileEditorInput(fileInput.getFile());
        }
        super.init(site, input);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.createCombinedPreferenceStore();
        this.setPreferenceStore(store);
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkMethodOccurrences = store.getBoolean("markMethodOccurrences");
        this.fMarkFunctionOccurrences = store.getBoolean("markFunctionOccurrences");
        this.fMarkConstantOccurrences = store.getBoolean("markConstantOccurrences");
        this.fMarkGlobalVariableOccurrences = store.getBoolean("markGlobalVariableOccurrences");
        this.fMarkLocalVariableOccurrences = store.getBoolean("markLocalVariableOccurrences");
        this.fMarkImplementors = store.getBoolean("markImplementors");
        this.fMarkMethodExitPoints = store.getBoolean("markMethodExitPoints");
        this.fMarkBreakContinueTargets = store.getBoolean("markBreakContinueTargets");
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        IPreferenceStore phpEditorPrefs = PHPUiPlugin.getDefault().getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs, phpEditorPrefs});
    }

    public void dispose() {
        if (this.fContextMenuGroup != null) {
            this.fContextMenuGroup.dispose();
            this.fContextMenuGroup = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.dispose();
            this.fInformationPresenter = null;
        }
        if (this.fPhpVersionListener != null) {
            PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.fPhpVersionListener);
            this.fPhpVersionListener = null;
        }
        if (this.fPreferencesListener != null) {
            InstanceScope.INSTANCE.getNode("org.eclipse.php.core").removePreferenceChangeListener(this.fPreferencesListener);
        }
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
        if (this.fPHPOutlinePage != null) {
            if (this.fPHPOutlinePage instanceof ConfigurableContentOutlinePage && this.fPHPOutlinePageListener != null) {
                ((ConfigurableContentOutlinePage)this.fPHPOutlinePage).removeDoubleClickListener((IDoubleClickListener)this.fPHPOutlinePageListener);
            }
            if (this.fPHPOutlinePageListener != null) {
                this.fPHPOutlinePageListener.uninstall((ISelectionProvider)this.fPHPOutlinePage);
            }
        }
        this.uninstallOccurrencesFinder();
        this.uninstallOverrideIndicator();
        if (this.getSelectionProvider() instanceof IPostSelectionProvider) {
            IPostSelectionProvider psp = (IPostSelectionProvider)this.getSelectionProvider();
            try {
                IAction action = this.getAction("org.eclipse.php.ui.edit.text.php.open.type.hierarchy");
                if (action instanceof ISelectionChangedListener) {
                    psp.removePostSelectionChangedListener((ISelectionChangedListener)action);
                }
                if ((action = this.getAction("org.eclipse.php.ui.edit.text.php.open.call.hierarchy")) instanceof ISelectionChangedListener) {
                    psp.removePostSelectionChangedListener((ISelectionChangedListener)action);
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        super.dispose();
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.fContextMenuGroup != null) {
            ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
            this.fContextMenuGroup.setContext(context);
            this.fContextMenuGroup.fillContextMenu(menu);
            this.fContextMenuGroup.setContext(null);
        }
    }

    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        if (this.getSourceViewer().isEditable()) {
            menu.appendToGroup("group.edit", (IContributionItem)new Separator("group.open"));
            IAction action = this.getAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION);
            if (action != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.php.ui.edit.text.open.editor")) != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.dltk.ui.edit.text.script.show.outline")) != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.php.ui.edit.text.php.open.type.hierarchy")) != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.dltk.ui.edit.text.script.open.hierarchy")) != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.php.ui.edit.text.php.open.call.hierarchy")) != null) {
                menu.appendToGroup("group.open", action);
            }
        }
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = new SmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new SmartLineEndAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.goto.lineEnd", (IAction)action);
        action = new SmartLineEndAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.select.lineEnd", (IAction)action);
        action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
    }

    protected void createActions() {
        IPostSelectionProvider psp;
        super.createActions();
        this.fSelectionHistory = new SelectionHistory(this);
        Object action = new StructureSelectEnclosingAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.pdt.ui.edit.text.select.enclosing");
        this.setAction("SelectEnclosingElement", (IAction)action);
        action = new StructureSelectNextAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.pdt.ui.edit.text.select.next");
        this.setAction("SelectNextElement", (IAction)action);
        action = new StructureSelectPreviousAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.pdt.ui.edit.text.select.previous");
        this.setAction("SelectPreviousElement", (IAction)action);
        StructureSelectHistoryAction historyAction = new StructureSelectHistoryAction(this, this.fSelectionHistory);
        historyAction.setActionDefinitionId("org.eclipse.pdt.ui.edit.text.select.last");
        this.setAction("RestoreLastSelection", (IAction)historyAction);
        this.fSelectionHistory.setHistoryAction(historyAction);
        ResourceBundle resourceBundle = PHPUIMessages.getResourceBundle();
        action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.php.ui.editor.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new OpenFunctionsManualAction(resourceBundle, this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.manual");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, (IAction)action);
        this.markAsCursorDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, true);
        action = new OpenDeclarationAction(resourceBundle, this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.text.open.editor");
        this.setAction("org.eclipse.php.ui.edit.text.open.editor", (IAction)action);
        this.markAsCursorDependentAction("org.eclipse.php.ui.edit.text.open.editor", true);
        action = new OpenTypeHierarchyAction(this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.type.hierarchy");
        this.setAction("org.eclipse.php.ui.edit.text.php.open.type.hierarchy", (IAction)action);
        this.markAsCursorDependentAction("org.eclipse.php.ui.edit.text.php.open.type.hierarchy", true);
        if (this.getSelectionProvider() instanceof IPostSelectionProvider) {
            psp = (IPostSelectionProvider)this.getSelectionProvider();
            psp.addPostSelectionChangedListener((ISelectionChangedListener)((OpenTypeHierarchyAction)((Object)action)));
        }
        action = new OpenCallHierarchyAction(this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.call.hierarchy");
        this.setAction("org.eclipse.php.ui.edit.text.php.open.call.hierarchy", (IAction)action);
        this.markAsCursorDependentAction("org.eclipse.php.ui.edit.text.php.open.call.hierarchy", true);
        if (this.getSelectionProvider() instanceof IPostSelectionProvider) {
            psp = (IPostSelectionProvider)this.getSelectionProvider();
            psp.addPostSelectionChangedListener((ISelectionChangedListener)((OpenCallHierarchyAction)((Object)action)));
        }
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.", (ITextEditor)this, 53, true);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.hierarchy");
        this.setAction("org.eclipse.dltk.ui.edit.text.script.open.hierarchy", (IAction)action);
        this.markAsCursorDependentAction("org.eclipse.dltk.ui.edit.text.script.open.hierarchy", true);
        Object resAction = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.show.phpdoc");
        this.setAction("ShowPHPDoc", (IAction)resAction);
        resAction = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 51, true);
        resAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.show.outline");
        this.setAction("org.eclipse.dltk.ui.edit.text.script.show.outline", (IAction)resAction);
        resAction = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", (ITextEditor)this, 17, true);
        resAction.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        this.setAction("FoldingExpand", (IAction)resAction);
        resAction.setEnabled(true);
        resAction = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", (ITextEditor)this, 18, true);
        resAction.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        this.setAction("FoldingCollapse", (IAction)resAction);
        resAction.setEnabled(true);
        if (this.isExternal) {
            action = new ToggleExternalBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)action);
            action = new ManageExternalBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)action);
            action = new EditExternalBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)action);
            this.setAction("RulerDoubleClick", (IAction)new ToggleExternalBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler(), null));
        }
        PHPSearchActionGroup jsg = new PHPSearchActionGroup(this);
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{jsg});
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{jsg});
    }

    public ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_invalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (PHPStructuredEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return PHPStructuredEditor.isBracket(document.getChar(offset - 1)) && PHPStructuredEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("foldingEnabled");
    }

    private void installProjectionSupport() {
        this.projectionSupportInstalled = true;
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionModelUpdater = new PHPFoldingStructureProviderProxy();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            this.fProjectionModelUpdater.projectionEnabled();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.isFoldingEnabled()) {
            this.installProjectionSupport();
        }
        if (this.isMarkingOccurrences()) {
            this.installOccurrencesFinder(true);
        }
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.addEditorReconcilingListener(this.getSourceViewerConfiguration(), this.getTextViewer());
        StyledText styledText = this.getTextViewer().getTextWidget();
        styledText.getContent().addTextChangeListener(new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                PHPStructuredEditor.this.fReconcileSelection = true;
                PHPUiPlugin.getDefault().getASTProvider().markASTDirty();
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
            }
        });
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        this.setHelpContextId("org.eclipse.php.help.editor_preferences");
    }

    private void addEditorReconcilingListener(SourceViewerConfiguration config, StructuredTextViewer textViewer) {
        IReconciler reconciler = config.getReconciler((ISourceViewer)textViewer);
        if (reconciler instanceof DocumentRegionProcessor) {
            ((DocumentRegionProcessor)reconciler).addReconcilingListener(this.fEditorReconcilingListener);
        }
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
        SourceViewerConfiguration old = config;
        super.setSourceViewerConfiguration(config);
        StructuredTextViewer stv = this.getTextViewer();
        if (stv != null) {
            this.removeEditorReconcilingListener(old, stv);
            this.addEditorReconcilingListener(config, stv);
        }
    }

    private void removeEditorReconcilingListener(SourceViewerConfiguration config, StructuredTextViewer textViewer) {
        IReconciler reconciler = config.getReconciler((ISourceViewer)textViewer);
        if (reconciler instanceof DocumentRegionProcessor) {
            ((DocumentRegionProcessor)reconciler).removeReconcilingListener(this.fEditorReconcilingListener);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IFile resource = null;
        this.isExternal = false;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            resource = fileInput.getFile();
            if (this.getRefactorableFileEditorInput() != null && this.getRefactorableFileEditorInput().isRefactor()) {
                this.getRefactorableFileEditorInput().setRefactor(false);
                this.getDocumentProvider().disconnect((Object)this.getRefactorableFileEditorInput());
                this.getRefactorableFileEditorInput().setFile(fileInput.getFile());
                input = this.getRefactorableFileEditorInput();
            } else {
                input = new RefactorableFileEditorInput(fileInput.getFile());
            }
        }
        if (resource != null) {
            if (PHPToolkitUtil.isPhpFile(resource)) {
                PhpSourceParser.editFile.set(resource);
                super.doSetInput(input);
                this.initPHPVersionsListener();
            } else {
                super.doSetInput(input);
            }
        } else {
            this.isExternal = true;
            super.doSetInput(input);
        }
        ImageDescriptor imageDescriptor = input.getImageDescriptor();
        if (imageDescriptor != null) {
            this.setTitleImage(JFaceResources.getResources().createImageWithDefault(imageDescriptor));
        }
        if (this.isShowingOverrideIndicators()) {
            this.installOverrideIndicator(true);
        }
        if (this.fProjectionModelUpdater != null) {
            this.updateProjectionSupport();
        }
    }

    private void updateProjectionSupport() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionModelUpdater = new PHPFoldingStructureProviderProxy();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(projectionViewer);
            this.fProjectionModelUpdater.initialize();
        }
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        if (this.getRefactorableFileEditorInput() != null) {
            this.getRefactorableFileEditorInput().setRefactor(true);
        }
        return super.canHandleMove(originalElement, movedElement);
    }

    private RefactorableFileEditorInput getRefactorableFileEditorInput() {
        if (this.getEditorInput() instanceof RefactorableFileEditorInput) {
            return (RefactorableFileEditorInput)this.getEditorInput();
        }
        return null;
    }

    public Object getAdapter(Class required) {
        Object adapter = super.getAdapter(required);
        if (adapter instanceof ConfigurableContentOutlinePage && IContentOutlinePage.class.equals((Object)required) && this.shouldOutlineViewBeLoaded()) {
            ConfigurableContentOutlinePage outlinePage = (ConfigurableContentOutlinePage)adapter;
            if (this.fPHPOutlinePageListener == null) {
                this.fPHPOutlinePageListener = new OutlineSelectionChangedListener(outlinePage.getConfiguration());
                outlinePage.addDoubleClickListener((IDoubleClickListener)this.fPHPOutlinePageListener);
            }
            this.fPHPOutlinePageListener.install((ISelectionProvider)outlinePage);
            this.fPHPOutlinePage = outlinePage;
            outlinePage.setInput((Object)this.getModelElement());
        }
        return adapter;
    }

    private boolean shouldOutlineViewBeLoaded() {
        return this.fPHPOutlinePage == null || this.fPHPOutlinePage.getControl() == null || this.fPHPOutlinePage.getControl().isDisposed();
    }

    protected void clearStatusLine() {
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
    }

    public SourceViewerConfiguration getSourceViwerConfiguration() {
        return super.getSourceViewerConfiguration();
    }

    public Point getCachedSelectedRange() {
        return this.fCachedSelectedRange;
    }

    protected void handleCursorPositionChanged() {
        this.updateCursorDependentActions();
        this.fCachedSelectedRange = this.getTextViewer().getSelectedRange();
        super.handleCursorPositionChanged();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        try {
            if ("org.eclipse.php.uihoverModifiers".equals(property) || "org.eclipse.php.uihoverModifierMasks".equals(property)) {
                this.updateHoverBehavior();
                return;
            }
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if ("markOccurrences".equals(property)) {
                if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                    this.fMarkOccurrenceAnnotations = newBooleanValue;
                    if (!this.fMarkOccurrenceAnnotations) {
                        this.uninstallOccurrencesFinder();
                    } else {
                        this.installOccurrencesFinder(true);
                    }
                }
                return;
            }
            if ("markTypeOccurrences".equals(property)) {
                this.fMarkTypeOccurrences = newBooleanValue;
                return;
            }
            if ("markMethodOccurrences".equals(property)) {
                this.fMarkMethodOccurrences = newBooleanValue;
                return;
            }
            if ("markFunctionOccurrences".equals(property)) {
                this.fMarkFunctionOccurrences = newBooleanValue;
                return;
            }
            if ("markConstantOccurrences".equals(property)) {
                this.fMarkConstantOccurrences = newBooleanValue;
                return;
            }
            if ("markGlobalVariableOccurrences".equals(property)) {
                this.fMarkGlobalVariableOccurrences = newBooleanValue;
                return;
            }
            if ("markLocalVariableOccurrences".equals(property)) {
                this.fMarkLocalVariableOccurrences = newBooleanValue;
                return;
            }
            if ("markMethodExitPoints".equals(property)) {
                this.fMarkMethodExitPoints = newBooleanValue;
                return;
            }
            if ("markBreakContinueTargets".equals(property)) {
                this.fMarkBreakContinueTargets = newBooleanValue;
                return;
            }
            if ("markImplementors".equals(property)) {
                this.fMarkImplementors = newBooleanValue;
                return;
            }
            if ("stickyOccurrences".equals(property)) {
                this.fStickyOccurrenceAnnotations = newBooleanValue;
                return;
            }
            if (this.affectsOverrideIndicatorAnnotations(event)) {
                if (this.isShowingOverrideIndicators()) {
                    if (this.fOverrideIndicatorManager == null) {
                        this.installOverrideIndicator(true);
                    }
                } else if (this.fOverrideIndicatorManager != null) {
                    this.uninstallOverrideIndicator();
                }
                return;
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
        if ("foldingEnabled".equals(property) && this.getSourceViewer() instanceof ProjectionViewer && this.isFoldingEnabled() && !this.projectionSupportInstalled) {
            this.installProjectionSupport();
        }
    }

    protected boolean affectsOverrideIndicatorAnnotations(PropertyChangeEvent event) {
        String key = event.getProperty();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.php.ui.overrideIndicator");
        if (key == null || preference == null) {
            return false;
        }
        return key.equals(preference.getHighlightPreferenceKey()) || key.equals(preference.getVerticalRulerPreferenceKey()) || key.equals(preference.getOverviewRulerPreferenceKey()) || key.equals(preference.getTextPreferenceKey());
    }

    protected boolean isShowingOverrideIndicators() {
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.php.ui.overrideIndicator");
        IPreferenceStore store = this.getPreferenceStore();
        return this.getBoolean(store, preference.getHighlightPreferenceKey()) || this.getBoolean(store, preference.getVerticalRulerPreferenceKey()) || this.getBoolean(store, preference.getOverviewRulerPreferenceKey()) || this.getBoolean(store, preference.getTextPreferenceKey());
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key != null && store.getBoolean(key);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.php.ui.phpEditorScope"});
    }

    public void markAsCursorDependentAction(String actionId, boolean mark) {
        assert (actionId != null);
        if (mark) {
            if (!this.fCursorActions.contains(actionId)) {
                this.fCursorActions.add(actionId);
            }
        } else {
            this.fCursorActions.remove(actionId);
        }
    }

    public IDocument getDocument() {
        if (this.getSourceViewer() != null) {
            return this.getSourceViewer().getDocument();
        }
        return null;
    }

    private void updateAction(String actionId) {
        assert (actionId != null);
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateCursorDependentActions() {
        if (this.fCursorActions != null) {
            long currentTime = System.currentTimeMillis();
            if (this.fLastActionsUpdate > currentTime - 1000L) {
                return;
            }
            this.fLastActionsUpdate = currentTime;
            Iterator<String> e = this.fCursorActions.iterator();
            while (e.hasNext()) {
                this.updateAction(e.next());
            }
        }
    }

    private void updateHoverBehavior() {
        String[] types;
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] stringArray = types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int[] nArray = stateMasks;
                    int n3 = stateMasks.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int stateMask = nArray[n4];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++n4;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++n2;
        }
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new PHPStructuredTextViewer((ITextEditor)this, parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p instanceof ISourceModuleDocumentProvider) {
            ISourceModuleDocumentProvider cp = (ISourceModuleDocumentProvider)p;
            cp.setSavePolicy(this.fSavePolicy);
        }
        try {
            super.performSave(overwrite, progressMonitor);
        }
        finally {
            if (p instanceof ISourceModuleDocumentProvider) {
                ISourceModuleDocumentProvider cp = (ISourceModuleDocumentProvider)p;
                cp.setSavePolicy(null);
            }
        }
    }

    public IDocumentProvider getDocumentProvider() {
        LocalStorageModelProvider provider;
        if (this.getEditorInput() instanceof ExternalStorageEditorInput && (provider = LocalStorageModelProvider.getInstance()) != null) {
            return provider;
        }
        if (this.getEditorInput() instanceof RefactorableFileEditorInput) {
            return super.getDocumentProvider();
        }
        if (this.getEditorInput() instanceof IStorageEditorInput && (provider = StorageModelProvider.getInstance()) != null) {
            return provider;
        }
        return super.getDocumentProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReconcileListener(IPhpScriptReconcilingListener reconcileListener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)reconcileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReconcileListener(IPhpScriptReconcilingListener reconcileListener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)reconcileListener);
        }
    }

    @Override
    public void aboutToBeReconciled() {
        PHPUiPlugin.getDefault().getASTProvider().aboutToBeReconciled((ISourceModule)this.getModelElement());
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IPhpScriptReconcilingListener)listeners[i]).aboutToBeReconciled();
            ++i;
        }
    }

    @Override
    public void reconciled(Program ast, boolean forced, IProgressMonitor progressMonitor) {
        PHPUiPlugin phpPlugin = PHPUiPlugin.getDefault();
        if (phpPlugin == null) {
            return;
        }
        ISourceModule inputModelElement = (ISourceModule)this.getModelElement();
        phpPlugin.getASTProvider().reconciled(ast, inputModelElement, progressMonitor);
        this.fReconcileSelection = false;
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IPhpScriptReconcilingListener)listeners[i]).reconciled(ast, forced, progressMonitor);
            ++i;
        }
    }

    public IModelElement getModelElement() {
        return EditorUtility.getEditorInputModelElement((IEditorPart)this, (boolean)false);
    }

    protected IModelElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    protected IModelElement getElementAt(int offset, boolean reconcile) {
        block5: {
            ISourceModule unit = (ISourceModule)this.getModelElement();
            if (unit != null) {
                try {
                    if (reconcile) {
                        this.fReconcileSelection = false;
                        ScriptModelUtil.reconcile((ISourceModule)unit);
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (ModelException x) {
                    if (x.isDoesNotExist()) break block5;
                    System.err.println(x.getStatus());
                }
            }
        }
        return null;
    }

    public IScriptProject getProject() {
        IModelElement modelElement = this.getModelElement();
        if (modelElement != null) {
            return modelElement.getScriptProject();
        }
        return null;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, Program astRoot) {
        this.updateOccurencesAnnotationsRunJob(selection, astRoot);
    }

    protected void updateOccurrenceAnnotations(final ITextSelection selection, final IModelElement sourceModule) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        String updatingOccurencesJobName = "Updating occurence annotations";
        IJobManager jobManager = Job.getJobManager();
        if (jobManager.find((Object)updatingOccurencesJobName).length > 0) {
            jobManager.cancel((Object)updatingOccurencesJobName);
        }
        Job job = new Job(updatingOccurencesJobName){

            protected IStatus run(IProgressMonitor monitor) {
                Program astRoot = null;
                try {
                    astRoot = SharedASTProvider.getAST((ISourceModule)sourceModule, SharedASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
                if (!monitor.isCanceled() && astRoot != null) {
                    PHPStructuredEditor.this.updateOccurencesAnnotationsRunJob(selection, astRoot);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return this.getName().equals(family);
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    private void updateOccurencesAnnotationsRunJob(ITextSelection selection, Program astRoot) {
        IOccurrencesFinder finder;
        int type;
        Expression name;
        IOccurrencesFinder finder2;
        if (astRoot == null || selection == null) {
            return;
        }
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        if (document.getLength() != astRoot.getEnd() || this.fReconcileSelection) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)selection.getOffset(), (int)selection.getLength());
        if (locations == null) {
            // empty if block
        }
        if (locations == null && this.fMarkMethodExitPoints && (finder2 = OccurrencesFinderFactory.createMethodExitsFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkImplementors && (finder2 = OccurrencesFinderFactory.createIncludeFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkBreakContinueTargets && (finder2 = OccurrencesFinderFactory.createBreakContinueTargetFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkImplementors && (finder2 = OccurrencesFinderFactory.createImplementorsOccurrencesFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (selectedNode != null && selectedNode.getType() == 60 && (name = ((Variable)selectedNode).getName()) instanceof Identifier) {
            selectedNode = name;
        }
        if (locations == null && selectedNode != null && (selectedNode instanceof Identifier || this.isScalarButNotInString(selectedNode)) && this.markOccurrencesOfType(type = PhpElementConciliator.concile((ASTNode)selectedNode)) && (finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type)) != null && finder.initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if (locations == null) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            } else if (hasChanged) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private boolean isScalarButNotInString(ASTNode node) {
        return node.getType() == 51 && node.getParent().getType() != 47;
    }

    protected void uninstallOverrideIndicator() {
        if (this.fOverrideIndicatorManager != null) {
            this.removeReconcileListener(this.fOverrideIndicatorManager);
            this.fOverrideIndicatorManager.removeAnnotations();
            this.fOverrideIndicatorManager = null;
        }
    }

    protected void installOverrideIndicator(boolean provideAST) {
        this.uninstallOverrideIndicator();
        if (this.getDocumentProvider() == null) {
            return;
        }
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        final IModelElement inputElement = this.getModelElement();
        if (model == null || inputElement == null || inputElement.getElementType() != 5) {
            return;
        }
        this.fOverrideIndicatorManager = new OverrideIndicatorManager(model, inputElement, null);
        this.addReconcileListener(this.fOverrideIndicatorManager);
        if (provideAST) {
            Job job = new Job("Installing override indicator"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Program ast = SharedASTProvider.getAST((ISourceModule)inputElement, SharedASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor());
                        if (PHPStructuredEditor.this.fOverrideIndicatorManager != null) {
                            PHPStructuredEditor.this.fOverrideIndicatorManager.reconciled(ast, true, PHPStructuredEditor.this.getProgressMonitor());
                        }
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(50);
            job.schedule();
        }
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            @Override
            public void selectionChanged(IEditorPart part, ITextSelection selection, Program astRoot) {
                PHPStructuredEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            IModelElement source = this.getModelElement();
            if (source != null && source.getElementType() == 5) {
                this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, (IModelElement)((ISourceModule)source));
            }
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    public boolean isMarkingOccurrences() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("markOccurrences");
    }

    boolean markOccurrencesOfType(int type) {
        switch (type) {
            case 1: {
                return this.fMarkGlobalVariableOccurrences;
            }
            case 3: {
                return this.fMarkLocalVariableOccurrences;
            }
            case 2: {
                return this.fMarkFunctionOccurrences;
            }
            case 4: 
            case 8: {
                return this.fMarkTypeOccurrences;
            }
            case 5: {
                return this.fMarkConstantOccurrences;
            }
            case 6: {
                return this.fMarkMethodOccurrences;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        Job job = new Job("PHPStructuredEditor selection changed job"){

            protected IStatus run(IProgressMonitor monitor) {
                ISourceReference element = PHPStructuredEditor.this.computeHighlightRangeSourceReference();
                PHPStructuredEditor.this.setSelection(element, false);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setSystem(true);
        job.schedule();
    }

    public ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        final StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        final int[] caret = new int[1];
        if (sourceViewer instanceof ITextViewerExtension5) {
            final ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!styledText.isDisposed()) {
                        caret[0] = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
                    }
                }
            });
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret[0] = offset + styledText.getCaretOffset();
        }
        IModelElement element = this.getElementAt(caret[0], false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)element;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block20: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            final ISelection[] selection = new ISelection[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    selection[0] = PHPStructuredEditor.this.getSelectionProvider().getSelection();
                }
            });
            if (selection[0] == null) {
                return;
            }
            if (selection[0] instanceof TextSelection) {
                Object firstElement;
                TextSelection textSelection = (TextSelection)selection[0];
                if (textSelection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)textSelection).getFirstElement()) instanceof IImplForPhp) {
                    ((IImplForPhp)firstElement).setModelElement(this.getModelElement());
                }
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    ISourceRange range = null;
                    range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember && (range = ((IMember)reference).getNameRange()) != null) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block20;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (ModelException modelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    public void updateSaveActionsState(IProject project) {
        PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.ui", PHPUiPlugin.getDefault().getPluginPreferences());
        String doCleanupPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces", null, project);
        String ignoreEmptyPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces_ignore_empty", null, project);
        this.saveActionsEnabled = Boolean.parseBoolean(doCleanupPref);
        this.saveActionsIgnoreEmptyLines = Boolean.parseBoolean(ignoreEmptyPref);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IScriptProject project;
        if (this.getDocument() instanceof IStructuredDocument) {
            CommandStack commandStack = ((IStructuredDocument)this.getDocument()).getUndoManager().getCommandStack();
            ((IStructuredDocument)this.getDocument()).getUndoManager().forceEndOfPendingCommand(null, this.getViewer().getSelectedRange().x, this.getViewer().getSelectedRange().y);
            if (commandStack instanceof BasicCommandStack) {
                ((BasicCommandStack)commandStack).saveIsDone();
            }
        }
        if ((project = this.getProject()) != null) {
            this.updateSaveActionsState(project.getProject());
        }
        if (this.saveActionsEnabled) {
            ExtendedRemoveTrailingWhitespaceOperation op = new ExtendedRemoveTrailingWhitespaceOperation(this.saveActionsIgnoreEmptyLines);
            try {
                op.run((IFileBuffer)FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.getDocument()), progressMonitor);
            }
            catch (OperationCanceledException e) {
                Logger.logException(e);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        super.doSave(progressMonitor);
    }

    public ISourceViewer getViewer() {
        return super.getSourceViewer();
    }

    public void update() {
        super.update();
        if (this.fPHPOutlinePage != null && this.fPHPOutlinePage instanceof ConfigurableContentOutlinePage) {
            ((ConfigurableContentOutlinePage)this.fPHPOutlinePage).setInput((Object)this.getModelElement());
        }
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        IPreferenceStore store;
        Object object;
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        ITextEditorDropTargetListener listener = (ITextEditorDropTargetListener)this.getAdapter(ITextEditorDropTargetListener.class);
        if (listener == null && (object = Platform.getAdapterManager().loadAdapter((Object)this, "org.eclipse.ui.texteditor.ITextEditorDropTargetListener")) instanceof ITextEditorDropTargetListener) {
            listener = (ITextEditorDropTargetListener)object;
        }
        if (listener != null) {
            dndService.addMergedDropTarget((Control)viewer.getTextWidget(), 3, listener.getTransfers(), (DropTargetListener)listener);
        }
        if ((store = this.getPreferenceStore()) != null && store.getBoolean("textDragAndDropEnabled")) {
            this.installTextDragAndDrop(viewer);
        }
    }

    protected void installTextDragAndDrop(final ISourceViewer viewer) {
        if (viewer == null || this.fIsTextDragAndDropInstalled) {
            return;
        }
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        final StyledText st = viewer.getTextWidget();
        final ISelectionProvider selectionProvider = viewer.getSelectionProvider();
        DragSource source = new DragSource((Control)st, 3);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){
            String fSelectedText;
            Point fSelection;

            public void dragStart(DragSourceEvent event) {
                PHPStructuredEditor.this.fTextDragAndDropToken = null;
                try {
                    this.fSelection = st.getSelection();
                    event.doit = this.isLocationSelected(new Point(event.x, event.y));
                    ISelection selection = selectionProvider.getSelection();
                    this.fSelectedText = selection instanceof ITextSelection ? ((ITextSelection)selection).getText() : st.getSelectionText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    event.doit = false;
                }
            }

            private boolean isLocationSelected(Point point) {
                if (PHPStructuredEditor.this.isBlockSelectionModeEnabled()) {
                    return false;
                }
                int offset = st.getOffsetAtLocation(point);
                Point p = st.getLocationAtOffset(offset);
                if (p.x > point.x) {
                    --offset;
                }
                return offset >= this.fSelection.x && offset < this.fSelection.y;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.fSelectedText;
                PHPStructuredEditor.this.fTextDragAndDropToken = (Object)this;
            }

            public void dragFinished(DragSourceEvent event) {
                try {
                    if (event.detail == 2 && PHPStructuredEditor.this.validateEditorInputState()) {
                        IRewriteTarget target;
                        Point newSelection = st.getSelection();
                        int length = this.fSelection.y - this.fSelection.x;
                        int delta = 0;
                        if (newSelection.x < this.fSelection.x) {
                            delta = length;
                        }
                        st.replaceTextRange(this.fSelection.x + delta, length, "");
                        if (PHPStructuredEditor.this.fTextDragAndDropToken == null && (target = (IRewriteTarget)PHPStructuredEditor.this.getAdapter(IRewriteTarget.class)) != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                finally {
                    PHPStructuredEditor.this.fTextDragAndDropToken = null;
                }
            }
        });
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){
            private Point fSelection;

            public void dragEnter(DropTargetEvent event) {
                PHPStructuredEditor.this.fTextDragAndDropToken = null;
                this.fSelection = st.getSelection();
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : ((event.operations & 1) != 0 ? 1 : 0);
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : ((event.operations & 1) != 0 ? 1 : 0);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback |= 8;
            }

            public void drop(DropTargetEvent event) {
                block12: {
                    try {
                        if (PHPStructuredEditor.this.fTextDragAndDropToken != null && event.detail == 2) {
                            int caretOffset = st.getCaretOffset();
                            if (this.fSelection.x <= caretOffset && caretOffset <= this.fSelection.y) {
                                event.detail = 0;
                                return;
                            }
                            IRewriteTarget target = (IRewriteTarget)PHPStructuredEditor.this.getAdapter(IRewriteTarget.class);
                            if (target != null) {
                                target.beginCompoundChange();
                            }
                        }
                        if (!PHPStructuredEditor.this.validateEditorInputState()) {
                            event.detail = 0;
                            return;
                        }
                        String text = (String)event.data;
                        if (PHPStructuredEditor.this.isBlockSelectionModeEnabled()) break block12;
                        Point newSelection = st.getSelection();
                        try {
                            int modelOffset = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)newSelection.x);
                            viewer.getDocument().replace(modelOffset, 0, text);
                        }
                        catch (BadLocationException badLocationException) {
                            PHPStructuredEditor.this.fTextDragAndDropToken = null;
                            return;
                        }
                        st.setSelectionRange(newSelection.x, text.length());
                    }
                    finally {
                        PHPStructuredEditor.this.fTextDragAndDropToken = null;
                    }
                }
            }
        };
        dndService.addMergedDropTarget((Control)st, 3, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)dropTargetListener);
        this.fIsTextDragAndDropInstalled = true;
    }

    protected void uninstallTextDragAndDrop(ISourceViewer viewer) {
        if (viewer == null || !this.fIsTextDragAndDropInstalled) {
            return;
        }
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        dndService.removeMergedDropTarget((Control)st);
        DragSource dragSource = (DragSource)st.getData("DragSource");
        if (dragSource != null) {
            dragSource.dispose();
            st.setData("DragSource", null);
        }
        this.fIsTextDragAndDropInstalled = false;
    }

    public boolean isDirty() {
        CommandStack commandStack;
        boolean result = super.isDirty();
        if (!result) {
            return result;
        }
        if (this.getDocument() instanceof IStructuredDocument && (commandStack = ((IStructuredDocument)this.getDocument()).getUndoManager().getCommandStack()) instanceof BasicCommandStack) {
            BasicCommandStack bcs = (BasicCommandStack)commandStack;
            return bcs.isSaveNeeded();
        }
        return result;
    }

    public void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return true;
    }

    protected void installTabsToSpacesConverter() {
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (config != null && sourceViewer instanceof ITextViewerExtension7) {
            ((ITextViewerExtension7)sourceViewer).setTabsToSpacesConverter((IAutoEditStrategy)new TabAutoEditStrategy());
            this.updateIndentPrefixes();
        }
    }

    protected void uninstallTabsToSpacesConverter() {
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == PHPStructuredEditor.this.getEditorSite().getWorkbenchWindow() && PHPStructuredEditor.this.fMarkOccurrenceAnnotations && PHPStructuredEditor.this.isActivePart()) {
                PHPStructuredEditor.this.fForcedMarkOccurrencesSelection = PHPStructuredEditor.this.getSelectionProvider().getSelection();
                IModelElement sourceModule = PHPStructuredEditor.this.getModelElement();
                if (sourceModule != null && sourceModule.getElementType() == 5) {
                    PHPStructuredEditor.this.updateOccurrenceAnnotations((ITextSelection)PHPStructuredEditor.this.fForcedMarkOccurrencesSelection, sourceModule);
                }
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == PHPStructuredEditor.this.getEditorSite().getWorkbenchWindow() && PHPStructuredEditor.this.fMarkOccurrenceAnnotations && PHPStructuredEditor.this.isActivePart()) {
                PHPStructuredEditor.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class EditorReconcilingListener
    implements ISourceReconcilingListener {
        private EditorReconcilingListener() {
        }

        public void aboutToBeReconciled() {
            PHPStructuredEditor.this.aboutToBeReconciled();
        }

        public void reconciled(IDocument document, IAnnotationModel model, boolean forced, IProgressMonitor progressMonitor) {
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PHPStructuredEditor.this.selectionChanged();
        }
    }

    class ExtendedRemoveTrailingWhitespaceOperation
    extends RemoveTrailingWhitespaceOperation {
        private boolean fIgnoreEmptyLines;

        public ExtendedRemoveTrailingWhitespaceOperation(boolean ignoreEmptyLines) {
            this.fIgnoreEmptyLines = ignoreEmptyLines;
        }

        protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer fileBuffer, IProgressMonitor progressMonitor) throws CoreException {
            IDocument document = fileBuffer.getDocument();
            int lineCount = document.getNumberOfLines();
            progressMonitor = Progress.getMonitor((IProgressMonitor)progressMonitor);
            progressMonitor.beginTask(PHPUIMessages.RemoveTrailingWhitespaceOperation_task_generatingChanges, lineCount);
            try {
                MultiTextEditWithProgress multiEdit = new MultiTextEditWithProgress(PHPUIMessages.RemoveTrailingWhitespaceOperation_task_applyingChanges);
                int i = 0;
                while (i < lineCount) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IRegion region = document.getLineInformation(i);
                    if (region.getLength() != 0) {
                        int lineStart = region.getOffset();
                        int lineExclusiveEnd = lineStart + region.getLength();
                        int j = lineExclusiveEnd - 1;
                        while (j >= lineStart && Character.isWhitespace(document.getChar(j))) {
                            --j;
                        }
                        if (!this.fIgnoreEmptyLines || ++j != lineStart) {
                            if (j < lineExclusiveEnd) {
                                multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                            }
                            progressMonitor.worked(1);
                        }
                    }
                    ++i;
                }
                MultiTextEditWithProgress multiTextEditWithProgress = multiEdit.getChildrenSize() <= 0 ? null : multiEdit;
                return multiTextEditWithProgress;
            }
            catch (BadLocationException x) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 1, "", (Throwable)x));
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)PHPStructuredEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = PHPStructuredEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.php.PHP_DOC", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(annotationHover.getClass().getName())) {
                    controlCreator = new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell shell) {
                            int shellStyle = 0x14 | PHPStructuredEditor.this.getOrientation();
                            return new PHPSourceViewerInformationControl(shell, shellStyle, 768);
                        }
                    };
                } else if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                PHPStructuredEditor.this.fInformationPresenter.setOffset(offset);
                PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                PHPStructuredEditor.this.fInformationPresenter.setMargins(4, 0);
                PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                PHPStructuredEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            String decoratedMessage;
            IHoverMessageDecorator decorator;
            IRegion hoverRegion;
            int offset;
            block6: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block6;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            if (textHover instanceof IPHPTextHover && (decorator = ((IPHPTextHover)textHover).getMessageDecorator()) != null && (decoratedMessage = decorator.getDecoratedMessage(hoverInfo)) != null && decoratedMessage.length() > 0) {
                hoverInfo = decoratedMessage;
            }
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            PHPStructuredEditor.this.fInformationPresenter.setOffset(offset);
            PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            PHPStructuredEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"org.eclipse.php.PHP_DOC", (int)offset, (boolean)true);
            PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            PHPStructuredEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
            this.fTextOperationAction.run();
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IInformationControlCreator fControlCreator;
        private final Object fHoverInfo;
        private final IRegion fHoverRegion;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)PHPStructuredEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)PHPStructuredEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore store = this.getPreferenceStore();
            if (!store.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            if (next != -1) {
                this.setCaretPosition(next);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super("mark occrrences job name");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = PHPStructuredEditor.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)PHPStructuredEditor.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && PHPStructuredEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            StructuredTextViewer textViewer = PHPStructuredEditor.this.getTextViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = PHPStructuredEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)PHPStructuredEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<1, Position> annotationMap = new HashMap<1, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.php.ui.occurrences.write" : "org.eclipse.php.ui.occurrences";
                ReconcileAnnotationKey reconcileAnnotationKey = new ReconcileAnnotationKey(null, "org.eclipse.php.PHP_DEFAULT", 0);
                TemporaryAnnotation annotation = new TemporaryAnnotation(position, annotationType, description, reconcileAnnotationKey){

                    public void paint(GC gc, Canvas canvas, Rectangle r) {
                        ImageUtilities.drawImage((Image)PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_OCCURRENCES), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
                    }
                };
                annotationMap.put(annotation, position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = PHPStructuredEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(PHPStructuredEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    PHPStructuredEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry entry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                    }
                }
                PHPStructuredEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = PHPStructuredEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)PHPStructuredEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (PHPStructuredEditor.this.fOccurrencesFinderJob != null) {
                PHPStructuredEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener
    implements IDoubleClickListener {
        private ContentOutlineConfiguration configuration;

        public OutlineSelectionChangedListener(ContentOutlineConfiguration configuration) {
            this.configuration = configuration;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!this.configuration.isLinkedWithEditor(null)) {
                return;
            }
            PHPStructuredEditor.this.doSelectionChanged(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            PHPStructuredEditor.this.doSelectionChanged(event);
        }
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore store = this.getPreferenceStore();
            if (!store.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            if (previous != -1) {
                this.setCaretPosition(previous);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = PHPStructuredEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SmartLineEndAction
    extends TextNavigationAction {
        private final boolean fDoSelect;

        public SmartLineEndAction(StyledText textWidget, boolean doSelect) {
            super(textWidget, 0x1000008);
            this.fDoSelect = doSelect;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int lineLength;
            ISourceViewer fSourceViewer;
            StyledText st;
            boolean isSmartHomeEndEnabled = true;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean("useSmartHomeEnd");
            }
            if ((st = (fSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            try {
                int caretOffsetInDocument = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)fSourceViewer, (int)caretOffset);
                lineLength = fSourceViewer.getDocument().getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int lineEndOffset = lineOffset + lineLength;
            int delta = lineEndOffset - st.getCharCount();
            if (delta > 0) {
                lineEndOffset -= delta;
                lineLength -= delta;
            }
            String line = "";
            if (lineLength > 0) {
                line = st.getText(lineOffset, lineEndOffset - 1);
            }
            int i = lineLength - 1;
            while (i > -1 && Character.isWhitespace(line.charAt(i))) {
                --i;
            }
            ++i;
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == i ? lineEndOffset : lineOffset + i;
            } else if (caretOffset < lineEndOffset) {
                newCaretOffset = lineEndOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            }
            int offsetInLine = newCaretOffset - lineOffset;
            int lineFullLength = st.getLine(lineNumber).length();
            while (offsetInLine > lineFullLength) {
                --newCaretOffset;
                --offsetInLine;
            }
            st.setCaretOffset(newCaretOffset);
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        private final boolean fDoSelect;

        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)PHPStructuredEditor.this, textWidget, doSelect);
            this.fDoSelect = doSelect;
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            String type = "__dftl_partition_content_type";
            try {
                type = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.php.PHP_DEFAULT", (int)offset, (boolean)true);
            }
            catch (BadLocationException badLocationException) {}
            int index = super.getLineStartPosition(document, line, length, offset);
            if (type.equals("org.eclipse.php.PHP_DOC") || type.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
                if (index < length - 1 && line.charAt(index) == '*' && line.charAt(index + 1) != '/') {
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                }
            } else if (index < length - 1 && line.charAt(index) == '/' && line.charAt(index + 1) == '/') {
                ++index;
                while (++index < length && Character.isWhitespace(line.charAt(index))) {
                }
            }
            return index;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int lineLength;
            int caretOffsetInDocument;
            ISourceViewer fSourceViewer;
            StyledText st;
            boolean isSmartHomeEndEnabled = true;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean("useSmartHomeEnd");
            }
            if ((st = (fSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            IDocument document = fSourceViewer.getDocument();
            try {
                caretOffsetInDocument = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)fSourceViewer, (int)caretOffset);
                lineLength = document.getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String line = "";
            if (lineLength > 0) {
                int end = lineOffset + lineLength - 1;
                end = Math.min(end, st.getCharCount() - 1);
                line = st.getText(lineOffset, end);
            }
            int index = this.getLineStartPosition(document, line, lineLength, caretOffsetInDocument);
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == index ? lineOffset : lineOffset + index;
            } else if (caretOffset > lineOffset) {
                newCaretOffset = lineOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            } else {
                st.setCaretOffset(newCaretOffset);
            }
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }
}

