/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.ui.internal.Logger;

public class PresentationCollector
extends AbstractCollection {
    private final TextPresentation fPresentation;
    private int lastOffset;

    PresentationCollector(TextPresentation presentation) {
        Assert.isNotNull((Object)presentation);
        this.fPresentation = presentation;
        this.lastOffset = 0;
    }

    @Override
    public boolean add(Object o) {
        StyleRange range = (StyleRange)o;
        if (this.lastOffset > range.start) {
            IllegalArgumentException e = new IllegalArgumentException("Overlapping start in StyleRange " + range.start + ":" + range.length);
            Logger.logException((Throwable)e);
            throw e;
        }
        if (range.length < 0) {
            IllegalArgumentException e = new IllegalArgumentException("Negative length StyleRange " + range.start + ":" + range.length);
            Logger.logException((Throwable)e);
            return false;
        }
        this.lastOffset = range.start + range.length;
        this.fPresentation.addStyleRange(range);
        return true;
    }

    @Override
    public Iterator iterator() {
        return this.fPresentation.getNonDefaultStyleRangeIterator();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }
}

