/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class UseStatementInjector {
    private ScriptCompletionProposal proposal;

    public UseStatementInjector(ScriptCompletionProposal proposal) {
        this.proposal = proposal;
    }

    private Collection<Identifier> createIdentifiers(AST ast, String namespaceName) {
        String[] split = namespaceName.split("\\\\");
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            identifiers.add(ast.newIdentifier(s));
            ++n2;
        }
        return identifiers;
    }

    private NamespaceDeclaration getCurrentNamespace(Program program, ISourceModule sourceModule, int offset) {
        SourceType ns = (SourceType)PHPModelUtils.getPossibleCurrentNamespace((ISourceModule)sourceModule, (int)offset);
        if (ns == null) {
            if (program.statements() != null && !program.statements().isEmpty() && program.statements().get(0) instanceof NamespaceDeclaration) {
                NamespaceDeclaration result = (NamespaceDeclaration)program.statements().get(0);
                for (Statement statement : program.statements()) {
                    if (statement.getStart() >= offset) {
                        return result;
                    }
                    if (!(statement instanceof NamespaceDeclaration)) continue;
                    result = (NamespaceDeclaration)statement;
                }
                return result;
            }
            return null;
        }
        ASTNode node = null;
        try {
            node = program.getElementAt(ns.getSourceRange().getOffset());
        }
        catch (ModelException modelException) {}
        if (node == null) {
            return null;
        }
        do {
            switch (node.getType()) {
                case 64: {
                    return (NamespaceDeclaration)node;
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String getNamespaceName(NamespaceDeclaration namespaceDecl) {
        StringBuilder nameBuf = new StringBuilder();
        NamespaceName name = namespaceDecl.getName();
        if (name == null) {
            return "\\";
        }
        for (Identifier identifier : name.segments()) {
            if (nameBuf.length() > 0) {
                nameBuf.append('\\');
            }
            nameBuf.append(identifier.getName());
        }
        return nameBuf.toString();
    }

    private boolean needsAliasPrepend(IModelElement modelElement) throws ModelException {
        if (modelElement instanceof IMethod) {
            if (modelElement instanceof FakeConstructor) {
                return true;
            }
            IType declaringType = ((IMethod)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        if (modelElement instanceof IField) {
            IField field = (IField)modelElement;
            if (!PHPFlags.isConstant((int)field.getFlags())) {
                return false;
            }
            IType declaringType = ((IField)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        return true;
    }

    private String readNamespacePrefix(ISourceModule sourceModule, IDocument document, int offset, PHPVersion phpVersion) {
        IStructuredDocumentRegion sRegion;
        if (offset > 0) {
            --offset;
        }
        if ((sRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                try {
                    tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                int elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                TextSequence statement = PHPTextSequenceUtilities.getStatement((int)(elementStart + tRegion.getLength()), (IStructuredDocumentRegion)sRegion, (boolean)true);
                int endPosition = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statement, (int)statement.length());
                int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((PHPVersion)phpVersion, (CharSequence)statement, (int)endPosition, (boolean)true);
                String elementName = statement.subSequence(startPosition, endPosition).toString();
                if (elementName.length() > 0) {
                    return PHPModelUtils.extractNamespaceName((String)elementName, (ISourceModule)sourceModule, (int)offset);
                }
            }
        }
        return null;
    }

    public int inject(IDocument document, ITextViewer textViewer, int offset) {
        IModelElement editorElement;
        ITextEditor textEditor;
        PHPCompletionProposal phpCompletionProposal;
        FakeConstructor fc;
        IModelElement modelElement = this.proposal.getModelElement();
        if (modelElement instanceof FakeConstructor ? (fc = (FakeConstructor)modelElement).getParent() instanceof AliasType : modelElement instanceof AliasType) {
            return offset;
        }
        if (modelElement == null) {
            return offset;
        }
        if (this.proposal instanceof PHPCompletionProposal && ProposalExtraInfo.isNoInsert((Object)(phpCompletionProposal = (PHPCompletionProposal)this.proposal).getExtraInfo())) {
            return offset;
        }
        try {
            IModelElement type;
            if (offset - this.proposal.getReplacementLength() > 0 && document.getChar(offset - this.proposal.getReplacementLength() - 1) == '\\') {
                return offset;
            }
            if (modelElement.getElementType() == 7 && PHPFlags.isNamespace((int)((IType)modelElement).getFlags())) {
                if (offset - this.proposal.getReplacementLength() > 0) {
                    IModelElement editorElement2;
                    ITextEditor textEditor2;
                    String prefix = document.get(offset - this.proposal.getReplacementLength(), this.proposal.getReplacementLength());
                    String fullName = ((IType)modelElement).getElementName();
                    if (fullName.startsWith(prefix) && prefix.indexOf(92) < 0 && (textEditor2 = ((PHPStructuredTextViewer)textViewer).getTextEditor()) instanceof PHPStructuredEditor && (editorElement2 = ((PHPStructuredEditor)textEditor2).getModelElement()) != null) {
                        String typeName;
                        ISourceModule sourceModule = ((ModelElement)editorElement2).getSourceModule();
                        String namespaceName = fullName;
                        if (fullName.indexOf(92) > 0) {
                            namespaceName = fullName.substring(0, fullName.indexOf(92));
                        }
                        String usePartName = namespaceName;
                        boolean useAlias = !Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertFullyQualifiedNameForNamespaceCheckBox", true, null);
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                        TextEdit edits = null;
                        ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
                        parser.setSource(document.get().toCharArray());
                        Program program = parser.createAST(null);
                        if (this.isSameNamespace(namespaceName, program, sourceModule, offset)) {
                            return offset;
                        }
                        UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)usePartName, (int)offset);
                        List<String> importedTypeName = this.getImportedTypeName(moduleDeclaration, offset);
                        if (!importedTypeName.contains(typeName = namespaceName)) {
                            int beginLine;
                            int index;
                            program.recordModifications();
                            AST ast = program.getAST();
                            NamespaceName newNamespaceName = ast.newNamespaceName(this.createIdentifiers(ast, usePartName), false, false);
                            UseStatementPart newUseStatementPart = ast.newUseStatementPart(newNamespaceName, null);
                            org.eclipse.php.internal.core.ast.nodes.UseStatement newUseStatement = ast.newUseStatement(Arrays.asList(newUseStatementPart));
                            NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
                            if (currentNamespace != null) {
                                index = this.getLastUsestatementIndex(currentNamespace.getBody().statements(), offset);
                                if (index > 0) {
                                    try {
                                        beginLine = document.getLineOfOffset(((Statement)currentNamespace.getBody().statements().get(index - 1)).getEnd()) + 1;
                                        newUseStatement.setSourceRange(document.getLineOffset(beginLine), 0);
                                    }
                                    catch (Exception exception) {}
                                }
                                currentNamespace.getBody().statements().add(index, newUseStatement);
                            } else {
                                index = this.getLastUsestatementIndex(program.statements(), offset);
                                if (index > 0) {
                                    try {
                                        beginLine = document.getLineOfOffset(((Statement)program.statements().get(index - 1)).getEnd()) + 1;
                                        newUseStatement.setSourceRange(document.getLineOffset(beginLine), 0);
                                    }
                                    catch (Exception exception) {}
                                }
                                program.statements().add(index, newUseStatement);
                            }
                            HashMap<String, String> options = new HashMap<String, String>(PHPCorePlugin.getOptions());
                            IScopeContext[] contents = new IScopeContext[]{new ProjectScope(modelElement.getScriptProject().getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
                            int i = 0;
                            while (i < contents.length) {
                                IScopeContext scopeContext = contents[i];
                                IEclipsePreferences node = scopeContext.getNode("org.eclipse.php.core");
                                if (node != null) {
                                    String size;
                                    String useTabs;
                                    if (!options.containsKey("org.eclipse.php.core.phpForamtterUseTabs") && (useTabs = node.get("org.eclipse.php.core.phpForamtterUseTabs", null)) != null) {
                                        options.put("org.eclipse.php.core.phpForamtterUseTabs", useTabs);
                                    }
                                    if (!options.containsKey("org.eclipse.php.core.phpForamtterIndentationSize") && (size = node.get("org.eclipse.php.core.phpForamtterIndentationSize", null)) != null) {
                                        options.put("org.eclipse.php.core.phpForamtterIndentationSize", size);
                                    }
                                }
                                ++i;
                            }
                            ast.setInsertUseStatement(true);
                            edits = program.rewrite(document, options);
                            edits.apply(document);
                            ast.setInsertUseStatement(false);
                        } else if (!(useAlias || usePart != null && usePartName.equals(usePart.getNamespace().getFullyQualifiedName()))) {
                            this.proposal.setReplacementString(String.valueOf('\\') + fullName);
                        }
                        if (edits != null) {
                            int replacementOffset = this.proposal.getReplacementOffset() + edits.getLength();
                            offset += edits.getLength();
                            this.proposal.setReplacementOffset(replacementOffset);
                        }
                    }
                    return offset;
                }
                return offset;
            }
            if (modelElement.getElementType() != 7 && !(modelElement instanceof FakeConstructor) && (type = modelElement.getAncestor(7)) != null && !PHPFlags.isNamespace((int)((IType)type).getFlags())) {
                return offset;
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)modelElement);
        if (namespace != null && textViewer instanceof PHPStructuredTextViewer && (textEditor = ((PHPStructuredTextViewer)textViewer).getTextEditor()) instanceof PHPStructuredEditor && (editorElement = ((PHPStructuredEditor)textEditor).getModelElement()) != null) {
            ISourceModule sourceModule = ((ModelElement)editorElement).getSourceModule();
            try {
                boolean useAlias;
                String namespaceName;
                String usePartName = namespaceName = namespace.getElementName();
                boolean bl = useAlias = !Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertFullyQualifiedNameForNamespaceCheckBox", true, null);
                if (!useAlias) {
                    usePartName = String.valueOf(usePartName) + '\\' + modelElement.getElementName();
                }
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                TextEdit edits = null;
                ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
                parser.setSource(document.get().toCharArray());
                Program program = parser.createAST(null);
                if (this.isSameNamespace(namespaceName, program, sourceModule, offset)) {
                    return offset;
                }
                UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)usePartName, (int)offset);
                List<String> importedTypeName = this.getImportedTypeName(moduleDeclaration, offset);
                String typeName = "";
                typeName = !useAlias ? modelElement.getElementName().toLowerCase() : (usePart != null && usePart.getAlias() != null && usePart.getAlias().getName() != null ? usePart.getAlias().getName() : PHPModelUtils.extractElementName((String)namespaceName).toLowerCase());
                if (!importedTypeName.contains(typeName)) {
                    int beginLine;
                    int index;
                    program.recordModifications();
                    AST ast = program.getAST();
                    NamespaceName newNamespaceName = ast.newNamespaceName(this.createIdentifiers(ast, usePartName), false, false);
                    UseStatementPart newUseStatementPart = ast.newUseStatementPart(newNamespaceName, null);
                    org.eclipse.php.internal.core.ast.nodes.UseStatement newUseStatement = ast.newUseStatement(Arrays.asList(newUseStatementPart));
                    NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
                    if (currentNamespace != null) {
                        index = this.getLastUsestatementIndex(currentNamespace.getBody().statements(), offset);
                        if (index > 0) {
                            try {
                                beginLine = document.getLineOfOffset(((Statement)currentNamespace.getBody().statements().get(index - 1)).getEnd()) + 1;
                                newUseStatement.setSourceRange(document.getLineOffset(beginLine), 0);
                            }
                            catch (Exception exception) {}
                        }
                        currentNamespace.getBody().statements().add(index, newUseStatement);
                    } else {
                        index = this.getLastUsestatementIndex(program.statements(), offset);
                        if (index > 0) {
                            try {
                                beginLine = document.getLineOfOffset(((Statement)program.statements().get(index - 1)).getEnd()) + 1;
                                newUseStatement.setSourceRange(document.getLineOffset(beginLine), 0);
                            }
                            catch (Exception exception) {}
                        }
                        program.statements().add(index, newUseStatement);
                    }
                    HashMap<String, String> options = new HashMap<String, String>(PHPCorePlugin.getOptions());
                    IScopeContext[] contents = new IScopeContext[]{new ProjectScope(modelElement.getScriptProject().getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
                    int i = 0;
                    while (i < contents.length) {
                        IScopeContext scopeContext = contents[i];
                        IEclipsePreferences node = scopeContext.getNode("org.eclipse.php.core");
                        if (node != null) {
                            String size;
                            String useTabs;
                            if (!options.containsKey("org.eclipse.php.core.phpForamtterUseTabs") && (useTabs = node.get("org.eclipse.php.core.phpForamtterUseTabs", null)) != null) {
                                options.put("org.eclipse.php.core.phpForamtterUseTabs", useTabs);
                            }
                            if (!options.containsKey("org.eclipse.php.core.phpForamtterIndentationSize") && (size = node.get("org.eclipse.php.core.phpForamtterIndentationSize", null)) != null) {
                                options.put("org.eclipse.php.core.phpForamtterIndentationSize", size);
                            }
                        }
                        ++i;
                    }
                    ast.setInsertUseStatement(true);
                    edits = program.rewrite(document, options);
                    edits.apply(document);
                    ast.setInsertUseStatement(false);
                } else if (!(useAlias || usePart != null && usePartName.equals(usePart.getNamespace().getFullyQualifiedName()))) {
                    this.proposal.setReplacementString(String.valueOf('\\') + namespaceName + '\\' + this.proposal.getReplacementString());
                }
                if (useAlias && this.needsAliasPrepend(modelElement)) {
                    String namespacePrefix = String.valueOf(typeName) + '\\';
                    String replacementString = this.proposal.getReplacementString();
                    String existingNamespacePrefix = this.readNamespacePrefix(sourceModule, document, offset, ProjectOptions.getPhpVersion((IModelElement)editorElement));
                    if (!usePartName.equals(existingNamespacePrefix)) {
                        replacementString = String.valueOf(namespacePrefix) + replacementString;
                    }
                    this.proposal.setReplacementString(replacementString);
                }
                if (edits != null) {
                    int replacementOffset = this.proposal.getReplacementOffset() + edits.getLength();
                    offset += edits.getLength();
                    this.proposal.setReplacementOffset(replacementOffset);
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
        }
        return offset;
    }

    private int getLastUsestatementIndex(List<Statement> statements, int offset) {
        int result = 0;
        int i = 0;
        while (i < statements.size()) {
            Statement statement = statements.get(i);
            if (statement.getEnd() <= offset && statement instanceof org.eclipse.php.internal.core.ast.nodes.UseStatement) {
                result = i + 1;
            }
            ++i;
        }
        return result;
    }

    private List<String> getImportedTypeName(ModuleDeclaration moduleDeclaration, int offset) {
        UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)offset);
        ArrayList<String> importedClass = new ArrayList<String>();
        UseStatement[] useStatementArray = useStatements;
        int n = useStatements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            for (UsePart usePart : statement.getParts()) {
                String name = usePart.getAlias() != null ? usePart.getAlias().getName() : usePart.getNamespace().getName();
                importedClass.add(name.toLowerCase());
            }
            ++n2;
        }
        return importedClass;
    }

    private boolean isSameNamespace(String namespaceName, Program program, ISourceModule sourceModule, int offset) {
        NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
        if (currentNamespace == null) {
            return false;
        }
        return namespaceName.equals(this.getNamespaceName(currentNamespace));
    }
}

