/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PHPFileCreationWizardPage
extends WizardPage {
    protected Text containerText;
    protected Text fileText;
    private ISelection selection;
    protected static final String UTF_8 = "UTF 8";
    protected static final String NO_TEMPLATE = "-- none -- ";
    protected Label targetResourceLabel;

    public PHPFileCreationWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(PHPUIMessages.PHPFileCreationWizardPage_3);
        this.setDescription(PHPUIMessages.PHPFileCreationWizardPage_4);
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_FILE);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(PHPUIMessages.PHPFileCreationWizardPage_5);
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(PHPUIMessages.PHPFileCreationWizardPage_6);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPFileCreationWizardPage.this.handleBrowse();
            }
        });
        this.targetResourceLabel = new Label(container, 0);
        this.targetResourceLabel.setText(PHPUIMessages.PHPFileCreationWizardPage_7);
        this.fileText = new Text(container, 2052);
        this.fileText.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.creating_a_php_file_within_a_project");
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IAdaptable) {
                obj = ((IAdaptable)obj).getAdapter(IResource.class);
            }
            IContainer container = null;
            if (obj instanceof IResource) {
                container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
            }
            if (container != null) {
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.setInitialFileName(PHPUIMessages.PHPFileCreationWizardPage_8);
    }

    protected void setInitialFileName(String fileName) {
        this.fileText.setText(fileName);
        this.fileText.setSelection(0, 7);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, PHPUIMessages.PHPFileCreationWizardPage_9);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    protected void dialogChanged() {
        IContentType contentType;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_10);
            return;
        }
        IContainer containerFolder = this.getContainer(container);
        if (containerFolder == null || !containerFolder.exists()) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_11);
            return;
        }
        if (!containerFolder.getProject().isOpen()) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_12);
            return;
        }
        if (fileName == null) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_15);
            return;
        }
        if (!fileName.equals("") && containerFolder.getFile((IPath)new Path(fileName)).exists()) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_14);
            return;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (fileName.length() == 0 || dotIndex == 0) {
            this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_15);
            return;
        }
        if (dotIndex != -1) {
            String fileNameWithoutExtention = fileName.substring(0, dotIndex);
            int i = 0;
            while (i < fileNameWithoutExtention.length()) {
                char ch = fileNameWithoutExtention.charAt(i);
                if (!Character.isJavaIdentifierPart(ch) && ch != '.' && ch != '-') {
                    this.updateStatus(PHPUIMessages.PHPFileCreationWizardPage_16);
                    return;
                }
                ++i;
            }
        }
        if (!(contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP)).isAssociatedWith(fileName)) {
            String[] fileExtensions = contentType.getFileSpecs(8);
            StringBuffer buffer = new StringBuffer(PHPUIMessages.PHPFileCreationWizardPage_17);
            buffer.append(fileExtensions[0]);
            String[] stringArray = fileExtensions;
            int n = fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                buffer.append(", ").append(extension);
                ++n2;
            }
            buffer.append("]");
            this.updateStatus(buffer.toString());
            return;
        }
        this.updateStatus(null);
    }

    protected IContainer getContainer(String text) {
        Path path = new Path(text);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        return resource instanceof IContainer ? (IContainer)resource : null;
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public void setContainerName(String containerPath) {
        this.containerText.setText(containerPath);
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public IProject getProject() {
        String projectName = this.getContainerName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectName));
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource != null) {
            project = resource.getProject();
        }
        return project;
    }
}

