/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;

public abstract class AbstractOccurrencesFinder
extends AbstractVisitor
implements IOccurrencesFinder {
    protected static final String BASE_DESCRIPTION = CoreMessages.getString("AbstractOccurrencesFinder.0");
    protected static final String BASE_WRITE_DESCRIPTION = CoreMessages.getString("AbstractOccurrencesFinder.1");
    protected static final String BRACKETS = "()";
    protected List<IOccurrencesFinder.OccurrenceLocation> fResult;
    protected String fDescription;
    protected Program fASTRoot;
    protected ProblemDesc[] fProblems;
    protected NamespaceDeclaration fCurrentNamespace;
    protected Map<String, UseStatementPart> fLastUseParts = new HashMap<String, UseStatementPart>();

    @Override
    public String initialize(Program root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform(root, offset, length));
    }

    @Override
    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        this.findOccurrences();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public static ProblemDesc[] getProblems(Program node) {
        block5: {
            if (node.getSourceModule() != null) break block5;
            return null;
        }
        try {
            IResource resource = node.getSourceModule().getUnderlyingResource();
            if (resource != null) {
                IMarker[] markers = resource.findMarkers("org.eclipse.dltk.core.problem", true, 1);
                ProblemDesc[] problems = new ProblemDesc[markers.length];
                int i = 0;
                while (i < markers.length) {
                    problems[i] = new ProblemDesc(markers[i].getAttribute("id", 0), markers[i].getAttribute("charStart", 0), markers[i].getAttribute("charEnd", 0), markers[i].getAttribute("severity", 0));
                    ++i;
                }
                return problems;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected boolean hasProblems(int offset, int end) {
        if (this.fProblems != null) {
            ProblemDesc[] problemDescArray = this.fProblems;
            int n = this.fProblems.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemDesc problemDesc = problemDescArray[n2];
                if (problemDesc.offset <= offset && problemDesc.end >= end) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void addOccurrence(IOccurrencesFinder.OccurrenceLocation location) {
        if (!this.hasProblems(location.getOffset(), location.getOffset() + location.getLength())) {
            this.fResult.add(location);
        }
    }

    protected abstract void findOccurrences();

    protected abstract int getOccurrenceType(ASTNode var1);

    @Override
    public Program getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getJobLabel() {
        return "OccurrencesFinder_job_label";
    }

    @Override
    public int getSearchKind() {
        return 5;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return "OccurrencesFinder_label_plural";
    }

    @Override
    public String getUnformattedSingularLabel() {
        return "OccurrencesFinder_label_singular";
    }

    @Override
    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        this.fCurrentNamespace = namespaceDeclaration;
        this.fLastUseParts.clear();
        return true;
    }

    @Override
    public void endVisit(NamespaceDeclaration namespaceDeclaration) {
        this.fCurrentNamespace = null;
        this.fLastUseParts.clear();
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        List<UseStatementPart> useParts = useStatement.parts();
        for (UseStatementPart part : useParts) {
            String name = null;
            if (part.getAlias() != null) {
                name = part.getAlias().getName();
            } else {
                name = part.getName().getName();
                int index = name.lastIndexOf(92);
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
            }
            this.fLastUseParts.put(name, part);
        }
        return true;
    }

    public static String getFullName(Identifier identifier, Map<String, UseStatementPart> lastUseParts, NamespaceDeclaration currentNamespace) {
        return AbstractOccurrencesFinder.getFullName(identifier.getName(), lastUseParts, currentNamespace);
    }

    public static String getFullName(String fullName, Map<String, UseStatementPart> lastUseParts, NamespaceDeclaration currentNamespace) {
        if (fullName.charAt(0) != '\\') {
            int index = fullName.lastIndexOf(92);
            if (index >= 0) {
                String namespace = fullName.substring(0, index);
                if (lastUseParts.containsKey(namespace)) {
                    fullName = lastUseParts.get(namespace).getName().getName() + '\\' + fullName.substring(index + 1);
                }
            } else if (lastUseParts.containsKey(fullName)) {
                fullName = lastUseParts.get(fullName).getName().getName();
            } else if (currentNamespace != null && currentNamespace.getName() != null) {
                fullName = currentNamespace.getName().getName() + '\\' + fullName;
            }
        }
        if (fullName.charAt(0) == '\\') {
            fullName = fullName.substring(1);
        }
        return fullName;
    }

    static class ProblemDesc {
        int kind;
        int offset;
        int end;
        int severity;

        public ProblemDesc(int kind, int offset, int end, int severity) {
            this.kind = kind;
            this.offset = offset;
            this.end = end;
            this.severity = severity;
        }

        public boolean isError() {
            return (this.severity & 2) != 0;
        }
    }
}

