/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;

public class XMLPreferencesWriter {
    public static final char DELIMITER = '\u0005';

    public static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLPreferencesWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    protected static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLPreferencesWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    protected static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    protected static void write(StringBuffer sb, HashMap map) {
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            sb.append("<");
            sb.append(key);
            sb.append(">");
            Object object = entry.getValue();
            if (object instanceof HashMap) {
                XMLPreferencesWriter.write(sb, (HashMap)object);
            } else if (object != null) {
                sb.append(XMLPreferencesWriter.getEscaped(object.toString()));
            } else {
                sb.append("");
            }
            sb.append("</");
            sb.append(key);
            sb.append(">");
        }
    }

    public static void write(Preferences pluginPreferences, String prefsKey, IXMLPreferencesStorable[] objects) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(sb, objects);
        pluginPreferences.setValue(prefsKey, sb.toString());
    }

    public static void write(Preferences pluginPreferences, String prefsKey, IXMLPreferencesStorable object) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.write(sb, object.storeToMap());
        pluginPreferences.setValue(prefsKey, sb.toString());
    }

    protected static void appendDelimitedString(StringBuffer buffer, IXMLPreferencesStorable[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                XMLPreferencesWriter.write(buffer, elements[i].storeToMap());
                if (i < elements.length - 1) {
                    buffer.append('\u0005');
                }
                ++i;
            }
        }
    }

    public static String storableElementsToString(IXMLPreferencesStorable[] elements) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(sb, elements);
        return sb.toString();
    }
}

