/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java_cup.runtime.Symbol;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.core.DocumentReader;
import org.eclipse.php.formatter.core.Logger;
import org.eclipse.php.formatter.core.ReplaceEdit;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DereferenceNode;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.compiler.ast.nodes.Comment;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.compiler.ast.parser.php54.CompilerAstLexer;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CodeFormatterVisitor
extends AbstractVisitor
implements ICodeFormattingProcessor {
    public static final int NO_LINE_WRAP = 0;
    public static final int FIRST_WRAP_WHEN_NECESSARY = 1;
    public static final int WRAP_FIRST_ELEMENT = 2;
    public static final int WRAP_ALL_ELEMENTS = 3;
    public static final int WRAP_ALL_ELEMENTS_NO_INDENT_FIRST = 4;
    public static final int WRAP_ALL_ELEMENTS_EXCEPT_FIRST = 5;
    public static final int ALWAYS_WRAP_ELEMENT = 6;
    public static final int WRAP_WHEN_NECESSARY = 7;
    private static final int NO_LINE_WRAP_INDENT = -1;
    private static final int DEFAULT_INDENTATION = 0;
    private static final int INDENT_ON_COLUMN = 1;
    private static final int INDENT_ONE = 2;
    private static final String EMPTY_STRING = "";
    private static final String FUNCTION_NAME_PRINT = "print";
    private static final byte PHP_OPEN_TAG = 0;
    private static final byte PHP_OPEN_SHORT_TAG = 1;
    private static final char PHP_OPEN_SHORT_TAG_WITH_EQUAL = '\u0002';
    private static final char PHP_OPEN_ASP_TAG = '\u0003';
    private static final char EQUAL = '=';
    private static final String KEY_VALUE_OPERATOR = "=>";
    private static final char OPEN_PARN = '(';
    private static final char CLOSE_PARN = ')';
    private static final char OPEN_CURLY = '{';
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char COLON = ':';
    private static final char SEMICOLON = ';';
    private static final char SPACE = ' ';
    private static final char COMMA = ',';
    private static final char QUESTION_MARK = '?';
    private static final char PHPDOC_CLASS_SEPARATOR = '|';
    private String lineSeparator;
    private CodeFormatterPreferences preferences;
    private final IDocument document;
    private PHPVersion phpVersion;
    private boolean useShortTags;
    private int indentationLevel;
    private boolean indentationLevelDesending = false;
    private AstLexer astLexer;
    private boolean isPhpEqualTag = false;
    private int startRegionPosition = -1;
    private int endRegionPosition = Integer.MAX_VALUE;
    private boolean isPrevSpace = false;
    private boolean isHeredocSemicolon = false;
    private int lineWidth = 0;
    private int binaryExpressionLineWrapPolicy = -1;
    private int binaryExpressionIndentGap = 0;
    private boolean wasBinaryExpressionWrapped = false;
    private String binaryExpressionSavedBuffer = null;
    private InfixExpression binaryExpressionSavedNode = null;
    private int binaryExpressionSavedChangesIndex = -1;
    private int binaryExpressionRevertPolicy = -1;
    private boolean isBinaryExpressionExtraIndentation = false;
    private StringBuffer replaceBuffer = new StringBuffer();
    private List<Symbol> tokens = new ArrayList<Symbol>();
    private List<ReplaceEdit> changes = new LinkedList<ReplaceEdit>();
    private int stInScriptin = -1;
    private boolean isInsideFun;
    private Stack<Integer> chainStack = new Stack();
    private Integer peek;
    private Set<IfStatement> processedIfStatements = new HashSet<IfStatement>();
    private boolean newLineOfComment;
    private List<String> commentWords;
    boolean editsEnabled;
    boolean useTags;
    int tagsKind;
    private String disablingTag;
    private String enablingTag;
    private boolean doNotIndent = false;
    boolean inComment = false;
    private int indentLengthForComment;
    private String indentStringForComment;
    private boolean blockEnd;
    private boolean recordCommentIndentVariables = false;
    private List<Integer> indentationLevelList = new ArrayList<Integer>();
    Stack<CommentIndentationObject> commentIndetationStack = new Stack();
    private boolean ignoreEmptyLineSetting = false;

    public CodeFormatterVisitor(IDocument document, CodeFormatterPreferences codeFormatterPreferences, String lineSeparator, PHPVersion phpVersion, boolean useShortTags, IRegion region) throws Exception {
        this(document, codeFormatterPreferences, lineSeparator, phpVersion, useShortTags, region, 0);
    }

    public CodeFormatterVisitor(IDocument document, CodeFormatterPreferences codeFormatterPreferences, String lineSeparator, PHPVersion phpVersion, boolean useShortTags, IRegion region, int indentationLevel) throws Exception {
        this.phpVersion = phpVersion;
        this.useShortTags = useShortTags;
        this.document = document;
        this.lineSeparator = lineSeparator;
        this.indentationLevel = indentationLevel;
        this.preferences = codeFormatterPreferences;
        this.startRegionPosition = region.getOffset();
        this.endRegionPosition = this.startRegionPosition + region.getLength();
        this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
        Program program = null;
        try {
            StringReader reader = new StringReader(document.get());
            program = ASTParser.newParser((Reader)reader, (PHPVersion)phpVersion, (boolean)true).createAST((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            Logger.log(1, "Parsing error, file could not be formatted.");
        }
        this.useTags = this.preferences.use_tags;
        this.tagsKind = 0;
        if (this.useTags) {
            if (this.preferences.disabling_tag != null && this.preferences.disabling_tag.length > 0) {
                this.disablingTag = new String(this.preferences.disabling_tag);
            }
            if (this.preferences.enabling_tag != null && this.preferences.enabling_tag.length > 0) {
                this.enablingTag = new String(this.preferences.enabling_tag);
            }
        }
        this.editsEnabled = true;
        if (program != null) {
            program.accept((Visitor)this);
        }
    }

    public CodeFormatterVisitor(IDocument document, String lineSeparator, PHPVersion phpVersion, boolean useShortTags, IRegion region) throws Exception {
        this(document, CodeFormatterPreferences.getDefaultPreferences(), lineSeparator, phpVersion, useShortTags, region, 0);
    }

    private void appendToBuffer(Object obj) {
        this.isPrevSpace = false;
        if (obj == null) {
            return;
        }
        this.replaceBuffer.append(obj);
        if (!this.lineSeparator.equals(obj)) {
            this.lineWidth += obj.toString().length();
        }
    }

    private int checkFirstTokenLength(int start, int end) {
        int length = 0;
        try {
            this.scan(start, end);
            Symbol token = this.tokens.get(0);
            length = token.right - token.left;
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return length;
    }

    private int countStrInBuffer(String str) {
        int count = 0;
        int index = this.replaceBuffer.indexOf(str);
        while (index >= 0 && index < this.replaceBuffer.length()) {
            index = this.replaceBuffer.indexOf(str, index + 1);
            ++count;
        }
        return count;
    }

    private char getBufferFirstChar(int position) throws BadLocationException {
        int offset = position;
        while (offset < this.replaceBuffer.length()) {
            char currChar = this.replaceBuffer.charAt(offset);
            if (currChar != ' ' && currChar != '\t' && currChar != '\r' && currChar != '\n') {
                return currChar;
            }
            ++offset;
        }
        return '\u0000';
    }

    public List<ReplaceEdit> getChanges() {
        IRegion[] partitions = new IRegion[]{};
        try {
            partitions = this.getAllSingleLine(TextUtilities.computePartitioning((IDocument)this.document, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)0, (int)this.document.getLength(), (boolean)false));
        }
        catch (BadLocationException badLocationException) {}
        List<ReplaceEdit> allChanges = Collections.unmodifiableList(this.changes);
        ArrayList<ReplaceEdit> result = new ArrayList<ReplaceEdit>();
        for (ReplaceEdit edit : allChanges) {
            if (this.isInSingleLine(edit, partitions, 0)) continue;
            result.add(edit);
        }
        return Collections.unmodifiableList(result);
    }

    private int getCharPosition(int start, int end, char c) {
        try {
            int index = 0;
            while (start + index < end) {
                if (this.document.getChar(start + index) == c) {
                    return start + index;
                }
                ++index;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return -1;
    }

    private String getDocumentString(int start, int end) {
        char[] result = new char[end - start];
        try {
            int index = 0;
            while (start + index < end) {
                result[index] = this.document.getChar(start + index);
                ++index;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return new String(result);
    }

    private AstLexer getLexer(Reader reader) throws Exception {
        org.eclipse.php.internal.core.compiler.ast.parser.php5.CompilerAstLexer result = null;
        if (PHPVersion.PHP5.equals((Object)this.phpVersion)) {
            result = new org.eclipse.php.internal.core.compiler.ast.parser.php5.CompilerAstLexer(reader);
            result.setAST(new AST(reader, PHPVersion.PHP5, false, this.useShortTags));
            this.stInScriptin = 1;
        } else if (PHPVersion.PHP4.equals((Object)this.phpVersion)) {
            result = new org.eclipse.php.internal.core.compiler.ast.parser.php4.CompilerAstLexer(reader);
            ((org.eclipse.php.internal.core.compiler.ast.parser.php4.CompilerAstLexer)result).setAST(new AST(reader, PHPVersion.PHP4, false, this.useShortTags));
            this.stInScriptin = 2;
        } else if (PHPVersion.PHP5_3.equals((Object)this.phpVersion)) {
            result = new org.eclipse.php.internal.core.compiler.ast.parser.php53.CompilerAstLexer(reader);
            ((org.eclipse.php.internal.core.compiler.ast.parser.php53.CompilerAstLexer)result).setAST(new AST(reader, PHPVersion.PHP5_3, false, this.useShortTags));
            this.stInScriptin = 1;
        } else if (PHPVersion.PHP5_4.equals((Object)this.phpVersion)) {
            result = new CompilerAstLexer(reader);
            ((CompilerAstLexer)result).setAST(new AST(reader, PHPVersion.PHP5_4, false, this.useShortTags));
            this.stInScriptin = 1;
        } else if (PHPVersion.PHP5_5.equals((Object)this.phpVersion)) {
            result = new org.eclipse.php.internal.core.compiler.ast.parser.php55.CompilerAstLexer(reader);
            ((org.eclipse.php.internal.core.compiler.ast.parser.php55.CompilerAstLexer)result).setAST(new AST(reader, PHPVersion.PHP5_5, false, this.useShortTags));
            this.stInScriptin = 1;
        } else {
            throw new IllegalArgumentException("unrecognized version " + this.phpVersion);
        }
        return result;
    }

    private byte getPhpStartTag(int offset) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        if (this.document.getChar(offset) != '<') break block6;
                        if (this.document.getChar(offset + 1) != '%') break block7;
                        return 3;
                    }
                    if (this.document.getChar(offset + 2) != '=') break block8;
                    return 2;
                }
                if (this.document.getChar(offset + 2) == 'p' || this.document.getChar(offset + 2) == 'P') break block9;
                return 1;
            }
            try {
                if (this.document.getChar(offset + 1) == '?') {
                    return 0;
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return -1;
    }

    private int getPhpTagIndentationLevel(int offset) {
        int diff;
        block5: {
            try {
                int line = this.document.getLineOfOffset(offset);
                int startLineOffset = this.document.getLineOffset(line);
                diff = 0;
                int i = startLineOffset;
                while (i < offset) {
                    if (this.document.getChar(i) != '\t' && this.document.getChar(i) != ' ') break;
                    ++diff;
                    ++i;
                }
                if (this.preferences.indentationChar == '\t') {
                    return diff;
                }
                if (this.preferences.indentationSize > 0) break block5;
                return -1;
            }
            catch (Exception e) {
                Logger.logException(e);
                return -1;
            }
        }
        return diff / this.preferences.indentationSize;
    }

    private void handleAction(int lastPosition, Statement action, boolean addNewlineBeforeAction) {
        boolean isIndentationAdded = false;
        if (action.getType() == 6) {
            isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
        } else if (action.getType() == 22) {
            if (this.preferences.new_line_for_empty_statement) {
                this.insertNewLine();
                ++this.indentationLevel;
                this.indent();
                isIndentationAdded = true;
            }
        } else if (addNewlineBeforeAction) {
            ++this.indentationLevel;
            this.insertNewLine();
            this.indent();
            isIndentationAdded = true;
        } else {
            this.insertSpace();
        }
        this.handleChars(lastPosition, action.getStart());
        action.accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
    }

    private boolean handleBlockOpenBrace(byte bracePosition, boolean placeSpaceBeforeOpenCurly) {
        boolean isIndentationAdded = false;
        switch (bracePosition) {
            case 2: {
                ++this.indentationLevel;
                isIndentationAdded = true;
            }
            case 1: {
                this.insertNewLine();
                this.indent();
                break;
            }
            default: {
                if (!placeSpaceBeforeOpenCurly) break;
                this.insertSpace();
            }
        }
        return isIndentationAdded;
    }

    private void handleChars(int offset, int end) {
        try {
            if (this.startRegionPosition < end && this.endRegionPosition >= end) {
                boolean hasComments = this.hasComments(offset, end);
                if (hasComments) {
                    this.handleComments(offset, end, this.astLexer.getCommentList(), false, 0);
                } else {
                    this.handleCharsWithoutComments(offset, end);
                }
            }
            this.replaceBuffer.setLength(0);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void handleChars1(int offset, int end, boolean isIndented, int indentGap) {
        try {
            if (this.startRegionPosition < end && this.endRegionPosition >= end) {
                boolean hasComments = this.hasComments(offset, end);
                if (hasComments) {
                    this.handleComments(offset, end, this.astLexer.getCommentList(), isIndented, indentGap);
                } else {
                    this.handleCharsWithoutComments(offset, end);
                }
            }
            this.replaceBuffer.setLength(0);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private boolean hasComments(int offset, int end) throws Exception {
        this.scan(offset, end);
        assert (this.astLexer != null);
        boolean hasComments = this.astLexer.getCommentList().size() > 0;
        return hasComments;
    }

    private void handleCharsWithoutComments(int offset, int end) throws BadLocationException {
        this.handleCharsWithoutComments(offset, end, false);
    }

    private void handleCharsWithoutComments(int offset, int end, boolean isComment) throws BadLocationException {
        String content = this.document.get(offset, end - offset).toLowerCase();
        int phpTagOpenIndex = -1;
        if (!(isComment || (phpTagOpenIndex = content.indexOf("<?")) == -1 && (phpTagOpenIndex = content.indexOf("<%")) == -1)) {
            this.handleSplittedPhpBlock(offset + phpTagOpenIndex, end);
        } else {
            this.isPrevSpace = false;
            int startLine = this.document.getLineOfOffset(offset);
            int endLine = this.document.getLineOfOffset(end);
            int emptyLines = 0;
            if (!this.ignoreEmptyLineSetting) {
                int line = startLine;
                while (line < endLine) {
                    if (this.isEmptyLine(line)) {
                        ++emptyLines;
                    }
                    ++line;
                }
                if (emptyLines > this.preferences.blank_line_preserve_empty_lines) {
                    emptyLines = this.preferences.blank_line_preserve_empty_lines;
                }
                int newLinesInBuffer = this.countStrInBuffer(this.lineSeparator);
                if (emptyLines > 0 && newLinesInBuffer < emptyLines + 1) {
                    int line2 = newLinesInBuffer;
                    while (line2 < emptyLines + 1) {
                        this.insertNewLine();
                        ++line2;
                    }
                    if (this.inComment) {
                        if (!this.doNotIndent) {
                            this.indentForComment(this.indentationLevelDesending);
                        }
                    } else {
                        this.indent();
                    }
                }
            }
            this.ignoreEmptyLineSetting = false;
            boolean needToReplace = true;
            if (end - offset == this.replaceBuffer.length()) {
                if (end - offset == 0 && this.replaceBuffer.length() == 0) {
                    needToReplace = false;
                } else {
                    needToReplace = false;
                    int index = 0;
                    while (offset + index < end) {
                        char bufferChar;
                        char docChar = this.document.getChar(offset + index);
                        if (docChar != (bufferChar = this.replaceBuffer.charAt(index))) {
                            needToReplace = true;
                            break;
                        }
                        ++index;
                    }
                }
            }
            if (needToReplace && this.editsEnabled) {
                this.insertString(offset, end, this.replaceBuffer.toString());
            }
            if (this.recordCommentIndentVariables) {
                this.recordCommentIndentVariables = false;
                this.indentLengthForComment = this.lineWidth;
                String afterNewLine = EMPTY_STRING;
                int position = this.replaceBuffer.lastIndexOf(this.lineSeparator);
                if (position >= 0) {
                    if (this.getBufferFirstChar(position + this.lineSeparator.length()) == '\u0000') {
                        afterNewLine = this.replaceBuffer.substring(position + this.lineSeparator.length(), this.replaceBuffer.length());
                    }
                } else if (this.getBufferFirstChar(0) == '\u0000') {
                    afterNewLine = this.replaceBuffer.toString();
                }
                this.indentStringForComment = afterNewLine;
            }
            this.indentationLevelDesending = false;
            this.replaceBuffer.setLength(0);
        }
    }

    private int handleCommaList(ASTNode[] array, int lastPosition, boolean insertSpaceBeforeComma, boolean insertSpaceAfterComma, int lineWrapPolicy, int indentGap, boolean forceSplit) {
        int oldIndentationLevel = this.indentationLevel;
        boolean wasBinaryExpressionWrapped = this.wasBinaryExpressionWrapped;
        if (array.length == 0) {
            return lastPosition;
        }
        String savedBuffer = this.replaceBuffer.toString();
        int changesIndex = this.changes.size() - 1;
        int savedLastPosition = lastPosition;
        boolean isExtraIndentation = false;
        CommentIndentationObject cio = new CommentIndentationObject();
        this.commentIndetationStack.add(cio);
        boolean isFirst = true;
        int i = 0;
        while (i < array.length) {
            FunctionInvocation functionInvocation;
            if (!isFirst) {
                if (insertSpaceBeforeComma) {
                    this.insertSpace();
                }
                this.appendToBuffer(Character.valueOf(','));
                if (insertSpaceAfterComma) {
                    this.insertSpace();
                }
            }
            if (i == 1 && lineWrapPolicy == 5) {
                savedBuffer = this.replaceBuffer.toString();
                changesIndex = this.changes.size() - 1;
                savedLastPosition = lastPosition;
            }
            switch (lineWrapPolicy) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    lineWrapPolicy = 7;
                    this.insertNewLine();
                    if (!cio.indented) {
                        this.indentationLevel += indentGap;
                    }
                    this.indent();
                    break;
                }
                case 7: {
                    if (this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    this.insertNewLine();
                    this.indent();
                    break;
                }
                case 2: {
                    if (!forceSplit && this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    this.revert(savedBuffer, changesIndex);
                    lastPosition = savedLastPosition;
                    i = 0;
                    lineWrapPolicy = 7;
                    this.insertNewLine();
                    if (!cio.indented) {
                        this.indentationLevel += indentGap;
                    }
                    this.indent();
                    break;
                }
                case 3: {
                    if (!forceSplit && this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    this.revert(savedBuffer, changesIndex);
                    lastPosition = savedLastPosition;
                    i = 0;
                    lineWrapPolicy = 6;
                    this.insertNewLine();
                    if (!cio.indented) {
                        this.indentationLevel += indentGap;
                    }
                    this.indent();
                    break;
                }
                case 4: {
                    if (!forceSplit && this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    this.revert(savedBuffer, changesIndex);
                    lastPosition = savedLastPosition;
                    i = 0;
                    lineWrapPolicy = 6;
                    this.insertNewLine();
                    if (!cio.indented) {
                        this.indentationLevel += indentGap;
                    }
                    this.indent();
                    ++this.indentationLevel;
                    isExtraIndentation = true;
                    break;
                }
                case 5: {
                    if (!forceSplit && this.lineWidth + array[i].getLength() <= this.preferences.line_wrap_line_split) break;
                    this.revert(savedBuffer, changesIndex);
                    lastPosition = savedLastPosition;
                    i = i > 0 ? 1 : 0;
                    lineWrapPolicy = 6;
                    this.insertNewLine();
                    if (!cio.indented) {
                        this.indentationLevel += indentGap;
                    }
                    this.indent();
                    break;
                }
                case 6: {
                    this.insertNewLine();
                    this.indent();
                }
            }
            int start = array[i].getStart();
            try {
                ASTNode obj;
                Object object = obj = array[i] instanceof FormalParameter ? ((FormalParameter)array[i]).getParameterType() : array[i];
                if (obj instanceof NamespaceName && ((NamespaceName)obj).isGlobal()) {
                    if (Character.isWhitespace(this.document.getChar(start - 1)) || this.document.getChar(start - 1) == '\\') {
                        --start;
                    }
                } else if (i == 0 && array[i] instanceof UseStatementPart && ((UseStatementPart)array[i]).getName() != null && ((UseStatementPart)array[i]).getName().isGlobal() && (Character.isWhitespace(this.document.getChar(start - 1)) || this.document.getChar(start - 1) == '\\')) {
                    --start;
                }
            }
            catch (BadLocationException badLocationException) {}
            this.handleChars1(lastPosition, start, oldIndentationLevel != this.indentationLevel, indentGap);
            array[i].accept((Visitor)this);
            lastPosition = array[i] instanceof FunctionInvocation ? ((functionInvocation = (FunctionInvocation)array[i]).getArrayDereferenceList() != null && !functionInvocation.getArrayDereferenceList().getDereferences().isEmpty() ? ((DereferenceNode)functionInvocation.getArrayDereferenceList().getDereferences().get(functionInvocation.getArrayDereferenceList().getDereferences().size() - 1)).getEnd() : array[i].getEnd()) : array[i].getEnd();
            isFirst = false;
            ++i;
        }
        this.commentIndetationStack.pop();
        if (isExtraIndentation) {
            --this.indentationLevel;
        }
        if (oldIndentationLevel != this.indentationLevel) {
            this.indentationLevel = oldIndentationLevel;
        }
        if (wasBinaryExpressionWrapped != this.wasBinaryExpressionWrapped) {
            this.wasBinaryExpressionWrapped = wasBinaryExpressionWrapped;
        }
        return lastPosition;
    }

    /*
     * Unable to fully structure code
     */
    private void handleComments(int offset, int end, List<Comment> commentList, boolean isIndented, int indentGap) throws Exception {
        oldIgnoreEmptyLineSetting = this.ignoreEmptyLineSetting;
        this.ignoreEmptyLineSetting = false;
        startLine = this.document.getLineOfOffset(offset);
        start = offset;
        needIndentNewLine = false;
        indentationLevelDesending = this.indentationLevelDesending;
        this.inComment = true;
        previousCommentIsSingleLine = false;
        iter = commentList.iterator();
        block5: while (iter.hasNext()) {
            comment = iter.next();
            commentStartLine = this.document.getLineOfOffset(comment.sourceStart() + offset);
            position = this.replaceBuffer.lastIndexOf(this.lineSeparator);
            startAtFirstColumn = this.document.getLineOffset(commentStartLine) == comment.sourceStart() + offset;
            endWithNewLineIndent = this.endWithNewLineIndent(this.replaceBuffer.toString());
            afterNewLine = "";
            switch (comment.getCommentType()) {
                case 0: {
                    v0 = indentOnFirstColumn = startAtFirstColumn == false || this.preferences.never_indent_line_comments_on_first_column == false;
                    if (startLine == commentStartLine) {
                        indentOnFirstColumn = false;
                        startLinereg = this.document.getLineInformation(startLine);
                        this.lineWidth = comment.sourceStart() + offset - startLinereg.getOffset();
                        if (position >= 0) {
                            if (this.getBufferFirstChar(position + this.lineSeparator.length()) == '\u0000') {
                                afterNewLine = this.replaceBuffer.substring(position + this.lineSeparator.length(), this.replaceBuffer.length());
                                this.replaceBuffer.replace(position, this.replaceBuffer.length(), "");
                                this.insertSpaces(1);
                            } else {
                                this.insertSpace();
                            }
                        } else if (this.getBufferFirstChar(0) == '\u0000') {
                            this.replaceBuffer.setLength(0);
                            this.insertSpaces(1);
                        } else {
                            this.insertSpace();
                        }
                    } else {
                        if (indentationLevelDesending) {
                            reg = this.document.getLineInformation(commentStartLine - 1);
                            previousChar = this.document.getChar(reg.getOffset() + reg.getLength() - 1);
                            indentationSize = this.preferences.indentationSize;
                            if (previousChar != '{') {
                                line = 0;
                                while (line < this.preferences.blank_line_preserve_empty_lines) {
                                    this.insertNewLine();
                                    ++line;
                                }
                                if (this.isInsideFun) {
                                    ++indentationSize;
                                }
                            }
                            i = 0;
                            while (i < indentationSize) {
                                this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                                this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                                ++i;
                            }
                        }
                        if (this.getBufferFirstChar(0) == '\u0000') {
                            if (position >= 0) {
                                this.replaceBuffer.setLength(0);
                                this.lineWidth = 0;
                                this.insertNewLine();
                            } else {
                                this.replaceBuffer.setLength(0);
                                this.lineWidth = 0;
                            }
                        } else {
                            if (position >= 0 && this.getBufferFirstChar(position + this.lineSeparator.length()) == '\u0000') {
                                this.replaceBuffer.replace(position, this.replaceBuffer.length(), "");
                            }
                            this.insertNewLine();
                            if (!isIndented && !this.commentIndetationStack.isEmpty()) {
                                cio = this.commentIndetationStack.peek();
                                if (!cio.indented) {
                                    cio.indented = true;
                                    this.indentationLevel += indentGap;
                                }
                            }
                        }
                        if (indentationLevelDesending || this.blockEnd) {
                            i = 0;
                            while (i < this.preferences.indentationSize) {
                                this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                                this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                                ++i;
                            }
                        }
                        needIndentNewLine = true;
                    }
                    this.doNotIndent = true;
                    resetCommentIndentVariables = true;
                    if (indentOnFirstColumn) {
                        if (previousCommentIsSingleLine && this.indentStringForComment != null) {
                            this.appendToBuffer(this.indentStringForComment);
                            this.lineWidth = this.indentLengthForComment;
                            resetCommentIndentVariables = false;
                        } else {
                            this.indent();
                        }
                        if (this.lineWidth > 0) {
                            startAtFirstColumn = false;
                        }
                        this.doNotIndent = false;
                    }
                    previousCommentIsSingleLine = true;
                    this.handleCharsWithoutComments(start, comment.sourceStart() + offset);
                    this.doNotIndent = false;
                    this.resetEnableStatus(this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart()));
                    if (this.editsEnabled && this.preferences.comment_format_line_comment && (startAtFirstColumn && this.preferences.comment_format_line_comment_starting_on_first_column || !startAtFirstColumn)) {
                        if (resetCommentIndentVariables) {
                            this.resetCommentIndentVariables();
                        }
                        if (startLine == commentStartLine) {
                            this.initCommentIndentVariables(offset, startLine, comment, endWithNewLineIndent);
                            this.lineWidth = this.indentLengthForComment;
                        }
                        if (startAtFirstColumn && this.preferences.never_indent_line_comments_on_first_column) {
                            this.indentLengthForComment = 0;
                            this.indentStringForComment = "";
                        }
                        if (!(needInsertNewLine = (commentContent = this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart())).endsWith(this.lineSeparator))) {
                            delimiters = this.document.getLegalLineDelimiters();
                            i = 0;
                            while (i < delimiters.length) {
                                needInsertNewLine = commentContent.endsWith(delimiters[i]);
                                if (needInsertNewLine) break;
                                ++i;
                            }
                        }
                        commentTokLen = commentContent.startsWith("#") != false ? 1 : 2;
                        this.commentWords = Arrays.asList(commentContent.substring(commentTokLen).trim().split("[ \t]"));
                        this.commentWords = CodeFormatterVisitor.removeEmptyString(this.commentWords);
                        commentContent = CodeFormatterVisitor.join(this.commentWords, " ");
                        commentContent = commentContent.trim();
                        newLineStart = true;
                        this.appendToBuffer("//");
                        for (String word : this.commentWords) {
                            if (this.preferences.comment_line_length != 9999 && !newLineStart && this.lineWidth + 1 + word.length() > this.preferences.comment_line_length) {
                                this.insertNewLine();
                                if (!startAtFirstColumn || startAtFirstColumn && indentOnFirstColumn) {
                                    if (this.indentLengthForComment >= 0) {
                                        this.appendToBuffer(this.indentStringForComment);
                                    } else {
                                        this.indent();
                                    }
                                }
                                this.appendToBuffer("//");
                                this.insertSpaces(1);
                                this.appendToBuffer(word);
                                continue;
                            }
                            this.insertSpaces(1);
                            this.appendToBuffer(word);
                            newLineStart = false;
                        }
                        this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
                        if (needInsertNewLine) {
                            this.insertNewLine();
                            needInsertNewLine = false;
                        } else {
                            this.insertSpaces(1);
                            afterNewLine = "";
                        }
                    } else {
                        commentContent = this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart());
                        needInsertNewLine = commentContent.endsWith(this.lineSeparator);
                        if (!needInsertNewLine) {
                            delimiters = this.document.getLegalLineDelimiters();
                            i = 0;
                            while (i < delimiters.length) {
                                needInsertNewLine = commentContent.endsWith(delimiters[i]);
                                if (needInsertNewLine) break;
                                ++i;
                            }
                        }
                        if (needInsertNewLine) {
                            this.lineWidth = 0;
                            needInsertNewLine = false;
                        } else {
                            afterNewLine = "";
                        }
                    }
                    start = comment.sourceEnd() + offset;
                    ** GOTO lbl439
                }
                case 2: {
                    previousCommentIsSingleLine = false;
                    this.inComment = false;
                    this.handleCharsWithoutComments(start, comment.sourceStart() + offset);
                    this.inComment = true;
                    this.resetEnableStatus(this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart()));
                    codeBeforeComment = this.document.get(0, comment.sourceStart() + offset).trim();
                    v1 = isHeaderComment = codeBeforeComment.equals("<?") != false || codeBeforeComment.equals("<?php") != false;
                    if ((!isHeaderComment || this.preferences.comment_format_header) && this.editsEnabled && this.preferences.comment_format_javadoc_comment) {
                        block = (PHPDocBlock)comment;
                        this.newLineOfComment = false;
                        this.appendToBuffer("/**");
                        this.commentWords = new ArrayList<String>();
                        texts = block.getTexts().toArray(new Scalar[block.getTexts().size()]);
                        tags = block.getTags();
                        if (tags == null || tags.length == 0) {
                            texts = this.getNonblankScalars(texts);
                        }
                        lastLineIsBlank = false;
                        isFirst = true;
                        if (this.getNonblankScalars(texts).length == 0) {
                            texts = new Scalar[]{};
                        }
                        if (this.preferences.comment_new_lines_at_javadoc_boundaries) {
                            this.insertNewLineForPHPDoc();
                            if (texts.length == 0) {
                                lastLineIsBlank = true;
                            }
                        }
                        textsLength = texts.length;
                        j = 0;
                        while (j < textsLength) {
                            scalar = texts[j];
                            word = scalar.getValue();
                            if (word.trim().length() > 0) {
                                this.commentWords.add(word);
                                if (this.preferences.join_lines_in_comments) {
                                    if (!isFirst) {
                                        this.insertNewLineForPHPDoc();
                                    }
                                    isFirst = false;
                                    this.initCommentWords();
                                    this.formatPHPDocText(this.commentWords, null, false, false);
                                    this.commentWords = new ArrayList<String>();
                                    lastLineIsBlank = false;
                                }
                            } else if (!this.preferences.comment_clear_blank_lines_in_javadoc_comment) {
                                if (isFirst && this.preferences.comment_new_lines_at_javadoc_boundaries && this.commentWords.isEmpty()) {
                                    isFirst = false;
                                    lastLineIsBlank = true;
                                } else {
                                    isFirst = false;
                                    this.initCommentWords();
                                    this.formatPHPDocText(this.commentWords, null, false, false);
                                    this.insertNewLineForPHPDoc();
                                    this.commentWords = new ArrayList<String>();
                                    lastLineIsBlank = true;
                                }
                            }
                            ++j;
                        }
                        if (!this.commentWords.isEmpty()) {
                            this.initCommentWords();
                            this.formatPHPDocText(this.commentWords, null, false, false);
                            lastLineIsBlank = false;
                        }
                        if (tags != null && tags.length > 0) {
                            if (this.preferences.comment_insert_empty_line_before_root_tags && !lastLineIsBlank) {
                                this.insertNewLineForPHPDoc();
                                this.appendToBuffer(" ");
                            }
                            i = 0;
                            while (i < tags.length) {
                                phpDocTag = tags[i];
                                insertTag = true;
                                words = phpDocTag.getDescTexts();
                                if (i == tags.length - 1 && !this.preferences.comment_new_lines_at_javadoc_boundaries) {
                                    words = this.getNonblankWords(words);
                                }
                                this.commentWords = new ArrayList<String>();
                                if (this.getNonblankWords(words).length == 0) {
                                    hasRefs = phpDocTag.getReferencesWithOrigOrder().length != 0;
                                    nbLines = words.length;
                                    if (!hasRefs && nbLines > 1) {
                                        --nbLines;
                                    }
                                    this.formatCommentWords(phpDocTag, insertTag, false);
                                    j = 0;
                                    while (j < nbLines) {
                                        this.insertNewLineForPHPDoc();
                                        ++j;
                                    }
                                } else {
                                    j = 0;
                                    while (j < words.length) {
                                        word = words[j];
                                        if (word.trim().length() > 0) {
                                            this.commentWords.add(word);
                                            if (this.preferences.join_lines_in_comments) {
                                                this.formatCommentWords(phpDocTag, insertTag, true);
                                                insertTag = false;
                                            }
                                        } else if (!this.preferences.comment_clear_blank_lines_in_javadoc_comment && !insertTag) {
                                            this.formatCommentWords(phpDocTag, insertTag, true);
                                            insertTag = false;
                                        }
                                        ++j;
                                    }
                                    if (!this.commentWords.isEmpty() || insertTag) {
                                        this.formatCommentWords(phpDocTag, insertTag, this.commentWords.isEmpty() == false);
                                    }
                                }
                                ++i;
                            }
                            lastLineIsBlank = false;
                        }
                        if (this.preferences.comment_new_lines_at_javadoc_boundaries && !lastLineIsBlank) {
                            this.insertNewLineForPHPDoc();
                            this.appendToBuffer("/");
                        } else if (lastLineIsBlank) {
                            this.appendToBuffer("/");
                        } else {
                            this.indertWordToComment("*/");
                        }
                        this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
                    } else {
                        commentContent = this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart());
                        lines = Arrays.asList(commentContent.split("\r\n?|\n", -1));
                        this.appendToBuffer(lines.get(0));
                        i = 1;
                        while (i < lines.size()) {
                            this.insertNewLineForPHPDoc(false);
                            this.appendToBuffer(lines.get(i).replaceFirst("^[ \t]+", ""));
                            ++i;
                        }
                        this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
                    }
                    start = comment.sourceEnd() + offset;
                    this.insertNewLine();
                    this.indent();
                    ** GOTO lbl439
                }
                case 1: {
                    previousCommentIsSingleLine = false;
                    if (this.getBufferFirstChar(0) != '\u0000') {
                        this.replaceBuffer.setLength(0);
                        reg = this.document.getLineInformationOfOffset(end);
                        this.lineWidth = end - reg.getOffset();
                        this.resetEnableStatus(this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart()));
                        while (iter.hasNext()) {
                            nextComment = iter.next();
                            this.resetEnableStatus(this.document.get(nextComment.sourceStart() + offset, nextComment.sourceEnd() - nextComment.sourceStart()));
                        }
                        start = end;
                        break block5;
                    }
                    v2 = indentOnFirstColumn = startAtFirstColumn == false || this.preferences.never_indent_block_comments_on_first_column == false;
                    if (startLine == commentStartLine) {
                        indentOnFirstColumn = false;
                        startLinereg = this.document.getLineInformation(startLine);
                        this.lineWidth = comment.sourceStart() + offset - startLinereg.getOffset();
                        if (position >= 0) {
                            afterNewLine = this.replaceBuffer.substring(position + this.lineSeparator.length(), this.replaceBuffer.length());
                            this.replaceBuffer.replace(position, this.replaceBuffer.length(), "");
                            this.insertSpaces(1);
                        } else {
                            this.replaceBuffer.setLength(0);
                            this.insertSpaces(1);
                        }
                    } else {
                        if (position >= 0) {
                            this.replaceBuffer.replace(position + this.lineSeparator.length(), this.replaceBuffer.length(), "");
                            this.lineWidth = 0;
                        } else {
                            this.replaceBuffer.setLength(0);
                            this.lineWidth = 0;
                        }
                        if (indentationLevelDesending || this.blockEnd) {
                            i = 0;
                            while (i < this.preferences.indentationSize) {
                                this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                                this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                                ++i;
                            }
                        }
                        needIndentNewLine = true;
                    }
                    this.resetCommentIndentVariables();
                    if (startLine != commentStartLine && this.blockEnd) {
                        this.recordCommentIndentVariables = true;
                    }
                    this.doNotIndent = true;
                    if (indentOnFirstColumn) {
                        this.indent();
                        this.doNotIndent = false;
                        if (this.lineWidth > 0) {
                            startAtFirstColumn = false;
                        }
                    }
                    this.handleCharsWithoutComments(start, comment.sourceStart() + offset);
                    this.doNotIndent = false;
                    start = comment.sourceEnd() + offset;
                    this.resetEnableStatus(this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart()));
                    if (startLine == commentStartLine) {
                        this.initCommentIndentVariables(offset, startLine, comment, endWithNewLineIndent);
                        this.lineWidth = this.indentLengthForComment;
                    }
                    if (startAtFirstColumn && this.preferences.never_indent_block_comments_on_first_column) {
                        this.indentLengthForComment = 0;
                        this.indentStringForComment = "";
                    }
                    if (!this.editsEnabled || !this.preferences.comment_format_block_comment || comment instanceof VarComment) ** GOTO lbl428
                    this.appendToBuffer("/*");
                    commentContent = this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart());
                    commentContent = commentContent.trim();
                    commentContent = commentContent.substring(2, commentContent.length() - 2);
                    lines = Arrays.asList(commentContent.split("\r\n?|\n", -1));
                    this.commentWords = new ArrayList<String>();
                    if (lines.size() != 1) ** GOTO lbl379
                    word = lines.get(0).trim();
                    this.commentWords.add(word);
                    this.initCommentWords();
                    sb = new StringBuffer();
                    for (String w : this.commentWords) {
                        if (w.trim().length() == 0) continue;
                        sb.append(w).append(" ");
                    }
                    if (this.preferences.comment_line_length != 9999 && this.lineWidth + 1 + sb.length() + 2 > this.preferences.comment_line_length) ** GOTO lbl378
                    this.appendToBuffer(" ");
                    this.appendToBuffer(sb.toString());
                    this.appendToBuffer("*/");
                    this.commentWords = new ArrayList<String>();
                    this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
                    this.insertNewLine();
                    ** GOTO lbl439
lbl378:
                    // 1 sources

                    this.commentWords = new ArrayList<String>();
lbl379:
                    // 2 sources

                    this.newLineOfComment = false;
                    if (this.preferences.comment_new_lines_at_block_boundaries) {
                        this.insertNewLineForPHPBlockComment(this.indentLengthForComment, this.indentStringForComment);
                        this.newLineOfComment = true;
                    }
                    isFirst = true;
                    j = 0;
                    while (j < lines.size()) {
                        word = lines.get(j).trim();
                        if (word.startsWith("*")) {
                            word = word.substring(1);
                        }
                        if (word.length() > 0) {
                            this.commentWords.add(word);
                            if (this.preferences.join_lines_in_comments) {
                                if (!isFirst) {
                                    this.insertNewLineForPHPBlockComment(this.indentLengthForComment, this.indentStringForComment);
                                    this.newLineOfComment = true;
                                }
                                isFirst = false;
                                this.formatCommentBlockWords(this.indentLengthForComment, this.indentStringForComment);
                            }
                        } else if (!this.preferences.comment_clear_blank_lines_in_block_comment && j != 0 && j != lines.size() - 1) {
                            this.formatCommentBlockWords(this.indentLengthForComment, this.indentStringForComment);
                            if (isFirst && this.preferences.comment_new_lines_at_block_boundaries) {
                                this.newLineOfComment = true;
                                isFirst = false;
                            } else {
                                this.insertNewLineForPHPBlockComment(this.indentLengthForComment, this.indentStringForComment);
                                this.newLineOfComment = true;
                                isFirst = false;
                            }
                        }
                        ++j;
                    }
                    if (!this.commentWords.isEmpty()) {
                        this.formatCommentBlockWords(this.indentLengthForComment, this.indentStringForComment);
                        isFirst = false;
                    }
                    if (isFirst && this.preferences.comment_new_lines_at_block_boundaries) {
                        this.appendToBuffer("/");
                    } else if (this.newLineOfComment || this.preferences.comment_new_lines_at_block_boundaries) {
                        this.insertNewLine();
                        if (this.indentLengthForComment >= 0) {
                            this.appendToBuffer(this.indentStringForComment);
                        } else {
                            this.indent();
                        }
                        this.appendToBuffer(" */");
                    } else {
                        this.indertWordToComment("*/");
                    }
                    this.newLineOfComment = false;
                    this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
                    ** GOTO lbl438
lbl428:
                    // 1 sources

                    commentContent = this.document.get(comment.sourceStart() + offset, comment.sourceEnd() - comment.sourceStart());
                    lines = Arrays.asList(commentContent.split("\r\n?|\n", -1));
                    this.appendToBuffer(lines.get(0));
                    i = 1;
                    while (i < lines.size()) {
                        this.insertNewLineForPHPBlockComment(this.indentLengthForComment, this.indentStringForComment, false);
                        this.appendToBuffer(lines.get(i).replaceFirst("^[ \t]+", ""));
                        ++i;
                    }
                    this.handleCharsWithoutComments(comment.sourceStart() + offset, comment.sourceEnd() + offset, true);
lbl438:
                    // 2 sources

                    this.insertNewLine();
                }
lbl439:
                // 5 sources

                default: {
                    if (needIndentNewLine) {
                        this.indent();
                        needIndentNewLine = false;
                        afterNewLine = "";
                    }
                    this.appendToBuffer(afterNewLine);
                }
            }
        }
        this.inComment = false;
        this.ignoreEmptyLineSetting = oldIgnoreEmptyLineSetting;
        this.handleCharsWithoutComments(start, end);
    }

    private void indentBaseOnPrevLine(int commentStartLine) throws BadLocationException {
        IRegion prevLine = this.document.getLineInformation(commentStartLine);
        int i = 0;
        block3: while (i < prevLine.getLength()) {
            switch (this.document.getChar(i + prevLine.getOffset())) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.appendToBuffer(Character.valueOf(this.document.getChar(i + prevLine.getOffset())));
                    break;
                }
                default: {
                    break block3;
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isComment(IRegion iRegion) {
        int i = 0;
        while (i < iRegion.getLength() - 1) {
            try {
                switch (this.document.getChar(iRegion.getOffset() + i)) {
                    case '/': {
                        if (this.document.getChar(iRegion.getOffset() + i + 1) == '/') {
                            return true;
                        }
                        if (this.document.getChar(iRegion.getOffset() + i + 1) == '*') {
                            return true;
                        }
                    }
                    case '*': {
                        return true;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
            ++i;
        }
        return false;
    }

    private boolean endWithNewLineIndent(String string) {
        String indent = this.getIndent();
        return string.endsWith(String.valueOf(this.lineSeparator) + indent);
    }

    private String getIndent() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.indentationLevel * this.preferences.indentationSize) {
            sb.append(this.preferences.indentationChar);
            ++i;
        }
        return sb.toString();
    }

    private void resetCommentIndentVariables() {
        this.indentLengthForComment = -1;
        this.indentStringForComment = null;
    }

    private void indentForComment(boolean indentationLevelDesending) {
        this.indent();
        if (indentationLevelDesending || this.blockEnd) {
            int i = 0;
            while (i < this.preferences.indentationSize) {
                this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                ++i;
            }
        }
    }

    private void initCommentIndentVariables(int offset, int startLine, Comment comment, boolean endWithNewLineIndent) throws BadLocationException {
        this.indentLengthForComment = 0;
        this.indentStringForComment = EMPTY_STRING;
        IRegion startRegion = this.document.getLineInformation(startLine);
        String startLineContent = this.document.get(startRegion.getOffset(), comment.sourceStart() + offset - startRegion.getOffset()).trim();
        StringBuffer sb = new StringBuffer();
        int lastIndentationLevel = this.indentationLevel;
        lastIndentationLevel = endWithNewLineIndent ? (this.indentationLevelList.size() >= 2 ? this.indentationLevelList.get(this.indentationLevelList.size() - 2).intValue() : this.indentationLevelList.get(this.indentationLevelList.size() - 1).intValue()) : this.indentationLevelList.get(this.indentationLevelList.size() - 1);
        int i = 0;
        while (i < lastIndentationLevel * this.preferences.indentationSize) {
            sb.append(this.preferences.indentationChar);
            ++i;
        }
        i = 0;
        while (i < startLineContent.length()) {
            sb.append(" ");
            ++i;
        }
        if (startLineContent.length() > 0) {
            sb.append(" ");
        }
        this.indentStringForComment = sb.toString();
        char[] blankArray = this.indentStringForComment.toCharArray();
        int i2 = 0;
        while (i2 < blankArray.length) {
            this.indentLengthForComment = blankArray[i2] == '\t' ? (this.indentLengthForComment += 3) : ++this.indentLengthForComment;
            ++i2;
        }
    }

    public static List<String> removeEmptyString(List<String> commentWords) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < commentWords.size()) {
            String word = commentWords.get(i);
            if (word.trim().length() != 0) {
                result.add(word);
            }
            ++i;
        }
        return result;
    }

    private Scalar[] getNonblankScalars(Scalar[] texts) {
        int end = texts.length;
        int i = texts.length - 1;
        while (i >= 0) {
            if (texts[i].getValue().trim().length() != 0) break;
            if (end > 0) {
                --end;
            }
            --i;
        }
        if (end == 0) {
            return new Scalar[0];
        }
        int start = 0;
        int i2 = 0;
        while (i2 < texts.length) {
            if (texts[i2].getValue().trim().length() != 0) break;
            if (start < texts.length - 1) {
                ++start;
            }
            ++i2;
        }
        Scalar[] result = new Scalar[end - start];
        System.arraycopy(texts, start, result, 0, end - start);
        return result;
    }

    private String[] getNonblankWords(String[] words) {
        int length = words.length;
        int i = words.length - 1;
        while (i >= 0) {
            if (words[i].trim().length() != 0) break;
            --length;
            --i;
        }
        String[] result = new String[length];
        System.arraycopy(words, 0, result, 0, length);
        return result;
    }

    private void resetEnableStatus(String content) {
        int enablingTagIndex = -1;
        int disablingTagIndex = -1;
        if (this.useTags) {
            if (this.disablingTag != null) {
                disablingTagIndex = content.lastIndexOf(this.disablingTag);
            }
            if (this.enablingTag != null) {
                enablingTagIndex = content.lastIndexOf(this.enablingTag);
            }
            if (enablingTagIndex < disablingTagIndex) {
                this.editsEnabled = false;
            } else if (enablingTagIndex > disablingTagIndex) {
                this.editsEnabled = true;
            }
        }
    }

    private void formatCommentBlockWords(int indentLength, String blanks) {
        this.initCommentWords();
        for (String word : this.commentWords) {
            if (word.trim().length() == 0) continue;
            this.indertWordToCommentBlock(word, indentLength, blanks);
        }
        this.commentWords = new ArrayList<String>();
    }

    private void formatCommentWords(PHPDocTag phpDocTag, boolean insertTag, boolean hasDesc) {
        this.initCommentWords();
        this.insertNewLineForPHPDoc();
        this.formatPHPDocText(this.commentWords, phpDocTag, insertTag, hasDesc);
        this.commentWords = new ArrayList<String>();
    }

    private void initCommentWords() {
        String commentContent = CodeFormatterVisitor.join(this.commentWords, " ");
        commentContent = commentContent.trim();
        this.commentWords = Arrays.asList(commentContent.split("[ \t\r\n]"));
        this.commentWords = CodeFormatterVisitor.removeEmptyString(this.commentWords);
    }

    private void insertNewLineForPHPBlockComment(int indentLength, String blanks) {
        this.insertNewLineForPHPBlockComment(indentLength, blanks, true);
    }

    private void insertNewLineForPHPBlockComment(int indentLength, String blanks, boolean addCommentSymbol) {
        this.insertNewLine();
        if (indentLength >= 0) {
            this.appendToBuffer(blanks);
            this.lineWidth += indentLength - blanks.length();
        } else {
            this.indent();
        }
        if (addCommentSymbol) {
            this.appendToBuffer(" *");
        } else {
            this.appendToBuffer(" ");
        }
    }

    private void insertNewLineForPHPDoc() {
        this.insertNewLineForPHPDoc(true);
    }

    private void insertNewLineForPHPDoc(boolean addCommentSymbol) {
        this.insertNewLine();
        this.indent();
        if (addCommentSymbol) {
            this.appendToBuffer(" *");
        } else {
            this.appendToBuffer(" ");
        }
    }

    private void formatPHPDocText(List<String> words, PHPDocTag phpDocTag, boolean insertTag, boolean hasDesc) {
        boolean insertSpace = true;
        String tag = EMPTY_STRING;
        if (phpDocTag != null) {
            tag = "@" + PHPDocTag.getTagKind((int)phpDocTag.getTagKind());
        }
        int tagLength = tag.length() + 1;
        this.newLineOfComment = true;
        if (phpDocTag != null) {
            if (insertTag) {
                this.insertSpaces(1);
                String reference = this.getTagReference(phpDocTag);
                this.appendToBuffer(tag);
                this.appendToBuffer(reference);
            }
            this.newLineOfComment = false;
            if (this.preferences.comment_insert_new_line_for_parameter && phpDocTag.getTagKind() == 7) {
                if (insertTag && hasDesc) {
                    this.insertNewLineForPHPDoc();
                }
                if (this.preferences.comment_indent_root_tags) {
                    this.insertSpaces(tagLength);
                }
                this.insertSpaces(1);
                insertSpace = false;
                this.newLineOfComment = true;
                if (this.preferences.comment_indent_root_tags && this.preferences.comment_indent_parameter_description) {
                    int i = 0;
                    while (i < this.preferences.indentationSize) {
                        this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                        this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                        ++i;
                    }
                }
            } else if (!insertTag && this.preferences.comment_indent_root_tags) {
                this.insertSpaces(tagLength);
            }
        }
        for (String word : words) {
            if (word.trim().length() == 0) continue;
            this.indertWordToComment(phpDocTag, tagLength, word, insertSpace);
            insertSpace = true;
        }
    }

    private String getTagReference(PHPDocTag phpDocTag) {
        SimpleReference[] reference = phpDocTag.getReferencesWithOrigOrder();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < reference.length) {
            if (i > 0 && reference[i - 1] instanceof TypeReference && reference[i] instanceof TypeReference) {
                sb.append('|').append(reference[i].getName());
            } else {
                sb.append(" ").append(reference[i].getName());
            }
            ++i;
        }
        return sb.toString();
    }

    private void indertWordToComment(String word) {
        this.indertWordToComment(null, 0, word, true);
    }

    private void indertWordToCommentBlock(String word, int indentLength, String blanks) {
        if (this.preferences.comment_line_length != 9999 && !this.newLineOfComment && this.lineWidth + 1 + word.length() > this.preferences.comment_line_length) {
            this.insertNewLine();
            if (indentLength >= 0) {
                this.appendToBuffer(blanks);
                this.lineWidth += indentLength - blanks.length();
            } else {
                this.indent();
            }
            this.appendToBuffer(" * ");
            this.appendToBuffer(word);
        } else {
            this.insertSpaces(1);
            this.appendToBuffer(word);
            this.newLineOfComment = false;
        }
    }

    private void indertWordToComment(PHPDocTag phpDocTag, int tagLength, String word, boolean insertSpace) {
        word = word.trim();
        if (this.preferences.comment_line_length != 9999 && !this.newLineOfComment && this.lineWidth + 1 + word.length() > this.preferences.comment_line_length) {
            this.insertNewLineForPHPDoc();
            this.appendToBuffer(" ");
            if (phpDocTag != null) {
                if (this.preferences.comment_indent_root_tags) {
                    this.insertSpaces(tagLength);
                }
                if (this.preferences.comment_indent_root_tags && this.preferences.comment_indent_parameter_description && phpDocTag.getTagKind() == 7) {
                    int i = 0;
                    while (i < this.preferences.indentationSize) {
                        this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                        this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                        ++i;
                    }
                }
            }
            this.appendToBuffer(word);
        } else {
            if (insertSpace) {
                this.insertSpaces(1);
            }
            this.appendToBuffer(word);
            this.newLineOfComment = false;
        }
    }

    private void insertSpaces(int size) {
        int i = 0;
        while (i < size) {
            this.replaceBuffer.append(' ');
            ++this.lineWidth;
            this.isPrevSpace = true;
            ++i;
        }
    }

    private void handleForSemicolon(Expression[] beforExpressions, Expression[] afterExpressions) {
        if (this.preferences.insert_space_before_semicolon_in_for && beforExpressions.length > 0) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(';'));
        if (this.preferences.insert_space_after_semicolon_in_for && afterExpressions.length > 0) {
            this.insertSpace();
        }
    }

    private void handlePhpEndTag(int start, int end, String endTagStr) {
        this.appendToBuffer(endTagStr);
        try {
            boolean foundTag = false;
            int index = 0;
            while (start + index < end) {
                char currentChar = this.document.getChar(start + index);
                if (foundTag) {
                    this.appendToBuffer(Character.valueOf(currentChar));
                } else if (currentChar == '>') {
                    foundTag = true;
                }
                ++index;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void handleSemicolon(int start, int end) {
        if (this.preferences.insert_space_before_semicolon && !this.isHeredocSemicolon) {
            this.insertSpace();
        }
        if (this.isContainChar(start, end, ';')) {
            this.appendToBuffer(Character.valueOf(';'));
            if (this.isHeredocSemicolon && this.isPhpEqualTag) {
                this.isPhpEqualTag = false;
                this.insertNewLine();
                this.isPhpEqualTag = true;
            }
            this.isHeredocSemicolon = false;
        } else if (this.isContainChar(start, end, '?')) {
            this.handlePhpEndTag(start, end, "?>");
        } else {
            this.handlePhpEndTag(start, end, "%>");
        }
        this.handleChars(start, end);
        this.binaryExpressionLineWrapPolicy = -1;
        if (this.wasBinaryExpressionWrapped) {
            this.indentationLevel -= this.binaryExpressionIndentGap;
            this.wasBinaryExpressionWrapped = false;
        }
        this.binaryExpressionIndentGap = 0;
        this.binaryExpressionSavedBuffer = null;
        if (this.isBinaryExpressionExtraIndentation) {
            --this.indentationLevel;
            this.isBinaryExpressionExtraIndentation = false;
        }
    }

    private void indent() {
        if (!this.isPhpEqualTag) {
            this.indentationLevelList.add(this.indentationLevel);
            int i = 0;
            while (i < this.indentationLevel * this.preferences.indentationSize) {
                this.appendToBuffer(Character.valueOf(this.preferences.indentationChar));
                this.lineWidth += this.preferences.indentationChar == ' ' ? 0 : 3;
                ++i;
            }
        }
    }

    private void updateLinesWidth(ASTNode node) {
        try {
            int lineForStart = this.document.getLineOfOffset(node.getStart());
            int lineForEnd = this.document.getLineOfOffset(node.getEnd());
            this.lineWidth = lineForStart == lineForEnd ? (this.lineWidth += node.getLength()) : this.document.getLineLength(lineForEnd);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void insertNewLine() {
        if (!this.isPhpEqualTag) {
            this.appendToBuffer(this.lineSeparator);
            this.lineWidth = 0;
        }
    }

    private void insertNewLines(Statement statement) {
        int numberOfLines = this.getNumbreOfLines(statement);
        int i = 0;
        while (i < numberOfLines) {
            this.insertNewLine();
            ++i;
        }
    }

    private int getNumbreOfLines(Statement statement) {
        int numberOfLines = 1;
        switch (statement.getType()) {
            case 64: {
                numberOfLines = this.preferences.blank_lines_before_namespace + 1;
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                break;
            }
            case 29: 
            case 42: {
                numberOfLines = this.preferences.blank_line_before_method_declaration + 1;
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                break;
            }
            case 25: {
                numberOfLines = this.preferences.blank_line_before_field_declaration + 1;
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                break;
            }
            case 12: 
            case 40: {
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                numberOfLines = this.preferences.blank_line_before_class_declaration + 1;
                break;
            }
            case 11: {
                numberOfLines = this.preferences.blank_line_before_constant_declaration + 1;
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                break;
            }
            default: {
                numberOfLines = 1;
            }
        }
        return numberOfLines;
    }

    private void handleSplittedPhpBlock(int offset, int end) throws BadLocationException {
        IRegion lineRegion = this.document.getLineInformationOfOffset(offset);
        switch (this.getPhpStartTag(offset)) {
            case 1: 
            case 3: {
                if (this.document.get(offset + 2, lineRegion.getOffset() + lineRegion.getLength() - (offset + 2)).trim().length() != 0) {
                    this.insertNewLine();
                }
                this.handleCharsWithoutComments(offset + 2, end);
                break;
            }
            case 2: {
                this.handleCharsWithoutComments(offset + 3, end);
                break;
            }
            case 0: {
                if (this.document.get(offset + 5, lineRegion.getOffset() + lineRegion.getLength() - (offset + 5)).trim().length() != 0) {
                    this.insertNewLine();
                }
                this.handleCharsWithoutComments(offset + 5, end);
            }
        }
    }

    private void insertSpace() {
        if (!this.isPrevSpace) {
            this.replaceBuffer.append(' ');
            ++this.lineWidth;
            this.isPrevSpace = true;
        }
    }

    private void insertString(int offset, int end, String content) {
        assert (end >= offset);
        ReplaceEdit replaceEdit = new ReplaceEdit(offset, end - offset, content);
        this.changes.add(replaceEdit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isContainChar(int start, int end, char c) {
        try {
            int index = 0;
            while (true) {
                if (start + index >= end) {
                    return false;
                }
                if (this.document.getChar(start + index) == c) {
                    return true;
                }
                ++index;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return false;
    }

    private boolean isEmptyLine(int line) throws BadLocationException {
        int lineStart = this.document.getLineOffset(line);
        int lineEnd = lineStart + this.document.getLineLength(line);
        int offset = lineStart;
        while (offset < lineEnd) {
            char currChar = this.document.getChar(offset);
            if (currChar != ' ' && currChar != '\t' && currChar != '\r' && currChar != '\n') {
                return false;
            }
            ++offset;
        }
        return true;
    }

    private void revert(String savedBuffer, int changesIndex) {
        this.replaceBuffer.setLength(0);
        this.replaceBuffer.append(savedBuffer);
        int index = this.changes.size() - 1;
        while (index > changesIndex) {
            this.changes.remove(index);
            --index;
        }
    }

    private void scan(int offset, int end) throws Exception {
        DocumentReader reader = new DocumentReader(this.document, offset, end - offset);
        if (this.astLexer == null) {
            this.astLexer = this.getLexer(reader);
        } else {
            this.astLexer.yyreset((Reader)reader);
            this.astLexer.resetCommentList();
        }
        assert (this.stInScriptin != -1);
        this.astLexer.yybegin(this.stInScriptin);
        this.tokens.clear();
        try {
            Symbol symbol = null;
            do {
                symbol = this.astLexer.next_token();
                this.tokens.add(symbol);
            } while (symbol != null && symbol.sym != 0);
        }
        catch (Exception exception) {}
    }

    private int setSpaceAfterBlock(int offset) {
        if (this.preferences.insert_space_after_closing_brace_in_block) {
            this.insertSpace();
            this.handleChars(offset, offset);
        }
        return offset;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        VariableBase variableName = arrayAccess.getName();
        variableName.accept((Visitor)this);
        if (this.preferences.insert_space_before_opening_bracket_in_array) {
            this.insertSpace();
        }
        if (arrayAccess.getArrayType() == 1) {
            this.appendToBuffer(Character.valueOf('['));
        } else {
            this.appendToBuffer(Character.valueOf('{'));
        }
        int lastPosition = variableName.getEnd();
        if (arrayAccess.getIndex() == null) {
            if (this.preferences.insert_space_between_empty_brackets) {
                this.insertSpace();
            }
        } else {
            if (this.preferences.insert_space_after_opening_bracket_in_array) {
                this.insertSpace();
            }
            this.handleChars(lastPosition, arrayAccess.getIndex().getStart());
            arrayAccess.getIndex().accept((Visitor)this);
            if (this.preferences.insert_space_before_closing_bracket_in_array) {
                this.insertSpace();
            }
            lastPosition = arrayAccess.getIndex().getEnd();
        }
        this.handleChars(lastPosition, arrayAccess.getEnd() - 1);
        ++this.lineWidth;
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        int lastPosition;
        if (this.preferences.insert_space_before_opening_paren_in_array) {
            this.insertSpace();
        }
        if (arrayCreation.isHasArrayKey()) {
            this.appendToBuffer(Character.valueOf('('));
            lastPosition = arrayCreation.getStart() + 5;
        } else {
            lastPosition = arrayCreation.getStart() + 1;
        }
        List eleList = arrayCreation.elements();
        ArrayElement[] elements = new ArrayElement[eleList.size()];
        elements = eleList.toArray(elements);
        if (elements.length > 0) {
            if (this.preferences.insert_space_after_opening_paren_in_array) {
                this.insertSpace();
            }
            if (this.preferences.new_line_after_open_array_parenthesis) {
                this.insertNewLine();
                ++this.indentationLevel;
                this.indent();
                --this.indentationLevel;
            }
            this.lineWidth += 5;
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_expressions_in_array_init_indent_policy, this.preferences.line_wrap_array_init_indentation);
            ++this.lineWidth;
            lastPosition = this.handleCommaList((ASTNode[])elements, lastPosition, this.preferences.insert_space_before_list_comma_in_array, this.preferences.insert_space_after_list_comma_in_array, this.preferences.line_wrap_expressions_in_array_init_line_wrap_policy, indentationGap, this.preferences.line_wrap_expressions_in_array_init_force_split);
            --this.lineWidth;
            if (this.preferences.insert_space_before_closing_paren_in_array) {
                this.insertSpace();
            }
            if (this.preferences.new_line_before_close_array_parenthesis_array) {
                this.insertNewLine();
                this.indent();
            }
        }
        if (arrayCreation.isHasArrayKey()) {
            this.appendToBuffer(Character.valueOf(')'));
        } else {
            this.appendToBuffer(Character.valueOf(']'));
        }
        if (arrayCreation.getArrayDereferenceList() != null && !arrayCreation.getArrayDereferenceList().getDereferences().isEmpty()) {
            lastPosition = this.formatDereference(lastPosition, arrayCreation.getArrayDereferenceList());
        } else {
            this.handleChars(lastPosition, arrayCreation.getEnd());
        }
        return false;
    }

    private int calculateIndentGap(int indentationPolicy, int defaultIndentation) {
        switch (indentationPolicy) {
            case 0: {
                return defaultIndentation;
            }
            case 1: {
                int lineIndentation = this.preferences.indentationChar == '\t' ? (int)Math.ceil(this.lineWidth / 4) : (int)Math.ceil(this.lineWidth / this.preferences.indentationSize);
                return lineIndentation - this.indentationLevel;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    public boolean visit(ArrayElement arrayElement) {
        if (arrayElement.getKey() != null) {
            arrayElement.getKey().accept((Visitor)this);
            if (this.preferences.insert_space_before_arrow_in_array) {
                this.insertSpace();
            }
            this.appendToBuffer(KEY_VALUE_OPERATOR);
            if (this.preferences.insert_space_after_arrow_in_array) {
                this.insertSpace();
            }
            this.handleChars(arrayElement.getKey().getEnd(), arrayElement.getValue().getStart());
        }
        arrayElement.getValue().accept((Visitor)this);
        return false;
    }

    public boolean visit(Assignment assignment) {
        VariableBase leftSide = assignment.getLeftHandSide();
        leftSide.accept((Visitor)this);
        if (this.preferences.insert_space_before_assignment) {
            this.insertSpace();
        }
        this.appendToBuffer(Assignment.getOperator((int)assignment.getOperator()));
        if (this.preferences.insert_space_after_assignment) {
            this.insertSpace();
        }
        Expression rightSideValue = assignment.getRightHandSide();
        this.handleChars(leftSide.getEnd(), rightSideValue.getStart());
        rightSideValue.accept((Visitor)this);
        return false;
    }

    public boolean visit(ASTError astError) {
        this.updateLinesWidth((ASTNode)astError);
        return false;
    }

    public boolean visit(BackTickExpression backTickExpression) {
        this.updateLinesWidth((ASTNode)backTickExpression);
        return false;
    }

    public boolean visit(Block block) {
        boolean blockIndentation = false;
        boolean isPhpMode = true;
        boolean isEmptyBlockNewLine = true;
        boolean isUnbracketedNamespace = false;
        boolean isNamespace = false;
        boolean isClassDeclaration = false;
        boolean isFunctionDeclaration = false;
        switch (block.getParent().getType()) {
            case 64: {
                int j;
                int numberOfLines;
                isNamespace = true;
                if (!block.isCurly()) {
                    isEmptyBlockNewLine = false;
                    isUnbracketedNamespace = true;
                    if (block.statements().size() > 0) {
                        Statement statement = (Statement)block.statements().get(0);
                        numberOfLines = this.getNumbreOfLines(statement) - 1;
                        if ((numberOfLines = this.preferences.blank_lines_after_namespace - numberOfLines) > 0) {
                            j = 0;
                            while (j < numberOfLines) {
                                this.insertNewLine();
                                ++j;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < this.preferences.blank_lines_after_namespace) {
                            this.insertNewLine();
                            ++i;
                        }
                    }
                    this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                    break;
                }
                if (block.statements().size() > 0) {
                    Statement statement = (Statement)block.statements().get(0);
                    numberOfLines = this.getNumbreOfLines(statement) - 1;
                    if ((numberOfLines = this.preferences.blank_lines_after_namespace - numberOfLines) > 0) {
                        j = 0;
                        while (j < numberOfLines) {
                            this.insertNewLine();
                            ++j;
                        }
                    }
                } else {
                    int i = 0;
                    while (i < this.preferences.blank_lines_after_namespace) {
                        this.insertNewLine();
                        ++i;
                    }
                }
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
            }
            case 12: 
            case 40: {
                isEmptyBlockNewLine = this.preferences.new_line_in_empty_class_body;
                blockIndentation = this.preferences.indent_statements_within_type_declaration;
                isClassDeclaration = true;
                break;
            }
            case 56: {
                blockIndentation = this.preferences.indent_statements_within_switch;
                break;
            }
            case 29: {
                isEmptyBlockNewLine = this.preferences.new_line_in_empty_method_body;
                blockIndentation = this.preferences.indent_statements_within_function;
                int i = 0;
                while (i < this.preferences.blank_line_at_begin_of_method) {
                    this.insertNewLine();
                    ++i;
                }
                isFunctionDeclaration = true;
                this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                break;
            }
            default: {
                isEmptyBlockNewLine = this.preferences.new_line_in_empty_block;
                blockIndentation = this.preferences.indent_statements_within_block;
            }
        }
        if (blockIndentation) {
            ++this.indentationLevel;
        }
        int lastStatementEndOffset = isUnbracketedNamespace ? block.getStart() - 1 : block.getStart() + 1;
        List statementsList = block.statements();
        Statement[] statements = new Statement[statementsList.size()];
        statements = block.statements().toArray(statements);
        int i = 0;
        while (i < statements.length) {
            boolean isASTError;
            boolean isHtmlStatement = statements[i].getType() == 38;
            boolean bl = isASTError = statements[i].getType() == 4;
            if (isASTError && i + 1 < statements.length) {
                lastStatementEndOffset = statements[i + 1].getStart();
            } else {
                if (isPhpMode && !isHtmlStatement) {
                    if (this.getPhpStartTag(lastStatementEndOffset) != -1) {
                        this.insertNewLine();
                    }
                    if (!this.isThrowOrReturnFormatCase(statements)) {
                        this.insertNewLines(statements[i]);
                        this.indent();
                    }
                    this.handleChars(lastStatementEndOffset, statements[i].getStart());
                } else if (isPhpMode && isHtmlStatement) {
                    isPhpMode = false;
                } else if (!isPhpMode && !isHtmlStatement) {
                    this.isPhpEqualTag = this.getPhpStartTag(lastStatementEndOffset) == 2;
                    this.insertNewLines(statements[i]);
                    this.indent();
                    if (lastStatementEndOffset <= statements[i].getStart()) {
                        this.handleChars(lastStatementEndOffset, statements[i].getStart());
                    }
                    isPhpMode = true;
                } else assert (false);
                statements[i].accept((Visitor)this);
                lastStatementEndOffset = statements[i].getEnd();
                if (isNamespace && i + 1 < statements.length && statements[i].getType() == 67) {
                    if (statements[i + 1].getType() == 67) {
                        this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                    } else {
                        int numberOfLines = this.getNumbreOfLines(statements[i + 1]) - 1;
                        if ((numberOfLines = this.preferences.blank_lines_after_use_statements - numberOfLines) > 0) {
                            int j = 0;
                            while (j < numberOfLines) {
                                this.insertNewLine();
                                ++j;
                            }
                        }
                        this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                    }
                }
            }
            ++i;
        }
        if (!isPhpMode) {
            this.isPhpEqualTag = false;
        }
        if (blockIndentation) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        int endPosition = block.getEnd() - 1;
        boolean hasComments = false;
        if (this.startRegionPosition < endPosition && this.endRegionPosition >= endPosition) {
            try {
                hasComments = this.hasComments(lastStatementEndOffset, endPosition);
            }
            catch (Exception exception) {}
        }
        if ((statements.length > 0 || isEmptyBlockNewLine || hasComments) && !isUnbracketedNamespace && !this.isThrowOrReturnFormatCase(statements)) {
            this.insertNewLine();
            this.indent();
        }
        if (block.getEnd() > block.getStart()) {
            int end = block.getEnd() - 1;
            if (!block.isCurly()) {
                switch (block.getParent().getType()) {
                    case 56: {
                        end = block.getEnd() - "endswitch".length();
                        break;
                    }
                    case 61: {
                        end = block.getEnd() - "endwhile".length();
                        break;
                    }
                    case 28: {
                        end = block.getEnd() - "endfor".length();
                        break;
                    }
                    case 26: {
                        end = block.getEnd() - "endforeach".length();
                        break;
                    }
                    case 19: {
                        end = block.getEnd() - "enddeclare".length();
                        break;
                    }
                    case 34: {
                        end = block.getEnd();
                    }
                }
            }
            if (isClassDeclaration || isFunctionDeclaration) {
                int j;
                if (isClassDeclaration) {
                    j = 0;
                    while (j < this.preferences.blank_line_at_end_of_class) {
                        this.insertNewLine();
                        ++j;
                    }
                    if (this.preferences.blank_line_at_end_of_class > 0) {
                        this.indent();
                    }
                } else {
                    j = 0;
                    while (j < this.preferences.blank_line_at_end_of_method) {
                        this.insertNewLine();
                        ++j;
                    }
                    if (this.preferences.blank_line_at_end_of_method > 0) {
                        this.indent();
                    }
                }
            }
            this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
            this.blockEnd = true;
            this.handleChars(lastStatementEndOffset, end);
            this.blockEnd = false;
            ++this.lineWidth;
        }
        return false;
    }

    private boolean isThrowOrReturnFormatCase(Statement[] statements) {
        return this.preferences.control_statement_keep_guardian_on_one_line && statements.length == 1 && statements[0].getParent().getParent() instanceof IfStatement && ((IfStatement)statements[0].getParent().getParent()).getFalseStatement() == null && (statements[0].getType() == 50 || statements[0].getType() == 75 || statements[0].getType() == 57);
    }

    public boolean visit(BreakStatement breakStatement) {
        int lastPosition = breakStatement.getStart() + 5;
        this.lineWidth += 5;
        Expression expression = breakStatement.getExpression();
        if (expression != null) {
            this.insertSpace();
            this.handleChars(lastPosition, expression.getStart());
            expression.accept((Visitor)this);
            lastPosition = expression.getEnd();
        }
        this.handleSemicolon(lastPosition, breakStatement.getEnd());
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_before_cast_type) {
            this.insertSpace();
        }
        String type = EMPTY_STRING;
        int start = castExpression.getStart();
        int end = castExpression.getExpression().getStart();
        switch (castExpression.getCastingType()) {
            case 0: {
                if (this.isContainChar(start, end, 'e')) {
                    type = "integer";
                    break;
                }
                type = "int";
                break;
            }
            case 1: {
                if (this.isContainChar(start, end, 'f')) {
                    type = "float";
                    break;
                }
                if (this.isContainChar(start, end, 'r')) {
                    type = "real";
                    break;
                }
                type = "double";
                break;
            }
            case 2: {
                type = "string";
                break;
            }
            case 3: {
                type = "array";
                break;
            }
            case 4: {
                type = "object";
                break;
            }
            case 5: {
                if (this.isContainChar(start, end, 'e')) {
                    type = "boolean";
                    break;
                }
                type = "bool";
                break;
            }
            case 6: {
                type = "unset";
            }
        }
        this.appendToBuffer(type);
        if (this.preferences.insert_space_after_cast_type) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        if (this.preferences.insert_space_after_cast_expression) {
            this.insertSpace();
        }
        this.handleChars(start, end);
        castExpression.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        if (this.preferences.insert_space_before_opening_paren_in_catch) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_catch) {
            this.insertSpace();
        }
        this.lineWidth += 5;
        int start = catchClause.getClassName().getStart();
        if (catchClause.getClassName() instanceof NamespaceName) {
            NamespaceName namespaceName = (NamespaceName)catchClause.getClassName();
            try {
                if (namespaceName.isGlobal() && (Character.isWhitespace(this.document.getChar(start - 1)) || this.document.getChar(start - 1) == '\\')) {
                    --start;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        this.handleChars(catchClause.getStart() + 5, start);
        catchClause.getClassName().accept((Visitor)this);
        this.insertSpace();
        this.handleChars(catchClause.getClassName().getEnd(), catchClause.getVariable().getStart());
        catchClause.getVariable().accept((Visitor)this);
        if (this.preferences.insert_space_before_closing_paren_in_catch) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
        this.handleChars(catchClause.getVariable().getEnd(), catchClause.getBody().getStart());
        catchClause.getBody().accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        return false;
    }

    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        boolean isFirst = true;
        this.insertSpace();
        int lastPosition = classConstantDeclaration.getStart() + 5;
        this.lineWidth += 5;
        List names = classConstantDeclaration.names();
        Identifier[] variableNames = new Identifier[names.size()];
        variableNames = names.toArray(variableNames);
        int i = 0;
        while (i < variableNames.length) {
            if (!isFirst) {
                if (this.preferences.insert_space_before_comma_in_class_constant) {
                    this.insertSpace();
                }
                this.appendToBuffer(Character.valueOf(','));
                if (this.preferences.insert_space_after_comma_in_class_constant) {
                    this.insertSpace();
                }
            }
            this.handleChars(lastPosition, variableNames[i].getStart());
            variableNames[i].accept((Visitor)this);
            lastPosition = variableNames[i].getEnd();
            if (this.preferences.insert_space_before_assignment) {
                this.insertSpace();
            }
            this.appendToBuffer(Character.valueOf('='));
            if (this.preferences.insert_space_after_assignment) {
                this.insertSpace();
            }
            List initializers = classConstantDeclaration.initializers();
            Expression[] constantValues = new Expression[initializers.size()];
            constantValues = initializers.toArray(constantValues);
            this.handleChars(lastPosition, constantValues[i].getStart());
            constantValues[i].accept((Visitor)this);
            lastPosition = constantValues[i].getEnd();
            isFirst = false;
            ++i;
        }
        this.handleSemicolon(lastPosition, classConstantDeclaration.getEnd());
        return false;
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        String modifier = ClassDeclaration.getModifier((int)classDeclaration.getModifier());
        if (!modifier.equals(EMPTY_STRING)) {
            this.appendToBuffer(modifier);
            this.insertSpace();
        }
        if (classDeclaration instanceof TraitDeclaration) {
            this.appendToBuffer("trait");
        } else {
            this.appendToBuffer("class");
        }
        this.insertSpace();
        this.handleChars(classDeclaration.getStart(), classDeclaration.getName().getStart());
        classDeclaration.getName().accept((Visitor)this);
        int lastPosition = classDeclaration.getName().getEnd();
        Expression superClass = classDeclaration.getSuperClass();
        if (superClass != null) {
            this.appendToBuffer(" extends ");
            int start = superClass.getStart();
            try {
                if (superClass instanceof NamespaceName && ((NamespaceName)superClass).isGlobal() && (Character.isWhitespace(this.document.getChar(start - 1)) || this.document.getChar(start - 1) == '\\')) {
                    --start;
                }
            }
            catch (BadLocationException badLocationException) {}
            this.handleChars(lastPosition, start);
            classDeclaration.getSuperClass().accept((Visitor)this);
            lastPosition = classDeclaration.getSuperClass().getEnd();
        }
        List interfacesList = classDeclaration.interfaces();
        Identifier[] interfaces = new Identifier[interfacesList.size()];
        if ((interfaces = interfacesList.toArray(interfaces)) != null && interfaces.length > 0) {
            this.appendToBuffer(" implements ");
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_superinterfaces_in_type_declaration_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
            lastPosition = this.handleCommaList((ASTNode[])interfaces, lastPosition, this.preferences.insert_space_before_comma_in_implements, this.preferences.insert_space_after_comma_in_implements, this.preferences.line_wrap_superinterfaces_in_type_declaration_line_wrap_policy, indentationGap, this.preferences.line_wrap_superinterfaces_in_type_declaration_force_split);
        }
        boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_class, this.preferences.insert_space_before_opening_brace_in_class);
        this.handleChars(lastPosition, classDeclaration.getBody().getStart());
        classDeclaration.getBody().accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (classInstanceCreation.getChainingInstanceCall() != null && !classInstanceCreation.getChainingInstanceCall().getChainingMethodOrProperty().isEmpty()) {
            this.appendToBuffer(Character.valueOf('('));
        }
        this.appendToBuffer("new ");
        this.handleChars(classInstanceCreation.getStart(), classInstanceCreation.getClassName().getStart());
        classInstanceCreation.getClassName().accept((Visitor)this);
        if (this.preferences.insert_space_before_opening_paren_in_function) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        List ctorParams = classInstanceCreation.ctorParams();
        int numberOfCtorParameters = ctorParams.size();
        if (numberOfCtorParameters == 0 && this.preferences.insert_space_between_empty_paren_in_function) {
            this.insertSpace();
        }
        if (numberOfCtorParameters > 0 && this.preferences.insert_space_after_opening_paren_in_function) {
            this.insertSpace();
        }
        Expression[] arrayOfParameters = ctorParams.toArray(new Expression[ctorParams.size()]);
        int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_arguments_in_allocation_expression_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
        int lastPosition = this.handleCommaList((ASTNode[])arrayOfParameters, classInstanceCreation.getClassName().getEnd(), this.preferences.insert_space_before_comma_in_function, this.preferences.insert_space_after_comma_in_function, this.preferences.line_wrap_arguments_in_allocation_expression_line_wrap_policy, indentationGap, this.preferences.line_wrap_arguments_in_allocation_expression_force_split);
        if (numberOfCtorParameters > 0 && this.preferences.insert_space_before_closing_paren_in_function) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        if (classInstanceCreation.getChainingInstanceCall() != null && !classInstanceCreation.getChainingInstanceCall().getChainingMethodOrProperty().isEmpty()) {
            this.appendToBuffer(Character.valueOf(')'));
        }
        this.handleChars(lastPosition, classInstanceCreation.getEnd());
        return false;
    }

    public boolean visit(ClassName className) {
        className.getName().accept((Visitor)this);
        return false;
    }

    public boolean visit(CloneExpression cloneExpression) {
        this.insertSpace();
        this.lineWidth += 5;
        Expression expression = cloneExpression.getExpression();
        this.handleChars(cloneExpression.getStart() + 5, expression.getStart());
        expression.accept((Visitor)this);
        return false;
    }

    public boolean visit(org.eclipse.php.internal.core.ast.nodes.Comment comment) {
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getCondition().accept((Visitor)this);
        if (this.preferences.insert_space_before_conditional_question_mark) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('?'));
        if (this.preferences.insert_space_after_conditional_question_mark) {
            this.insertSpace();
        }
        Expression ifTrue = conditionalExpression.getIfTrue();
        Expression ifFalse = conditionalExpression.getIfFalse();
        int offset = conditionalExpression.getCondition().getStart();
        int colonOffset = 0;
        if (ifTrue != null) {
            this.handleChars(conditionalExpression.getCondition().getEnd(), ifTrue.getStart());
            ifTrue.accept((Visitor)this);
        } else {
            int length = offset;
            if (ifFalse != null) {
                length = ifFalse.getStart();
            }
            colonOffset = this.getCharPosition(conditionalExpression.getCondition().getEnd(), length, ':');
            this.handleChars(conditionalExpression.getCondition().getEnd(), colonOffset);
        }
        if (this.preferences.insert_space_before_conditional_colon) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(':'));
        if (this.preferences.insert_space_after_conditional_colon) {
            this.insertSpace();
        }
        if (ifTrue != null && ifFalse != null) {
            this.handleChars(ifTrue.getEnd(), conditionalExpression.getIfFalse().getStart());
        } else if (ifTrue == null && ifFalse != null) {
            this.handleChars(colonOffset, conditionalExpression.getIfFalse().getStart());
        } else if (ifTrue != null && ifFalse == null) {
            this.handleChars(ifTrue.getEnd(), colonOffset);
        }
        if (ifFalse != null) {
            ifFalse.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        int lastPosition = continueStatement.getStart() + 8;
        this.lineWidth += 8;
        Expression expression = continueStatement.getExpression();
        if (expression != null) {
            this.insertSpace();
            this.handleChars(lastPosition, expression.getStart());
            expression.accept((Visitor)this);
            lastPosition = expression.getEnd();
        }
        this.handleSemicolon(lastPosition, continueStatement.getEnd());
        return false;
    }

    public boolean visit(DeclareStatement declareStatement) {
        boolean isFirst = true;
        if (this.preferences.insert_space_before_opening_paren_in_declare) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_declare) {
            this.insertSpace();
        }
        int lastPosition = declareStatement.getStart() + 7;
        this.lineWidth += 7;
        List direciveNameList = declareStatement.directiveNames();
        Identifier[] directiveNames = new Identifier[direciveNameList.size()];
        directiveNames = direciveNameList.toArray(directiveNames);
        int i = 0;
        while (i < directiveNames.length) {
            if (!isFirst) {
                if (this.preferences.insert_space_before_comma_in_class_variable) {
                    this.insertSpace();
                }
                this.appendToBuffer(Character.valueOf(','));
                if (this.preferences.insert_space_after_comma_in_class_variable) {
                    this.insertSpace();
                }
            }
            this.handleChars(lastPosition, directiveNames[i].getStart());
            directiveNames[i].accept((Visitor)this);
            lastPosition = directiveNames[i].getEnd();
            if (this.preferences.insert_space_before_assignment) {
                this.insertSpace();
            }
            this.appendToBuffer(Character.valueOf('='));
            if (this.preferences.insert_space_after_assignment) {
                this.insertSpace();
            }
            List directiveValuesList = declareStatement.directiveValues();
            Expression[] directiveValues = new Expression[directiveValuesList.size()];
            directiveValues = directiveValuesList.toArray(directiveValues);
            this.handleChars(lastPosition, directiveValues[i].getStart());
            directiveValues[i].accept((Visitor)this);
            lastPosition = directiveValues[i].getEnd();
            isFirst = false;
            ++i;
        }
        if (this.preferences.insert_space_before_closing_paren_in_declare) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleAction(lastPosition, declareStatement.getBody(), true);
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.lineWidth += 2;
        Statement body = doStatement.getBody();
        this.handleAction(doStatement.getStart() + 2, body, true);
        int lastPosition = body.getEnd();
        int doActionEnd = body.getEnd();
        if (this.preferences.control_statement_insert_newline_before_while_in_do) {
            this.insertNewLine();
            this.indent();
        } else {
            lastPosition = this.setSpaceAfterBlock(doActionEnd);
        }
        String textBetween = EMPTY_STRING;
        int indexOfWhile = -1;
        try {
            textBetween = this.document.get(doActionEnd, doStatement.getCondition().getStart() - doActionEnd).toLowerCase();
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
        indexOfWhile = textBetween.indexOf("while");
        if (indexOfWhile > 0) {
            this.handleChars(lastPosition, indexOfWhile += doActionEnd);
            this.appendToBuffer("while");
            this.handleChars(indexOfWhile, indexOfWhile);
            lastPosition = indexOfWhile;
        } else {
            this.appendToBuffer("while");
        }
        if (this.preferences.insert_space_before_opening_paren_in_while) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.insertSpace();
        }
        this.handleChars(lastPosition, doStatement.getCondition().getStart());
        doStatement.getCondition().accept((Visitor)this);
        if (this.preferences.insert_space_before_closing_paren_in_while) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleSemicolon(doStatement.getCondition().getEnd(), doStatement.getEnd());
        return false;
    }

    public boolean visit(EchoStatement echoStatement) {
        int lastPosition = echoStatement.getStart() + 4;
        this.lineWidth += 4;
        this.insertSpace();
        List expressionList = echoStatement.expressions();
        Expression[] expressions = new Expression[expressionList.size()];
        expressions = expressionList.toArray(expressions);
        lastPosition = this.handleCommaList((ASTNode[])expressions, lastPosition, this.preferences.insert_space_before_comma_in_echo, this.preferences.insert_space_after_comma_in_echo, 0, -1, false);
        this.handleSemicolon(lastPosition, echoStatement.getEnd());
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        int end;
        int start = emptyStatement.getStart();
        if (this.isContainChar(start, end = emptyStatement.getEnd(), '?')) {
            this.handlePhpEndTag(start, end, "?>");
        } else if (this.isContainChar(start, end, '%')) {
            this.handlePhpEndTag(start, end, "%>");
        } else {
            this.appendToBuffer(Character.valueOf(';'));
        }
        this.handleChars(start, end);
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        expression.accept((Visitor)this);
        this.handleSemicolon(expression.getEnd(), expressionStatement.getEnd());
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        fieldAccess.getDispatcher().accept((Visitor)this);
        if (this.preferences.insert_space_before_arrow_in_field_access) {
            this.insertSpace();
        }
        this.appendToBuffer("->");
        if (this.preferences.insert_space_after_arrow_in_field_access) {
            this.insertSpace();
        }
        this.handleChars(fieldAccess.getDispatcher().getEnd(), fieldAccess.getField().getStart());
        fieldAccess.getField().accept((Visitor)this);
        return false;
    }

    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        boolean isFirst = true;
        Variable[] variableNames = fieldsDeclaration.getVariableNames();
        Expression[] initialValues = fieldsDeclaration.getInitialValues();
        int lastPosition = variableNames[0].getStart();
        String modifier = fieldsDeclaration.getModifierString();
        int firstChar = 32;
        try {
            firstChar = this.document.getChar(fieldsDeclaration.getStart());
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        if (modifier.equalsIgnoreCase("public") && (firstChar == 118 || firstChar == 86)) {
            modifier = "var";
        }
        this.appendToBuffer(modifier);
        this.insertSpace();
        this.handleChars(fieldsDeclaration.getStart(), lastPosition);
        int i = 0;
        while (i < variableNames.length) {
            if (!isFirst) {
                if (this.preferences.insert_space_before_comma_in_class_variable) {
                    this.insertSpace();
                }
                this.appendToBuffer(Character.valueOf(','));
                if (this.preferences.insert_space_after_comma_in_class_variable) {
                    this.insertSpace();
                }
            }
            this.handleChars(lastPosition, variableNames[i].getStart());
            variableNames[i].accept((Visitor)this);
            lastPosition = variableNames[i].getEnd();
            if (initialValues[i] != null) {
                if (this.preferences.insert_space_before_assignment) {
                    this.insertSpace();
                }
                this.appendToBuffer(Character.valueOf('='));
                if (this.preferences.insert_space_after_assignment) {
                    this.insertSpace();
                }
                this.handleChars(lastPosition, initialValues[i].getStart());
                initialValues[i].accept((Visitor)this);
                lastPosition = initialValues[i].getEnd();
            }
            isFirst = false;
            ++i;
        }
        this.handleSemicolon(lastPosition, fieldsDeclaration.getEnd());
        return false;
    }

    public boolean visit(ForEachStatement forEachStatement) {
        if (this.preferences.insert_space_before_open_paren_in_foreach) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_open_paren_in_foreach) {
            this.insertSpace();
        }
        this.lineWidth += 7;
        this.handleChars(forEachStatement.getStart() + 7, forEachStatement.getExpression().getStart());
        forEachStatement.getExpression().accept((Visitor)this);
        this.appendToBuffer(" as ");
        int lastPosition = forEachStatement.getExpression().getEnd();
        if (forEachStatement.getKey() != null) {
            this.handleChars(forEachStatement.getExpression().getEnd(), forEachStatement.getKey().getStart());
            forEachStatement.getKey().accept((Visitor)this);
            if (this.preferences.insert_space_before_arrow_in_foreach) {
                this.insertSpace();
            }
            this.appendToBuffer(KEY_VALUE_OPERATOR);
            if (this.preferences.insert_space_after_arrow_in_foreach) {
                this.insertSpace();
            }
            lastPosition = forEachStatement.getKey().getEnd();
        }
        this.handleChars(lastPosition, forEachStatement.getValue().getStart());
        forEachStatement.getValue().accept((Visitor)this);
        if (this.preferences.insert_space_before_close_paren_in_foreach) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleAction(forEachStatement.getValue().getEnd(), forEachStatement.getStatement(), true);
        return false;
    }

    public boolean visit(FormalParameter formalParameter) {
        int lastPosition = formalParameter.getStart();
        if (formalParameter.isMandatory()) {
            lastPosition += 5;
            this.lineWidth += 5;
        }
        if (formalParameter.getParameterType() != null) {
            formalParameter.getParameterType().accept((Visitor)this);
            lastPosition = formalParameter.getParameterType().getEnd();
            this.insertSpace();
        }
        this.handleChars(lastPosition, formalParameter.getParameterName().getStart());
        formalParameter.getParameterName().accept((Visitor)this);
        if (formalParameter.hasDefaultValue()) {
            if (this.preferences.insert_space_before_assignment) {
                this.insertSpace();
            }
            this.appendToBuffer(Character.valueOf('='));
            if (this.preferences.insert_space_after_assignment) {
                this.insertSpace();
            }
            this.handleChars(formalParameter.getParameterName().getEnd(), formalParameter.getDefaultValue().getStart());
        }
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        int lastPosition = forStatement.getStart() + 3;
        this.lineWidth += 3;
        if (this.preferences.insert_space_before_open_paren_in_for) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        List forExpressions = null;
        forExpressions = forStatement.initializers();
        Expression[] initializations = new Expression[forExpressions.size()];
        forExpressions.toArray(initializations);
        forExpressions = forStatement.conditions();
        Expression[] conditions = new Expression[forExpressions.size()];
        forExpressions.toArray(conditions);
        forExpressions = forStatement.updaters();
        Expression[] increasements = new Expression[forExpressions.size()];
        forExpressions.toArray(increasements);
        if (this.preferences.insert_space_after_open_paren_in_for && initializations.length > 0) {
            this.insertSpace();
        }
        lastPosition = this.handleCommaList((ASTNode[])initializations, lastPosition, this.preferences.insert_space_before_comma_in_for, this.preferences.insert_space_after_comma_in_for, 0, -1, false);
        this.handleForSemicolon(initializations, conditions);
        lastPosition = this.handleCommaList((ASTNode[])conditions, lastPosition, this.preferences.insert_space_before_comma_in_for, this.preferences.insert_space_after_comma_in_for, 0, -1, false);
        this.handleForSemicolon(conditions, increasements);
        lastPosition = this.handleCommaList((ASTNode[])increasements, lastPosition, this.preferences.insert_space_before_comma_in_for, this.preferences.insert_space_after_comma_in_for, 0, -1, false);
        if (this.preferences.insert_space_before_close_paren_in_for && increasements.length > 0) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleAction(lastPosition, forStatement.getBody(), true);
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        this.isInsideFun = true;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDocumentString(functionDeclaration.getStart(), functionDeclaration.getStart() + 8));
        if (functionDeclaration.isReference()) {
            buffer.append(" &");
        } else {
            buffer.append(' ');
        }
        buffer.append(functionDeclaration.getFunctionName().getName());
        this.appendToBuffer(buffer.toString());
        this.handleChars(functionDeclaration.getStart(), functionDeclaration.getFunctionName().getEnd());
        if (this.preferences.insert_space_before_opening_paren_in_function_declaration) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        int lastPosition = functionDeclaration.getFunctionName().getEnd();
        if (functionDeclaration.formalParameters().size() > 0) {
            if (this.preferences.insert_space_after_opening_paren_in_function_declaration) {
                this.insertSpace();
            }
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_parameters_in_method_declaration_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
            List parameterList = functionDeclaration.formalParameters();
            FormalParameter[] parameters = new FormalParameter[parameterList.size()];
            parameters = parameterList.toArray(parameters);
            lastPosition = this.handleCommaList((ASTNode[])parameters, lastPosition, this.preferences.insert_space_before_comma_in_function_declaration, this.preferences.insert_space_after_comma_in_function_declaration, this.preferences.line_wrap_parameters_in_method_declaration_line_wrap_policy, indentationGap, this.preferences.line_wrap_parameters_in_method_declaration_force_split);
            if (this.preferences.insert_space_before_closing_paren_in_function_declaration) {
                this.insertSpace();
            }
        } else if (this.preferences.insert_space_between_empty_paren_in_function_declaration) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        if (functionDeclaration.getBody() != null) {
            boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_function, this.preferences.insert_space_before_opening_brace_in_function);
            this.handleChars(lastPosition, functionDeclaration.getBody().getStart());
            functionDeclaration.getBody().accept((Visitor)this);
            if (isIndentationAdded) {
                --this.indentationLevel;
                this.indentationLevelDesending = true;
            }
        } else {
            this.handleSemicolon(lastPosition, functionDeclaration.getEnd());
        }
        this.isInsideFun = false;
        return false;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        String name;
        Expression functionName = functionInvocation.getFunctionName().getName();
        if (functionName.getType() == 33 && FUNCTION_NAME_PRINT.equalsIgnoreCase(name = ((Identifier)functionName).getName())) {
            this.handlePrintCall(functionInvocation);
            return false;
        }
        this.innerVisit(functionInvocation);
        return false;
    }

    private void innerVisit(FunctionInvocation functionInvocation) {
        this.innerVisit(functionInvocation, true);
    }

    private void innerVisit(FunctionInvocation functionInvocation, boolean addParen) {
        Expression functionName = functionInvocation.getFunctionName().getName();
        functionName.accept((Visitor)this);
        if (this.preferences.insert_space_before_opening_paren_in_function) {
            this.insertSpace();
        }
        if (addParen) {
            this.appendToBuffer(Character.valueOf('('));
        }
        int lastPosition = functionName.getEnd();
        if (functionInvocation.parameters().size() > 0) {
            if (this.preferences.insert_space_after_opening_paren_in_function) {
                this.insertSpace();
            }
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_arguments_in_method_invocation_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
            List parametersList = functionInvocation.parameters();
            Expression[] parameters = new Expression[parametersList.size()];
            parameters = parametersList.toArray(parameters);
            if (addParen) {
                ++this.lineWidth;
            }
            if (this.preferences.insert_space_before_closing_paren_in_function) {
                ++this.lineWidth;
            }
            lastPosition = this.handleCommaList((ASTNode[])parameters, lastPosition, this.preferences.insert_space_before_comma_in_function, this.preferences.insert_space_after_comma_in_function, this.preferences.line_wrap_arguments_in_method_invocation_line_wrap_policy, indentationGap, this.preferences.line_wrap_arguments_in_method_invocation_force_split);
            if (this.preferences.insert_space_before_closing_paren_in_function) {
                --this.lineWidth;
                this.insertSpace();
            }
            if (addParen) {
                --this.lineWidth;
            }
        } else if (this.preferences.insert_space_between_empty_paren_in_function) {
            this.insertSpace();
        }
        if (addParen) {
            this.appendToBuffer(Character.valueOf(')'));
        }
        if (functionInvocation.getArrayDereferenceList() != null && !functionInvocation.getArrayDereferenceList().getDereferences().isEmpty()) {
            lastPosition = this.formatDereference(lastPosition, functionInvocation.getArrayDereferenceList());
        } else {
            this.handleChars(lastPosition, functionInvocation.getEnd());
        }
    }

    private int formatDereference(int lastPosition, PHPArrayDereferenceList list) {
        this.handleChars(lastPosition, ((DereferenceNode)list.getDereferences().get(0)).getStart());
        lastPosition = ((DereferenceNode)list.getDereferences().get(0)).getStart();
        for (DereferenceNode dereferenceNode : list.getDereferences()) {
            if (dereferenceNode.getName() instanceof org.eclipse.php.internal.core.ast.nodes.Scalar) {
                this.appendToBuffer(Character.valueOf('['));
                org.eclipse.php.internal.core.ast.nodes.Scalar scalar = (org.eclipse.php.internal.core.ast.nodes.Scalar)dereferenceNode.getName();
                this.appendToBuffer(scalar.getStringValue());
                this.appendToBuffer(Character.valueOf(']'));
                this.handleChars(dereferenceNode.getStart(), dereferenceNode.getEnd());
            } else {
                this.appendToBuffer(Character.valueOf('['));
                this.handleChars(lastPosition, dereferenceNode.getName().getStart());
                dereferenceNode.getName().accept((Visitor)this);
                this.appendToBuffer(Character.valueOf(']'));
                this.handleChars(dereferenceNode.getName().getEnd(), dereferenceNode.getEnd());
            }
            lastPosition = dereferenceNode.getEnd();
        }
        return lastPosition;
    }

    private void handlePrintCall(FunctionInvocation functionInvocation) {
        boolean hasParenthsis;
        List parametersList = functionInvocation.parameters();
        Expression[] parameters = new Expression[parametersList.size()];
        boolean bl = hasParenthsis = (parameters = parametersList.toArray(parameters))[0].getType() == 62;
        if (hasParenthsis) {
            this.innerVisit(functionInvocation, false);
            return;
        }
        this.insertSpace();
        Expression functionName = functionInvocation.getFunctionName().getName();
        int lastPosition = functionName.getEnd();
        int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_arguments_in_method_invocation_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
        lastPosition = this.handleCommaList((ASTNode[])parameters, lastPosition, this.preferences.insert_space_before_comma_in_function, this.preferences.insert_space_after_comma_in_function, this.preferences.line_wrap_arguments_in_method_invocation_line_wrap_policy, indentationGap, this.preferences.line_wrap_arguments_in_method_invocation_force_split);
        this.handleChars(lastPosition, functionInvocation.getEnd());
    }

    public boolean visit(FunctionName functionName) {
        return true;
    }

    public boolean visit(GlobalStatement globalStatement) {
        int lastPosition = globalStatement.getStart() + 6;
        this.lineWidth += 6;
        this.insertSpace();
        List varList = globalStatement.variables();
        Expression[] variables = new Expression[varList.size()];
        variables = varList.toArray(variables);
        lastPosition = this.handleCommaList((ASTNode[])variables, lastPosition, this.preferences.insert_space_before_comma_in_global, this.preferences.insert_space_after_comma_in_global, 0, -1, false);
        this.handleSemicolon(lastPosition, globalStatement.getEnd());
        return false;
    }

    public boolean visit(Identifier identifier) {
        this.lineWidth += identifier.getLength();
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        int len = this.checkFirstTokenLength(ifStatement.getStart(), ifStatement.getCondition().getStart());
        if (this.preferences.insert_space_before_opening_paren_in_if) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_if) {
            this.insertSpace();
        }
        this.lineWidth += len;
        this.handleChars(ifStatement.getStart() + len, ifStatement.getCondition().getStart());
        ifStatement.getCondition().accept((Visitor)this);
        if (this.wasBinaryExpressionWrapped) {
            this.indentationLevel -= this.binaryExpressionIndentGap;
            this.wasBinaryExpressionWrapped = false;
        }
        if (this.preferences.insert_space_before_closing_paren_in_if) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        int lastPosition = ifStatement.getCondition().getEnd();
        boolean addNewlineBeforeAction = true;
        if (ifStatement.getTrueStatement().getType() != 6) {
            if (len == 2) {
                addNewlineBeforeAction = !this.preferences.control_statement_keep_then_on_same_line && (!this.preferences.control_statement_keep_simple_if_on_one_line || ifStatement.getFalseStatement() != null);
            } else if (len == 6) {
                addNewlineBeforeAction = !this.preferences.control_statement_keep_then_on_same_line;
            }
        }
        this.handleAction(lastPosition, ifStatement.getTrueStatement(), addNewlineBeforeAction);
        lastPosition = ifStatement.getTrueStatement().getEnd();
        if (ifStatement.getFalseStatement() == null || ifStatement.getFalseStatement().getType() == 4) {
            return false;
        }
        if (ifStatement.getFalseStatement().getType() == 34) {
            try {
                this.handleElseIfCases(ifStatement);
            }
            catch (BadLocationException ble) {
                Logger.logException(ble);
                return false;
            }
        }
        if (ifStatement.getTrueStatement().getType() == 6) {
            if (this.preferences.control_statement_insert_newline_before_else_and_elseif_in_if) {
                this.insertNewLine();
                this.indent();
            } else {
                lastPosition = this.setSpaceAfterBlock(ifStatement.getTrueStatement().getEnd());
            }
            try {
                lastPosition = this.internalHandleElse(ifStatement, lastPosition);
            }
            catch (BadLocationException ble) {
                Logger.logException(ble);
                return false;
            }
            this.handleAction(lastPosition, ifStatement.getFalseStatement(), true);
            boolean processed = this.isProcessed(ifStatement);
            if (!((Block)ifStatement.getTrueStatement()).isCurly() && !processed) {
                this.handleChars(ifStatement.getFalseStatement().getEnd(), ifStatement.getEnd());
                this.appendToBuffer("endif;");
                this.handleChars(ifStatement.getEnd(), ifStatement.getEnd());
            }
        } else {
            this.insertNewLine();
            this.indent();
            try {
                lastPosition = this.internalHandleElse(ifStatement, lastPosition);
            }
            catch (BadLocationException ble) {
                Logger.logException(ble);
                return false;
            }
            boolean elseActionInSameLine = this.preferences.control_statement_keep_else_on_same_line;
            this.handleAction(lastPosition, ifStatement.getFalseStatement(), !elseActionInSameLine);
        }
        return false;
    }

    private boolean isProcessed(IfStatement ifStatement) {
        boolean precessed = true;
        if (!this.processedIfStatements.contains(ifStatement)) {
            this.addAllIfStatements(ifStatement);
            precessed = false;
        }
        return precessed;
    }

    private void handleElseIfCases(IfStatement ifStatement) throws BadLocationException {
        int lastPosition = ifStatement.getTrueStatement().getEnd();
        IfStatement falseIfStatement = (IfStatement)ifStatement.getFalseStatement();
        int len = this.checkFirstTokenLength(falseIfStatement.getStart(), falseIfStatement.getCondition().getStart());
        boolean elseIndentationLevelChanged = false;
        String textBetween = EMPTY_STRING;
        int trueStatementEnd = ifStatement.getTrueStatement().getEnd();
        int indexOfElse = -1;
        textBetween = this.document.get(trueStatementEnd, ifStatement.getFalseStatement().getStart() - trueStatementEnd).toLowerCase();
        indexOfElse = textBetween.lastIndexOf("else");
        if (ifStatement.getTrueStatement().getType() == 6) {
            if (this.preferences.control_statement_insert_newline_before_else_and_elseif_in_if) {
                this.insertNewLine();
                this.indent();
            } else if (len == 2) {
                lastPosition = this.setSpaceAfterBlock(ifStatement.getTrueStatement().getEnd());
            }
            if (len != 2) {
                if (indexOfElse > 0) {
                    this.handleChars(lastPosition, ifStatement.getFalseStatement().getStart());
                } else {
                    if (!this.preferences.control_statement_insert_newline_before_else_and_elseif_in_if && this.preferences.insert_space_after_closing_brace_in_block) {
                        this.insertSpace();
                    }
                    this.handleChars(ifStatement.getTrueStatement().getEnd(), ifStatement.getFalseStatement().getStart());
                }
            } else if (indexOfElse > 0) {
                this.handleChars(lastPosition, indexOfElse += trueStatementEnd);
                this.appendToBuffer("else ");
                if (!this.preferences.control_statement_keep_else_if_on_same_line) {
                    this.insertNewLine();
                    ++this.indentationLevel;
                    elseIndentationLevelChanged = true;
                    this.indent();
                }
                this.handleChars(indexOfElse, ifStatement.getFalseStatement().getStart());
                lastPosition = indexOfElse;
            } else {
                this.appendToBuffer("else ");
                if (!this.preferences.control_statement_keep_else_if_on_same_line) {
                    this.insertNewLine();
                    ++this.indentationLevel;
                    elseIndentationLevelChanged = true;
                    this.indent();
                }
                indexOfElse = trueStatementEnd < lastPosition ? lastPosition : indexOfElse + trueStatementEnd;
                this.handleChars(indexOfElse, ifStatement.getFalseStatement().getStart());
            }
        } else {
            this.insertNewLine();
            this.indent();
            if (indexOfElse > 0) {
                this.handleChars(lastPosition, indexOfElse += trueStatementEnd);
                this.appendToBuffer("else ");
                if (!this.preferences.control_statement_keep_else_if_on_same_line) {
                    this.insertNewLine();
                    ++this.indentationLevel;
                    elseIndentationLevelChanged = true;
                    this.indent();
                }
                this.handleChars(indexOfElse, ifStatement.getFalseStatement().getStart());
                lastPosition = indexOfElse;
            } else {
                this.appendToBuffer(len == 2 ? "else " : EMPTY_STRING);
                if (len == 2 && !this.preferences.control_statement_keep_else_if_on_same_line) {
                    this.insertNewLine();
                    ++this.indentationLevel;
                    elseIndentationLevelChanged = true;
                    this.indent();
                }
                if (indexOfElse == -1) {
                    indexOfElse = 0;
                }
                this.handleChars(indexOfElse + trueStatementEnd, ifStatement.getFalseStatement().getStart());
            }
        }
        boolean processed = this.isProcessed(ifStatement);
        ifStatement.getFalseStatement().accept((Visitor)this);
        if (elseIndentationLevelChanged) {
            --this.indentationLevel;
        }
        if (ifStatement.getTrueStatement().getType() == 6 && !((Block)ifStatement.getTrueStatement()).isCurly() && !processed) {
            this.handleChars(ifStatement.getFalseStatement().getEnd(), ifStatement.getEnd());
            this.appendToBuffer("endif;");
            this.handleChars(ifStatement.getEnd(), ifStatement.getEnd());
        }
    }

    private void addAllIfStatements(IfStatement ifStatement) {
        Statement falseIfStatement;
        this.processedIfStatements.add(ifStatement);
        while ((falseIfStatement = ifStatement.getFalseStatement()) instanceof IfStatement) {
            ifStatement = (IfStatement)falseIfStatement;
            this.processedIfStatements.add(ifStatement);
        }
    }

    private int internalHandleElse(IfStatement ifStatement, int lastPosition) throws BadLocationException {
        String textBetween = EMPTY_STRING;
        int trueStatementEnd = ifStatement.getTrueStatement().getEnd();
        int indexOfElse = -1;
        textBetween = this.document.get(trueStatementEnd, ifStatement.getFalseStatement().getStart() - trueStatementEnd).toLowerCase();
        indexOfElse = textBetween.lastIndexOf("else");
        if (indexOfElse > 0) {
            this.handleChars(lastPosition, indexOfElse += trueStatementEnd);
            this.appendToBuffer("else");
            this.handleChars(indexOfElse, indexOfElse);
            lastPosition = indexOfElse;
        } else {
            this.appendToBuffer("else");
        }
        return lastPosition;
    }

    public boolean visit(IgnoreError ignoreError) {
        ++this.lineWidth;
        ignoreError.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(Include include) {
        int lastPosition = include.getStart();
        int len = include.getIncludeType() == 2 || include.getIncludeType() == 0 ? 7 : 12;
        this.lineWidth += len;
        this.insertSpace();
        this.handleChars(lastPosition += len, include.getExpression().getStart());
        include.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        boolean isStringOperator;
        boolean forceSplit = this.preferences.line_wrap_binary_expression_force_split;
        if (this.binaryExpressionLineWrapPolicy == -1) {
            this.binaryExpressionLineWrapPolicy = this.preferences.line_wrap_binary_expression_line_wrap_policy;
            this.binaryExpressionIndentGap = this.calculateIndentGap(this.preferences.line_wrap_binary_expression_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
        }
        if (this.binaryExpressionSavedBuffer == null) {
            this.binaryExpressionSavedBuffer = this.replaceBuffer.toString();
            this.binaryExpressionSavedNode = infixExpression;
            this.binaryExpressionSavedChangesIndex = this.changes.size() - 1;
            this.binaryExpressionRevertPolicy = -1;
        }
        infixExpression.getLeft().accept((Visitor)this);
        int operator = infixExpression.getOperator();
        boolean bl = isStringOperator = operator == 11 || operator == 10 || operator == 12;
        if (isStringOperator || this.preferences.insert_space_before_binary_operation) {
            this.insertSpace();
        }
        this.appendToBuffer(InfixExpression.getOperator((int)operator));
        int lineW = this.calcLinesWidth((ASTNode)infixExpression.getRight());
        switch (this.binaryExpressionLineWrapPolicy) {
            case 0: {
                break;
            }
            case 1: {
                if (lineW <= this.preferences.line_wrap_line_split) break;
                this.wasBinaryExpressionWrapped = this.indentationLevel == 1;
                this.binaryExpressionLineWrapPolicy = 7;
                this.insertNewLine();
                this.indentationLevel += this.binaryExpressionIndentGap;
                this.wasBinaryExpressionWrapped = true;
                this.indent();
                break;
            }
            case 7: {
                if (lineW <= this.preferences.line_wrap_line_split) break;
                this.wasBinaryExpressionWrapped = true;
                this.insertNewLine();
                this.indent();
                break;
            }
            case 2: {
                if (!forceSplit && lineW <= this.preferences.line_wrap_line_split) break;
                if (this.binaryExpressionRevertPolicy != -1) {
                    this.binaryExpressionRevertPolicy = -1;
                    this.binaryExpressionLineWrapPolicy = 7;
                    this.insertNewLine();
                    this.indentationLevel += this.binaryExpressionIndentGap;
                    this.indent();
                } else {
                    this.binaryExpressionRevertPolicy = 2;
                    this.binaryExpressionLineWrapPolicy = 0;
                }
                this.wasBinaryExpressionWrapped = true;
                break;
            }
            case 3: {
                if (!forceSplit && lineW <= this.preferences.line_wrap_line_split) break;
                if (this.binaryExpressionRevertPolicy != -1) {
                    this.binaryExpressionRevertPolicy = -1;
                    this.binaryExpressionLineWrapPolicy = 6;
                    this.insertNewLine();
                    this.indentationLevel += this.binaryExpressionIndentGap;
                    this.indent();
                } else {
                    this.binaryExpressionRevertPolicy = 3;
                    this.binaryExpressionLineWrapPolicy = 0;
                }
                this.wasBinaryExpressionWrapped = true;
                break;
            }
            case 4: {
                if (!forceSplit && lineW <= this.preferences.line_wrap_line_split) break;
                if (this.binaryExpressionRevertPolicy != -1) {
                    this.binaryExpressionRevertPolicy = -1;
                    this.binaryExpressionLineWrapPolicy = 6;
                    this.insertNewLine();
                    this.indentationLevel += this.binaryExpressionIndentGap;
                    this.indent();
                    ++this.indentationLevel;
                    this.isBinaryExpressionExtraIndentation = true;
                } else {
                    this.binaryExpressionRevertPolicy = 4;
                    this.binaryExpressionLineWrapPolicy = 0;
                }
                this.wasBinaryExpressionWrapped = true;
                break;
            }
            case 5: {
                if (!forceSplit && lineW <= this.preferences.line_wrap_line_split) break;
                if (this.binaryExpressionRevertPolicy != -1) {
                    this.binaryExpressionLineWrapPolicy = 3;
                } else {
                    this.binaryExpressionRevertPolicy = 5;
                    this.binaryExpressionLineWrapPolicy = 0;
                }
                this.wasBinaryExpressionWrapped = true;
                break;
            }
            case 6: {
                this.insertNewLine();
                this.indent();
            }
        }
        if (isStringOperator || this.preferences.insert_space_after_binary_operation) {
            this.insertSpace();
        }
        this.handleChars(infixExpression.getLeft().getEnd(), infixExpression.getRight().getStart());
        if (this.binaryExpressionRevertPolicy != -1 && infixExpression == this.binaryExpressionSavedNode) {
            if (this.binaryExpressionLineWrapPolicy == 3 && this.binaryExpressionRevertPolicy == 5) {
                infixExpression.getRight().accept((Visitor)this);
            } else {
                this.revert(this.binaryExpressionSavedBuffer, this.binaryExpressionSavedChangesIndex);
                this.binaryExpressionLineWrapPolicy = this.binaryExpressionRevertPolicy;
                infixExpression.accept((Visitor)this);
            }
        } else {
            infixExpression.getRight().accept((Visitor)this);
        }
        return false;
    }

    private int calcLinesWidth(ASTNode node) {
        int lineW = this.lineWidth;
        try {
            int lineForStart = this.document.getLineOfOffset(node.getStart());
            int lineForEnd = this.document.getLineOfOffset(node.getEnd());
            lineW = lineForStart == lineForEnd ? (lineW += node.getLength()) : this.document.getLineLength(lineForEnd);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return lineW;
    }

    public boolean visit(InLineHtml inLineHtml) {
        this.updateLinesWidth((ASTNode)inLineHtml);
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getExpression().accept((Visitor)this);
        if (this.preferences.insert_space_before_binary_operation) {
            this.insertSpace();
        }
        this.appendToBuffer("instanceof");
        if (this.preferences.insert_space_after_binary_operation) {
            this.insertSpace();
        }
        this.handleChars(instanceOfExpression.getExpression().getEnd(), instanceOfExpression.getClassName().getStart());
        instanceOfExpression.getClassName().accept((Visitor)this);
        return false;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.insertSpace();
        this.lineWidth += 9;
        this.handleChars(interfaceDeclaration.getStart() + 9, interfaceDeclaration.getName().getStart());
        interfaceDeclaration.getName().accept((Visitor)this);
        int lastPosition = interfaceDeclaration.getName().getEnd();
        List interfaceList = interfaceDeclaration.interfaces();
        Identifier[] interfaces = new Identifier[interfaceList.size()];
        interfaces = interfaceList.toArray(interfaces);
        if (interfaces.length > 0) {
            this.appendToBuffer(" extends ");
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_superinterfaces_in_type_declaration_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
            lastPosition = this.handleCommaList((ASTNode[])interfaces, lastPosition, this.preferences.insert_space_before_comma_in_implements, this.preferences.insert_space_after_comma_in_implements, this.preferences.line_wrap_superinterfaces_in_type_declaration_line_wrap_policy, indentationGap, this.preferences.line_wrap_superinterfaces_in_type_declaration_force_split);
        }
        boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_class, this.preferences.insert_space_before_opening_brace_in_class);
        this.handleChars(lastPosition, interfaceDeclaration.getBody().getStart());
        interfaceDeclaration.getBody().accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        return false;
    }

    public boolean visit(ListVariable listVariable) {
        if (this.preferences.insert_space_before_opening_paren_in_list) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_list) {
            this.insertSpace();
        }
        int lastPosition = listVariable.getStart() + 4;
        this.lineWidth += 4;
        List variables = listVariable.variables();
        VariableBase[] variablesArray = variables.toArray(new VariableBase[variables.size()]);
        lastPosition = this.handleCommaList((ASTNode[])variablesArray, lastPosition, this.preferences.insert_space_before_comma_in_list, this.preferences.insert_space_after_comma_in_list, 0, -1, false);
        if (this.preferences.insert_space_before_closing_paren_in_list && (variablesArray[variablesArray.length - 1].getLength() != 0 || !this.preferences.insert_space_after_comma_in_list)) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleChars(lastPosition, listVariable.getEnd());
        return false;
    }

    public boolean visit(MethodDeclaration classMethodDeclaration) {
        String originalModifier = this.getDocumentString(classMethodDeclaration.getStart(), classMethodDeclaration.getFunction().getStart()).trim();
        StringTokenizer tokenizer = new StringTokenizer(originalModifier);
        StringBuffer strBuffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            strBuffer.append(String.valueOf(tokenizer.nextToken()) + " ");
        }
        String formattedModifier = EMPTY_STRING;
        int len = strBuffer.length();
        if (len > 0) {
            formattedModifier = strBuffer.toString().substring(0, len - 1);
        }
        this.appendToBuffer(formattedModifier);
        if (formattedModifier.length() > 0) {
            this.insertSpace();
        }
        this.handleChars(classMethodDeclaration.getStart(), classMethodDeclaration.getFunction().getStart());
        classMethodDeclaration.getFunction().accept((Visitor)this);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        int value;
        VariableBase dispatch = methodInvocation.getDispatcher();
        if (this.preferences.new_line_in_second_invoke > 0) {
            if (this.chainStack.isEmpty() || this.chainStack.peek() == -1) {
                this.chainStack.push(1);
            } else {
                value = this.chainStack.pop();
                this.chainStack.push(++value);
            }
            if (!(dispatch instanceof MethodInvocation)) {
                this.chainStack.push(-1);
            }
        }
        dispatch.accept((Visitor)this);
        if (this.preferences.insert_space_before_arrow_in_method_invocation) {
            this.insertSpace();
        }
        if (this.preferences.new_line_in_second_invoke > 0) {
            if (this.peek == null) {
                this.peek = -1;
            }
            if (this.chainStack.peek() == -1) {
                this.chainStack.pop();
            }
            Integer n = this.peek = this.peek > this.chainStack.peek() ? this.peek : this.chainStack.peek();
            if (this.peek > this.preferences.new_line_in_second_invoke - 1 && dispatch instanceof MethodInvocation) {
                this.insertNewLine();
                ++this.indentationLevel;
                this.indent();
                --this.indentationLevel;
            }
        }
        this.appendToBuffer("->");
        if (this.preferences.insert_space_after_arrow_in_method_invocation) {
            this.insertSpace();
        }
        if (this.preferences.insert_space_after_arrow_in_method_invocation) {
            this.insertSpace();
        }
        this.handleChars(methodInvocation.getDispatcher().getEnd(), methodInvocation.getMethod().getStart());
        methodInvocation.getMethod().accept((Visitor)this);
        if (this.preferences.new_line_in_second_invoke > 0 && !this.chainStack.isEmpty()) {
            value = this.chainStack.pop();
            if (--value > 0) {
                this.chainStack.push(value);
            } else {
                this.peek = !this.chainStack.isEmpty() ? this.chainStack.peek() : Integer.valueOf(-1);
            }
        }
        return false;
    }

    public boolean visit(ParenthesisExpression parenthesisExpression) {
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_open_paren_in_parenthesis_expression) {
            this.insertSpace();
        }
        int lastPosition = parenthesisExpression.getStart();
        Expression expression = parenthesisExpression.getExpression();
        if (expression != null) {
            this.handleChars(lastPosition, expression.getStart());
            expression.accept((Visitor)this);
            lastPosition = expression.getEnd();
        }
        if (this.preferences.insert_space_before_close_paren_in_parenthesis_expression) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        this.handleChars(lastPosition, parenthesisExpression.getEnd());
        return false;
    }

    public boolean visit(PostfixExpression postfixExpressions) {
        postfixExpressions.getVariable().accept((Visitor)this);
        if (this.preferences.insert_space_before_postfix_expression) {
            this.insertSpace();
        }
        this.appendToBuffer(PostfixExpression.getOperator((int)postfixExpressions.getOperator()));
        if (this.preferences.insert_space_before_prefix_expression) {
            this.insertSpace();
        }
        this.handleChars(postfixExpressions.getVariable().getEnd(), postfixExpressions.getEnd());
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        if (this.preferences.insert_space_before_prefix_expression) {
            this.insertSpace();
        }
        this.appendToBuffer(PostfixExpression.getOperator((int)prefixExpression.getOperator()));
        if (this.preferences.insert_space_after_prefix_expression) {
            this.insertSpace();
        }
        this.handleChars(prefixExpression.getStart(), prefixExpression.getVariable().getStart());
        prefixExpression.getVariable().accept((Visitor)this);
        return false;
    }

    public boolean visit(Program program) {
        int lastStatementEndOffset = 0;
        boolean isPhpMode = false;
        List statementList = program.statements();
        Statement[] statements = new Statement[statementList.size()];
        statements = statementList.toArray(statements);
        int i = 0;
        while (i < statements.length) {
            boolean isStatementAfterError;
            boolean isASTError;
            boolean isHtmlStatement = statements[i].getType() == 38;
            boolean bl = isASTError = statements[i].getType() == 4;
            boolean bl2 = i > 0 ? statements[i - 1].getType() == 4 : (isStatementAfterError = false);
            if (isASTError && i + 1 < statements.length) {
                lastStatementEndOffset = statements[i + 1].getStart();
            } else {
                if (isPhpMode && !isHtmlStatement) {
                    if (lastStatementEndOffset > 0) {
                        if (!isStatementAfterError && this.getPhpStartTag(lastStatementEndOffset) != -1) {
                            this.insertNewLine();
                        }
                        this.insertNewLines(statements[i]);
                        this.indent();
                        if (lastStatementEndOffset <= statements[i].getStart()) {
                            this.handleChars(lastStatementEndOffset, statements[i].getStart());
                        }
                    }
                } else if (isPhpMode && isHtmlStatement) {
                    if (lastStatementEndOffset > 0 && lastStatementEndOffset <= statements[i].getStart()) {
                        this.handleChars(lastStatementEndOffset, statements[i].getStart());
                    }
                    isPhpMode = false;
                } else if (!isPhpMode && !isHtmlStatement) {
                    if (!isStatementAfterError) {
                        this.isPhpEqualTag = this.getPhpStartTag(lastStatementEndOffset) == 2;
                        this.indentationLevel = this.getPhpTagIndentationLevel(lastStatementEndOffset);
                        this.insertNewLines(statements[i]);
                    }
                    this.indent();
                    if (lastStatementEndOffset <= statements[i].getStart()) {
                        this.handleChars(lastStatementEndOffset, statements[i].getStart());
                    }
                    isPhpMode = true;
                } else {
                    isPhpMode = false;
                }
                statements[i].accept((Visitor)this);
                lastStatementEndOffset = statements[i].getEnd();
                if (i + 1 < statements.length && statements[i].getType() == 64 && statements[i + 1].getType() == 64) {
                    int numberOfLines = this.getNumbreOfLines(statements[i + 1]) - 1;
                    if ((numberOfLines = this.preferences.blank_lines_between_namespaces - numberOfLines) > 0) {
                        int j = 0;
                        while (j < numberOfLines) {
                            this.insertNewLine();
                            ++j;
                        }
                    }
                    this.ignoreEmptyLineSetting = !this.preferences.indent_empty_lines;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean visit(Quote quote) {
        this.updateLinesWidth((ASTNode)quote);
        if (quote.getQuoteType() == 2) {
            int i = quote.getEnd();
            if (this.isContainChar(i, i + 1, ';')) {
                this.isHeredocSemicolon = true;
            } else {
                boolean isPhpEqualTagOld = this.isPhpEqualTag;
                this.isPhpEqualTag = false;
                this.insertNewLine();
                this.isPhpEqualTag = isPhpEqualTagOld;
            }
        }
        return false;
    }

    public boolean visit(Reference reference) {
        ++this.lineWidth;
        reference.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(ReflectionVariable reflectionVariable) {
        ++this.lineWidth;
        reflectionVariable.getName().accept((Visitor)this);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        int lastPosition = returnStatement.getStart() + 6;
        this.lineWidth += 6;
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            this.insertSpace();
            this.handleChars(lastPosition, expression.getStart());
            expression.accept((Visitor)this);
            lastPosition = expression.getEnd();
        }
        this.handleSemicolon(lastPosition, returnStatement.getEnd());
        return false;
    }

    public boolean visit(YieldExpression yieldExpression) {
        this.lineWidth += 5;
        int lastPosition = yieldExpression.getStart() + 5;
        this.insertSpace();
        if (yieldExpression.getKey() != null) {
            this.handleChars(lastPosition, yieldExpression.getKey().getStart());
            yieldExpression.getKey().accept((Visitor)this);
            if (this.preferences.insert_space_before_arrow_in_yield) {
                this.insertSpace();
            }
            this.appendToBuffer(KEY_VALUE_OPERATOR);
            if (this.preferences.insert_space_after_arrow_in_yield) {
                this.insertSpace();
            }
            lastPosition = yieldExpression.getKey().getEnd();
        }
        this.handleChars(lastPosition, yieldExpression.getExpression().getStart());
        yieldExpression.getExpression().accept((Visitor)this);
        lastPosition = yieldExpression.getExpression().getEnd();
        return false;
    }

    public boolean visit(org.eclipse.php.internal.core.ast.nodes.Scalar scalar) {
        this.updateLinesWidth((ASTNode)scalar);
        return false;
    }

    public boolean visit(StaticConstantAccess staticConstantAccess) {
        staticConstantAccess.getClassName().accept((Visitor)this);
        if (this.preferences.insert_space_before_coloncolon_in_field_access) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(':'));
        this.appendToBuffer(Character.valueOf(':'));
        if (this.preferences.insert_space_after_coloncolon_in_field_access) {
            this.insertSpace();
        }
        this.handleChars(staticConstantAccess.getClassName().getEnd(), staticConstantAccess.getConstant().getStart());
        staticConstantAccess.getConstant().accept((Visitor)this);
        return false;
    }

    public boolean visit(StaticFieldAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept((Visitor)this);
        if (this.preferences.insert_space_before_coloncolon_in_field_access) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(':'));
        this.appendToBuffer(Character.valueOf(':'));
        if (this.preferences.insert_space_after_coloncolon_in_field_access) {
            this.insertSpace();
        }
        this.handleChars(staticFieldAccess.getClassName().getEnd(), staticFieldAccess.getField().getStart());
        staticFieldAccess.getField().accept((Visitor)this);
        return false;
    }

    public boolean visit(StaticMethodInvocation staticMethodInvocation) {
        staticMethodInvocation.getClassName().accept((Visitor)this);
        if (this.preferences.insert_space_before_coloncolon_in_method_invocation) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(':'));
        this.appendToBuffer(Character.valueOf(':'));
        if (this.preferences.insert_space_after_coloncolon_in_method_invocation) {
            this.insertSpace();
        }
        this.handleChars(staticMethodInvocation.getClassName().getEnd(), staticMethodInvocation.getMethod().getStart());
        staticMethodInvocation.getMethod().accept((Visitor)this);
        return false;
    }

    public boolean visit(StaticStatement staticStatement) {
        int lastPosition = staticStatement.getStart() + 6;
        this.lineWidth += 6;
        this.insertSpace();
        List expList = staticStatement.expressions();
        Expression[] expressions = new Expression[expList.size()];
        expressions = expList.toArray(expressions);
        lastPosition = this.handleCommaList((ASTNode[])expressions, lastPosition, this.preferences.insert_space_before_comma_in_static, this.preferences.insert_space_after_comma_in_static, 0, -1, false);
        this.handleSemicolon(lastPosition, staticStatement.getEnd());
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        int lastStatementEndOffset = 0;
        if (switchCase.isDefault()) {
            if (this.preferences.insert_space_after_switch_default) {
                this.insertSpace();
            }
            lastStatementEndOffset = switchCase.getStart() + 7;
            this.lineWidth += 7;
        } else {
            this.insertSpace();
            this.lineWidth += 4;
            this.handleChars(switchCase.getStart() + 4, switchCase.getValue().getStart());
            switchCase.getValue().accept((Visitor)this);
            if (this.preferences.insert_space_after_switch_case_value) {
                this.insertSpace();
            }
            lastStatementEndOffset = switchCase.getValue().getEnd();
        }
        this.appendToBuffer(Character.valueOf(':'));
        int regularStatementIndentation = 0;
        int breakStatementIndentation = 0;
        if (this.preferences.indent_statements_within_case) {
            ++regularStatementIndentation;
        }
        if (this.preferences.indent_break_statements_within_case) {
            ++breakStatementIndentation;
        }
        Statement[] actions = new Statement[switchCase.actions().size()];
        switchCase.actions().toArray(actions);
        if (actions.length == 0) {
            this.handleChars(lastStatementEndOffset, switchCase.getEnd());
        } else {
            int i = 0;
            while (i < actions.length) {
                if (actions[i].getType() == 38) {
                    this.handleChars(lastStatementEndOffset, lastStatementEndOffset);
                    lastStatementEndOffset = actions[i].getEnd();
                } else {
                    boolean isBreakStatement = actions[i].getType() == 7;
                    this.indentationLevel += isBreakStatement ? breakStatementIndentation : regularStatementIndentation;
                    this.insertNewLine();
                    this.indent();
                    this.handleChars(lastStatementEndOffset, actions[i].getStart());
                    actions[i].accept((Visitor)this);
                    lastStatementEndOffset = actions[i].getEnd();
                    this.indentationLevel -= isBreakStatement ? breakStatementIndentation : regularStatementIndentation;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        if (this.preferences.insert_space_before_opening_paren_in_switch) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_switch) {
            this.insertSpace();
        }
        this.lineWidth += 6;
        Expression expression = switchStatement.getExpression();
        this.handleChars(switchStatement.getStart() + 6, expression.getStart());
        expression.accept((Visitor)this);
        if (this.preferences.insert_space_before_closing_paren_in_switch) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        boolean isIndentationAdded = false;
        isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_switch, this.preferences.insert_space_before_opening_brace_in_switch);
        Block body = switchStatement.getBody();
        this.handleChars(expression.getEnd(), body.getStart());
        body.accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.insertSpace();
        this.lineWidth += 5;
        Expression expr = throwStatement.getExpression();
        this.handleChars(throwStatement.getStart() + 5, expr.getStart());
        expr.accept((Visitor)this);
        this.handleSemicolon(expr.getEnd(), throwStatement.getEnd());
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
        this.lineWidth += 3;
        Block body = tryStatement.getBody();
        this.handleChars(tryStatement.getStart() + 3, body.getStart());
        body.accept((Visitor)this);
        if (isIndentationAdded) {
            --this.indentationLevel;
            this.indentationLevelDesending = true;
        }
        int lastStatementEndOffset = body.getEnd();
        List clausesList = tryStatement.catchClauses();
        CatchClause[] catchClauses = new CatchClause[clausesList.size()];
        catchClauses = clausesList.toArray(catchClauses);
        int i = 0;
        while (i < catchClauses.length) {
            if (this.preferences.control_statement_insert_newline_before_catch_in_try) {
                this.insertNewLine();
                this.indent();
            } else if (this.preferences.insert_space_after_closing_brace_in_block) {
                this.insertSpace();
            }
            this.handleChars(lastStatementEndOffset, catchClauses[i].getStart());
            catchClauses[i].accept((Visitor)this);
            lastStatementEndOffset = catchClauses[i].getEnd();
            ++i;
        }
        if (tryStatement.finallyClause() != null) {
            if (this.preferences.control_statement_insert_newline_before_finally_in_try) {
                this.insertNewLine();
                this.indent();
            } else if (this.preferences.insert_space_after_closing_brace_in_block) {
                this.insertSpace();
            }
            this.handleChars(lastStatementEndOffset, tryStatement.finallyClause().getStart());
            tryStatement.finallyClause().accept((Visitor)this);
            lastStatementEndOffset = tryStatement.finallyClause().getEnd();
        }
        return false;
    }

    public boolean visit(UnaryOperation unaryOperation) {
        if (this.preferences.insert_space_before_unary_expression) {
            this.insertSpace();
        }
        this.appendToBuffer(UnaryOperation.getOperator((int)unaryOperation.getOperator()));
        if (this.preferences.insert_space_after_unary_expression) {
            this.insertSpace();
        }
        Expression expr = unaryOperation.getExpression();
        this.handleChars(unaryOperation.getStart(), expr.getStart());
        expr.accept((Visitor)this);
        return false;
    }

    public boolean visit(Variable variable) {
        if (variable.isDollared()) {
            ++this.lineWidth;
        }
        variable.getName().accept((Visitor)this);
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        if (this.preferences.insert_space_before_opening_paren_in_while) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.insertSpace();
        }
        this.lineWidth += 5;
        this.handleChars(whileStatement.getStart() + 5, whileStatement.getCondition().getStart());
        whileStatement.getCondition().accept((Visitor)this);
        if (this.preferences.insert_space_before_closing_paren_in_while) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        int lastPosition = whileStatement.getCondition().getEnd();
        this.handleAction(lastPosition, whileStatement.getBody(), true);
        return false;
    }

    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        this.appendToBuffer("namespace");
        this.insertSpace();
        int lastPosition = namespaceDeclaration.getStart();
        if (namespaceDeclaration.getName() != null) {
            this.handleChars(namespaceDeclaration.getStart(), namespaceDeclaration.getName().getStart());
            namespaceDeclaration.getName().accept((Visitor)this);
            lastPosition = namespaceDeclaration.getName().getEnd();
        }
        if (namespaceDeclaration.isBracketed()) {
            boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_class, this.preferences.insert_space_before_opening_brace_in_class);
            this.handleChars(lastPosition, namespaceDeclaration.getBody().getStart());
            namespaceDeclaration.getBody().accept((Visitor)this);
            if (isIndentationAdded) {
                --this.indentationLevel;
                this.indentationLevelDesending = true;
            }
        } else {
            this.handleSemicolon(lastPosition, namespaceDeclaration.getBody().getStart() - 1);
            namespaceDeclaration.getBody().accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(NamespaceName namespaceName) {
        List segments;
        if (namespaceName.isGlobal()) {
            this.appendToBuffer("\\");
        }
        if (namespaceName.isCurrent()) {
            this.appendToBuffer("namespace\\");
        }
        if ((segments = namespaceName.segments()).size() > 0) {
            int start = namespaceName.getStart();
            try {
                if (namespaceName.isGlobal() && (Character.isWhitespace(this.document.getChar(start - 1)) || this.document.getChar(start - 1) == '\\')) {
                    --start;
                }
            }
            catch (BadLocationException badLocationException) {}
            this.handleChars(start, ((Identifier)segments.get(0)).getStart());
            Iterator it = segments.iterator();
            Identifier prev = null;
            while (it.hasNext()) {
                Identifier identifier = (Identifier)it.next();
                if (prev != null) {
                    this.handleChars(prev.getEnd(), identifier.getStart());
                }
                identifier.accept((Visitor)this);
                if (!it.hasNext()) continue;
                this.appendToBuffer("\\");
                prev = identifier;
            }
        } else {
            this.handleChars(namespaceName.getStart(), namespaceName.getEnd());
        }
        return false;
    }

    public boolean visit(UseStatement useStatement) {
        int lastPosition = useStatement.getStart() + 3;
        this.lineWidth += 3;
        this.insertSpace();
        List parts = useStatement.parts();
        lastPosition = this.handleCommaList(parts.toArray(new ASTNode[parts.size()]), lastPosition, this.preferences.insert_space_before_comma_in_global, this.preferences.insert_space_after_comma_in_global, 0, -1, false);
        this.handleSemicolon(lastPosition, useStatement.getEnd());
        return false;
    }

    public boolean visit(UseStatementPart useStatementPart) {
        useStatementPart.getName().accept((Visitor)this);
        Identifier alias = useStatementPart.getAlias();
        if (alias != null) {
            this.insertSpace();
            this.appendToBuffer("as");
            this.insertSpace();
            this.handleChars(useStatementPart.getName().getEnd(), alias.getStart());
            alias.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        StringBuffer buffer = new StringBuffer();
        if (lambdaFunctionDeclaration.isStatic()) {
            buffer.append("static ");
        }
        buffer.append(this.getDocumentString(lambdaFunctionDeclaration.getStart(), lambdaFunctionDeclaration.getStart() + 8));
        if (lambdaFunctionDeclaration.isReference()) {
            buffer.append(" &");
        } else {
            buffer.append(' ');
        }
        this.appendToBuffer(buffer.toString());
        this.handleChars(lambdaFunctionDeclaration.getStart(), lambdaFunctionDeclaration.getStart() + 8);
        if (this.preferences.insert_space_before_opening_paren_in_function_declaration) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf('('));
        List formalParameters = lambdaFunctionDeclaration.formalParameters();
        FormalParameter[] params = formalParameters.toArray(new FormalParameter[formalParameters.size()]);
        int lastPosition = lambdaFunctionDeclaration.getStart() + 8;
        if (params.length > 0) {
            if (this.preferences.insert_space_after_opening_paren_in_function_declaration) {
                this.insertSpace();
            }
            int indentationGap = this.calculateIndentGap(this.preferences.line_wrap_parameters_in_method_declaration_indent_policy, this.preferences.line_wrap_wrapped_lines_indentation);
            lastPosition = this.handleCommaList((ASTNode[])params, lastPosition, this.preferences.insert_space_before_comma_in_function_declaration, this.preferences.insert_space_after_comma_in_function_declaration, this.preferences.line_wrap_parameters_in_method_declaration_line_wrap_policy, indentationGap, this.preferences.line_wrap_parameters_in_method_declaration_force_split);
            if (this.preferences.insert_space_before_closing_paren_in_function_declaration) {
                this.insertSpace();
            }
        } else if (this.preferences.insert_space_between_empty_paren_in_function_declaration) {
            this.insertSpace();
        }
        this.appendToBuffer(Character.valueOf(')'));
        List variables = lambdaFunctionDeclaration.lexicalVariables();
        if (variables.size() > 0) {
            this.insertSpace();
            this.appendToBuffer("use");
            this.appendToBuffer(Character.valueOf('('));
            if (this.preferences.insert_space_before_opening_paren_in_function_declaration) {
                this.insertSpace();
            }
            Expression[] vars = variables.toArray(new Expression[variables.size()]);
            lastPosition = this.handleCommaList((ASTNode[])vars, lastPosition, this.preferences.insert_space_before_comma_in_function_declaration, this.preferences.insert_space_after_comma_in_function_declaration, this.preferences.line_wrap_parameters_in_method_declaration_line_wrap_policy, 0, this.preferences.line_wrap_parameters_in_method_declaration_force_split);
            if (this.preferences.insert_space_before_closing_paren_in_function_declaration) {
                this.insertSpace();
            }
            this.appendToBuffer(Character.valueOf(')'));
        }
        if (lambdaFunctionDeclaration.getBody() != null) {
            boolean isIndentationAdded = this.handleBlockOpenBrace(this.preferences.brace_position_for_function, this.preferences.insert_space_before_opening_brace_in_function);
            this.handleChars(lastPosition, lambdaFunctionDeclaration.getBody().getStart());
            lambdaFunctionDeclaration.getBody().accept((Visitor)this);
            if (isIndentationAdded) {
                --this.indentationLevel;
                this.indentationLevelDesending = true;
            }
        } else {
            this.handleSemicolon(lastPosition, lambdaFunctionDeclaration.getEnd());
        }
        return false;
    }

    public boolean visit(TraitUseStatement node) {
        if (node.getTraitList().size() > 0) {
            this.lineWidth += 3;
            this.insertSpace();
            this.handleChars(node.getStart() + 3, ((NamespaceName)node.getTraitList().get(0)).getStart());
        }
        return true;
    }

    public String createIndentationString(int indentationUnits) {
        if (indentationUnits < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        tabs = indentationUnits;
        if (tabs == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer(tabs);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        return buffer.toString();
    }

    public MultiTextEdit getTextEdits() {
        List<ReplaceEdit> allChanges = this.getChanges();
        MultiTextEdit rootEdit = new MultiTextEdit();
        for (ReplaceEdit edit : allChanges) {
            org.eclipse.text.edits.ReplaceEdit textEdit = new org.eclipse.text.edits.ReplaceEdit(edit.offset, edit.length, edit.content);
            rootEdit.addChild((TextEdit)textEdit);
        }
        return rootEdit;
    }

    private boolean isInSingleLine(ReplaceEdit edit, IRegion[] partitions, int removedLength) {
        removedLength = 0;
        int i = 0;
        while (i < partitions.length) {
            IRegion iTypedRegion = partitions[i];
            if (edit.offset >= iTypedRegion.getOffset() + removedLength && edit.offset + edit.length <= iTypedRegion.getOffset() + iTypedRegion.getLength() + removedLength) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IRegion[] getAllSingleLine(ITypedRegion[] partitions) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.document instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)this.document;
            ITextRegion phpOpenRegion = null;
            int i = 0;
            while (i < partitions.length) {
                ITypedRegion iTypedRegion = partitions[i];
                if ("org.eclipse.php.PHP_DEFAULT".equals(iTypedRegion.getType())) {
                    if (this.isInSingleLine(iTypedRegion.getOffset(), iTypedRegion.getLength())) {
                        result.add(iTypedRegion);
                    } else {
                        IStructuredDocumentRegion iStructuredDocumentRegion = structuredDocument.getRegionAtCharacterOffset(iTypedRegion.getOffset());
                        ITextRegionList regions = iStructuredDocumentRegion.getRegions();
                        for (ITextRegion iTypedRegion2 : regions) {
                            if ("PHP_OPEN".equals(iTypedRegion2.getType())) {
                                if (phpOpenRegion != null) continue;
                                phpOpenRegion = iTypedRegion2;
                                continue;
                            }
                            if (!"PHP_CLOSE".equals(iTypedRegion2.getType()) || phpOpenRegion == null) continue;
                            Region region = new Region(iStructuredDocumentRegion.getStart() + phpOpenRegion.getStart(), iTypedRegion2.getStart() + iTypedRegion2.getLength());
                            result.add(region);
                            phpOpenRegion = null;
                        }
                    }
                }
                ++i;
            }
            ArrayList<IRegion> temp = new ArrayList<IRegion>();
            for (IRegion iRegion : result) {
                if (!this.isInSingleLine(iRegion.getOffset(), iRegion.getLength())) continue;
                temp.add(iRegion);
            }
            result = temp;
        }
        return result.toArray(new IRegion[result.size()]);
    }

    private boolean isInSingleLine(int start, int length) {
        try {
            String text = this.document.get(start, length);
            int index = text.indexOf("<?");
            start += index;
            if (text.lastIndexOf("?>") >= 0) {
                length = text.lastIndexOf("?>") + 2 - index;
            }
            if (this.document.getLineOfOffset(start) == this.document.getLineOfOffset(start + length)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static String join(Collection<String> s, String delimiter) {
        if (s == null || s.isEmpty()) {
            return EMPTY_STRING;
        }
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            builder.append(delimiter).append(iter.next());
        }
        return builder.toString();
    }

    class CommentIndentationObject {
        boolean indented;

        CommentIndentationObject() {
        }
    }
}

