/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.contentassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.osgi.framework.Bundle;

public class ContentAssistTests
extends AbstractPDTTTest {
    protected static IProject project;
    protected static IFile testFile;
    protected static PHPStructuredEditor fEditor;
    protected static final Map<PHPVersion, String[]> TESTS;
    protected static final char OFFSET_CHAR = '|';

    static {
        TESTS = new LinkedHashMap<PHPVersion, String[]>();
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Content Assist");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        PHPUiPlugin.getDefault().getPluginPreferences().setDefault("contentAssistAutoinsert", true);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public ContentAssistTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Content Assist Tests");
        for (Map.Entry<PHPVersion, String[]> pair : TESTS.entrySet()) {
            final PHPVersion phpVersion = pair.getKey();
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            int i = 0;
            while (i < pair.getValue().length) {
                String[] files;
                String[] stringArray = files = ContentAssistTests.getPDTTFiles((String)pair.getValue()[i], (Bundle)PHPUiTests.getDefault().getBundle());
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    try {
                        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
                        phpVerSuite.addTest((Test)new ContentAssistTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion((IProject)project, (PHPVersion)phpVersion);
                                pdttFile.applyPreferences();
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                String data = pdttFile.getFile();
                                int offset = data.lastIndexOf(124);
                                data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
                                1.createFile(new ByteArrayInputStream(data.getBytes()), Long.toString(System.currentTimeMillis()));
                                String result = 1.executeAutoInsert(offset);
                                1.closeEditor();
                                if (!pdttFile.getExpected().trim().equals(result.trim())) {
                                    StringBuilder errorBuf = new StringBuilder();
                                    errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
                                    errorBuf.append(pdttFile.getExpected());
                                    errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
                                    errorBuf.append(result);
                                    1.fail((String)errorBuf.toString());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n2;
                }
                ++i;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                ContentAssistTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                ContentAssistTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static void closeEditor() {
        fEditor.doSave(null);
        fEditor.getSite().getPage().closeEditor((IEditorPart)fEditor, false);
        fEditor = null;
        if (testFile.exists()) {
            try {
                testFile.delete(true, false, null);
                project.refreshLocal(2, null);
                project.build(6, null);
                PHPCoreTests.waitForIndexer();
            }
            catch (CoreException coreException) {}
        }
    }

    protected static String executeAutoInsert(int offset) {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            ContentAssistTests.fail((String)("fEditor.getTextViewer() returns null for file " + testFile.getFullPath() + "(" + testFile.getLocation() + ")"));
        }
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(offset);
        viewer.doOperation(13);
        return fEditor.getDocument().get();
    }

    protected static void createFile(InputStream inputStream, String fileName) throws Exception {
        testFile = project.getFile(new Path(fileName).removeFileExtension().addFileExtension("php").lastSegment());
        testFile.create(inputStream, true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        FileEditorInput input = new FileEditorInput(testFile);
        IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.php.editor", true);
        if (part instanceof PHPStructuredEditor) {
            fEditor = (PHPStructuredEditor)part;
        } else {
            ContentAssistTests.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }
}

