/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class DeprecatedHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new DeprecatedApply();
    }

    @Override
    public void initDefaultPreferences() {
        this.getStyle().setStrikethroughByDefault(true).setEnabledByDefault(false);
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public String getDisplayName() {
        return Messages.DeprecatedHighlighting_0;
    }

    protected class DeprecatedApply
    extends AbstractSemanticApply {
        protected DeprecatedApply() {
        }

        public boolean visit(Program program) {
            try {
                DeprecatedHighlighting.this.getSourceModule().accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element instanceof IMember) {
                            try {
                                if (ModelUtils.isDeprecated(element)) {
                                    DeprecatedHighlighting.this.highlight(((IMember)element).getNameRange());
                                }
                            }
                            catch (ModelException e) {
                                Logger.logException(e);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            return true;
        }

        public boolean visit(ClassName classConst) {
            block5: {
                if (classConst.getName() instanceof Identifier) {
                    String className = ((Identifier)classConst.getName()).getName();
                    IModelAccessCache cache = classConst.getAST().getBindingResolver().getModelAccessCache();
                    try {
                        IType[] types = PHPModelUtils.getTypes((String)className, (ISourceModule)DeprecatedHighlighting.this.getSourceModule(), (int)classConst.getStart(), (IModelAccessCache)cache, (IProgressMonitor)new NullProgressMonitor());
                        if (types == null) break block5;
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            if (ModelUtils.isDeprecated((IModelElement)type)) {
                                DeprecatedHighlighting.this.highlight((ASTNode)classConst);
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                }
            }
            return true;
        }

        public boolean visit(FieldAccess fieldAccess) {
            IField field = ModelUtils.getField(fieldAccess);
            if (field != null && ModelUtils.isDeprecated((IModelElement)field)) {
                DeprecatedHighlighting.this.highlight((ASTNode)fieldAccess.getMember());
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInv) {
            IMethod method = ModelUtils.getMethod(methodInv);
            if (method != null && ModelUtils.isDeprecated((IModelElement)method)) {
                DeprecatedHighlighting.this.highlight((ASTNode)methodInv.getMethod().getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation funcInv) {
            block4: {
                Collection functions;
                String functionName;
                IModelAccessCache cache;
                block3: {
                    IMethod method;
                    if (!(funcInv.getParent() instanceof StaticMethodInvocation)) break block3;
                    StaticMethodInvocation methodInvocation = (StaticMethodInvocation)funcInv.getParent();
                    ITypeBinding type = methodInvocation.getClassName().resolveTypeBinding();
                    if (type != null && ModelUtils.isDeprecated(type.getPHPElement())) {
                        DeprecatedHighlighting.this.highlight((ASTNode)methodInvocation.getClassName());
                    }
                    if ((method = ModelUtils.getMethod(methodInvocation)) == null || !ModelUtils.isDeprecated((IModelElement)method)) break block4;
                    DeprecatedHighlighting.this.highlight((ASTNode)methodInvocation.getMethod().getFunctionName());
                    break block4;
                }
                if (!(funcInv.getParent() instanceof MethodInvocation) && (cache = funcInv.getAST().getBindingResolver().getModelAccessCache()) != null && (functionName = ModelUtils.getFunctionName(funcInv.getFunctionName())) != null && (functions = cache.getGlobalFunctions(DeprecatedHighlighting.this.getSourceModule(), functionName, null)) != null) {
                    for (IMethod function : functions) {
                        if (!ModelUtils.isDeprecated((IModelElement)function)) continue;
                        DeprecatedHighlighting.this.highlight((ASTNode)funcInv.getFunctionName());
                        break;
                    }
                }
            }
            return true;
        }
    }
}

