/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.IStringValidator;
import org.eclipse.php.internal.ui.util.ValidationStatus;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractPHPPreferenceBlock
extends AbstractPHPPreferencePageBlock {
    protected PreferencePage preferencePage;
    protected ArrayList buttons = new ArrayList();
    protected ArrayList textBoxes = new ArrayList();
    protected ArrayList labels = new ArrayList();
    protected ArrayList combos = new ArrayList();

    protected void add(Button button) {
        this.buttons.add(button);
    }

    protected void add(Text text) {
        this.textBoxes.add(text);
    }

    protected void add(Label label) {
        this.labels.add(label);
    }

    protected void add(ValuedCombo valuedCombo) {
        this.combos.add(valuedCombo);
    }

    protected void restoreDefaultValues() {
        this.restoreDefaultButtonValues();
        this.restoreDefaultTextValues();
        this.restoreDefaultComboTextValues();
    }

    protected void restoreDefaultComboTextValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object data = valuedCombo.getData();
            if (data == null) continue;
            valuedCombo.selectValue(this.getPreferenceStore().getDefaultString((String)data));
        }
    }

    protected void restoreDefaultTextValues() {
        Object[] controlsArray = this.textBoxes.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Text text = (Text)controlsArray[i];
            Object data = text.getData();
            if (data != null) {
                text.setText(this.getPreferenceStore().getDefaultString((String)data));
            }
            ++i;
        }
    }

    protected void restoreDefaultButtonValues() {
        Object[] controlsArray = this.buttons.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Button button = (Button)controlsArray[i];
            Object data = button.getData();
            if (data != null) {
                button.setSelection(this.getPreferenceStore().getDefaultBoolean((String)data));
            }
            ++i;
        }
    }

    protected void initializeValues() {
        this.initializeButtonsValues();
        this.initializeTextValues();
        this.initializeComboValues();
    }

    protected void initializeComboValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object data = valuedCombo.getData();
            if (data == null) continue;
            valuedCombo.selectValue(this.getPreferenceStore().getString((String)data));
        }
    }

    protected void initializeTextValues() {
        Object[] controlsArray = this.textBoxes.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Text text = (Text)controlsArray[i];
            Object data = text.getData();
            if (data != null) {
                text.setText(this.getPreferenceStore().getString((String)data));
            }
            ++i;
        }
    }

    protected void initializeButtonsValues() {
        Object[] controlsArray = this.buttons.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Button button = (Button)controlsArray[i];
            Object data = button.getData();
            if (data != null) {
                button.setSelection(this.getPreferenceStore().getBoolean((String)data));
            }
            ++i;
        }
    }

    protected void storeValues() {
        this.storeButtonsValues();
        this.storeTextValues();
        this.storeCombosValues();
    }

    protected void storeCombosValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object data = valuedCombo.getData();
            if (data == null) continue;
            this.getPreferenceStore().setValue((String)data, valuedCombo.getSelectionValue());
        }
    }

    protected void storeTextValues() {
        Object[] controlsArray = this.textBoxes.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Text text = (Text)controlsArray[i];
            Object data = text.getData();
            if (data != null) {
                this.getPreferenceStore().setValue((String)data, text.getText());
            }
            ++i;
        }
    }

    protected void storeButtonsValues() {
        Object[] controlsArray = this.buttons.toArray();
        int i = 0;
        while (i < controlsArray.length) {
            Button button = (Button)controlsArray[i];
            Object data = button.getData();
            if (data != null) {
                this.getPreferenceStore().setValue((String)data, button.getSelection());
            }
            ++i;
        }
    }

    protected void setControlsEnabled(String key, boolean enabled) {
        this.setControlsEnabled(this.buttons, key, enabled);
        this.setControlsEnabled(this.textBoxes, key, enabled);
        this.setControlsEnabled(this.labels, key, enabled);
        this.setControlsEnabled(this.combos, key, enabled);
    }

    private void setControlsEnabled(ArrayList controls, String key, boolean enabled) {
        for (Control control : controls) {
            Object data = control.getData();
            if (data == null || !((String)data).equals(key)) continue;
            control.setEnabled(enabled);
        }
    }

    protected FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    @Override
    protected Composite createSubsection(Composite parent, String label) {
        Group group = new Group(parent, 32);
        group.setText(label);
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        return group;
    }

    @Override
    protected Button addCheckBox(Composite parent, String label, String prefKey, int horizontalIndent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(256);
        gd.horizontalIndent = horizontalIndent;
        gd.horizontalSpan = 3;
        checkBox.setLayoutData((Object)gd);
        checkBox.setData((Object)prefKey);
        this.add(checkBox);
        return checkBox;
    }

    protected Text addLabelledTextField(Composite parent, String label, String key, int textlimit, int horizontalIndent, IStringValidator stringValidator) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setData((Object)key);
        GridData data = new GridData();
        data.horizontalIndent = horizontalIndent;
        labelControl.setLayoutData((Object)data);
        this.add(labelControl);
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        data = new GridData();
        if (textlimit != 0) {
            textBox.setTextLimit(textlimit);
            data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics((Control)parent), (int)(textlimit + 1));
        }
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        if (stringValidator != null) {
            textBox.addModifyListener((ModifyListener)new TextFieldValidateListener(stringValidator));
        }
        this.add(textBox);
        return textBox;
    }

    protected Text addLabelledTextField(Composite parent, String label, String key, int textlimit, int horizontalIndent) {
        return this.addLabelledTextField(parent, label, key, textlimit, horizontalIndent, null);
    }

    protected Control createContents(Composite parent) {
        return new Composite(parent, 0);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    @Override
    public void performDefaults() {
        this.restoreDefaultValues();
    }

    @Override
    public boolean performOK(boolean isProjectSpecific) {
        this.storeValues();
        PHPUiPlugin.getDefault().savePluginPreferences();
        return true;
    }

    @Override
    public void performApply(boolean isProjectSpecific) {
        this.storeValues();
        PHPUiPlugin.getDefault().savePluginPreferences();
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected abstract PreferencePage getPreferencePage();

    class TextFieldValidateListener
    implements ModifyListener {
        private IStringValidator stringValidator;

        public TextFieldValidateListener(IStringValidator stringValidator) {
            this.stringValidator = stringValidator;
        }

        public void modifyText(ModifyEvent e) {
            ValidationStatus status = this.stringValidator.validate(((Text)e.widget).getText());
            if (!status.isOK()) {
                AbstractPHPPreferenceBlock.this.getPreferencePage().setErrorMessage(status.getError());
                AbstractPHPPreferenceBlock.this.getPreferencePage().setValid(false);
            } else {
                AbstractPHPPreferenceBlock.this.getPreferencePage().setErrorMessage(null);
                AbstractPHPPreferenceBlock.this.getPreferencePage().setValid(true);
            }
        }
    }
}

