/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.formatter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.Bundle;

public class FormatterTestsWrapper
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IFile testFile;
    protected IProject project;
    protected static final char OFFSET_CHAR = '|';
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/formatter/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/formatter/php53"});
    }

    public FormatterTestsWrapper() {
        super("");
    }

    public Test suite(Map map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Formatter Tests");
        PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = FormatterTestsWrapper.getPDTTFiles((String)testsDirectory, (Bundle)PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    FormatterTests test = new FormatterTests(this, fileName){

                        protected void tearDown() throws Exception {
                            if (testFile != null) {
                                testFile.delete(true, null);
                                testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            this.executeLocator(pdttFile.getFile(), fileName);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected void executeLocator(String data, String fileName) throws Exception {
        this.testFile = this.createFile(data.trim());
        IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(this.testFile);
        try {
            IStructuredDocument document = modelForEdit.getStructuredDocument();
            String beforeFormat = document.get();
            final PhpFormatProcessorImpl formatter = new PhpFormatProcessorImpl();
            this.perfMonitor.execute("PerformanceTests.testFormatter_" + fileName, new PerformanceMonitor.Operation((IDocument)document){
                private final /* synthetic */ IDocument val$document;
                {
                    this.val$document = iDocument;
                }

                @Override
                public void run() throws Exception {
                    formatter.formatDocument(this.val$document, 0, this.val$document.getLength());
                }
            }, 1, 10);
            document.set(beforeFormat);
            modelForEdit.save();
        }
        finally {
            if (modelForEdit != null) {
                modelForEdit.releaseFromEdit();
            }
        }
    }

    protected IFile createFile(String data) throws Exception {
        IFile testFile = this.project.getFile("pdttest/test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }

    public class FormatterTests
    extends AbstractPDTTTest {
        public FormatterTests(String description) {
            super(description);
        }
    }
}

