/* The following code was generated by JFlex 1.4.1 on 3/10/14 3:11 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php4;

import org.eclipse.php.internal.core.util.collections.IntHashtable;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 3/10/14 3:11 AM from the specification file
 * <tt>highlighting_scanner.jflex</tt>
 */
public class PhpLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_PHP_LINE_COMMENT = 20;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_COMMENT = 16;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_DOC_COMMENT = 18;
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 14;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 22;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  8,  8, 
     9,  9, 10, 10, 11, 11, 12, 12
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\20\2\0\1\11\22\0\1\12\1\24\1\73\1\70"+
    "\1\67\1\30\1\31\1\17\1\57\1\61\1\26\1\23\1\13\1\4"+
    "\1\2\1\27\1\5\7\76\2\1\1\55\1\14\1\25\1\21\1\22"+
    "\1\71\1\72\1\36\1\7\1\45\1\40\1\3\1\43\1\60\1\52"+
    "\1\41\1\63\1\53\1\46\1\65\1\37\1\34\1\54\1\64\1\35"+
    "\1\50\1\42\1\44\1\56\1\51\1\6\1\62\1\10\1\16\1\74"+
    "\1\16\1\33\1\47\1\75\1\36\1\7\1\45\1\40\1\3\1\43"+
    "\1\60\1\52\1\41\1\63\1\53\1\46\1\65\1\37\1\34\1\54"+
    "\1\64\1\35\1\50\1\42\1\44\1\56\1\51\1\6\1\62\1\10"+
    "\1\66\1\32\1\15\1\13\201\10\uff00\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\15\0\1\1\1\2\1\3\1\4\1\3\1\2\3\4"+
    "\1\5\1\3\1\6\1\7\1\10\12\3\17\4\1\3"+
    "\1\4\1\3\1\4\1\11\1\3\1\12\1\3\1\13"+
    "\1\14\7\15\1\16\5\15\3\17\1\15\1\20\1\1"+
    "\1\15\1\21\1\22\2\23\3\24\3\25\3\26\1\27"+
    "\1\30\2\2\1\31\6\4\1\32\1\0\2\4\2\0"+
    "\2\31\1\33\1\34\1\31\4\4\1\35\3\4\1\36"+
    "\2\4\1\37\23\4\1\40\1\4\12\0\1\4\2\41"+
    "\1\42\3\0\1\43\1\44\1\45\1\46\2\15\1\0"+
    "\1\47\1\50\1\0\1\50\1\51\1\52\20\0\1\53"+
    "\1\54\1\2\7\4\1\2\1\4\2\0\4\4\1\55"+
    "\3\4\1\56\3\4\1\57\4\4\1\60\15\4\1\61"+
    "\11\0\1\4\1\41\3\15\34\0\1\62\6\4\1\63"+
    "\1\64\1\65\2\4\1\0\1\66\1\0\4\4\1\67"+
    "\4\4\1\70\1\4\1\71\5\4\1\72\2\4\1\73"+
    "\11\4\11\0\1\4\1\41\25\0\1\74\7\0\1\75"+
    "\3\0\2\4\1\76\4\4\1\77\1\100\2\101\1\0"+
    "\2\4\1\102\3\4\1\103\1\4\1\104\1\4\1\105"+
    "\1\4\1\106\1\4\1\107\6\4\1\110\1\111\1\4"+
    "\6\0\1\112\2\0\1\4\1\113\6\0\1\114\1\115"+
    "\3\0\1\116\4\0\1\117\2\0\1\120\13\0\2\4"+
    "\1\121\2\4\1\122\1\0\1\123\14\4\1\124\1\125"+
    "\1\126\4\0\1\127\13\0\1\130\4\0\1\131\3\0"+
    "\1\132\4\0\1\133\1\134\4\4\1\135\1\136\1\137"+
    "\1\140\1\141\7\4\4\0\1\142\1\0\1\143\1\144"+
    "\2\0\1\145\1\0\1\146\4\0\1\147\4\0\1\150"+
    "\1\151\3\4\1\152\2\4\1\153\1\154\1\4\1\155"+
    "\2\4\1\156\1\157\10\0\1\160\3\0\1\161\1\162"+
    "\2\4\1\163\2\4\1\164\1\4\1\165\1\0\1\166"+
    "\1\0\1\167\1\170\2\0\1\171\2\0\1\172\1\173"+
    "\1\174\3\4\1\175\2\0\1\176\1\177\1\0\3\4"+
    "\1\200\1\201\1\202\1\203\1\204\1\205";

  private static int [] zzUnpackAction() {
    int [] result = new int[613];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\0\0\u0333\0\u0372"+
    "\0\u03b1\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\0"+
    "\0\0\0\0\0\u056a\0\u05a9\0\u05e8\0\u0627\0\u0666\0\u06a5"+
    "\0\u06e4\0\u0723\0\u0762\0\u07a1\0\u07e0\0\u081f\0\u085e\0\u089d"+
    "\0\u08dc\0\u091b\0\u095a\0\u0999\0\u09d8\0\u0a17\0\u0a56\0\u0a95"+
    "\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f\0\u0c4e\0\u0c8d"+
    "\0\0\0\u0ccc\0\0\0\u0d0b\0\u0d4a\0\0\0\0\0\u0d89"+
    "\0\u0dc8\0\u0e07\0\u0e46\0\u0e85\0\u0ec4\0\0\0\u0f03\0\u0f42"+
    "\0\u0f81\0\u0fc0\0\u0fff\0\0\0\u103e\0\u0e85\0\u107d\0\u10bc"+
    "\0\u0f03\0\u10fb\0\0\0\u113a\0\u1179\0\u11b8\0\0\0\u11f7"+
    "\0\u1236\0\u1275\0\u12b4\0\0\0\0\0\u12f3\0\u0d0b\0\0"+
    "\0\u1332\0\u1371\0\u13b0\0\0\0\u13ef\0\u142e\0\u146d\0\u14ac"+
    "\0\u14eb\0\u152a\0\0\0\u1569\0\u15a8\0\u15e7\0\u056a\0\u1626"+
    "\0\u06e4\0\u1665\0\u16a4\0\u16e3\0\u04ec\0\u1722\0\u1761\0\u17a0"+
    "\0\u17df\0\u04ec\0\u181e\0\u185d\0\u189c\0\u04ec\0\u18db\0\u191a"+
    "\0\u04ec\0\u1959\0\u1998\0\u19d7\0\u1a16\0\u1a55\0\u1a94\0\u1ad3"+
    "\0\u1b12\0\u1b51\0\u1b90\0\u1bcf\0\u1c0e\0\u1c4d\0\u1c8c\0\u1ccb"+
    "\0\u1d0a\0\u1d49\0\u1d88\0\u1dc7\0\0\0\u1e06\0\u1e45\0\u0c4e"+
    "\0\u1e84\0\u1ec3\0\u1f02\0\u1f41\0\u1f80\0\u1fbf\0\u1ffe\0\u203d"+
    "\0\u207c\0\u20bb\0\u20fa\0\u2139\0\u0d4a\0\u2178\0\u21b7\0\0"+
    "\0\0\0\u21f6\0\0\0\u2235\0\u2274\0\u22b3\0\0\0\u22f2"+
    "\0\u2331\0\0\0\0\0\0\0\u2370\0\u23af\0\u23ee\0\u242d"+
    "\0\u246c\0\u24ab\0\u24ea\0\u2529\0\u2568\0\u25a7\0\u25e6\0\u2625"+
    "\0\u2664\0\u26a3\0\u26e2\0\u2721\0\0\0\u2760\0\u279f\0\u27de"+
    "\0\u281d\0\u285c\0\u289b\0\u28da\0\u2919\0\u2958\0\u1569\0\u2997"+
    "\0\u29d6\0\u2a15\0\u2a54\0\u2a93\0\u2ad2\0\u2b11\0\u04ec\0\u2b50"+
    "\0\u2b8f\0\u2bce\0\u04ec\0\u2c0d\0\u2c4c\0\u2c8b\0\u2cca\0\u2d09"+
    "\0\u2d48\0\u2d87\0\u2dc6\0\u04ec\0\u2e05\0\u2e44\0\u2e83\0\u2ec2"+
    "\0\u2f01\0\u2f40\0\u2f7f\0\u2fbe\0\u2ffd\0\u303c\0\u307b\0\u30ba"+
    "\0\u30f9\0\u04ec\0\u3138\0\u3177\0\u31b6\0\u31f5\0\u3234\0\u3273"+
    "\0\u32b2\0\u32f1\0\u3330\0\u336f\0\u33ae\0\u21b7\0\u33ed\0\u342c"+
    "\0\u346b\0\u34aa\0\u34e9\0\u3528\0\u3567\0\u35a6\0\u35e5\0\u3624"+
    "\0\u3663\0\u36a2\0\u36e1\0\u3720\0\u375f\0\u379e\0\u37dd\0\u381c"+
    "\0\u385b\0\u389a\0\u38d9\0\u3918\0\u3957\0\u3996\0\u39d5\0\u3a14"+
    "\0\u3a53\0\u3a92\0\u3ad1\0\u3b10\0\u04ec\0\u3b4f\0\u3b8e\0\u3bcd"+
    "\0\u3c0c\0\u3c4b\0\u3c8a\0\u04ec\0\u3cc9\0\u04ec\0\u3d08\0\u3d47"+
    "\0\u3d86\0\u3dc5\0\u3e04\0\u3e43\0\u3e82\0\u3ec1\0\u3f00\0\u04ec"+
    "\0\u3f3f\0\u3f7e\0\u3fbd\0\u3ffc\0\u04ec\0\u403b\0\u04ec\0\u407a"+
    "\0\u40b9\0\u40f8\0\u4137\0\u4176\0\u04ec\0\u41b5\0\u41f4\0\u04ec"+
    "\0\u4233\0\u4272\0\u42b1\0\u42f0\0\u432f\0\u436e\0\u43ad\0\u43ec"+
    "\0\u442b\0\u446a\0\u44a9\0\u44e8\0\u4527\0\u4566\0\u45a5\0\u45e4"+
    "\0\u4623\0\u4662\0\u46a1\0\u46e0\0\u471f\0\u475e\0\u479d\0\u47dc"+
    "\0\u481b\0\u485a\0\u4899\0\u48d8\0\u4917\0\u4956\0\u4995\0\u49d4"+
    "\0\u4a13\0\u4a52\0\u4a91\0\u4ad0\0\u4b0f\0\u4b4e\0\u4b8d\0\u4bcc"+
    "\0\u4c0b\0\0\0\u4c4a\0\u4c89\0\u4cc8\0\u4d07\0\u4d46\0\u4d85"+
    "\0\u4dc4\0\0\0\u4e03\0\u4e42\0\u4e81\0\u4ec0\0\u4eff\0\u04ec"+
    "\0\u4f3e\0\u4f7d\0\u4fbc\0\u4ffb\0\u04ec\0\u04ec\0\u503a\0\0"+
    "\0\u5079\0\u50b8\0\u50f7\0\u04ec\0\u5136\0\u5175\0\u51b4\0\u04ec"+
    "\0\u51f3\0\u04ec\0\u5232\0\u04ec\0\u5271\0\u04ec\0\u52b0\0\u04ec"+
    "\0\u52ef\0\u532e\0\u536d\0\u53ac\0\u53eb\0\u542a\0\u04ec\0\u04ec"+
    "\0\u5469\0\u54a8\0\u54e7\0\u5526\0\u5565\0\u55a4\0\u55e3\0\0"+
    "\0\u5622\0\u5661\0\u56a0\0\u20bb\0\u56df\0\u571e\0\u575d\0\u579c"+
    "\0\u57db\0\u581a\0\0\0\0\0\u5859\0\u5898\0\u58d7\0\0"+
    "\0\u5916\0\u5955\0\u5994\0\u59d3\0\0\0\u5a12\0\u5a51\0\0"+
    "\0\u5a90\0\u5acf\0\u5b0e\0\u5b4d\0\u5b8c\0\u5bcb\0\u5c0a\0\u5c49"+
    "\0\u5c88\0\u5cc7\0\u5d06\0\u5d45\0\u5d84\0\u5dc3\0\u5e02\0\u5e41"+
    "\0\u04ec\0\u3dc5\0\u04ec\0\u5e80\0\u5ebf\0\u5efe\0\u5f3d\0\u5f7c"+
    "\0\u5fbb\0\u5ffa\0\u6039\0\u6078\0\u60b7\0\u60f6\0\u6135\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u6174\0\u61b3\0\u61f2\0\u6231\0\u04ec\0\u6270"+
    "\0\u62af\0\u62ee\0\u632d\0\u636c\0\u63ab\0\u63ea\0\u6429\0\u6468"+
    "\0\u64a7\0\u64e6\0\0\0\u6525\0\u6564\0\u65a3\0\u65e2\0\0"+
    "\0\u6621\0\u6660\0\u669f\0\0\0\u66de\0\u671d\0\u675c\0\u679b"+
    "\0\0\0\u04ec\0\u67da\0\u6819\0\u6858\0\u6897\0\u68d6\0\u04ec"+
    "\0\u04ec\0\u6915\0\u04ec\0\u6954\0\u6993\0\u69d2\0\u6a11\0\u6a50"+
    "\0\u6a8f\0\u6ace\0\u6b0d\0\u6b4c\0\u6b8b\0\u6bca\0\0\0\u6c09"+
    "\0\0\0\0\0\u6c48\0\u6c87\0\0\0\u6cc6\0\0\0\u6d05"+
    "\0\u6d44\0\u6d83\0\u6dc2\0\u6e01\0\u6e40\0\u6e7f\0\u6ebe\0\u6efd"+
    "\0\0\0\0\0\u6f3c\0\u6f7b\0\u6fba\0\u04ec\0\u6ff9\0\u7038"+
    "\0\u04ec\0\u04ec\0\u7077\0\u04ec\0\u70b6\0\u70f5\0\u04ec\0\0"+
    "\0\u7134\0\u7173\0\u71b2\0\u71f1\0\u7230\0\u726f\0\u72ae\0\u72ed"+
    "\0\0\0\u732c\0\u736b\0\u73aa\0\0\0\0\0\u73e9\0\u7428"+
    "\0\u04ec\0\u7467\0\u74a6\0\u04ec\0\u74e5\0\u04ec\0\u7524\0\0"+
    "\0\u7563\0\0\0\0\0\u75a2\0\u75e1\0\0\0\u7620\0\u765f"+
    "\0\0\0\u04ec\0\u04ec\0\u769e\0\u76dd\0\u771c\0\0\0\u775b"+
    "\0\u779a\0\0\0\0\0\u77d9\0\u7818\0\u7857\0\u7896\0\0"+
    "\0\0\0\0\0\u04ec\0\u04ec\0\u04ec";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[613];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\77\0\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\2\27\1\30\1\31\1\32\1\30\1\33"+
    "\1\27\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\41\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\2\26\1\64\1\65\1\66\1\67\1\70"+
    "\1\30\4\26\1\71\1\72\1\73\1\74\1\30\1\75"+
    "\1\16\1\76\1\17\1\77\1\100\1\101\1\102\1\101"+
    "\1\103\3\102\4\101\2\77\15\101\21\102\1\101\1\102"+
    "\1\101\1\102\1\101\4\102\1\104\1\105\3\101\1\106"+
    "\1\107\1\110\1\100\17\111\1\106\54\111\1\112\2\111"+
    "\1\77\1\100\1\101\1\102\1\101\1\103\3\102\4\101"+
    "\2\77\15\101\21\102\1\101\1\102\1\101\1\102\1\101"+
    "\4\102\1\104\1\105\3\101\1\113\1\107\1\106\1\100"+
    "\4\114\1\115\61\114\1\116\10\114\1\16\1\100\1\101"+
    "\1\102\1\101\1\103\3\102\4\101\2\77\1\117\14\101"+
    "\21\102\1\101\1\102\1\101\1\102\1\101\4\102\1\104"+
    "\1\105\3\101\1\120\1\121\1\120\1\100\1\16\1\100"+
    "\1\101\1\122\1\101\1\103\3\122\4\101\2\77\1\117"+
    "\14\101\21\122\1\101\1\122\1\101\1\122\1\101\4\122"+
    "\1\104\1\105\3\101\1\120\1\121\1\120\1\100\3\123"+
    "\1\124\2\123\3\124\23\123\21\124\1\123\1\124\1\123"+
    "\1\124\1\123\4\124\11\123\26\125\1\126\50\125\26\127"+
    "\1\130\43\127\1\131\4\127\11\132\1\133\6\132\1\134"+
    "\1\132\1\135\5\132\1\136\40\132\1\137\5\132\11\140"+
    "\2\141\5\140\1\141\56\140\1\0\1\17\1\142\1\143"+
    "\1\0\1\17\70\0\1\17\1\0\1\142\3\0\1\142"+
    "\13\0\1\144\54\0\1\142\1\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\145\2\26\23\0\3\26\1\146\5\26"+
    "\1\147\1\150\6\26\1\0\1\151\1\0\1\26\1\0"+
    "\3\26\1\152\10\0\1\26\4\0\1\144\14\0\1\144"+
    "\1\153\55\0\1\17\1\142\1\143\1\0\1\17\1\154"+
    "\67\0\1\17\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\1\155\20\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\1\26\1\156\17\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\21\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\11\0\2\27\5\0"+
    "\1\27\56\0\17\157\1\77\54\157\1\160\2\157\21\0"+
    "\1\161\1\144\75\0\1\144\1\161\75\0\1\144\1\0"+
    "\1\144\74\0\1\161\76\0\2\144\2\0\1\162\72\0"+
    "\1\144\76\0\1\144\4\0\1\163\1\73\70\0\1\144"+
    "\1\164\75\0\1\144\7\0\1\144\66\0\1\144\10\0"+
    "\1\144\45\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\1\26\1\165\10\26\1\166\6\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\167\1\0\4\26\23\0\21\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\1\26\1\170\1\26\1\171"+
    "\10\26\1\172\4\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\173\1\0"+
    "\4\26\23\0\10\26\1\174\10\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\175\1\0\4\26\23\0\1\176\4\26\1\177\13\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\3\26"+
    "\1\200\3\26\1\201\4\26\1\202\4\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\1\26\1\203\17\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\1\204"+
    "\1\205\1\206\5\26\1\207\10\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\3\26\1\210\10\26\1\211"+
    "\4\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\1\212\1\26\1\213\4\26\1\214\2\26\1\215\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\5\26"+
    "\1\216\13\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\13\26\1\217\5\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\6\26\1\220\6\26\1\221\3\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\16\26"+
    "\1\222\2\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\1\26\1\223\1\224\16\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\55\0\1\225\22\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\2\26\1\226"+
    "\16\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\7\0\1\227\2\0\1\230\21\0\1\231\1\232"+
    "\1\233\1\0\1\234\1\235\1\0\1\236\1\237\3\0"+
    "\1\240\27\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\12\26\1\241\6\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\3\0\1\242\2\0\3\242\23\0"+
    "\6\242\1\243\12\242\1\0\1\242\1\0\1\242\1\0"+
    "\4\242\33\0\1\244\54\0\67\245\1\0\3\245\1\77"+
    "\1\246\2\245\1\0\1\100\3\0\1\100\70\0\1\100"+
    "\2\0\1\101\1\0\1\101\4\0\4\101\2\0\15\101"+
    "\21\0\1\101\1\0\1\101\1\0\1\101\6\0\3\101"+
    "\5\0\1\102\1\0\1\102\1\0\4\102\23\0\21\102"+
    "\1\0\1\102\1\0\1\102\1\0\4\102\10\0\1\102"+
    "\1\0\1\100\3\0\1\100\1\247\67\0\1\100\67\0"+
    "\1\250\7\0\3\251\1\252\2\251\3\252\23\251\21\252"+
    "\1\251\1\252\1\251\1\252\1\251\4\252\1\253\10\251"+
    "\5\77\1\254\1\255\67\77\1\254\75\0\1\110\1\0"+
    "\17\111\1\0\54\111\1\256\21\111\1\77\54\111\1\77"+
    "\2\111\73\0\1\113\25\0\1\257\56\0\1\101\1\0"+
    "\1\101\4\0\4\101\2\0\1\117\14\101\21\0\1\101"+
    "\1\0\1\101\1\0\1\101\6\0\3\101\1\120\1\0"+
    "\1\120\20\0\1\120\53\0\1\120\1\0\1\120\2\0"+
    "\1\122\1\0\1\122\1\0\4\122\1\260\2\0\1\261"+
    "\3\0\1\262\13\0\21\122\1\0\1\122\1\0\1\122"+
    "\1\0\4\122\10\0\1\122\1\0\1\124\1\0\1\124"+
    "\1\0\4\124\23\0\21\124\1\0\1\124\1\0\1\124"+
    "\1\0\4\124\10\0\1\124\26\125\1\0\50\125\27\0"+
    "\1\263\76\0\1\264\52\0\1\265\31\0\1\266\1\267"+
    "\1\270\1\271\1\272\1\273\1\274\1\275\1\276\1\277"+
    "\1\0\1\300\3\0\1\301\1\0\1\302\1\0\1\303"+
    "\4\0\1\304\11\0\11\132\1\134\6\132\1\134\1\132"+
    "\1\134\5\132\1\134\40\132\1\134\5\132\20\0\1\305"+
    "\100\0\1\306\65\0\2\141\5\0\1\141\57\0\1\142"+
    "\1\0\1\143\1\0\1\142\70\0\1\142\1\0\1\307"+
    "\2\0\2\307\15\0\1\307\52\0\1\307\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\5\26\1\310\1\311"+
    "\12\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\4\26\1\312\14\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\16\26\1\313\2\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\14\26\1\314\4\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\2\26\1\315"+
    "\16\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\20\26\1\316\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\317\1\0\1\317\1\0\1\317"+
    "\1\0\1\317\26\0\1\317\1\0\1\317\2\0\1\317"+
    "\1\0\1\317\30\0\1\317\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\1\26\1\165\17\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\320\1\0\4\26\23\0\21\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\20\157\1\0"+
    "\56\157\21\0\1\144\3\0\1\321\77\0\1\322\61\0"+
    "\2\164\5\0\1\164\57\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\4\26\1\323\14\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\6\26\1\324\12\26\1\0"+
    "\1\26\1\0\1\26\1\0\2\26\1\325\1\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\1\26\1\326\17\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\4\26\1\165\14\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\15\26\1\327\3\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\12\26\1\330"+
    "\6\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\7\26\1\331\1\26\1\332\7\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\333\1\0\4\26\23\0\21\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\11\26\1\334\7\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\14\26\1\335"+
    "\4\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\10\26\1\336\10\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\1\26\1\337\17\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\1\340\20\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\12\26\1\341\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\3\26"+
    "\1\342\15\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\14\26\1\343\4\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\344"+
    "\1\0\4\26\23\0\21\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\3\26\1\345\15\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\14\26\1\346\4\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\10\26"+
    "\1\347\10\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\2\26\1\350\16\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\14\26\1\351\4\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\7\26\1\352\1\26"+
    "\1\353\1\354\6\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\2\26\1\355\16\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\5\26\1\356\13\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\5\26\1\357"+
    "\13\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\5\26\1\360\13\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\1\26\1\361\17\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\1\26\1\362\17\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\34\0"+
    "\1\363\51\0\1\364\72\0\1\365\130\0\1\366\75\0"+
    "\1\367\101\0\1\370\105\0\1\371\67\0\1\372\101\0"+
    "\1\373\35\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\1\374\20\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\242\1\0\1\242\1\0\4\242"+
    "\23\0\21\242\1\0\1\242\1\0\1\242\1\0\4\242"+
    "\10\0\1\242\1\0\1\242\1\0\1\242\1\0\4\242"+
    "\23\0\16\242\1\375\2\242\1\0\1\242\1\0\1\242"+
    "\1\0\4\242\10\0\1\242\11\0\2\244\5\0\1\244"+
    "\56\0\20\245\1\0\56\245\1\0\1\376\1\0\1\376"+
    "\1\0\1\376\1\0\1\376\26\0\1\376\1\0\1\376"+
    "\2\0\1\376\1\0\1\376\30\0\1\376\1\0\1\252"+
    "\1\0\1\252\1\0\4\252\23\0\21\252\1\0\1\252"+
    "\1\0\1\252\1\0\4\252\10\0\1\252\5\0\1\377"+
    "\70\0\1\377\1\0\1\u0100\1\0\1\u0100\1\0\1\u0100"+
    "\1\0\1\u0100\26\0\1\u0100\1\0\1\u0100\2\0\1\u0100"+
    "\1\0\1\u0100\30\0\1\u0100\17\111\1\0\54\111\1\0"+
    "\2\111\20\0\1\262\67\0\1\260\6\0\1\262\64\0"+
    "\1\u0101\73\0\1\u0102\102\0\1\u0103\34\0\1\u0104\1\u0105"+
    "\67\0\1\u0106\43\0\1\u0107\132\0\1\u0108\20\0\1\u0109"+
    "\52\0\1\u010a\7\0\1\u010b\5\0\1\u010c\65\0\1\u010d"+
    "\105\0\1\u010e\62\0\1\u010f\1\0\1\u0110\101\0\1\u0111"+
    "\40\0\1\u0112\35\0\1\u0113\1\u0114\1\0\1\u0115\67\0"+
    "\1\u0116\1\u0117\43\0\1\u0118\32\0\1\u0119\106\0\1\u011a"+
    "\33\0\1\u011b\32\0\1\u011c\51\0\2\306\5\0\1\306"+
    "\57\0\1\307\3\0\1\307\70\0\1\307\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\6\26\1\u011d\12\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\u011e\1\0\4\26\23\0\21\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\4\26"+
    "\1\u011f\1\u0120\1\26\1\u0121\4\26\1\u0122\1\u0123\3\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\1\u0124"+
    "\20\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\u0125\1\0\4\26\23\0"+
    "\21\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\12\26\1\u0126\6\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\6\26\1\u0127\12\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\2\26\1\u0128\16\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\3\0"+
    "\1\u0129\2\0\3\u0129\1\0\1\321\21\0\21\u0129\1\0"+
    "\1\u0129\1\0\1\u0129\1\0\4\u0129\22\0\2\u012a\5\0"+
    "\1\u012a\47\0\1\u012b\7\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\13\26\1\u012c\5\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\10\26\1\u012d\10\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\10\26\1\u012e"+
    "\10\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\2\26\1\u012f\16\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\12\26\1\u0130\6\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\2\26\1\u0131\16\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\12\26\1\u0132"+
    "\6\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\12\26\1\u0133\6\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\u0134\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\u0135\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\u0136\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\3\26\1\u0137\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\14\26\1\u0138\4\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\11\26\1\u0139\7\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\u013a\1\0\4\26\23\0\21\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\6\26"+
    "\1\u013b\5\26\1\u013c\4\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\u013d"+
    "\1\0\4\26\23\0\21\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\3\26\1\u013e\15\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\14\26\1\u013f\4\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\6\26"+
    "\1\u0140\12\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\5\26\1\u0141\2\26\1\u0142\10\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\12\26\1\u0143\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\5\26"+
    "\1\u0144\13\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\6\26\1\u0145\12\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\6\26\1\u0146\12\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\12\26\1\u0147\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\3\26"+
    "\1\u0148\15\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\u0149\1\0\4\26"+
    "\23\0\21\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\34\0\1\u014a\125\0\1\u014b\51\0\1\u014c"+
    "\75\0\1\u014d\105\0\1\u014e\74\0\1\u014f\70\0\1\u0150"+
    "\112\0\1\u0151\63\0\1\u0152\42\0\1\26\1\0\1\26"+
    "\1\0\2\26\1\u0153\1\26\23\0\21\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\242"+
    "\1\0\1\242\1\0\4\242\23\0\5\242\1\u0154\13\242"+
    "\1\0\1\242\1\0\1\242\1\0\4\242\10\0\1\242"+
    "\5\0\1\77\70\0\1\77\1\0\1\77\1\0\1\77"+
    "\1\0\1\77\1\0\1\77\26\0\1\77\1\0\1\77"+
    "\2\0\1\77\1\0\1\77\30\0\1\77\36\0\1\u0155"+
    "\6\0\1\u0156\73\0\1\u0157\104\0\1\u0158\70\0\1\u0159"+
    "\101\0\1\u015a\116\0\1\u015b\61\0\1\u015c\3\0\1\u015d"+
    "\64\0\1\u015e\73\0\1\u015f\77\0\1\u0160\100\0\1\u0161"+
    "\71\0\1\u0162\100\0\1\u0163\6\0\1\u0164\33\0\1\u0165"+
    "\147\0\1\u0166\64\0\1\u0167\73\0\1\u0168\5\0\1\u0169"+
    "\34\0\1\u016a\132\0\1\u016b\75\0\1\u016c\47\0\1\u016d"+
    "\123\0\1\u016e\77\0\1\u016f\7\0\1\u0170\66\0\1\u0171"+
    "\76\0\1\u0172\75\0\1\u0173\104\0\1\u0174\114\0\1\u0175"+
    "\17\0\1\26\1\0\1\26\1\0\4\26\23\0\3\26"+
    "\1\u0176\15\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\u0177\1\0\4\26"+
    "\23\0\21\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\7\26\1\u0178\11\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\1\u0179\20\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\15\26\1\u017a\3\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\16\26\1\u017b"+
    "\2\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\5\26\1\u017c\13\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\1\u017d\3\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\17\26\1\u017e\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\u0129"+
    "\1\0\1\u0129\1\0\4\u0129\1\u017f\6\0\1\u0180\13\0"+
    "\21\u0129\1\0\1\u0129\1\0\1\u0129\1\0\4\u0129\10\0"+
    "\1\u0129\11\0\2\u012a\5\0\1\u012a\150\0\1\u0181\5\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\7\26\1\214"+
    "\11\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\1\26\1\u0182\17\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\5\26\1\u0183\13\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\21\26\1\0\1\26\1\0"+
    "\1\26\1\0\1\u0184\3\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\10\26\1\u0185\10\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\2\26"+
    "\1\u0186\16\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\10\26\1\u0187\10\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\6\26\1\u0188\12\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\2\26\1\u0189\16\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\u018a\1\0\4\26\23\0\21\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\6\26"+
    "\1\u018b\12\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\6\26\1\u018c\12\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\5\26\1\u018d\13\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\6\26\1\u018e\12\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\11\26"+
    "\1\u018f\7\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\14\26\1\u0190\4\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\12\26\1\u0191\6\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\3\26\1\u0192\15\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\2\26"+
    "\1\u0193\16\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\3\26\1\u0194\15\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\5\26\1\u0195\13\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\11\26\1\u0196\7\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\u0197\1\0\4\26\23\0\21\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\6\26"+
    "\1\u0198\12\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\3\26\1\u0199\15\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\46\0\1\u019a\33\0\1\u019b"+
    "\141\0\1\u019c\66\0\1\u019d\47\0\1\u019e\72\0\1\u019f"+
    "\6\0\1\u019c\46\0\1\u01a0\53\0\1\u01a1\43\0\1\u01a1"+
    "\134\0\1\u01a2\36\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\2\26\1\u01a3\16\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\242\1\0\1\242"+
    "\1\0\4\242\23\0\14\242\1\u01a4\4\242\1\0\1\242"+
    "\1\0\1\242\1\0\4\242\10\0\1\242\65\0\1\u01a5"+
    "\14\0\1\u01a6\137\0\1\u01a7\74\0\1\u01a8\106\0\1\u01a9"+
    "\27\0\1\u01aa\76\0\1\u01ab\140\0\1\u01ac\66\0\1\u01ad"+
    "\44\0\1\u01ae\127\0\1\u01af\76\0\1\u01b0\76\0\1\u01b1"+
    "\76\0\1\u01b2\100\0\1\u01b3\43\0\1\u01b4\143\0\1\u01b5"+
    "\110\0\1\u01b6\17\0\1\u01b7\146\0\1\u01b8\26\0\1\u01b9"+
    "\140\0\1\u01ba\73\0\1\u01bb\110\0\1\u01bc\76\0\1\u01bd"+
    "\60\0\1\u01be\113\0\1\u01bf\73\0\1\u01c0\35\0\1\u01c1"+
    "\141\0\1\u01c2\65\0\1\u01c3\36\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\4\26\1\u01c4\14\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\11\26\1\u01c5\7\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\1\26"+
    "\1\u01c6\17\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\5\26\1\u01c7\13\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\5\26\1\u01c8\13\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\7\26\1\u01c9\11\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\20\0\1\u0180\101\0\1\u01ca\54\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\3\26\1\u01cb\15\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\1\26\1\u01cc\17\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\12\26"+
    "\1\u01cd\6\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\1\26\1\u01ce\17\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\4\26\1\u01cf\14\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\11\26\1\u01d0\7\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\5\26"+
    "\1\u01d1\13\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\3\26\1\u01d2\15\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\6\26\1\u01d3\12\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\u01d4\1\0\4\26\23\0\21\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\11\26\1\u01d5\7\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\14\26"+
    "\1\u01d6\4\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\u01d7\1\0\4\26"+
    "\23\0\21\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\11\26\1\u01d8\7\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\16\26\1\u01d9\2\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\6\26\1\u01da\12\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\3\0\1\u01db\6\0\1\u019c\46\0\1\u01a0\62\0\1\u01a1"+
    "\43\0\1\u019c\46\0\1\u01a0\77\0\1\u019c\62\0\1\u01dc"+
    "\110\0\1\u01dd\60\0\1\u019c\73\0\1\u01de\40\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\12\26\1\u01df\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\54\0\1\u01e0\76\0\1\u01e1\57\0\1\u01e2\76\0\1\u01e3"+
    "\75\0\1\u01e4\112\0\1\u01e5\31\0\1\u01e6\130\0\1\u01e7"+
    "\76\0\1\u01e8\76\0\1\u01e9\112\0\1\u01ea\73\0\1\u01eb"+
    "\100\0\1\u01ec\63\0\1\u01ed\121\0\1\u01ee\55\0\1\u01ef"+
    "\42\0\1\u01f0\134\0\1\u01f1\73\0\1\u01f2\43\0\1\u01f3"+
    "\160\0\1\u01f4\47\0\1\u01f5\101\0\1\u01f6\73\0\1\u01f7"+
    "\74\0\1\u01f8\107\0\1\u01f9\32\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\14\26\1\u01fa\4\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\12\26\1\u01fb\6\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\u01fc\1\0\4\26\23\0\21\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\6\26"+
    "\1\u01fd\12\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\12\26\1\u01fe\6\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\u01ff"+
    "\1\0\4\26\23\0\21\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\6\26\1\u0200\12\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\u0201\1\0\4\26\23\0\21\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\u0202\1\0\4\26\23\0\21\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\16\26\1\u0203\2\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\1\u0204"+
    "\20\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\10\26\1\u0205\10\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\5\26\1\u0206\13\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\13\26\1\u0207\5\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\6\26\1\u0208"+
    "\12\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\14\26\1\u0209\4\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\13\26\1\u020a\5\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\36\0\1\u020b\43\0"+
    "\1\u019c\76\0\1\u020c\153\0\1\u019c\64\0\1\u020d\72\0"+
    "\1\u020e\73\0\1\u020f\75\0\1\u0210\75\0\1\u0211\111\0"+
    "\1\u0212\73\0\1\u0213\70\0\1\u0214\42\0\1\u0215\134\0"+
    "\1\u0216\105\0\1\u0217\62\0\1\u0218\103\0\1\u0219\71\0"+
    "\1\u021a\112\0\1\u021b\73\0\1\u021c\76\0\1\u021d\66\0"+
    "\1\u021e\121\0\1\u021f\52\0\1\u0220\110\0\1\u0221\70\0"+
    "\1\u0222\37\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\2\26\1\u0223\16\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\2\26\1\u0224\16\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\11\26\1\u0225\7\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\u0226\1\0\4\26\23\0\21\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\13\26\1\u0227"+
    "\5\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\13\26\1\u0228\5\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\3\26\1\u0229\15\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\u022a\1\0\4\26\23\0\21\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\1\u022b\20\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\13\26\1\u022c\5\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\5\26"+
    "\1\u022d\13\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\13\26\1\u022e\5\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\13\26\1\u022f\5\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\37\0\1\u019c"+
    "\74\0\1\u019c\44\0\1\u0230\134\0\1\u0231\102\0\1\u0232"+
    "\67\0\1\u0233\76\0\1\u0234\76\0\1\u0235\104\0\1\u0236"+
    "\112\0\1\u0237\53\0\1\u0238\44\0\1\u0239\151\0\1\u023a"+
    "\73\0\1\u023b\65\0\1\u023c\37\0\1\u023d\132\0\1\u023e"+
    "\40\0\1\26\1\0\1\26\1\0\4\26\23\0\1\26"+
    "\1\u023f\17\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\11\26\1\u0240\7\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\10\0\1\26\1\0\1\26\1\0\1\26"+
    "\1\0\4\26\23\0\16\26\1\u0241\2\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\10\0\1\26\1\0\1\26"+
    "\1\0\1\26\1\0\4\26\23\0\1\u0242\20\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\1\u0243\20\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\10\0\1\26"+
    "\1\0\1\26\1\0\1\26\1\0\4\26\23\0\3\26"+
    "\1\u0244\15\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\10\0\1\26\1\0\1\26\1\0\1\26\1\0\4\26"+
    "\23\0\1\u0245\20\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\13\26\1\u0246\5\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\34\0\1\u0247\104\0"+
    "\1\u0248\76\0\1\u0249\102\0\1\u024a\76\0\1\u024b\65\0"+
    "\1\u024c\113\0\1\u024d\106\0\1\u024e\52\0\1\u024f\76\0"+
    "\1\u0250\122\0\1\u0251\15\0\1\26\1\0\1\u0252\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\16\26\1\u0253\2\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\23\0\3\26\1\u0254\15\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\10\0\1\26\1\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\3\26\1\u0255"+
    "\15\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\3\26\1\u0256\15\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\37\0\1\u0257\42\0\1\u0258\140\0"+
    "\1\u0259\73\0\1\u025a\71\0\1\u025b\121\0\1\u025c\17\0"+
    "\1\26\1\0\1\26\1\0\4\26\23\0\11\26\1\u025d"+
    "\7\26\1\0\1\26\1\0\1\26\1\0\4\26\10\0"+
    "\1\26\1\0\1\26\1\0\1\26\1\0\4\26\23\0"+
    "\11\26\1\u025e\7\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\13\26\1\u025f\5\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26\40\0\1\u0260\41\0"+
    "\1\u0261\76\0\1\u0262\74\0\1\26\1\0\1\u0263\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\u0264\1\0"+
    "\4\26\23\0\21\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\10\0\1\26\1\0\1\26\1\0\1\26\1\0"+
    "\4\26\23\0\13\26\1\u0265\5\26\1\0\1\26\1\0"+
    "\1\26\1\0\4\26\10\0\1\26";

  private static int [] zzUnpackTrans() {
    int [] result = new int[30933];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\14\0\1\11\11\1\3\11\36\1\1\11\1\1"+
    "\1\11\2\1\2\11\6\1\1\11\5\1\1\11\6\1"+
    "\1\11\3\1\1\11\4\1\2\11\2\1\1\11\3\1"+
    "\1\11\6\1\1\11\1\0\2\1\2\0\44\1\1\11"+
    "\1\1\12\0\4\1\3\0\2\11\1\1\1\11\2\1"+
    "\1\0\1\11\1\1\1\0\3\11\20\0\1\11\13\1"+
    "\2\0\40\1\11\0\5\1\34\0\14\1\1\0\1\1"+
    "\1\0\36\1\11\0\2\1\25\0\1\11\7\0\1\11"+
    "\3\0\12\1\1\11\1\0\30\1\6\0\1\11\2\0"+
    "\2\1\6\0\2\11\3\0\1\11\4\0\1\11\2\0"+
    "\1\11\13\0\6\1\1\0\20\1\4\0\1\1\13\0"+
    "\1\11\4\0\1\11\3\0\1\11\4\0\1\11\21\1"+
    "\4\0\1\11\1\0\2\11\2\0\1\11\1\0\1\11"+
    "\4\0\1\1\4\0\2\11\15\1\1\11\10\0\1\11"+
    "\3\0\2\11\10\1\1\0\1\11\1\0\2\11\2\0"+
    "\1\11\2\0\1\11\5\1\1\11\2\0\2\11\1\0"+
    "\3\1\3\11\3\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[613];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    public PhpLexer(int state){
        initialize(state);
    }
    public void reset(char array[], int offset, int length) {
        this.zzBuffer = array;
        this.zzCurrentPos = offset;
        this.zzMarkedPos = offset;
        this.zzPushbackPos = offset;
        this.yychar = offset;
        this.zzEndRead = offset + length;
        this.zzStartRead = offset;
        this.zzAtEOF = zzCurrentPos >= zzEndRead;
        this.firstPos = offset;
    }

    public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzMarkedPos = parameters[0];
    	this.zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];
    	initialize(parameters[6]);
    }

    protected boolean isHeredocState(int state){
    	return state == ST_PHP_HEREDOC;
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected int getZZMarkedPos() {
        return zzMarkedPos;
    }

    protected int getZZEndRead() {
        return zzEndRead;
    }

    public char[] getZZBuffer() {
        return zzBuffer;
    }

    protected int getZZStartRead() {
    	return this.zzStartRead;
    }

    protected int getZZPushBackPosition() {
    	return this.zzPushbackPos;
    }

	protected void pushBack(int i) {
		yypushback(i);
	}

	public int getScriptingState() {
	   return ST_PHP_IN_SCRIPTING;
	}

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final IntHashtable lexerStates = new IntHashtable(100);

	protected IntHashtable getLexerStates() {
		return lexerStates;
	}

 // End user code



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PhpLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 192) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 121: 
          { return PHPDOC_CATEGORY;
          }
        case 134: break;
        case 45: 
          { return PHP_NEW;
          }
        case 135: break;
        case 77: 
          { return PHPDOC_DESC;
          }
        case 136: break;
        case 22: 
          { return PHP_LINE_COMMENT;
          }
        case 137: break;
        case 79: 
          { return PHPDOC_USES;
          }
        case 138: break;
        case 4: 
          { return  PHP_STRING;
          }
        case 139: break;
        case 69: 
          { return PHP_UNSET;
          }
        case 140: break;
        case 34: 
          { return PHP_CLOSETAG;
          }
        case 141: break;
        case 125: 
          { return PHPDOC_EXCEPTION;
          }
        case 142: break;
        case 105: 
          { return PHPDOC_METHOD;
          }
        case 143: break;
        case 101: 
          { return PHPDOC_IGNORE;
          }
        case 144: break;
        case 10: 
          { pushState(ST_PHP_LINE_COMMENT);
    return PHP_LINE_COMMENT;
          }
        case 145: break;
        case 131: 
          { return PHP_REQUIRE_ONCE;
          }
        case 146: break;
        case 104: 
          { return PHPDOC_GLOBAL;
          }
        case 147: break;
        case 112: 
          { return PHPDOC_LICENSE;
          }
        case 148: break;
        case 122: 
          { return PHPDOC_PROPERTY;
          }
        case 149: break;
        case 51: 
          { return PHP_ECHO;
          }
        case 150: break;
        case 102: 
          { return PHPDOC_THROWS;
          }
        case 151: break;
        case 18: 
          { popState();
    return PHP_STRING;
          }
        case 152: break;
        case 13: 
          { return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 153: break;
        case 117: 
          { return PHP__CLASS__;
          }
        case 154: break;
        case 91: 
          { return PHPDOC_MAGIC;
          }
        case 155: break;
        case 49: 
          { return PHP_VAR;
          }
        case 156: break;
        case 21: 
          { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			popState();
	}
	return PHP_LINE_COMMENT;
          }
        case 157: break;
        case 123: 
          { return PHP_ENDDECLARE;
          }
        case 158: break;
        case 93: 
          { return PHP_REQUIRE;
          }
        case 159: break;
        case 6: 
          { return PHP_SEMICOLON;
          }
        case 160: break;
        case 67: 
          { return PHP_ISSET;
          }
        case 161: break;
        case 36: 
          { if (yylength() == 2) {
        yypushback(1);
    }
    return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 162: break;
        case 41: 
          { popState();
    return PHP_COMMENT_END;
          }
        case 163: break;
        case 74: 
          { return PHP_CASTING;
          }
        case 164: break;
        case 1: 
          { yypushback(1);
    pushState(ST_PHP_HIGHLIGHTING_ERROR);
          }
        case 165: break;
        case 7: 
          { if (!phpStack.isEmpty()) {
        popState();
    }
	return  PHP_CURLY_CLOSE;
          }
        case 166: break;
        case 120: 
          { return PHPDOC_TUTORIAL;
          }
        case 167: break;
        case 82: 
          { return PHP_ELSEIF;
          }
        case 168: break;
        case 84: 
          { return PHP_STATIC;
          }
        case 169: break;
        case 127: 
          { return PHPDOC_STATICVAR;
          }
        case 170: break;
        case 110: 
          { return PHP__LINE__;
          }
        case 171: break;
        case 62: 
          { return PHP_ENDIF;
          }
        case 172: break;
        case 113: 
          { return PHPDOC_PACKAGE;
          }
        case 173: break;
        case 81: 
          { return PHP_ENDFOR;
          }
        case 174: break;
        case 42: 
          { popState();
    return PHPDOC_COMMENT_END;
          }
        case 175: break;
        case 47: 
          { return PHP_FOR;
          }
        case 176: break;
        case 129: 
          { return PHPDOC_FILESOURCE;
          }
        case 177: break;
        case 53: 
          { return PHP_EVAL;
          }
        case 178: break;
        case 43: 
          { popState();
    return PHP_LINE_COMMENT;
          }
        case 179: break;
        case 24: 
          { popState();return WHITESPACE;
          }
        case 180: break;
        case 8: 
          { pushState(ST_PHP_SINGLE_QUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 181: break;
        case 63: 
          { return PHP_EMPTY;
          }
        case 182: break;
        case 2: 
          { return PHP_NUMBER;
          }
        case 183: break;
        case 30: 
          { return PHP_DO;
          }
        case 184: break;
        case 86: 
          { return PHP_PARENT;
          }
        case 185: break;
        case 20: 
          { return PHPDOC_COMMENT;
          }
        case 186: break;
        case 132: 
          { return PHP_INCLUDE_ONCE;
          }
        case 187: break;
        case 37: 
          { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
    return PHP_VARIABLE;
          }
        case 188: break;
        case 57: 
          { return PHP_FROM;
          }
        case 189: break;
        case 66: 
          { return PHP_ARRAY;
          }
        case 190: break;
        case 99: 
          { return PHPDOC_AUTHOR;
          }
        case 191: break;
        case 72: 
          { return PHP_WHILE;
          }
        case 192: break;
        case 92: 
          { return PHP_EXTENDS;
          }
        case 193: break;
        case 100: 
          { return PHPDOC_ACCESS;
          }
        case 194: break;
        case 70: 
          { return PHP_CONST;
          }
        case 195: break;
        case 3: 
          { return PHP_TOKEN;
          }
        case 196: break;
        case 119: 
          { return PHPDOC_INTERNAL;
          }
        case 197: break;
        case 80: 
          { return PHPDOC_LINK;
          }
        case 198: break;
        case 5: 
          { return  WHITESPACE;
          }
        case 199: break;
        case 16: 
          { return PHP_ENCAPSED_AND_WHITESPACE;
          }
        case 200: break;
        case 40: 
          { int label_len;
    int length=yylength();
    if (yytext().charAt(length-2)=='\r') {
        label_len = length-2;
    } else {
        label_len = length-1;
    }

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==heredoc_len && yytext().substring(0,label_len).equals(heredoc)) {
        heredoc=null;
        heredoc_len=0;
        popState();
        return  PHP_HEREDOC_TAG;
    } else {
        return  PHP_CONSTANT_ENCAPSED_STRING;
    }
          }
        case 201: break;
        case 103: 
          { return PHPDOC_STATIC;
          }
        case 202: break;
        case 64: 
          { return PHP_BREAK;
          }
        case 203: break;
        case 88: 
          { return PHPDOC_FINAL;
          }
        case 204: break;
        case 15: 
          { yypushback(1);
        popState();
          }
        case 205: break;
        case 83: 
          { return PHP_RETURN;
          }
        case 206: break;
        case 107: 
          { return PHP_FUNCTION;
          }
        case 207: break;
        case 90: 
          { return PHPDOC_PARAM;
          }
        case 208: break;
        case 106: 
          { return PHP_ENDWHILE;
          }
        case 209: break;
        case 32: 
          { return PHP_PAAMAYIM_NEKUDOTAYIM;
          }
        case 210: break;
        case 46: 
          { return PHP_DIE;
          }
        case 211: break;
        case 108: 
          { return PHP_CONTINUE;
          }
        case 212: break;
        case 65: 
          { int startString=3;
    heredoc_len = yylength()-3-1-(yytext().charAt(yylength()-2)=='\r'?1:0);
    while ((yytext().charAt(startString) == ' ') || (yytext().charAt(startString) == '\t')) {
        startString++;
        heredoc_len--;
    }
    heredoc = yytext().substring(startString,heredoc_len+startString);
    pushState(ST_PHP_HEREDOC);
    return PHP_HEREDOC_TAG;
          }
        case 213: break;
        case 116: 
          { /* guy - support old versions */
    return PHP_FUNCTION;
          }
        case 214: break;
        case 96: 
          { return PHP_INCLUDE;
          }
        case 215: break;
        case 27: 
          { pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
          }
        case 216: break;
        case 23: 
          { return UNKNOWN_TOKEN;
          }
        case 217: break;
        case 85: 
          { return PHP_SWITCH;
          }
        case 218: break;
        case 52: 
          { return PHP_ELSE;
          }
        case 219: break;
        case 28: 
          { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
          }
        case 220: break;
        case 89: 
          { return PHPDOC_SINCE;
          }
        case 221: break;
        case 111: 
          { return PHPDOC_EXAMPLE;
          }
        case 222: break;
        case 114: 
          { return PHPDOC_VERSION;
          }
        case 223: break;
        case 11: 
          { pushState(ST_PHP_DOUBLE_QUOTES);
    return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 224: break;
        case 133: 
          { return PHP__FUNCTION__;
          }
        case 225: break;
        case 97: 
          { return PHP_FOREACH;
          }
        case 226: break;
        case 25: 
          { return PHP_OPERATOR;
          }
        case 227: break;
        case 48: 
          { return PHP_USE;
          }
        case 228: break;
        case 31: 
          { return PHP_IF;
          }
        case 229: break;
        case 14: 
          { popState();
    return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 230: break;
        case 58: 
          { return PHP_CASE;
          }
        case 231: break;
        case 94: 
          { return PHP_DEFAULT;
          }
        case 232: break;
        case 54: 
          { pushState(ST_PHP_DOC_COMMENT);
    return PHPDOC_COMMENT_START;
          }
        case 233: break;
        case 75: 
          { return PHP_THIS;
          }
        case 234: break;
        case 55: 
          { return  PHP_KEYWORD;
          }
        case 235: break;
        case 109: 
          { return PHP__FILE__;
          }
        case 236: break;
        case 98: 
          { return PHPDOC_RETURN;
          }
        case 237: break;
        case 78: 
          { return PHPDOC_TODO;
          }
        case 238: break;
        case 59: 
          { return PHP_LIST;
          }
        case 239: break;
        case 115: 
          { return PHP_ENDSWITCH;
          }
        case 240: break;
        case 50: 
          { return PHP_EXIT;
          }
        case 241: break;
        case 29: 
          { return PHP_AS;
          }
        case 242: break;
        case 38: 
          { pushState(ST_PHP_IN_SCRIPTING);
    return PHP_TOKEN;
          }
        case 243: break;
        case 71: 
          { return PHP_CLASS;
          }
        case 244: break;
        case 12: 
          { pushState(ST_PHP_BACKQUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
          }
        case 245: break;
        case 17: 
          { yypushback(1);
    popState();
          }
        case 246: break;
        case 26: 
          { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OPERATOR;
          }
        case 247: break;
        case 19: 
          { return PHP_COMMENT;
          }
        case 248: break;
        case 130: 
          { return PHPDOC_SUBPACKAGE;
          }
        case 249: break;
        case 39: 
          { popState();
    pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OPERATOR;
          }
        case 250: break;
        case 9: 
          { return PHP_CURLY_OPEN;
          }
        case 251: break;
        case 60: 
          { return PHPDOC_SEE;
          }
        case 252: break;
        case 33: 
          { return PHP_VARIABLE;
          }
        case 253: break;
        case 118: 
          { return PHPDOC_ABSTRACT;
          }
        case 254: break;
        case 56: 
          { return PHP_TRUE;
          }
        case 255: break;
        case 76: 
          { return PHPDOC_NAME;
          }
        case 256: break;
        case 95: 
          { return PHP_DECLARE;
          }
        case 257: break;
        case 126: 
          { return PHPDOC_COPYRIGHT;
          }
        case 258: break;
        case 35: 
          { yypushback(1);
    pushState(ST_PHP_IN_SCRIPTING);
    return PHP_CURLY_OPEN;
          }
        case 259: break;
        case 128: 
          { return PHPDOC_DEPRECATED;
          }
        case 260: break;
        case 68: 
          { return PHP_FALSE;
          }
        case 261: break;
        case 87: 
          { return PHP_GLOBAL;
          }
        case 262: break;
        case 73: 
          { return PHP_PRINT;
          }
        case 263: break;
        case 44: 
          { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	String text = yytext();
	if(text.indexOf('\r') != -1 || text.indexOf('\n') != -1 ){
		popState();
	}
	return PHP_LINE_COMMENT;
          }
        case 264: break;
        case 124: 
          { return PHP_ENDFOREACH;
          }
        case 265: break;
        case 61: 
          { return PHPDOC_VAR;
          }
        case 266: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
