/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.errors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;

public class PHP5ErrorReportingTests
extends AbstractPDTTTest {
    protected static final String[] TEST_DIRS = new String[]{"/workspace/errors/php5"};
    protected static Map<PdttFile, IFile> filesMap = new LinkedHashMap<PdttFile, IFile>();
    protected static IProject project;
    protected static int count;

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("ErrorReportingTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        for (PdttFile pdttFile : filesMap.keySet()) {
            IFile file = PHP5ErrorReportingTests.createFile(pdttFile.getFile().trim());
            filesMap.put(pdttFile, file);
        }
        PHPCoreTests.setProjectPhpVersion(project, PHPVersion.PHP5);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public PHP5ErrorReportingTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("php5");
        String[] stringArray = TEST_DIRS;
        int n = TEST_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            String[] stringArray2 = PHP5ErrorReportingTests.getPDTTFiles(testsDirectory);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(fileName);
                    filesMap.put(pdttFile, null);
                    suite.addTest((Test)new PHP5ErrorReportingTests("/" + fileName){

                        protected void runTest() throws Throwable {
                            IMarker[] markers;
                            IFile file = (IFile)filesMap.get(pdttFile);
                            StringBuilder buf = new StringBuilder();
                            IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.dltk.core.problem", true, 0);
                            int n = markers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMarker marker = iMarkerArray[n2];
                                buf.append("\n[line=");
                                buf.append(marker.getAttribute("lineNumber"));
                                buf.append(", start=");
                                buf.append(marker.getAttribute("charStart"));
                                buf.append(", end=");
                                buf.append(marker.getAttribute("charEnd"));
                                buf.append("] ");
                                buf.append(marker.getAttribute("message")).append('\n');
                                ++n2;
                            }
                            this.assertContents(pdttFile.getExpected(), buf.toString());
                        }
                    });
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                PHP5ErrorReportingTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                PHP5ErrorReportingTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static IFile createFile(String data) throws Exception {
        IFile testFile = project.getFile("test" + ++count + ".php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }
}

