/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class ParenthesesCloseIndentationStrategy
implements IIndentationStrategy {
    @Override
    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        IRegion parenOpenLine = this.getParenOpenLineInformation(document, forOffset);
        if (parenOpenLine == null) {
            return;
        }
        int indentationBaseLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, document.getLineOfOffset(parenOpenLine.getOffset()), forOffset, true);
        IRegion indentationBaseLine = document.getLineInformation(indentationBaseLineIndex);
        String blanks = "";
        blanks = indentationBaseLine != null ? FormatterUtils.getLineBlanks((IDocument)document, indentationBaseLine) : FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(forOffset));
        result.append(blanks);
    }

    protected IRegion getParenOpenLineInformation(IStructuredDocument document, int forOffset) throws BadLocationException {
        int offset = forOffset;
        int parenCount = 0;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return null;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        block0: do {
            if (!(tRegion instanceof IPhpScriptRegion)) continue;
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            tRegion = scriptRegion.getPhpToken(offset - regionStart - 1);
            while (tRegion != null) {
                String token = tRegion.getType();
                if (token == "PHP_ARRAY" && --parenCount < 0) {
                    return document.getLineInformationOfOffset(tRegion.getStart() + regionStart);
                }
                if (tRegion.getStart() <= 0) continue block0;
                tRegion = scriptRegion.getPhpToken(tRegion.getStart() - 1);
            }
        } while ((tRegion = null) != null);
        return null;
    }
}

