/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class PerFileModelAccessCache
implements IModelAccessCache {
    private ISourceModule sourceModule;
    private Map<IType, ITypeHierarchy> hierarchyCache = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<IMethod>> globalFunctionsCache;
    private Map<String, Collection<IType>> allTypesCache;
    private Map<String, Collection<IType>> allTraitsCache;
    private ReferenceTree fileHierarchy;

    public PerFileModelAccessCache(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
        this.allTraitsCache = Collections.synchronizedMap(new HashMap());
        this.allTypesCache = Collections.synchronizedMap(new HashMap());
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public ITypeHierarchy getSuperTypeHierarchy(IType type, IProgressMonitor monitor) throws ModelException {
        ITypeHierarchy hierarchy = this.hierarchyCache.get(type);
        if (hierarchy == null) {
            hierarchy = type.newSupertypeHierarchy(monitor);
            this.hierarchyCache.put(type, hierarchy);
        }
        return hierarchy;
    }

    @Override
    public ReferenceTree getFileHierarchy(ISourceModule sourceModule, IProgressMonitor monitor) {
        if (!this.sourceModule.equals(sourceModule)) {
            return FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
        }
        if (this.fileHierarchy == null) {
            this.fileHierarchy = FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
        }
        return this.fileHierarchy;
    }

    private <T extends IModelElement> Collection<T> filterElements(ISourceModule sourceModule, Collection<T> elements, IProgressMonitor monitor) {
        if (elements == null) {
            return null;
        }
        if (elements.size() == 1) {
            return elements;
        }
        LinkedList<IModelElement> filteredElements = new LinkedList<IModelElement>();
        for (IModelElement element : elements) {
            if (!sourceModule.equals(element.getOpenable())) continue;
            filteredElements.add(element);
        }
        if (filteredElements.size() > 0) {
            return filteredElements;
        }
        return PHPModelUtils.fileNetworkFilter(sourceModule, elements, this, monitor);
    }

    @Override
    public Collection<IMethod> getGlobalFunctions(ISourceModule sourceModule, String functionName, IProgressMonitor monitor) {
        Collection<IMethod> functions;
        if (functionName == null) {
            return new ArrayList<IMethod>();
        }
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            functions = Arrays.asList(PhpModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, monitor));
        } else {
            functionName = functionName.toLowerCase();
            if (this.globalFunctionsCache == null) {
                IMethod[] allFunctions;
                this.globalFunctionsCache = Collections.synchronizedMap(new HashMap());
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                IMethod[] iMethodArray = allFunctions = PhpModelAccess.getDefault().findMethods(null, ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, monitor);
                int n = allFunctions.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod function = iMethodArray[n2];
                    String elementName = function.getElementName().toLowerCase();
                    Collection<IMethod> funcList = this.globalFunctionsCache.get(elementName);
                    if (funcList == null) {
                        funcList = new LinkedList<IMethod>();
                        this.globalFunctionsCache.put(elementName, funcList);
                    }
                    funcList.add(function);
                    ++n2;
                }
            }
            functions = this.globalFunctionsCache.get(functionName);
        }
        return this.filterElements(sourceModule, functions, monitor);
    }

    @Override
    public Collection<IType> getTypes(ISourceModule sourceModule, String typeName, String namespaceName, IProgressMonitor monitor) {
        Collection<IType> types;
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            types = Arrays.asList(PhpModelAccess.getDefault().findTypes(namespaceName, typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null));
        } else {
            typeName = typeName.toLowerCase();
            StringBuffer key = new StringBuffer();
            if (namespaceName != null && !"".equals(namespaceName.trim())) {
                String nameSpace = namespaceName;
                if (namespaceName.startsWith("\\") || namespaceName.startsWith("/")) {
                    nameSpace = namespaceName.substring(1);
                }
                if (nameSpace.length() > 0) {
                    key.append(nameSpace.toLowerCase()).append("$");
                }
            }
            key.append(typeName);
            String searchFor = key.toString();
            if (!this.allTypesCache.containsKey(searchFor)) {
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                this.allTypesCache.put(searchFor, Arrays.asList(PhpModelAccess.getDefault().findTypes(namespaceName, typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null)));
            }
            types = this.allTypesCache.get(searchFor);
        }
        return this.filterElements(sourceModule, types, monitor);
    }

    @Override
    public Collection<IType> getTraits(ISourceModule sourceModule, String typeName, String namespaceName, IProgressMonitor monitor) {
        Collection<IType> types;
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            types = Arrays.asList(PhpModelAccess.getDefault().findTraits(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null));
        } else {
            typeName = typeName.toLowerCase();
            StringBuffer key = new StringBuffer();
            if (namespaceName != null && !"".equals(namespaceName.trim())) {
                String nameSpace = namespaceName;
                if (namespaceName.startsWith("\\") || namespaceName.startsWith("/")) {
                    nameSpace = namespaceName.substring(1);
                }
                if (nameSpace.length() > 0) {
                    key.append(nameSpace.toLowerCase()).append("$");
                }
            }
            key.append(typeName);
            String searchFor = key.toString();
            if (!this.allTraitsCache.containsKey(searchFor)) {
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                this.allTraitsCache.put(searchFor, Arrays.asList(PhpModelAccess.getDefault().findTraits(namespaceName, typeName, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null)));
            }
            types = this.allTraitsCache.get(searchFor);
        }
        return this.filterElements(sourceModule, types, monitor);
    }

    @Override
    public Collection<IType> getClasses(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, namespaceName, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (!PHPFlags.isClass(type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Collection<IType> getInterfaces(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, namespaceName, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (!PHPFlags.isInterface((int)type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Collection<IType> getClassesOrInterfaces(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, namespaceName, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (PHPFlags.isNamespace(type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Collection<IType> getNamespaces(ISourceModule sourceModule, String name, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, null, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (!PHPFlags.isNamespace(type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }
}

