/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.debug.core.debugger.parameters.IWebDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.IDebuggerInitializer;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class PHPWebServerDebuggerInitializer
implements IDebuggerInitializer {
    private static final String URL_ENCODING = "UTF-8";

    @Override
    public void debug(ILaunch launch) throws DebugException {
        DaemonPlugin.getDefault().makeSureDebuggerInitialized(null);
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        if (launch instanceof PHPLaunch) {
            ((PHPLaunch)launch).pretendRunning(true);
        }
        boolean openInBrowser = false;
        try {
            openInBrowser = launch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.OpenInBrowser", false);
        }
        catch (CoreException coreException) {}
        if (openInBrowser) {
            this.openBrowser(launch, parametersInitializer);
        } else {
            this.openUrlConnection(launch, parametersInitializer);
        }
        if (launch instanceof PHPLaunch) {
            ((PHPLaunch)launch).pretendRunning(false);
        }
    }

    protected void openBrowser(ILaunch launch, IDebugParametersInitializer parametersInitializer) throws DebugException {
        boolean runWithDebug = true;
        try {
            runWithDebug = launch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        }
        catch (CoreException coreException) {}
        URL requestURL = parametersInitializer.getRequestURL(launch);
        if (runWithDebug && !"run".equals(launch.getLaunchMode())) {
            try {
                String query = PHPLaunchUtilities.generateQuery(launch, parametersInitializer);
                String url = requestURL.toString();
                url = url.indexOf(63) == -1 ? String.valueOf(url) + '?' + query : String.valueOf(url) + '&' + query;
                requestURL = new URL(url);
            }
            catch (MalformedURLException e) {
                Logger.logException(e);
                String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e));
            }
        }
        final DebugException[] exception = new DebugException[1];
        final URL debugURL = requestURL;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int browserStyle = 14;
                    StringBuilder browserTitle = new StringBuilder(debugURL.getProtocol()).append("://").append(debugURL.getHost());
                    if (debugURL.getPort() != -1) {
                        browserTitle.append(':').append(debugURL.getPort());
                    }
                    browserTitle.append(debugURL.getPath());
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(browserStyle, "PDTDebuggerBrowser", browserTitle.toString(), browserTitle.toString());
                    if (PHPDebugPlugin.DEBUG) {
                        System.out.println("Opening URL in a browser: " + debugURL.toString());
                    }
                    browser.openURL(debugURL);
                }
                catch (Throwable t) {
                    Logger.logException("Error initializing the web browser.", t);
                    String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                    exception[0] = new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, t));
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    protected void openUrlConnection(ILaunch launch, IDebugParametersInitializer parametersInitializer) throws DebugException {
        block27: {
            URL requestURL = parametersInitializer.getRequestURL(launch);
            try {
                Hashtable<String, String> cookies;
                Hashtable<String, String> headers;
                Hashtable<String, String> requestParameters;
                String requestMethod;
                if (!(parametersInitializer instanceof IWebDebugParametersInitializer)) break block27;
                IWebDebugParametersInitializer webParametersInitializer = (IWebDebugParametersInitializer)parametersInitializer;
                StringBuilder getParams = new StringBuilder("?");
                Hashtable<String, String> debugParameters = parametersInitializer.getDebugParameters(launch);
                if (debugParameters != null) {
                    Enumeration<String> k = debugParameters.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = debugParameters.get(key);
                        getParams.append(URLEncoder.encode(key, URL_ENCODING)).append('=').append(URLEncoder.encode(value, URL_ENCODING));
                        if (!k.hasMoreElements()) continue;
                        getParams.append('&');
                    }
                }
                if ("GET".equals(requestMethod = webParametersInitializer.getRequestMethod(launch)) && (requestParameters = webParametersInitializer.getRequestParameters(launch)) != null) {
                    Enumeration<String> k = requestParameters.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = requestParameters.get(key);
                        getParams.append('&');
                        getParams.append(URLEncoder.encode(key, URL_ENCODING)).append('=').append(URLEncoder.encode(value, URL_ENCODING));
                    }
                }
                requestURL = new URL(requestURL.getProtocol(), requestURL.getHost(), requestURL.getPort(), String.valueOf(requestURL.getPath()) + getParams.toString());
                if (PHPDebugPlugin.DEBUG) {
                    System.out.println("Opening URL connection: " + requestURL.toString());
                }
                HttpURLConnection urlConection = (HttpURLConnection)requestURL.openConnection();
                urlConection.setDoInput(true);
                urlConection.setDoOutput(true);
                if (requestMethod != null) {
                    urlConection.setRequestMethod(requestMethod);
                }
                if ((headers = webParametersInitializer.getRequestHeaders(launch)) != null) {
                    Enumeration<String> k = headers.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = URLEncoder.encode(headers.get(key), URL_ENCODING);
                        if (PHPDebugPlugin.DEBUG) {
                            System.out.println("Adding HTTP header: " + key + "=" + value);
                        }
                        urlConection.addRequestProperty(key, value);
                    }
                }
                if ((cookies = webParametersInitializer.getRequestCookies(launch)) != null) {
                    StringBuilder cookieBuf = new StringBuilder();
                    Enumeration<String> k = cookies.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = cookies.get(key);
                        cookieBuf.append(URLEncoder.encode(key, URL_ENCODING)).append('=').append(URLEncoder.encode(value, URL_ENCODING));
                        if (!k.hasMoreElements()) continue;
                        cookieBuf.append("; ");
                    }
                    if (PHPDebugPlugin.DEBUG) {
                        System.out.println("Setting cookies: " + cookieBuf.toString());
                    }
                    urlConection.addRequestProperty("Cookie", cookieBuf.toString());
                }
                DataOutputStream outputStream = new DataOutputStream(urlConection.getOutputStream());
                try {
                    String rawData;
                    Hashtable<String, String> requestParameters2;
                    if (requestMethod == "POST" && (requestParameters2 = webParametersInitializer.getRequestParameters(launch)) != null) {
                        StringBuilder postParams = new StringBuilder();
                        Enumeration<String> k = requestParameters2.keys();
                        while (k.hasMoreElements()) {
                            String key = k.nextElement();
                            String value = requestParameters2.get(key);
                            postParams.append(URLEncoder.encode(key, URL_ENCODING)).append('=').append(URLEncoder.encode(value, URL_ENCODING));
                            if (!k.hasMoreElements()) continue;
                            postParams.append('&');
                        }
                        outputStream.writeBytes(postParams.toString());
                    }
                    if ((rawData = webParametersInitializer.getRequestRawData(launch)) != null) {
                        outputStream.writeBytes(rawData);
                    }
                }
                finally {
                    outputStream.flush();
                    outputStream.close();
                }
                String headerKey = urlConection.getHeaderFieldKey(1);
                if (headerKey == null) {
                    Logger.log(2, "No HeaderKey returned by server. Most likely not started");
                    String errorMessage = PHPDebugCoreMessages.DebuggerConnection_Problem_1;
                    throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null));
                }
                int i = 1;
                while ((headerKey = urlConection.getHeaderFieldKey(i)) != null) {
                    if (headerKey.equals("X-Zend-Debug-Server")) {
                        String headerValue = urlConection.getHeaderField(headerKey);
                        if (headerValue.equals("OK")) break;
                        Logger.log(2, "Unexpected Header Value returned by Server. " + headerValue);
                        String errorMessage = String.valueOf(PHPDebugCoreMessages.DebuggerConnection_Problem_2) + " - " + headerValue;
                        throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null));
                    }
                    ++i;
                }
                InputStream inputStream = urlConection.getInputStream();
                while (inputStream.read() != -1) {
                }
                inputStream.close();
            }
            catch (UnknownHostException e) {
                Logger.logException("Unknown host: " + requestURL.getHost(), e);
            }
            catch (ConnectException e) {
                Logger.logException("Unable to connect to URL " + requestURL, e);
            }
            catch (IOException e) {
                Logger.logException("Unable to connect to URL " + requestURL, e);
            }
            catch (Exception e) {
                Logger.logException("Unexpected exception communicating with Web server", e);
                String errorMessage = e.getMessage();
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e));
            }
        }
    }
}

