/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.CommentHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.handlers.AddBlockCommentHandler;
import org.eclipse.wst.sse.ui.internal.handlers.ToggleLineCommentHandler;

public class ToggleCommentHandler
extends CommentHandler
implements IHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset();
                IStructuredDocument sDoc = (IStructuredDocument)document;
                if (this.isMoreThanOneContextBlockSelected((IDocument)sDoc, textSelection)) {
                    AddBlockCommentHandler addBlockCommentHandlerWST = new AddBlockCommentHandler();
                    return addBlockCommentHandlerWST.execute(event);
                }
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                boolean isJavaScriptRegion = false;
                if (textRegion instanceof ForeignRegion) {
                    boolean bl = isJavaScriptRegion = textRegion.getType() == "BLOCK_TEXT";
                }
                if (textRegion == null || textRegion.getType() == "PHP_CONTENT" || isJavaScriptRegion) {
                    this.processAction(textEditor, document, textSelection);
                } else {
                    ToggleLineCommentHandler toggleCommentHandlerWST = new ToggleLineCommentHandler();
                    return toggleCommentHandlerWST.execute(event);
                }
            }
        }
        return null;
    }

    @Override
    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        int selectionStartLine = textSelection.getStartLine();
        int selectionEndLine = textSelection.getEndLine();
        try {
            int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
            int selectionEndOffset = textSelection.getOffset() + textSelection.getLength();
            if (selectionEndLine > selectionStartLine && selectionEndLineOffset == selectionEndOffset) {
                --selectionEndLine;
            }
        }
        catch (BadLocationException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        Position selectionPosition = null;
        LinePosition start = null;
        LinePosition end = null;
        boolean updateStartOffset = false;
        try {
            start = this.getLinePosition(document, textSelection.getOffset());
            end = this.getLinePosition(document, textSelection.getOffset() + textSelection.getLength());
            selectionPosition = new Position(textSelection.getOffset(), textSelection.getLength());
            document.addPosition(selectionPosition);
            int selectionStartLineOffset = document.getLineOffset(selectionStartLine);
            if (textSelection.getLength() > 0 && selectionStartLineOffset == textSelection.getOffset() && !this.isCommentLine(document, selectionStartLine)) {
                updateStartOffset = true;
            }
        }
        catch (BadLocationException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        this.processAction(document, selectionStartLine, selectionEndLine);
        this.updateCurrentSelection(textEditor, selectionPosition, start, end, document, updateStartOffset);
    }

    private LinePosition getLinePosition(IDocument document, int offset) throws BadLocationException {
        int line;
        LinePosition result = new LinePosition();
        result.line = line = document.getLineOfOffset(offset);
        result.offset = offset - document.getLineOffset(line);
        return result;
    }

    private int getOffset(IDocument document, LinePosition position) throws BadLocationException {
        int lineLength = document.getLineLength(position.line);
        int result = position.offset <= lineLength ? position.offset + document.getLineOffset(position.line) : lineLength + document.getLineOffset(position.line);
        return result;
    }

    private void processAction(IDocument document, int selectionStartLine, int selectionEndLine) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                model.beginRecording((Object)this, PHPUIMessages.ToggleComment_tooltip);
                model.aboutToChangeModel();
                boolean allLinesCommented = true;
                int i = selectionStartLine;
                while (i <= selectionEndLine) {
                    try {
                        if (document.getLineLength(i) > 0 && !this.isCommentLine(document, i)) {
                            allLinesCommented = false;
                            break;
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                    }
                    ++i;
                }
                if (allLinesCommented) {
                    this.uncommentMultiLine(document, selectionStartLine, selectionEndLine);
                } else {
                    this.commentMultiLine(document, selectionStartLine, selectionEndLine);
                }
            }
            finally {
                model.changedModel();
                model.endRecording((Object)this);
                model.releaseFromEdit();
            }
        }
    }

    private void updateCurrentSelection(ITextEditor textEditor, Position selectionPosition, LinePosition start, LinePosition end, IDocument document, boolean updateStartOffset) {
        if (start != null && end != null) {
            TextSelection selection = null;
            try {
                int offset = this.getOffset(document, start);
                selection = new TextSelection(document, offset, this.getOffset(document, end) - offset);
            }
            catch (BadLocationException e) {
                PHPUiPlugin.log(e);
            }
            ISelectionProvider provider = textEditor.getSelectionProvider();
            if (provider != null && selection != null) {
                provider.setSelection(selection);
            }
            document.removePosition(selectionPosition);
        }
    }

    static class LinePosition {
        public int line;
        public int offset;

        LinePosition() {
        }
    }
}

