/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.text.PHPDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class MatchingCharAutoEditStrategy
implements IAutoEditStrategy {
    protected static final char CURLY_OPEN = '{';
    protected static final char CURLY_CLOSE = '}';
    protected static final char ROUND_OPEN = '(';
    protected static final char ROUND_CLOSE = ')';
    protected static final char SQUARE_OPEN = '[';
    protected static final char SQUARE_CLOSE = ']';
    protected static final char SINGLE_QOUTE = '\'';
    protected static final char DOUBLE_QOUTES = '\"';
    protected static final char BACK_QOUTE = '`';
    protected static final char BACK_SLASH = '\\';
    protected static final int SEARCH_NOT_VALID = -1;
    protected static final int MATCHING_BRACKET_NEEDED = 0;
    protected static final int MATCHING_BRACKET_NOT_NEEDED = 1;
    protected static PHPDocumentRegionEdgeMatcher matcher = new PHPDocumentRegionEdgeMatcher();

    protected boolean isClosingBracket(char c) {
        return c == ')' || c == ']' || c == '}';
    }

    protected boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    protected static char getMatchingChar(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': 
            case '`': {
                return c;
            }
        }
        return '-';
    }

    protected boolean shouldAddClosingBracket(IStructuredDocument document, int offset, boolean isQuote) throws BadLocationException {
        if (document.getLength() == offset) {
            return document.getChar(offset - 2) != '?' || document.getChar(offset - 1) != '>';
        }
        if (document.getLength() == offset + 1) {
            return true;
        }
        char currChar = document.getChar(offset);
        char nextChar = document.getChar(offset + 1);
        if (Character.isWhitespace(currChar) || this.isClosingBracket(currChar) || isQuote && this.isQuote(currChar) || currChar == ';' || currChar == ',') {
            return true;
        }
        if (offset + 1 >= document.getLength()) {
            return false;
        }
        String state = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset);
        if (state == "PHP_OPENTAG") {
            return true;
        }
        if (currChar == '/' && (nextChar == '/' || nextChar == '*')) {
            return true;
        }
        if (currChar == '?' && nextChar == '>') {
            return true;
        }
        return currChar == '<' && nextChar == '<' && offset + 2 < document.getLength() && document.getChar(offset + 2) == '<';
    }

    protected static boolean isSpecialOpenCurlyInQuotes(IStructuredDocument document, int offset) throws BadLocationException {
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return false;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion.getType() != "PHP_ENCAPSED_AND_WHITESPACE") {
            return false;
        }
        char firstChar = document.getChar(sdRegion.getStartOffset() + tRegion.getStart());
        if (firstChar != '\"' && firstChar != '`') {
            return false;
        }
        char bracketChar = document.getChar(offset + 1);
        return bracketChar == '$';
    }

    protected void adjustDocumentOffset(DocumentCommand command) {
        ++command.offset;
        if (command.caretOffset != -1) {
            command.caretOffset = command.offset;
        }
    }
}

