/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.ParenthesesCloseIndentationStrategy;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ParenthesesCloseAutoEditStrategy
extends ParenthesesCloseIndentationStrategy
implements IAutoEditStrategy {
    private StringBuffer helpBuffer = new StringBuffer();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && (command.text.trim().endsWith(")") || command.text.trim().endsWith("]"))) {
            this.autoIndentAfterParenClose((IStructuredDocument)document, command);
        }
    }

    private void autoIndentAfterParenClose(IStructuredDocument document, DocumentCommand command) {
        this.helpBuffer.setLength(0);
        int currentOffset = command.offset;
        int lineNumber = document.getLineOfOffset(currentOffset);
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            if (ParenthesesCloseAutoEditStrategy.isBlanks(document, lineInfo.getOffset(), command.offset)) {
                this.placeMatchingBlanks(document, this.helpBuffer, lineNumber, currentOffset);
                command.offset = lineInfo.getOffset();
                command.length += currentOffset - lineInfo.getOffset();
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        command.text = String.valueOf(this.helpBuffer.toString()) + command.text;
    }

    protected static boolean isBlanks(IStructuredDocument document, int startOffset, int endOffset) throws BadLocationException {
        return document.get(startOffset, endOffset - startOffset).trim().length() == 0;
    }
}

