/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.CompletionCompanion;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public abstract class AbstractCompletionContext
implements ICompletionContext {
    public static final int NONE = 0;
    public static final int TRAIT_NAME = 1;
    public static final int TRAIT_KEYWORD = 2;
    private CompletionCompanion companion;
    private CompletionRequestor requestor;
    private ISourceModule sourceModule;
    private int offset;
    private PHPVersion phpVersion;
    private IStructuredDocument document;
    private IStructuredDocumentRegion structuredDocumentRegion;
    private ITextRegionCollection regionCollection;
    private IPhpScriptRegion phpScriptRegion;
    private String partitionType;
    private List<String> useTypes;

    @Override
    public void init(CompletionCompanion companion) {
        this.companion = companion;
    }

    protected CompletionCompanion getCompanion() {
        return this.companion;
    }

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (sourceModule == null) {
            throw new IllegalArgumentException();
        }
        this.requestor = requestor;
        this.sourceModule = sourceModule;
        this.offset = offset;
        this.phpVersion = ProjectOptions.getPhpVersion(sourceModule.getScriptProject().getProject());
        try {
            this.document = this.determineDocument(sourceModule, requestor);
            if (this.document != null) {
                this.structuredDocumentRegion = this.determineStructuredDocumentRegion(this.document, offset);
                if (this.structuredDocumentRegion != null) {
                    this.regionCollection = this.determineRegionCollection(this.document, this.structuredDocumentRegion, offset);
                    if (this.regionCollection != null) {
                        this.phpScriptRegion = this.determinePhpRegion(this.document, this.regionCollection, offset);
                        if (this.phpScriptRegion != null) {
                            this.partitionType = this.determinePartitionType(this.regionCollection, this.phpScriptRegion, offset);
                            if (this.partitionType != null) {
                                String prefix = this.getPrefix();
                                return prefix.length() <= 0 || Character.isJavaIdentifierStart(prefix.charAt(0)) || prefix.charAt(0) == '\\';
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return false;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    protected IStructuredDocumentRegion determineStructuredDocumentRegion(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion = null;
        int lastOffset = offset;
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = document.getRegionAtCharacterOffset(lastOffset);
            --lastOffset;
        }
        return sdRegion;
    }

    protected ITextRegionCollection determineRegionCollection(IStructuredDocument document, IStructuredDocumentRegion sdRegion, int offset) {
        IStructuredDocumentRegion regionCollection = sdRegion;
        ITextRegion textRegion = this.determineTextRegion(document, (ITextRegionCollection)sdRegion, offset);
        if (textRegion instanceof ITextRegionContainer) {
            regionCollection = (ITextRegionContainer)textRegion;
        }
        return regionCollection;
    }

    protected ITextRegion determineTextRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = offset == document.getLength() ? regionCollection.getLastRegion() : regionCollection.getRegionAtCharacterOffset(offset);
        return textRegion;
    }

    protected IPhpScriptRegion determinePhpRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = this.determineTextRegion(document, regionCollection, offset);
        IPhpScriptRegion phpScriptRegion = null;
        if (textRegion != null) {
            if (textRegion.getType() == "PHP_OPEN") {
                return null;
            }
            if (textRegion.getType() == "PHP_CLOSE") {
                if (regionCollection.getStartOffset(textRegion) == offset) {
                    textRegion = regionCollection.getRegionAtCharacterOffset(offset - 1);
                } else {
                    return null;
                }
            }
        }
        if (textRegion instanceof IPhpScriptRegion) {
            phpScriptRegion = (IPhpScriptRegion)textRegion;
        }
        return phpScriptRegion;
    }

    protected String determinePartitionType(ITextRegionCollection regionCollection, IPhpScriptRegion phpScriptRegion, int offset) throws BadLocationException {
        String regionType;
        int internalOffset = this.getOffset(offset, regionCollection, phpScriptRegion);
        String partitionType = phpScriptRegion.getPartition(internalOffset);
        if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = phpScriptRegion.getPhpToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || phpScriptRegion.getPhpToken(internalOffset).getStart() != internalOffset)) {
            partitionType = phpScriptRegion.getPartition(internalOffset - 1);
        }
        return partitionType;
    }

    protected IStructuredDocument determineDocument(ISourceModule module, CompletionRequestor requestor) throws ResourceAlreadyExists, IOException, CoreException {
        IDocument d;
        IStructuredDocument document = null;
        if (requestor instanceof IPHPCompletionRequestor && (d = ((IPHPCompletionRequestor)requestor).getDocument()) instanceof IStructuredDocument) {
            document = (IStructuredDocument)d;
        }
        if (document == null) {
            IStructuredModel structuredModel = null;
            try {
                IFile file = (IFile)module.getResource();
                if (file != null) {
                    if (file.exists()) {
                        structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                        document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                    } else {
                        document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                        document.set(module.getSource());
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return document;
    }

    public PHPVersion getPhpVersion() {
        return this.phpVersion;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public IStructuredDocument getDocument() {
        return this.document;
    }

    public ITextRegionCollection getRegionCollection() {
        return this.regionCollection;
    }

    public IPhpScriptRegion getPhpScriptRegion() {
        return this.phpScriptRegion;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public TextSequence getStatementText() {
        return PHPTextSequenceUtilities.getStatement(this.offset, this.structuredDocumentRegion, true);
    }

    public TextSequence getStatementText(int offset) {
        return PHPTextSequenceUtilities.getStatement(offset, this.structuredDocumentRegion, true);
    }

    public boolean hasWhitespaceBeforeCursor() {
        int statementEnd;
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        return statementLength != (statementEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength));
    }

    public CompletionRequestor getCompletionRequestor() {
        return this.requestor;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getPreviousWord() throws BadLocationException {
        int statementLength;
        int wordEnd;
        TextSequence statementText = this.getStatementText();
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength = statementText.length()), true);
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        if ((wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public String getPreviousWord(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        if ((wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public int getPreviousWordOffset(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return wordStart;
        }
        if (this.hasWhitespaceBeforeCursor()) {
            return wordStart;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, wordEnd, true);
        return wordStart;
    }

    public ITextRegion getPHPToken() throws BadLocationException {
        return this.getPHPToken(this.offset);
    }

    public ITextRegion getPHPToken(int offset) throws BadLocationException {
        return this.phpScriptRegion.getPhpToken(this.getOffset(offset, this.regionCollection, this.phpScriptRegion));
    }

    private int getOffset(int offset, ITextRegionCollection regionCollection, IPhpScriptRegion phpScriptRegion) {
        int result = offset - regionCollection.getStartOffset() - phpScriptRegion.getStart() - 1;
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public String getPrefix() throws BadLocationException {
        return this.getPrefixWithoutProcessing();
    }

    public String getPrefixWithoutProcessing() {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statementText, prefixEnd, true);
        return statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public int getPrefixEnd() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        int endOffset = this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + phpToken.getTextEnd();
        if (phpToken.getType() == "PHP_CONSTANT_ENCAPSED_STRING") {
            --endOffset;
        }
        return endOffset;
    }

    public ITextRegion getNextPHPToken() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.phpScriptRegion.getPhpToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.phpScriptRegion.getLength()) {
        }
        return phpToken;
    }

    public ITextRegion getNextPHPToken(int times) throws BadLocationException {
        ITextRegion phpToken = null;
        int offset = this.offset;
        while (times-- > 0) {
            phpToken = this.getPHPToken(offset);
            while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.phpScriptRegion.getPhpToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.phpScriptRegion.getLength()) {
            }
            if (phpToken == null) {
                return null;
            }
            offset = this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + phpToken.getEnd();
        }
        return phpToken;
    }

    public String getNextWord() throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken();
        return this.document.get(this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public String getNextWord(int times) throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken(times);
        return this.document.get(this.regionCollection.getStartOffset() + this.phpScriptRegion.getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public char getNextChar() throws BadLocationException {
        if (this.document.getLength() == this.offset) {
            return ' ';
        }
        return this.document.getChar(this.offset);
    }

    public int getUseTraitStatementContext() {
        return this.getUseTraitStatementContext(this.offset, this.structuredDocumentRegion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUseTraitStatementContext(int offset, IStructuredDocumentRegion sdRegion) {
        String type2;
        String type;
        int documentOffset;
        ArrayList<String> types = new ArrayList<String>();
        if (sdRegion == null) {
            sdRegion = this.structuredDocumentRegion;
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPhpToken(0) : phpScriptRegion.getPhpToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return 0;
                    }
                    if (startTokenRegion.getType() != "PHP_LINE_COMMENT" && startTokenRegion.getType() != "PHP_COMMENT" && startTokenRegion.getType() != "WHITESPACE" && !startTokenRegion.getType().startsWith("PHPDOC")) {
                        types.add(startTokenRegion.getType());
                    }
                    if (startTokenRegion.getType() != "PHP_CURLY_OPEN" && startTokenRegion.getType() != "PHP_INSTEADOF" && startTokenRegion.getType() != "PHP_SEMICOLON" && startTokenRegion.getType() != "PHP_AS") {
                        startTokenRegion = phpScriptRegion.getPhpToken(startTokenRegion.getStart() - 1);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (types.size() == 1) {
            type = (String)types.get(0);
            if (type == "PHP_CURLY_OPEN" || type == "PHP_INSTEADOF" || type == "PHP_SEMICOLON") {
                return 1;
            }
            if (type == "PHP_AS") {
                return 2;
            }
            if (type != "PHP_INSTEADOF") return 0;
            return 2;
        }
        if (types.size() == 2) {
            String type1 = (String)types.get(0);
            String type3 = (String)types.get(1);
            try {
                if (type3 == "PHP_SEMICOLON" && type1 == "PHP_STRING" && Character.isWhitespace(this.document.getChar(offset - 1))) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
            if (type3 != "PHP_CURLY_OPEN" && type3 != "PHP_INSTEADOF" && type3 != "PHP_SEMICOLON" && type1 != "PHP_STRING") return 0;
            return 1;
        }
        if (types.size() == 3) {
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_STRING" || type1 != "PHP_STRING" || type2 != "PHP_SEMICOLON") return 0;
            return 2;
        } else {
            if (types.size() != 4) return 0;
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_STRING" || type1 != "PHP_PAAMAYIM_NEKUDOTAYIM" || type2 != "PHP_STRING") return 0;
            return 2;
        }
    }

    public boolean isInUseTraitStatement() {
        return this.isInUseTraitStatement(this.offset, this.structuredDocumentRegion);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isInUseTraitStatement(int offset, IStructuredDocumentRegion sdRegion) {
        int documentOffset;
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(this.sourceModule.getScriptProject().getProject());
        if (phpVersion.isLessThan(PHPVersion.PHP5_4)) {
            return false;
        }
        if (this.useTypes != null) {
            return true;
        }
        if (sdRegion == null) {
            sdRegion = this.structuredDocumentRegion;
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPhpToken(0) : phpScriptRegion.getPhpToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_OPEN") {
                        TextSequence statementText1 = this.getStatementText(startOffset + startTokenRegion.getStart() - 1);
                        if ((startTokenRegion = phpScriptRegion.getPhpToken(startTokenRegion.getStart() - statementText1.length())) != null && startTokenRegion.getType() == "PHP_USE") {
                            String[] types = statementText1.toString().trim().substring(3).trim().split(",");
                            this.useTypes = new ArrayList<String>();
                            String[] stringArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String type = stringArray[n2];
                                this.useTypes.add(type.trim());
                                ++n2;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE") {
                        return false;
                    }
                    startTokenRegion = phpScriptRegion.getPhpToken(startTokenRegion.getStart() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public List<String> getUseTypes() {
        return this.useTypes;
    }
}

