/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.ArrayKeyContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class ArrayStringKeysStrategy
extends AbstractCompletionStrategy {
    public ArrayStringKeysStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ArrayStringKeysStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        boolean endsWithQuota;
        ICompletionContext context = this.getContext();
        if (!(context instanceof ArrayKeyContext)) {
            return;
        }
        SourceRange replaceRange = this.getReplacementRange(context);
        ArrayKeyContext arrayContext = (ArrayKeyContext)context;
        boolean bl = endsWithQuota = arrayContext.getNextChar() == '\'' || arrayContext.getNextChar() == '\"';
        if (arrayContext.hasQuotes() && !endsWithQuota) {
            replaceRange = new org.eclipse.dltk.core.SourceRange(replaceRange.getOffset(), replaceRange.getLength() + 1);
        }
        CompletionRequestor requestor = arrayContext.getCompletionRequestor();
        String prefix = arrayContext.getPrefix();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)arrayContext.getSourceModule());
        try {
            ArrayKeyFinder finder = new ArrayKeyFinder(prefix, arrayContext.getOffset());
            moduleDeclaration.traverse((ASTVisitor)finder);
            Set<String> names = finder.getNames();
            int extraObject = 1;
            if (!arrayContext.hasQuotes()) {
                extraObject |= 0x100;
            }
            for (String name : names) {
                if (requestor.isContextInformationMode()) continue;
                reporter.reportField((IField)new FakeField((ModelElement)arrayContext.getSourceModule(), name, 0, 0), "", (ISourceRange)replaceRange, false, 0, extraObject);
            }
        }
        catch (Exception exception) {}
    }

    protected void reportVariables(ICompletionReporter reporter, ArrayKeyContext context, String[] variables, String prefix) throws BadLocationException {
        this.reportVariables(reporter, context, variables, prefix, false);
    }

    protected void reportVariables(ICompletionReporter reporter, ArrayKeyContext context, String[] variables, String prefix, boolean removeDollar) throws BadLocationException {
        CompletionRequestor requestor = context.getCompletionRequestor();
        SourceRange replaceRange = this.getReplacementRange(context);
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (removeDollar) {
                variable = variable.substring(1);
            }
            if (variable.startsWith(prefix) && (!requestor.isContextInformationMode() || variable.length() == prefix.length())) {
                reporter.reportField((IField)new FakeField((ModelElement)context.getSourceModule(), variable, 0, 0), "", (ISourceRange)replaceRange, false);
            }
            ++n2;
        }
    }

    class ArrayKeyFinder
    extends PHPASTVisitor {
        private Set<String> names = new HashSet<String>();
        private String prefix;
        private int ignoredOffset;

        public ArrayKeyFinder(String prefix, int ignoredOffset) {
            this.prefix = prefix;
            this.ignoredOffset = ignoredOffset;
        }

        @Override
        public boolean visit(ArrayCreation s) throws Exception {
            return super.visit(s);
        }

        @Override
        public boolean visit(ArrayElement s) throws Exception {
            Scalar scalar;
            if (s.getKey() instanceof Scalar && (scalar = (Scalar)s.getKey()).getScalarType() == 2) {
                String key = ASTUtils.stripQuotes(scalar.getValue());
                if (!scalar.getValue().equals(key) && key.length() > 0 && key.toLowerCase().startsWith(this.prefix.toLowerCase())) {
                    this.names.add(key);
                }
            }
            return super.visit(s);
        }

        @Override
        public boolean visit(ArrayVariableReference s) throws Exception {
            Scalar scalar;
            if (s.start() < this.ignoredOffset && s.end() > this.ignoredOffset) {
                return super.visit(s);
            }
            if (s.getIndex() instanceof Scalar && (scalar = (Scalar)s.getIndex()).getScalarType() == 2) {
                String key = ASTUtils.stripQuotes(scalar.getValue());
                if (!scalar.getValue().equals(key) && key.length() > 0 && key.toLowerCase().startsWith(this.prefix.toLowerCase())) {
                    this.names.add(key);
                }
            }
            return super.visit(s);
        }

        @Override
        public boolean visit(ReflectionArrayVariableReference s) throws Exception {
            Scalar scalar;
            if (s.getIndex() instanceof Scalar && (scalar = (Scalar)s.getIndex()).getScalarType() == 2) {
                String key = ASTUtils.stripQuotes(scalar.getValue());
                if (!scalar.getValue().equals(key) && key.length() > 0 && key.toLowerCase().startsWith(this.prefix.toLowerCase())) {
                    this.names.add(key);
                }
            }
            return super.visit(s);
        }

        @Override
        public boolean visit(PHPArrayDereferenceList s) throws Exception {
            return super.visit(s);
        }

        public Set<String> getNames() {
            return this.names;
        }
    }
}

