/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.language.PHPMagicMethods;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ClassMethodsStrategy
extends ClassMembersStrategy {
    public ClassMethodsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassMethodsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ClassMemberContext)) {
            return;
        }
        ClassMemberContext concreteContext = (ClassMemberContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix().isEmpty() ? concreteContext.getPreviousWord() : concreteContext.getPrefix();
        boolean isParentCall = this.isParentCall(concreteContext);
        String suffix = this.getSuffix(concreteContext);
        Object replaceRange = null;
        replaceRange = suffix.equals("") ? this.getReplacementRange(concreteContext) : this.getReplacementRangeWithBraces(concreteContext);
        PHPVersion phpVersion = concreteContext.getPhpVersion();
        HashSet<String> magicMethods = new HashSet<String>();
        magicMethods.addAll(Arrays.asList(PHPMagicMethods.getMethods(phpVersion)));
        boolean exactName = requestor.isContextInformationMode();
        if (!exactName && concreteContext.getOffset() - 1 >= 0 && concreteContext.getDocument().getChar(concreteContext.getOffset() - 1) == '(') {
            exactName = true;
        }
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(type, null);
                IMethod[] methods = isParentCall ? PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, null) : PHPModelUtils.getTypeHierarchyMethod(type, hierarchy, prefix, exactName, null);
                boolean inConstructor = this.isInConstructor(type, type.getMethods(), concreteContext);
                for (IMethod method : this.removeOverriddenElements(Arrays.asList(methods))) {
                    if (concreteContext.isInUseTraitStatement()) {
                        reporter.reportMethod(method, "", (ISourceRange)replaceRange, 32);
                        continue;
                    }
                    if (this.isConstructor(method) && (!inConstructor || !this.isSuperConstructor(method, type, concreteContext)) || this.isFiltered((IMember)method, type, concreteContext)) continue;
                    if (magicMethods.contains(method.getElementName())) {
                        reporter.reportMethod(method, suffix, (ISourceRange)replaceRange, 4);
                        continue;
                    }
                    result.add(method);
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        for (IMethod method : result) {
            reporter.reportMethod(method, suffix, (ISourceRange)replaceRange);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInConstructor(IType type, IMethod[] methods, ClassMemberContext concreteContext) {
        try {
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return false;
                }
                IMethod method = methods[i];
                if (this.isConstructor(method) && method.getDeclaringType().equals(type)) {
                    ISourceRange construtorRange = method.getSourceRange();
                    if (concreteContext.getOffset() > construtorRange.getOffset() && concreteContext.getOffset() < construtorRange.getOffset() + construtorRange.getLength()) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return false;
    }

    private boolean isSuperConstructor(IMethod method, IType type, ClassMemberContext context) {
        return this.isConstructor(method) && context.getTriggerType() == ClassMemberContext.Trigger.CLASS && this.isParent(context) && !method.getDeclaringType().equals(type);
    }

    private boolean isParent(ClassMemberContext context) {
        return !this.isThisCall(context) && this.isParentCall(context) && this.isDirectParentCall(context);
    }

    private boolean isConstructor(IMethod method) {
        String methodName = method.getElementName();
        return methodName.equals("__construct") || methodName.equals(method.getDeclaringType().getElementName());
    }

    @Override
    protected boolean showNonStaticMembers(ClassMemberContext context) {
        return super.showNonStaticMembers(context) || context.getTriggerType() == ClassMemberContext.Trigger.CLASS;
    }

    public String getSuffix(AbstractCompletionContext abstractContext) throws BadLocationException {
        IStructuredDocument document = abstractContext.getDocument();
        int offset = abstractContext.getOffset();
        while (document.getLength() > offset) {
            char ch = document.getChar(offset);
            if (ch == '(') break;
            if (ch == '\n') {
                return "()";
            }
            ++offset;
        }
        return "";
    }
}

