/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;

public class DocumentorLexer
implements IDocumentorLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int ST_IN_TAGS = 6;
    public static final int YYINITIAL = 0;
    public static final int ST_IN_SHORT_DESC = 2;
    public static final int ST_IN_LONG_DESC = 4;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0001\t\u0000\u0001\u0004\u0002\u0000\u0001\u001f\u0001\u0006\u0001\u0005\u0010\u0000\u0001\u0007\u0003\u0000\u0001\"\u001c\u0000\u0001\b\u0001\t\u0001\r\u0001\u0016\u0001\u000e\u0001\u001a\u0001\u0012\u0001\u0010\u0001\u0015\u0001\u0000\u0001\u001c\u0001\u0019\u0001\u0018\u0001\u001b\u0001\u0011\u0001\u0014\u0001\u0000\u0001\f\u0001\n\u0001\u000b\u0001\u000f\u0001\u001d\u0001\u001e\u0001\u0017\u0001\u0013\u0001\u0000\u0001 \u0001\u0000\u0001!\uff82\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0002\u0002\u0003\u0003\u0002\u0002\u0004\u0004\u0002\u0002\u0005\u0001\u0002\u0002\u0001\u0002\u0002\u0002\u0001\u0002\u0002\u0003\u0000\u0001\u0006\u0001\u0007\u0002\u0006\u0002\u0001\u0002\u0000\u0001\u0001\u0001\b\u0013\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\n\u0002\u0000\u0001\u0001\u0011\u0000\u0001\u000b8\u0000\u0002\u000b\u0004\u0000\u0001\f\u0018\u0000\u0001\r\u0006\u0000\u0001\u000e\u0018\u0000\u0001\u000f\n\u0000\u0001\u0010\u0004\u0000\u0001\u0011\u0006\u0000\u0001\u0012\u0003\u0000\u0001\u0013\u0002\u0000\u0001\u0014\n\u0000\u0001\u0015\u0004\u0000\u0001\u0016\u0006\u0000\u0001\u0017\u0003\u0000\u0001\u0018\u0002\u0000\u0001\u0019\u0007\u0000\u0001\u001a\u0007\u0000\u0001\u001b\b\u0000\u0001\u001c\b\u0000\u0001\u001d\u0007\u0000\u0001\u001e\b\u0000\u0001\u001f\u0004\u0000\u0001 \u0001!\u0001\"\u0002\u0000\u0001#\u0001$\u0003\u0000\u0001%\u0002\u0000\u0001&\u0002\u0000\u0001'\u0006\u0000\u0001(\u0001)\u0001*\u0002\u0000\u0001+\u0001,\u0003\u0000\u0001-\u0002\u0000\u0001.\u0002\u0000\u0001/\u000b\u0000\u00010\u00011\u0003\u0000\u00012\u0002\u0000\u00013\u0007\u0000\u00014\u00015\u0003\u0000\u00016\u0002\u0000\u00017\u0001\u0000\u00018\u0002\u0000\u00019\u0001:\u0001\u0000\u0001;\u0001<\u0004\u0000\u0001=\u0002\u0000\u0001>\u0001?\u0001\u0000\u0001@\u0001A\u0004\u0000\u0001B\u0001\u0000\u0001C\u0003\u0000\u0001D\u0001\u0000\u0001E\u0001\u0000\u0001F\u0003\u0000\u0001G\u0001\u0000\u0001H\u0002\u0000\u0001I\u0001J\u0001\u0000\u0001K\u0002\u0000\u0001L\u0001M\t\u0000\u0001N\u0002\u0000\u0001O\u0001P\u0001\u0000\u0001Q\u0001\u0000\u0001R\u0001S";
    private static final int[] ZZ_ROWMAP;
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000#\u0000F\u0000i\u0000\u008c\u0000\u00af\u0000\u00d2\u0000\u00f5\u0000\u0118\u0000\u013b\u0000\u015e\u0000\u0118\u0000\u0181\u0000\u01a4\u0000\u01c7\u0000\u01ea\u0000\u0118\u0000\u020d\u0000\u0230\u0000\u0253\u0000\u0276\u0000\u0299\u0000\u0118\u0000\u02bc\u0000\u02df\u0000\u0302\u0000\u0325\u0000\u0348\u0000\u036b\u0000\u038e\u0000\u03b1\u0000\u03d4\u0000\u03f7\u0000\u041a\u0000\u015e\u0000\u01a4\u0000\u0118\u0000\u0118\u0000\u043d\u0000\u0460\u0000\u01ea\u0000\u0230\u0000\u0253\u0000\u0276\u0000\u0483\u0000\u0118\u0000\u04a6\u0000\u04c9\u0000\u04ec\u0000\u050f\u0000\u0532\u0000\u0555\u0000\u0578\u0000\u059b\u0000\u05be\u0000\u05e1\u0000\u0604\u0000\u0627\u0000\u064a\u0000\u066d\u0000\u0690\u0000\u06b3\u0000\u06d6\u0000\u0299\u0000\u02df\u0000\u0118\u0000\u06f9\u0000\u0348\u0000\u036b\u0000\u0118\u0000\u03d4\u0000\u03f7\u0000\u071c\u0000\u073f\u0000\u0762\u0000\u0785\u0000\u07a8\u0000\u07cb\u0000\u07ee\u0000\u0811\u0000\u0834\u0000\u0857\u0000\u087a\u0000\u089d\u0000\u08c0\u0000\u08e3\u0000\u0906\u0000\u0929\u0000\u094c\u0000\u096f\u0000\u0992\u0000\u09b5\u0000\u09d8\u0000\u09fb\u0000\u0a1e\u0000\u0a41\u0000\u0a64\u0000\u0a87\u0000\u0aaa\u0000\u0acd\u0000\u0af0\u0000\u0b13\u0000\u0b36\u0000\u0b59\u0000\u0b7c\u0000\u0b9f\u0000\u0bc2\u0000\u0be5\u0000\u0c08\u0000\u0c2b\u0000\u0c4e\u0000\u0c71\u0000\u0c94\u0000\u0cb7\u0000\u0cda\u0000\u0cfd\u0000\u0d20\u0000\u0d43\u0000\u0d66\u0000\u0d89\u0000\u0dac\u0000\u0dcf\u0000\u0df2\u0000\u0e15\u0000\u0e38\u0000\u0e5b\u0000\u0e7e\u0000\u0ea1\u0000\u0ec4\u0000\u0ee7\u0000\u0f0a\u0000\u0f2d\u0000\u0f50\u0000\u0f73\u0000\u0f96\u0000\u0fb9\u0000\u0fdc\u0000\u0fff\u0000\u1022\u0000\u1045\u0000\u1068\u0000\u108b\u0000\u10ae\u0000\u10d1\u0000\u10f4\u0000\u1117\u0000\u113a\u0000\u0118\u0000\u115d\u0000\u1180\u0000\u11a3\u0000\u11c6\u0000\u11e9\u0000\u0118\u0000\u120c\u0000\u122f\u0000\u1252\u0000\u1275\u0000\u1298\u0000\u12bb\u0000\u12de\u0000\u1301\u0000\u1324\u0000\u1347\u0000\u136a\u0000\u138d\u0000\u13b0\u0000\u13d3\u0000\u13f6\u0000\u1419\u0000\u143c\u0000\u145f\u0000\u1482\u0000\u14a5\u0000\u14c8\u0000\u14eb\u0000\u150e\u0000\u1531\u0000\u0118\u0000\u1554\u0000\u1577\u0000\u159a\u0000\u15bd\u0000\u15e0\u0000\u1603\u0000\u0118\u0000\u1626\u0000\u1649\u0000\u166c\u0000\u168f\u0000\u16b2\u0000\u16d5\u0000\u16f8\u0000\u171b\u0000\u173e\u0000\u1761\u0000\u1784\u0000\u17a7\u0000\u17ca\u0000\u17ed\u0000\u1810\u0000\u1833\u0000\u1856\u0000\u1879\u0000\u189c\u0000\u18bf\u0000\u18e2\u0000\u1905\u0000\u1928\u0000\u194b\u0000\u0118\u0000\u196e\u0000\u1991\u0000\u19b4\u0000\u19d7\u0000\u19fa\u0000\u1a1d\u0000\u1a40\u0000\u1a63\u0000\u1a86\u0000\u1aa9\u0000\u0118\u0000\u1acc\u0000\u1aef\u0000\u1b12\u0000\u1b35\u0000\u0118\u0000\u1b58\u0000\u1b7b\u0000\u1b9e\u0000\u1bc1\u0000\u1be4\u0000\u1c07\u0000\u0118\u0000\u1c2a\u0000\u1c4d\u0000\u1c70\u0000\u0118\u0000\u1c93\u0000\u1cb6\u0000\u1cd9\u0000\u1cfc\u0000\u1d1f\u0000\u1d42\u0000\u1d65\u0000\u1d88\u0000\u1dab\u0000\u1dce\u0000\u1df1\u0000\u1e14\u0000\u1e37\u0000\u0118\u0000\u1e5a\u0000\u1e7d\u0000\u1ea0\u0000\u1ec3\u0000\u0118\u0000\u1ee6\u0000\u1f09\u0000\u1f2c\u0000\u1f4f\u0000\u1f72\u0000\u1f95\u0000\u0118\u0000\u1fb8\u0000\u1fdb\u0000\u1ffe\u0000\u0118\u0000\u2021\u0000\u2044\u0000\u2067\u0000\u208a\u0000\u20ad\u0000\u20d0\u0000\u20f3\u0000\u2116\u0000\u2139\u0000\u215c\u0000\u0118\u0000\u217f\u0000\u21a2\u0000\u21c5\u0000\u21e8\u0000\u220b\u0000\u222e\u0000\u2251\u0000\u0118\u0000\u2274\u0000\u2297\u0000\u22ba\u0000\u22dd\u0000\u2300\u0000\u2323\u0000\u2346\u0000\u2369\u0000\u0118\u0000\u238c\u0000\u23af\u0000\u23d2\u0000\u23f5\u0000\u2418\u0000\u243b\u0000\u245e\u0000\u2481\u0000\u0118\u0000\u24a4\u0000\u24c7\u0000\u24ea\u0000\u250d\u0000\u2530\u0000\u2553\u0000\u2576\u0000\u0118\u0000\u2599\u0000\u25bc\u0000\u25df\u0000\u2602\u0000\u2625\u0000\u2648\u0000\u266b\u0000\u268e\u0000\u0118\u0000\u26b1\u0000\u26d4\u0000\u26f7\u0000\u271a\u0000\u0118\u0000\u0118\u0000\u273d\u0000\u2760\u0000\u2783\u0000\u0118\u0000\u0118\u0000\u27a6\u0000\u27c9\u0000\u27ec\u0000\u0118\u0000\u280f\u0000\u2832\u0000\u0118\u0000\u2855\u0000\u2878\u0000\u0118\u0000\u289b\u0000\u28be\u0000\u28e1\u0000\u2904\u0000\u2927\u0000\u294a\u0000\u0118\u0000\u0118\u0000\u296d\u0000\u2990\u0000\u29b3\u0000\u0118\u0000\u0118\u0000\u29d6\u0000\u29f9\u0000\u2a1c\u0000\u0118\u0000\u2a3f\u0000\u2a62\u0000\u0118\u0000\u2a85\u0000\u2aa8\u0000\u0118\u0000\u2acb\u0000\u2aee\u0000\u2b11\u0000\u2b34\u0000\u2b57\u0000\u2b7a\u0000\u2b9d\u0000\u2bc0\u0000\u2be3\u0000\u2c06\u0000\u2c29\u0000\u0118\u0000\u0118\u0000\u2c4c\u0000\u2c6f\u0000\u2c92\u0000\u0118\u0000\u2cb5\u0000\u2cd8\u0000\u0118\u0000\u2cfb\u0000\u2d1e\u0000\u2d41\u0000\u2d64\u0000\u2d87\u0000\u2daa\u0000\u2dcd\u0000\u0118\u0000\u0118\u0000\u2df0\u0000\u2e13\u0000\u2e36\u0000\u0118\u0000\u2e59\u0000\u2e7c\u0000\u0118\u0000\u2e9f\u0000\u0118\u0000\u2ec2\u0000\u2ee5\u0000\u0118\u0000\u0118\u0000\u2f08\u0000\u2f2b\u0000\u0118\u0000\u2f4e\u0000\u2f71\u0000\u2f94\u0000\u2fb7\u0000\u0118\u0000\u2fda\u0000\u2ffd\u0000\u0118\u0000\u0118\u0000\u3020\u0000\u3043\u0000\u0118\u0000\u3066\u0000\u3089\u0000\u30ac\u0000\u30cf\u0000\u0118\u0000\u30f2\u0000\u0118\u0000\u3115\u0000\u3138\u0000\u315b\u0000\u0118\u0000\u317e\u0000\u0118\u0000\u31a1\u0000\u0118\u0000\u31c4\u0000\u31e7\u0000\u320a\u0000\u0118\u0000\u322d\u0000\u0118\u0000\u3250\u0000\u3273\u0000\u0118\u0000\u0118\u0000\u3296\u0000\u0118\u0000\u32b9\u0000\u32dc\u0000\u0118\u0000\u0118\u0000\u32ff\u0000\u3322\u0000\u3345\u0000\u3368\u0000\u338b\u0000\u33ae\u0000\u33d1\u0000\u33f4\u0000\u3417\u0000\u0118\u0000\u343a\u0000\u345d\u0000\u0118\u0000\u0118\u0000\u3480\u0000\u0118\u0000\u34a3\u0000\u0118\u0000\u0118";
    private static final int[] ZZ_TRANS;
    private static final String ZZ_TRANS_PACKED_0 = "(\t\u0001\n\u001e\t\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\t\u0001\u000f\u001d\t\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\t\u0001\u000f\u0001\u0014\u0018\t\u0001\u0015\u0003\t\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u001f\t\u0001\u001a\u0001\u0017\u0001\u0018\u0001\u001b\u0002\t\u0001\u0014\u0018\t\u0001\u0015\u0003\t\u0001\u001c\u0001\u0017\u0001\u0018\u0001\u001d\u001f\t\u0001\u001e\u0001\u0017\u0001\u0018\u0001\u001f\u0002\t\u0001 \u0018\t\u0001!\u0002\t'\u0000\u0001\"\u001f\u0000\u0001#\u0002\u0000\u0001$\u0001\u0000\u0001%\u001e\u0000\u0001\f%\u0000\u0001&\u001e\u0000\u0001'\u0001%\u0001( \u0000\u0001)\u0001\u0011\u0001\u0012\u0001*\u0001\u0000\u0001%\u0001+\u0018\u0000\u0001,\u0004\u0000\u0001\u0011!\u0000\u0001-\u0001\u0011\u0001\u0012\u0001\u0000\u0001.\u0001\u0000\u0001+\u0018\u0000\u0001,\n\u0000\u0001/\u0001\u0000\u00010\u00011\u00012\u00013\u00014\u00015\u0002\u0000\u00016\u0001\u0000\u00017\u00018\u00019\u0001\u0000\u0001:\u0001;\u0001<\u0001=\u0001\u0000\u0001>\f\u0000\u0001?\u001c\u0000\u0001@\u0002\u0000\u0001A \u0000\u0001\u0017%\u0000\u0001B\u001e\u0000\u0001\u001a\u0002\u0000\u0001\u001b\u0002\u0000\u0001+\u0018\u0000\u0001,\u0003\u0000\u0001C\u0003\u0000\u0001B\u0001\u0000\u0001+\u0018\u0000\u0001,\u0003\u0000\u0001D\u0002\u0000\u0001E#\u0000\u0001F\u001e\u0000\u0001\u001e\u0002\u0000\u0001\u001f\u0002\u0000\u0001G\u0018\u0000\u0001H\u0003\u0000\u0001I\u0003\u0000\u0001F\u0001\u0000\u0001G\u0018\u0000\u0001H\n\u0000\u0001J\u0001\u0000\u0001K\u0001L\u0001M\u0001N\u0001O\u0001P\u0002\u0000\u0001Q\u0001\u0000\u0001R\u0001S\u0001T\u0001\u0000\u0001U\u0001V\u0001W\u0001X\u0001\u0000\u0001Y\f\u0000\u0001Z\u001f\u0000\u0001[\u001f\u0000\u0001'#\u0000\u0001%!\u0000\u0001-\u0001\u0011\u0001\u0012\u0003\u0000\u0001+\u0018\u0000\u0001,\u000b\u0000\u0001\\\u0003\u0000\u0001]\u0001\u0000\u0001^\u001e\u0000\u0001_\u0002\u0000\u0001`\u0001a\u0005\u0000\u0001b\u001c\u0000\u0001c\u0001d\u0001e\u001f\u0000\u0001f\u001c\u0000\u0001g\b\u0000\u0001h(\u0000\u0001i\u0015\u0000\u0001j1\u0000\u0001k\u0011\u0000\u0001l\u0003\u0000\u0001m(\u0000\u0001n\b\u0000\u0001o\u0015\u0000\u0001p\"\u0000\u0001q)\u0000\u0001r\"\u0000\u0001s\u0015\u0000\u0001t\"\u0000\u0001u\u0005\u0000\u0001v)\u0000\u0001w\u000e\u0000\u0001C\u0005\u0000\u0001+\u0018\u0000\u0001,\u0003\u0000\u0001I\u0005\u0000\u0001G\u0018\u0000\u0001H\u000b\u0000\u0001x\u0003\u0000\u0001y\u0001\u0000\u0001z\u001e\u0000\u0001{\u0002\u0000\u0001|\u0001}\u0005\u0000\u0001~\u001c\u0000\u0001\u007f\u0001\u0080\u0001\u0081\u001f\u0000\u0001\u0082\u001c\u0000\u0001\u0083\b\u0000\u0001\u0084(\u0000\u0001\u0085\u0015\u0000\u0001\u00861\u0000\u0001\u0087\u0011\u0000\u0001\u0088\u0003\u0000\u0001\u0089(\u0000\u0001\u008a\b\u0000\u0001\u008b\u0015\u0000\u0001\u008c\"\u0000\u0001\u008d)\u0000\u0001\u008e\"\u0000\u0001\u008f\u0015\u0000\u0001\u0090\"\u0000\u0001\u0091\u0005\u0000\u0001\u0092)\u0000\u0001\u0093\u000e\u0000\u0001[\u0001\u0094\u0001\u0095)\u0000\u0001\u0096%\u0000\u0001\u0097 \u0000\u0001\u0098\u001f\u0000\u0001\u0099(\u0000\u0001\u009a\u001d\u0000\u0001\u009b4\u0000\u0001\u009c\u0012\u0000\u0001\u009d#\u0000\u0001\u009e,\u0000\u0001\u009f\u0017\u0000\u0001\u00a0\"\u0000\u0001\u00a1+\u0000\u0001\u00a2\u0016\u0000\u0001\u00a3(\u0000\u0001\u00a4%\u0000\u0001\u00a5\u001d\u0000\u0001\u00a6\u0001\u00a7&\u0000\u0001\u00a8,\u0000\u0001\u00a9\u0012\u0000\u0001\u00aa!\u0000\u0001\u00ab\t\u0000\u0001\u00ac\u0019\u0000\u0001\u00ad$\u0000\u0001\u00ae\r\u0000\u0001\u00af \u0000\u0001\u00b0\u0001\u0000\u0001\u00b1\u001f\u0000\u0001\u00b2\u0016\u0000\u0001\u00b3\"\u0000\u0001\u00b41\u0000\u0001\u00b5\u0011\u0000\u0001\u00b6%\u0000\u0001\u00b7 \u0000\u0001\u00b8\u001f\u0000\u0001\u00b9(\u0000\u0001\u00ba\u001d\u0000\u0001\u00bb4\u0000\u0001\u00bc\u0012\u0000\u0001\u00bd#\u0000\u0001\u00be,\u0000\u0001\u00bf\u0017\u0000\u0001\u00c0\"\u0000\u0001\u00c1+\u0000\u0001\u00c2\u0016\u0000\u0001\u00c3(\u0000\u0001\u00c4%\u0000\u0001\u00c5\u001d\u0000\u0001\u00c6\u0001\u00c7&\u0000\u0001\u00c8,\u0000\u0001\u00c9\u0012\u0000\u0001\u00ca!\u0000\u0001\u00cb\t\u0000\u0001\u00cc\u0019\u0000\u0001\u00cd$\u0000\u0001\u00ce\r\u0000\u0001\u00cf \u0000\u0001\u00d0\u0001\u0000\u0001\u00d1\u001f\u0000\u0001\u00d2\u0016\u0000\u0001\u00d3\"\u0000\u0001\u00d41\u0000\u0001\u00d5\t\u0000\u0001\u0094+\u0000\u0001\u00d6%\u0000\u0001\u00d7$\u0000\u0001\u00d8\u001d\u0000\u0001\u00d9+\u0000\u0001\u00da\u001b\u0000\u0001\u00db&\u0000\u0001\u00dc\"\u0000\u0001\u00dd\"\u0000\u0001\u00de \u0000\u0001\u00df!\u0000\u0001\u00e0'\u0000\u0001\u00e1'\u0000\u0001\u00e2\u0014\u0000\u0001\u00e3!\u0000\u0001\u00e4!\u0000\u0001\u00e56\u0000\u0001\u00e6\u001a\u0000\u0001\u00e7\u001f\u0000\u0001\u00e8\u001f\u0000\u0001\u00e9!\u0000\u0001\u00ea!\u0000\u0001\u00eb&\u0000\u0001\u00ec \u0000\u0001\u00ed0\u0000\u0001\u00ee\u0014\u0000\u0001\u00ef\u001c\u0000\u0001\u00f0(\u0000\u0001\u00f1\u001e\u0000\u0001\u00f2(\u0000\u0001\u00f3\u001d\u0000\u0001\u00f4%\u0000\u0001\u00f5$\u0000\u0001\u00f6\u001d\u0000\u0001\u00f7+\u0000\u0001\u00f8\u001b\u0000\u0001\u00f9&\u0000\u0001\u00fa\"\u0000\u0001\u00fb\"\u0000\u0001\u00fc \u0000\u0001\u00fd!\u0000\u0001\u00fe'\u0000\u0001\u00ff'\u0000\u0001\u0100\u0014\u0000\u0001\u0101!\u0000\u0001\u0102!\u0000\u0001\u01036\u0000\u0001\u0104\u001a\u0000\u0001\u0105\u001f\u0000\u0001\u0106\u001f\u0000\u0001\u0107!\u0000\u0001\u0108!\u0000\u0001\u0109&\u0000\u0001\u010a \u0000\u0001\u010b0\u0000\u0001\u010c\u0014\u0000\u0001\u010d\u001c\u0000\u0001\u010e(\u0000\u0001\u010f\u001e\u0000\u0001\u0110(\u0000\u0001\u0111\u001e\u0000\u0001\u0112 \u0000\u0001\u0113)\u0000\u0001\u0114&\u0000\u0001\u0115\u0015\u0000\u0001\u0116(\u0000\u0001\u0117 \u0000\u0001\u01184\u0000\u0001\u0119\u0010\u0000\u0001\u011a(\u0000\u0001\u011b\u001c\u0000\u0001\u011c*\u0000\u0001\u011d\u0016\u0000\u0001\u011e2\u0000\u0001\u011f\u0012\u0000\u0001\u0120(\u0000\u0001\u0121 \u0000\u0001\u0122\"\u0000\u0001\u0123$\u0000\u0001\u0124%\u0000\u0001\u0125,\u0000\u0001\u0126\u0011\u0000\u0001\u01271\u0000\u0001\u0128\u0013\u0000\u0001\u0129-\u0000\u0001\u012a\u001b\u0000\u0001\u012b \u0000\u0001\u012c \u0000\u0001\u012d)\u0000\u0001\u012e&\u0000\u0001\u012f\u0015\u0000\u0001\u0130(\u0000\u0001\u0131 \u0000\u0001\u01324\u0000\u0001\u0133\u0010\u0000\u0001\u0134(\u0000\u0001\u0135\u001c\u0000\u0001\u0136*\u0000\u0001\u0137\u0016\u0000\u0001\u01382\u0000\u0001\u0139\u0012\u0000\u0001\u013a(\u0000\u0001\u013b \u0000\u0001\u013c\"\u0000\u0001\u013d$\u0000\u0001\u013e%\u0000\u0001\u013f,\u0000\u0001\u0140\u0011\u0000\u0001\u01411\u0000\u0001\u0142\u0013\u0000\u0001\u0143-\u0000\u0001\u0144\u001b\u0000\u0001\u0145\u001c\u0000\u0001\u0146$\u0000\u0001\u0147$\u0000\u0001\u0148#\u0000\u0001\u0149\"\u0000\u0001\u014a*\u0000\u0001\u014b\u0017\u0000\u0001\u014c3\u0000\u0001\u014d\u0018\u0000\u0001\u014e&\u0000\u0001\u014f&\u0000\u0001\u0150\"\u0000\u0001\u0151\u001b\u0000\u0001\u0152\u001c\u0000\u0001\u0153$\u0000\u0001\u0154/\u0000\u0001\u0155\u0014\u0000\u0001\u0156+\u0000\u0001\u0157\u0016\u0000\u0001\u0158)\u0000\u0001\u0159%\u0000\u0001\u015a\u001f\u0000\u0001\u015b\u001d\u0000\u0001\u015c\u001e\u0000\u0001\u015d$\u0000\u0001\u015e$\u0000\u0001\u015f#\u0000\u0001\u0160\"\u0000\u0001\u0161*\u0000\u0001\u0162\u0017\u0000\u0001\u01633\u0000\u0001\u0164\u0018\u0000\u0001\u0165&\u0000\u0001\u0166&\u0000\u0001\u0167\"\u0000\u0001\u0168\u001b\u0000\u0001\u0169\u001c\u0000\u0001\u016a$\u0000\u0001\u016b/\u0000\u0001\u016c\u0014\u0000\u0001\u016d+\u0000\u0001\u016e\u0016\u0000\u0001\u016f)\u0000\u0001\u0170%\u0000\u0001\u0171\u001f\u0000\u0001\u0172\u001d\u0000\u0001\u0173#\u0000\u0001\u01742\u0000\u0001\u0175!\u0000\u0001\u0176\u000e\u0000\u0001\u0177&\u0000\u0001\u0178(\u0000\u0001\u0179\u001e\u0000\u0001\u017a\"\u0000\u0001\u017b\u001f\u0000\u0001\u017c\u001f\u0000\u0001\u017d\"\u0000\u0001\u017e(\u0000\u0001\u017f#\u0000\u0001\u0180\u001b\u0000\u0001\u01815\u0000\u0001\u0182\u001c\u0000\u0001\u0183\u001a\u0000\u0001\u01842\u0000\u0001\u0185!\u0000\u0001\u0186\u000e\u0000\u0001\u0187&\u0000\u0001\u0188(\u0000\u0001\u0189\u001e\u0000\u0001\u018a\"\u0000\u0001\u018b\u001f\u0000\u0001\u018c\u001f\u0000\u0001\u018d\"\u0000\u0001\u018e(\u0000\u0001\u018f#\u0000\u0001\u0190\u001b\u0000\u0001\u01915\u0000\u0001\u0192\u001c\u0000\u0001\u0193\u0018\u0000\u0001\u0194\u001f\u0000\u0001\u0195\"\u0000\u0001\u01963\u0000\u0001\u0197\u001c\u0000\u0001\u0198\u001f\u0000\u0001\u0199%\u0000\u0001\u019a(\u0000\u0001\u019b\u0014\u0000\u0001\u019c#\u0000\u0001\u019d#\u0000\u0001\u019e \u0000\u0001\u019f\"\u0000\u0001\u01a0\u001f\u0000\u0001\u01a1\"\u0000\u0001\u01a23\u0000\u0001\u01a3\u001c\u0000\u0001\u01a4\u001f\u0000\u0001\u01a5%\u0000\u0001\u01a6(\u0000\u0001\u01a7\u0014\u0000\u0001\u01a8#\u0000\u0001\u01a9#\u0000\u0001\u01aa \u0000\u0001\u01ab#\u0000\u0001\u01ac(\u0000\u0001\u01ad\u001b\u0000\u0001\u01ae6\u0000\u0001\u01af\u0011\u0000\u0001\u01b0!\u0000\u0001\u01b1#\u0000\u0001\u01b2*\u0000\u0001\u01b3\u0018\u0000\u0001\u01b4(\u0000\u0001\u01b5\u001b\u0000\u0001\u01b66\u0000\u0001\u01b7\u0011\u0000\u0001\u01b8!\u0000\u0001\u01b9#\u0000\u0001\u01ba6\u0000\u0001\u01bb\u000e\u0000\u0001\u01bc \u0000\u0001\u01bd\u0011\u0000\u0001\u01be\u001a\u0000\u0001\u01bf\u001a\u0000\u0001\u01c0%\u0000\u0001\u01c1\u001f\u0000\u0001\u01c2 \u0000\u0001\u01c3\u0011\u0000\u0001\u01c4\u001a\u0000\u0001\u01c5\u001a\u0000\u0001\u01c6%\u0000\u0001\u01c7\u001f\u0000\u0001\u01c8 \u0000\u0001\u01c9#\u0000\u0001\u01ca#\u0000\u0001\u01cb \u0000\u0001\u01cc#\u0000\u0001\u01cd\u001d\u0000\u0001\u01ce/\u0000\u0001\u01cf.\u0000\u0001\u01d0\t\u0000\u0001\u01d1/\u0000\u0001\u01d2.\u0000\u0001\u01d3\u0017\u0000\u0001\u01d4\u0017\u0000\u0001\u01d5-\u0000\u0001\u01d6\u0017\u0000\u0001\u01d7%\u0000\u0001\u01d8\"\u0000\u0001\u01d9\u0014\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private static final int[] ZZ_ATTRIBUTE;
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0004\u0001\u0001\t\u0005\u0001\u0001\t\n\u0001\u0003\u0000\u0002\t\u0004\u0001\u0002\u0000\u0001\u0001\u0001\t\u0013\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0002\u0000\u0001\u0001\u0011\u0000\u0001\u00018\u0000\u0001\t\u0001\u0001\u0004\u0000\u0001\t\u0018\u0000\u0001\t\u0006\u0000\u0001\t\u0018\u0000\u0001\t\n\u0000\u0001\t\u0004\u0000\u0001\t\u0006\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0001\u0001\n\u0000\u0001\t\u0004\u0000\u0001\t\u0006\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0001\u0001\u0007\u0000\u0001\t\u0007\u0000\u0001\t\b\u0000\u0001\t\b\u0000\u0001\t\u0007\u0000\u0001\t\b\u0000\u0001\t\u0004\u0000\u0002\t\u0001\u0001\u0002\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0006\u0000\u0002\t\u0001\u0001\u0002\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u000b\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0007\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0001\t\u0004\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0001\t\u0004\u0000\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0001\t\u0002\u0000\u0002\t\t\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList<PHPDocTag> tagList = null;
    private int currTagId = 0;
    private int tagPosition = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;
    private List<Scalar> textList;
    int maxNumberofLines = 4;
    String oldString = null;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = DocumentorLexer.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = DocumentorLexer.zzUnpackAction();
        ZZ_ROWMAP = DocumentorLexer.zzUnpackRowMap();
        ZZ_TRANS = DocumentorLexer.zzUnpackTrans();
        ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
        ZZ_ATTRIBUTE = DocumentorLexer.zzUnpackAttribute();
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[473];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[473];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[13510];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[473];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public PHPDocBlock parse() {
        int start = this.zzStartRead - this.zzPushbackPos;
        this.longDesc = "";
        this.tagList = new ArrayList();
        this.textList = new ArrayList<Scalar>();
        this.sBuffer = new StringBuffer();
        this.numOfLines = 1;
        try {
            this.next_token();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        if (!this.tagList.isEmpty() && !this.textList.isEmpty()) {
            Scalar lastText = this.textList.get(this.textList.size() - 1);
            PHPDocTag lastTag = this.tagList.get(this.tagList.size() - 1);
            if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
                this.textList.remove(this.textList.size() - 1);
                if (!this.isBlank(lastText.getValue())) {
                    lastTag.getTexts().add(lastText);
                }
            }
        }
        PHPDocTag[] tags = new PHPDocTag[this.tagList.size()];
        this.tagList.toArray(tags);
        PHPDocBlock rv = new PHPDocBlock(start, this.zzMarkedPos - this.zzPushbackPos, this.shortDesc, this.longDesc, tags, this.textList);
        return rv;
    }

    private boolean isBlank(String value) {
        char[] line = value.toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (c != '\t' && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void startTagsState(int firstState) {
        this.updateStartPos();
        this.hendleDesc();
        this.currTagId = firstState;
        this.tagPosition = this.findTagPosition();
        this.sBuffer = new StringBuffer();
        this.yybegin(6);
    }

    private int findTagPosition() {
        int i = this.zzStartRead;
        while (i < this.zzMarkedPos) {
            if (this.zzBuffer[i] == '@') {
                return i - this.zzPushbackPos;
            }
            ++i;
        }
        return -1;
    }

    private void setNewTag(int newTag) {
        this.updateStartPos();
        this.setTagValue();
        this.sBuffer = new StringBuffer();
        this.currTagId = newTag;
        this.tagPosition = this.findTagPosition();
    }

    private void setTagValue() {
        String value = this.sBuffer.toString();
        if (this.currTagId == 17) {
            this.shortDesc = String.valueOf(this.shortDesc) + value;
            return;
        }
        PHPDocTag basicPHPDocTag = new PHPDocTag(this.tagPosition, this.zzStartRead - this.zzPushbackPos, this.currTagId, value, this.getTexts(this.tagPosition, this.zzStartRead, true));
        this.tagList.add(basicPHPDocTag);
    }

    private List<Scalar> getTexts(int start, int end, boolean remove) {
        ArrayList<Scalar> result = new ArrayList<Scalar>();
        Iterator<Scalar> iterator = this.textList.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = iterator.next();
            if (scalar.sourceStart() < start || scalar.sourceEnd() > end) continue;
            result.add(scalar);
            if (!remove) continue;
            iterator.remove();
        }
        return result;
    }

    private void appendText() {
        if (this.oldString != null) {
            this.sBuffer.append(this.oldString);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
        this.addText(sb.toString());
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void addText(String string) {
        this.textList.add(new Scalar(this.startPos, this.startPos + string.length(), string, 2));
    }

    private void hendleDesc() {
        if (this.zzLexicalState == 2) {
            this.shortDesc = this.sBuffer.toString().trim();
        } else {
            this.longDesc = this.sBuffer.toString().trim();
        }
        this.sBuffer = new StringBuffer();
    }

    private void startLongDescState(boolean withNewLine) {
        this.hendleDesc();
        this.updateStartPos();
        if (!withNewLine) {
            this.addText("");
        }
        this.yybegin(4);
    }

    private void hendleNewLine() {
        this.appendText();
        if (this.numOfLines == 4) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.yybegin(4);
        } else {
            ++this.numOfLines;
        }
    }

    private void appendLastText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos - 2);
        this.addText(sb.toString());
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void handleDocEnd_shortDesc() {
        this.appendLastText();
        if (this.numOfLines == this.maxNumberofLines) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.longDesc = this.sBuffer.toString().trim();
        } else {
            this.shortDesc = this.sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
        this.appendLastText();
        this.longDesc = this.sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        this.appendLastText();
        this.setTagValue();
    }

    private void updateStartPos() {
        this.startPos = this.zzMarkedPos;
        this.oldString = null;
    }

    @Override
    public void reset(Reader reader, char[] buffer, int[] parameters) {
        this.zzReader = reader;
        this.zzBuffer = buffer;
        this.zzMarkedPos = parameters[0];
        this.zzPushbackPos = parameters[1];
        this.zzCurrentPos = parameters[2];
        this.zzStartRead = parameters[3];
        this.zzEndRead = parameters[4];
        this.yyline = parameters[5];
        this.yychar = 0;
        this.yycolumn = 0;
        this.zzAtEOF = parameters[7] != 0;
        this.zzEOFDone = parameters[8] != 0;
        this.zzAtBOL = !this.zzAtEOF;
        this.zzLexicalState = 0;
    }

    @Override
    public int[] getParamenters() {
        return new int[]{this.zzMarkedPos, this.zzPushbackPos, this.zzCurrentPos, this.zzStartRead, this.zzEndRead, this.yyline, this.zzAtBOL ? 1 : 0, this.zzAtEOF ? 1 : 0, this.zzEOFDone ? 1 : 0};
    }

    @Override
    public char[] getBuffer() {
        return this.zzBuffer;
    }

    public DocumentorLexer(Reader in) {
        this.zzReader = in;
    }

    public DocumentorLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 96) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        this.oldString = new String(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.startPos = 0;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block176: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        break;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        break;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        break;
                    }
                    default: {
                        zzR = false;
                    }
                }
                ++zzCurrentPosL;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof2 = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof2) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            if (zzMarkedPosL > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        eof = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 16: {
                    this.startTagsState(11);
                }
                case 84: {
                    continue block176;
                }
                case 44: {
                    this.setNewTag(6);
                }
                case 85: {
                    continue block176;
                }
                case 51: {
                    this.startTagsState(28);
                }
                case 86: {
                    continue block176;
                }
                case 45: {
                    this.setNewTag(4);
                }
                case 87: {
                    continue block176;
                }
                case 68: {
                    this.startTagsState(34);
                }
                case 88: {
                    continue block176;
                }
                case 73: {
                    this.startTagsState(2);
                }
                case 89: {
                    continue block176;
                }
                case 32: {
                    this.startTagsState(14);
                }
                case 90: {
                    continue block176;
                }
                case 13: {
                    this.startTagsState(12);
                }
                case 91: {
                    continue block176;
                }
                case 70: {
                    this.setNewTag(16);
                }
                case 92: {
                    continue block176;
                }
                case 15: {
                    this.setNewTag(12);
                }
                case 93: {
                    continue block176;
                }
                case 42: {
                    this.setNewTag(9);
                }
                case 94: {
                    continue block176;
                }
                case 59: {
                    this.startTagsState(30);
                }
                case 95: {
                    continue block176;
                }
                case 18: {
                    this.startTagsState(17);
                }
                case 96: {
                    continue block176;
                }
                case 63: {
                    this.setNewTag(15);
                }
                case 97: {
                    continue block176;
                }
                case 12: {
                    this.startTagsState(8);
                }
                case 98: {
                    continue block176;
                }
                case 14: {
                    this.setNewTag(8);
                }
                case 99: {
                    continue block176;
                }
                case 50: {
                    this.startTagsState(22);
                }
                case 100: {
                    continue block176;
                }
                case 21: {
                    this.setNewTag(11);
                }
                case 101: {
                    continue block176;
                }
                case 43: {
                    this.setNewTag(29);
                }
                case 102: {
                    continue block176;
                }
                case 65: {
                    this.setNewTag(21);
                }
                case 103: {
                    continue block176;
                }
                case 20: {
                    this.startTagsState(5);
                }
                case 104: {
                    continue block176;
                }
                case 19: {
                    this.startTagsState(23);
                }
                case 105: {
                    continue block176;
                }
                case 17: {
                    this.startTagsState(27);
                }
                case 106: {
                    continue block176;
                }
                case 23: {
                    this.setNewTag(17);
                }
                case 107: {
                    continue block176;
                }
                case 52: {
                    this.setNewTag(18);
                }
                case 108: {
                    continue block176;
                }
                case 9: {
                    this.handleDocEnd_longDesc();
                    return -1;
                }
                case 109: {
                    continue block176;
                }
                case 29: {
                    this.setNewTag(24);
                }
                case 110: {
                    continue block176;
                }
                case 31: {
                    this.setNewTag(3);
                }
                case 111: {
                    continue block176;
                }
                case 83: {
                    this.setNewTag(32);
                }
                case 112: {
                    continue block176;
                }
                case 47: {
                    this.setNewTag(33);
                }
                case 113: {
                    continue block176;
                }
                case 55: {
                    this.setNewTag(28);
                }
                case 114: {
                    continue block176;
                }
                case 38: {
                    this.startTagsState(20);
                }
                case 115: {
                    continue block176;
                }
                case 67: {
                    this.startTagsState(16);
                }
                case 116: {
                    continue block176;
                }
                case 36: {
                    this.startTagsState(6);
                }
                case 117: {
                    continue block176;
                }
                case 69: {
                    this.setNewTag(10);
                }
                case 118: {
                    continue block176;
                }
                case 58: {
                    this.startTagsState(15);
                }
                case 119: {
                    continue block176;
                }
                case 82: {
                    this.startTagsState(32);
                }
                case 120: {
                    continue block176;
                }
                case 49: {
                    this.startTagsState(13);
                }
                case 121: {
                    continue block176;
                }
                case 37: {
                    this.startTagsState(4);
                }
                case 122: {
                    continue block176;
                }
                case 25: {
                    this.setNewTag(5);
                }
                case 123: {
                    continue block176;
                }
                case 26: {
                    this.startTagsState(24);
                }
                case 124: {
                    continue block176;
                }
                case 24: {
                    this.setNewTag(23);
                }
                case 125: {
                    continue block176;
                }
                case 41: {
                    this.setNewTag(1);
                }
                case 126: {
                    continue block176;
                }
                case 22: {
                    this.setNewTag(27);
                }
                case 127: {
                    continue block176;
                }
                case 60: {
                    this.startTagsState(21);
                }
                case 128: {
                    continue block176;
                }
                case 77: {
                    this.setNewTag(19);
                }
                case 129: {
                    continue block176;
                }
                case 61: {
                    this.setNewTag(0);
                }
                case 130: {
                    continue block176;
                }
                case 62: {
                    this.setNewTag(26);
                }
                case 131: {
                    continue block176;
                }
                case 54: {
                    this.setNewTag(22);
                }
                case 132: {
                    continue block176;
                }
                case 11: {
                    this.updateStartPos();
                    this.yybegin(2);
                }
                case 133: {
                    continue block176;
                }
                case 30: {
                    this.setNewTag(7);
                }
                case 134: {
                    continue block176;
                }
                case 3: {
                    this.hendleNewLine();
                }
                case 135: {
                    continue block176;
                }
                case 1: {
                    this.updateStartPos();
                }
                case 136: {
                    continue block176;
                }
                case 28: {
                    this.startTagsState(3);
                }
                case 137: {
                    continue block176;
                }
                case 79: {
                    this.setNewTag(35);
                }
                case 138: {
                    continue block176;
                }
                case 35: {
                    this.startTagsState(29);
                }
                case 139: {
                    continue block176;
                }
                case 40: {
                    this.setNewTag(14);
                }
                case 140: {
                    continue block176;
                }
                case 6: {
                    this.appendText();
                    this.startLongDescState(true);
                }
                case 141: {
                    continue block176;
                }
                case 34: {
                    this.startTagsState(9);
                }
                case 142: {
                    continue block176;
                }
                case 71: {
                    this.setNewTag(34);
                }
                case 143: {
                    continue block176;
                }
                case 4: {
                    this.startLongDescState(false);
                }
                case 144: {
                    continue block176;
                }
                case 75: {
                    this.setNewTag(25);
                }
                case 145: {
                    continue block176;
                }
                case 5: {
                    this.appendText();
                }
                case 146: {
                    continue block176;
                }
                case 81: {
                    this.setNewTag(31);
                }
                case 147: {
                    continue block176;
                }
                case 66: {
                    this.startTagsState(10);
                }
                case 148: {
                    continue block176;
                }
                case 39: {
                    this.startTagsState(33);
                }
                case 149: {
                    continue block176;
                }
                case 27: {
                    this.startTagsState(7);
                }
                case 150: {
                    continue block176;
                }
                case 53: {
                    this.setNewTag(13);
                }
                case 151: {
                    continue block176;
                }
                case 56: {
                    this.startTagsState(0);
                }
                case 152: {
                    continue block176;
                }
                case 57: {
                    this.startTagsState(26);
                }
                case 153: {
                    continue block176;
                }
                case 76: {
                    this.setNewTag(2);
                }
                case 154: {
                    continue block176;
                }
                case 74: {
                    this.startTagsState(19);
                }
                case 155: {
                    continue block176;
                }
                case 33: {
                    this.startTagsState(1);
                }
                case 156: {
                    continue block176;
                }
                case 80: {
                    this.startTagsState(31);
                }
                case 157: {
                    continue block176;
                }
                case 78: {
                    this.startTagsState(35);
                }
                case 158: {
                    continue block176;
                }
                case 7: {
                    this.maxNumberofLines = 4;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 159: {
                    continue block176;
                }
                case 46: {
                    this.setNewTag(20);
                }
                case 160: {
                    continue block176;
                }
                case 64: {
                    this.setNewTag(30);
                }
                case 161: {
                    continue block176;
                }
                case 10: {
                    this.handleDocEnd_inTags();
                    return -1;
                }
                case 162: {
                    continue block176;
                }
                case 72: {
                    this.startTagsState(25);
                }
                case 163: {
                    continue block176;
                }
                case 48: {
                    this.startTagsState(18);
                }
                case 164: {
                    continue block176;
                }
                case 2: 
                case 165: {
                    continue block176;
                }
                case 8: {
                    this.maxNumberofLines = 5;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 166: {
                    continue block176;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return -1;
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java DocumentorLexer <inputfile>");
        } else {
            int i = 0;
            while (i < argv.length) {
                DocumentorLexer scanner = null;
                try {
                    scanner = new DocumentorLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.next_token();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

