/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.IndentationBaseDetector;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.IndentationUtils;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DefaultIndentationStrategy
implements IIndentationStrategy {
    private static final String BLANK = "";
    private static boolean pairArrayParen;
    private static int pairArrayOffset;
    private IndentationObject indentationObject;

    public DefaultIndentationStrategy() {
    }

    public DefaultIndentationStrategy(IndentationObject indentationObject) {
        this.indentationObject = indentationObject;
    }

    private static ITextRegion getLastTokenRegion(IStructuredDocument document, IRegion line, int forOffset) throws BadLocationException {
        int offset = forOffset;
        int lineStartOffset = line.getOffset();
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return null;
        }
        Object tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            if ((tRegion = scriptRegion.getPhpToken(offset - regionStart)) == null) {
                return null;
            }
            do {
                String token = tRegion.getType();
                if (regionStart + tRegion.getStart() >= forOffset || PHPPartitionTypes.isPHPCommentState(token) || token == "WHITESPACE") continue;
                return tRegion;
            } while ((tRegion = tRegion.getStart() >= 1 ? scriptRegion.getPhpToken(tRegion.getStart() - 1) : null) != null && tRegion.getStart() + regionStart > lineStartOffset);
        }
        return null;
    }

    @Override
    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        this.placeMatchingBlanksForStructuredDocument(document, result, lineNumber, forOffset, this.getCommandText());
    }

    public void placeMatchingBlanksForStructuredDocument(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        this.placeMatchingBlanksForStructuredDocument(document, result, lineNumber, forOffset, BLANK);
    }

    private void placeMatchingBlanksForStructuredDocument(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset, String commandText) throws BadLocationException {
        int line;
        int offset;
        int newForOffset;
        int indentationBaseLineIndex;
        int lastNonEmptyLineIndex;
        if (forOffset == 0) {
            return;
        }
        if (this.indentationObject == null) {
            this.indentationObject = new IndentationObject(document);
        }
        boolean enterKeyPressed = document.getLineDelimiter().equals(result.toString());
        int lineOfOffset = document.getLineOfOffset(forOffset);
        IRegion lineInformationOfOffset = document.getLineInformation(lineOfOffset);
        String lineText = document.get(lineInformationOfOffset.getOffset(), lineInformationOfOffset.getLength());
        if (lineText.trim().startsWith("//") && enterKeyPressed) {
            lastNonEmptyLineIndex = lineOfOffset;
            indentationBaseLineIndex = lineOfOffset;
            int i = lineInformationOfOffset.getOffset();
            while (i < lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength() && document.getChar(i) != '/') {
                ++i;
            }
            newForOffset = i < forOffset ? i : forOffset;
        } else {
            newForOffset = forOffset;
            IndentationBaseDetector indentationDetector = new IndentationBaseDetector(document);
            lastNonEmptyLineIndex = indentationDetector.getIndentationBaseLine(lineNumber, newForOffset, false);
            indentationBaseLineIndex = indentationDetector.getIndentationBaseLine(lineNumber, newForOffset, true);
        }
        IRegion lastNonEmptyLine = document.getLineInformation(lastNonEmptyLineIndex);
        IRegion indentationBaseLine = document.getLineInformation(indentationBaseLineIndex);
        String blanks = FormatterUtils.getLineBlanks((IDocument)document, indentationBaseLine);
        result.append(blanks);
        int lastLineEndOffset = lastNonEmptyLine.getOffset() + lastNonEmptyLine.getLength();
        if (newForOffset < lastLineEndOffset) {
            offset = newForOffset;
            line = lineNumber;
        } else {
            offset = lastLineEndOffset;
            line = lastNonEmptyLineIndex;
        }
        if (DefaultIndentationStrategy.shouldIndent(document, offset, line)) {
            DefaultIndentationStrategy.indent(document, result, this.indentationObject.getIndentationChar(), this.indentationObject.getIndentationSize());
        } else {
            boolean intended = DefaultIndentationStrategy.indentMultiLineCase(document, lineNumber, newForOffset, enterKeyPressed, result, blanks, commandText, this.indentationObject);
            if (!intended) {
                int baseLineEndOffset;
                lastNonEmptyLineIndex = lineNumber;
                if (!enterKeyPressed && lastNonEmptyLineIndex > 0) {
                    --lastNonEmptyLineIndex;
                }
                while (lastNonEmptyLineIndex >= 0) {
                    IRegion lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                    String content = document.get(lineInfo.getOffset(), lineInfo.getLength());
                    if (content.trim().length() > 0) break;
                    --lastNonEmptyLineIndex;
                }
                if (!DefaultIndentationStrategy.isEndOfStatement(document, offset, lastNonEmptyLineIndex)) {
                    IRegion lineInfo;
                    if (indentationBaseLineIndex == lastNonEmptyLineIndex) {
                        DefaultIndentationStrategy.placeStringIndentation(document, lastNonEmptyLineIndex, result, this.indentationObject);
                    }
                    boolean shouldNotChangeIndent = false;
                    if (newForOffset != document.getLength()) {
                        char lineStartChar;
                        lineInfo = document.getLineInformation(lineNumber);
                        int nonEmptyOffset = newForOffset;
                        if (!enterKeyPressed && nonEmptyOffset == lineInfo.getOffset()) {
                            nonEmptyOffset = IndentationUtils.moveLineStartToNonBlankChar(document, nonEmptyOffset, lineNumber, false);
                        }
                        if ((lineStartChar = document.getChar(nonEmptyOffset)) == '}' || lineStartChar == ')') {
                            int peer;
                            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, nonEmptyOffset, true);
                            if (lineStartChar == '}') {
                                int peer2 = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '{', '}');
                                if (peer2 != -1) {
                                    shouldNotChangeIndent = true;
                                }
                            } else if (lineStartChar == ']') {
                                int peer3 = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '[', ']');
                                if (peer3 != -1) {
                                    shouldNotChangeIndent = true;
                                }
                            } else if (lineStartChar == ')' && (peer = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '(', ')')) != -1) {
                                shouldNotChangeIndent = true;
                            }
                        }
                    }
                    if (!shouldNotChangeIndent) {
                        result.setLength(result.length() - blanks.length());
                        lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                        result.append(FormatterUtils.getLineBlanks((IDocument)document, lineInfo));
                    }
                } else if (result.length() == blanks.length() && DefaultIndentationStrategy.shouldIndent(document, offset = (baseLineEndOffset = indentationBaseLine.getOffset() + indentationBaseLine.getLength()), line = indentationBaseLineIndex)) {
                    DefaultIndentationStrategy.indent(document, result, this.indentationObject.getIndentationChar(), this.indentationObject.getIndentationSize());
                }
            }
        }
    }

    private static void indent(IStructuredDocument document, StringBuffer result, int indentationChar, int indentationSize) {
        int i = 0;
        while (i < indentationSize) {
            result.append((char)indentationChar);
            ++i;
        }
    }

    private static boolean indentMultiLineCase(IStructuredDocument document, int lineNumber, int offset, boolean enterKeyPressed, StringBuffer result, String blanks, String commandText, IndentationObject indentationObject) {
        block20: {
            block21: {
                PHPHeuristicScanner scanner;
                IRegion region;
                block19: {
                    int peer;
                    String content;
                    block18: {
                        region = document.getLineInformationOfOffset(offset);
                        content = document.get(offset, region.getOffset() + region.getLength() - offset);
                        scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, offset, true);
                        if (!IndentationUtils.inBracelessBlock(scanner, document, offset)) break block18;
                        if (!"{".equals(commandText)) {
                            DefaultIndentationStrategy.indent(document, result, indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                        }
                        return true;
                    }
                    if (!content.trim().startsWith("{")) break block19;
                    int token = scanner.previousToken(offset - 1, -2);
                    if (token == 6 && (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) != -1) {
                        String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(peer));
                        StringBuffer newBuffer = new StringBuffer(newblanks);
                        result.setLength(result.length() - blanks.length());
                        result.append(newBuffer.toString());
                        return true;
                    }
                    break block20;
                }
                try {
                    int parenPeer;
                    if (!DefaultIndentationStrategy.inMultiLine(scanner, document, lineNumber, offset)) break block21;
                    int bound = (parenPeer = scanner.findOpeningPeer(offset - 1, -2, '(', ')')) != -1 ? parenPeer : -2;
                    int bracketPeer = scanner.findOpeningPeer(offset - 1, bound, '[', ']');
                    int peer = Math.max(parenPeer, bracketPeer);
                    if (peer != -1) {
                        int position = peer - 1;
                        int token = scanner.previousToken(position, -2);
                        while (token > 100 || token == 8) {
                            token = scanner.previousToken(--position, -2);
                        }
                        boolean isAssignment = scanner.previousToken(--position, -2) == 14 && scanner.previousToken(position - 1, -2) == 12;
                        token = scanner.previousToken(peer - 1, -2);
                        boolean isArray = token == 1029 || peer == bracketPeer;
                        String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(peer));
                        StringBuffer newBuffer = new StringBuffer(newblanks);
                        pairArrayParen = false;
                        String trimed = document.get(offset, region.getOffset() + region.getLength() - offset).trim();
                        if (enterKeyPressed || !trimed.startsWith(")") && !trimed.startsWith("]")) {
                            if (isArray) {
                                region = document.getLineInformationOfOffset(offset);
                                int arrayBracket = scanner.nextToken(offset, region.getOffset() + region.getLength());
                                if (arrayBracket == 6 || arrayBracket == 4) {
                                    int prev = scanner.previousToken(offset - 1, -2);
                                    if (isAssignment && arrayBracket == 6 && prev != 5 || isAssignment && arrayBracket == 4 && prev != 3) {
                                        DefaultIndentationStrategy.indent(document, newBuffer, 0, indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                                    } else {
                                        DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.getIndentationArrayInitSize(), indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                                        pairArrayParen = true;
                                    }
                                } else {
                                    DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.getIndentationArrayInitSize(), indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                                }
                            } else {
                                DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.getIndentationWrappedLineSize(), indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                            }
                        }
                        result.setLength(result.length() - blanks.length());
                        result.append(newBuffer.toString());
                        if (pairArrayParen) {
                            pairArrayOffset = offset + result.length();
                            result.append(Util.getLineSeparator(null, null));
                            result.append(blanks);
                        }
                        return true;
                    }
                    break block20;
                }
                catch (BadLocationException badLocationException) {}
            }
            int baseLine = DefaultIndentationStrategy.inMultiLineString(document, offset, lineNumber, enterKeyPressed);
            if (baseLine >= 0) {
                String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformation(baseLine));
                StringBuffer newBuffer = new StringBuffer(newblanks);
                DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.getIndentationWrappedLineSize(), indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
                result.setLength(result.length() - blanks.length());
                result.append(newBuffer.toString());
                return true;
            }
        }
        return false;
    }

    private static void indent(IStructuredDocument document, StringBuffer indent, int times, int indentationChar, int indentationSize) {
        int i = 0;
        while (i < times) {
            DefaultIndentationStrategy.indent(document, indent, indentationChar, indentationSize);
            ++i;
        }
    }

    private static boolean inMultiLine(PHPHeuristicScanner scanner, IStructuredDocument document, int lineNumber, int offset) {
        int lineStart = offset;
        try {
            IRegion region = document.getLineInformation(lineNumber);
            char[] line = document.get(lineStart, region.getOffset() + region.getLength() - lineStart).toCharArray();
            int i = 0;
            while (i < line.length) {
                char c = line[i];
                if (!Character.isWhitespace(c)) {
                    lineStart += i + 1;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart, document.getRegionAtCharacterOffset(lineStart), true);
        if (textSequence.length() == 0) {
            return false;
        }
        String regionType = FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0));
        if (IndentationUtils.isRegionTypeAllowedMultiline(regionType)) {
            int parenPeer;
            int statementStart = textSequence.getOriginalOffset(0);
            int bound = statementStart;
            bound = (parenPeer = scanner.findOpeningPeer(offset - 1, bound, '(', ')')) != -1 ? Math.max(parenPeer, bound) : bound;
            int bracketPeer = scanner.findOpeningPeer(offset - 1, bound, '[', ']');
            int peer = Math.max(parenPeer, bracketPeer);
            if (peer == -1) {
                return false;
            }
            if (statementStart < peer) {
                return true;
            }
        }
        return false;
    }

    private static int inMultiLineString(IStructuredDocument document, int offset, int lineNumber, boolean enterKeyPressed) {
        ITextRegion token;
        block5: {
            try {
                IRegion lineInfo = document.getLineInformation(lineNumber);
                document.getRegionAtCharacterOffset(offset);
                token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
                if (token != null) break block5;
                return -1;
            }
            catch (BadLocationException badLocationException) {}
        }
        String tokenType = token.getType();
        if (tokenType == "PHP_CONSTANT_ENCAPSED_STRING") {
            int startLine = document.getLineOfOffset(token.getStart());
            if (enterKeyPressed && startLine <= lineNumber || !enterKeyPressed && startLine < lineNumber) {
                return startLine;
            }
        }
        return -1;
    }

    private static boolean isEndOfStatement(IStructuredDocument document, int offset, int lineNumber) {
        ITextRegion token;
        IRegion lineInfo;
        block6: {
            block5: {
                try {
                    lineInfo = document.getLineInformation(lineNumber);
                    document.getRegionAtCharacterOffset(offset);
                    token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, lineInfo.getOffset() + lineInfo.getLength());
                    if (token != null) break block5;
                    return true;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (token.getType() != "PHP_SEMICOLON" && token.getType() != "PHP_CURLY_CLOSE") break block6;
            return true;
        }
        if (token.getType() == "PHP_HEREDOC_TAG" && document.get(lineInfo.getOffset(), lineInfo.getLength()).trim().endsWith(";")) {
            return true;
        }
        return false;
    }

    private static void placeStringIndentation(IStructuredDocument document, int lineNumber, StringBuffer result, IndentationObject indentationObject) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            int offset = lineInfo.getOffset() + lineInfo.getLength();
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (scriptRegion instanceof IPhpScriptRegion && tokenType == "PHP_TOKEN" && document.getChar(regionStart + token.getStart()) == '.' && (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)) != null && token.getType() == "PHP_CONSTANT_ENCAPSED_STRING") {
                boolean isToken = true;
                int currentOffset = regionStart + token.getStart() - 1;
                while (currentOffset >= lineInfo.getOffset()) {
                    token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1);
                    tokenType = token.getType();
                    if ((!isToken || tokenType != "PHP_TOKEN" || document.getChar(regionStart + token.getStart()) != '.') && (isToken || tokenType != "PHP_CONSTANT_ENCAPSED_STRING")) break;
                    currentOffset = regionStart + token.getStart() - 1;
                }
                DefaultIndentationStrategy.indent(document, result, indentationObject.getIndentationWrappedLineSize(), indentationObject.getIndentationChar(), indentationObject.getIndentationSize());
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean shouldIndent(IStructuredDocument document, int offset, int lineNumber) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return false;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return true;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (!(scriptRegion instanceof IPhpScriptRegion)) return false;
            if (tokenType != "PHP_TOKEN") return false;
            if (document.getChar(regionStart + token.getStart()) != ':') return false;
            int currentOffset = regionStart + token.getStart() - 1;
            while (true) {
                if (currentOffset < lineInfo.getOffset()) {
                    return false;
                }
                tokenType = (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)).getType();
                if (tokenType == "PHP_CASE") return true;
                if (tokenType == "PHP_DEFAULT") {
                    return true;
                }
                currentOffset = regionStart + token.getStart() - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected String getCommandText() {
        return BLANK;
    }

    public static int getPairArrayOffset() {
        if (pairArrayParen) {
            return pairArrayOffset;
        }
        return -1;
    }

    public static boolean getPairArrayParen() {
        return pairArrayParen;
    }

    public static void unsetPairArrayParen() {
        pairArrayParen = false;
    }
}

