/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    public static final String BRACKETS = "[]";
    public static final Pattern ARRAY_TYPE_PATTERN = PHPEvaluationUtils.ARRAY_TYPE_PATTERN;
    private static final String SPLASH = "\\";
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        int n;
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        TypeContext context = (TypeContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        int offset = typedGoal.getOffset();
        IModelAccessCache cache = context.getCache();
        IType[] types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context, offset, cache);
        HashMap<PHPDocBlock, IField> docs = new HashMap<PHPDocBlock, IField>();
        if (types != null) {
            int index;
            if (variableName.endsWith("]") && (index = variableName.indexOf("[")) != -1) {
                variableName = variableName.substring(0, index);
            }
            IType[] iTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                block19: {
                    IType type = iTypeArray[n3];
                    try {
                        IType[] superTypes;
                        ITypeHierarchy superHierarchy = cache != null ? cache.getSuperTypeHierarchy(type, null) : type.newSupertypeHierarchy(null);
                        IType[] iTypeArray2 = superTypes = superHierarchy.getAllTypes();
                        int n4 = superTypes.length;
                        n = 0;
                        while (n < n4) {
                            PHPDocBlock docBlock;
                            IType superType = iTypeArray2[n];
                            IField[] typeField = PHPModelUtils.getTypeField(superType, variableName, true);
                            if (typeField.length > 0 && (docBlock = PHPModelUtils.getDocBlock(typeField[0])) != null) {
                                docs.put(docBlock, typeField[0]);
                            }
                            ++n;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block19;
                        e.printStackTrace();
                    }
                }
                ++n3;
            }
        }
        for (Map.Entry entry : docs.entrySet()) {
            PHPDocBlock doc = (PHPDocBlock)((Object)entry.getKey());
            IField typeField = (IField)entry.getValue();
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)typeField);
            PHPDocTag[] pHPDocTagArray = doc.getTags();
            n = pHPDocTagArray.length;
            int n5 = 0;
            while (n5 < n) {
                PHPDocTag tag = pHPDocTagArray[n5];
                if (tag.getTagKind() == 12) {
                    SimpleReference[] references;
                    SimpleReference[] simpleReferenceArray = references = tag.getReferences();
                    int n6 = references.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        SimpleReference ref = simpleReferenceArray[n7];
                        String typeName = ref.getName();
                        IEvaluatedType evaluatedType = PHPEvaluationUtils.extractArrayType(typeName, currentNamespace, tag.sourceStart());
                        if (evaluatedType != null) {
                            this.evaluated.add(evaluatedType);
                        } else {
                            IEvaluatedType type;
                            if (currentNamespace != null) {
                                String fullName;
                                Map<String, UsePart> result;
                                String prefix;
                                if (typeName.indexOf(SPLASH) > 0) {
                                    prefix = typeName.substring(0, typeName.indexOf(SPLASH));
                                    result = PHPModelUtils.getAliasToNSMap(prefix, context.getRootNode(), doc.sourceStart(), currentNamespace, true);
                                    if (result.containsKey(prefix) && (typeName = typeName.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                        typeName = String.valueOf('\\') + typeName;
                                    }
                                } else if (typeName.indexOf(SPLASH) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, context.getRootNode(), doc.sourceStart(), currentNamespace, true)).containsKey(prefix) && (typeName = (fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                    typeName = String.valueOf('\\') + typeName;
                                }
                            }
                            if ((type = PHPEvaluationUtils.getEvaluatedType(typeName, currentNamespace)) != null) {
                                this.evaluated.add(type);
                            }
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        return PHPEvaluationUtils.getArrayType(type, currentNamespace, offset);
    }
}

