/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.debug.core.IPHPDebugConstants;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PHPDebugPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.core";
    public static final int INTERNAL_ERROR = 10001;
    public static final int INTERNAL_WARNING = 10002;
    private static PHPDebugPlugin plugin;
    private static final String BASE_URL = "http://localhost";
    private static boolean fIsSupportingMultipleDebugAllPages;
    private boolean fInitialAutoRemoveLaunches;
    private static boolean fLaunchChangedAutoRemoveLaunches;
    public static final boolean DEBUG;

    static {
        fIsSupportingMultipleDebugAllPages = true;
        DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.php.debug.core/debug"));
    }

    public PHPDebugPlugin() {
        plugin = this;
        this.getBundle().getBundleContext().addBundleListener((BundleListener)new PostStart());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        XDebugLaunchListener.shutdown();
        DBGpProxyHandler.instance.unregister();
        this.savePluginPreferences();
        super.stop(context);
        plugin = null;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", this.fInitialAutoRemoveLaunches);
    }

    public static PHPDebugPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static boolean getStopAtFirstLine() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
    }

    public static boolean getDebugInfoOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO);
    }

    public static boolean getOpenInBrowserOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER);
    }

    public static String getCurrentDebuggerId() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        String id = prefs.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        if (id == null || id.isEmpty()) {
            return "org.eclipse.php.debug.core.zendDebugger";
        }
        return id;
    }

    public static String getDebuggerId(String serverName) {
        Server server;
        String serverDebuggerId;
        if (serverName != null && (serverDebuggerId = (server = ServersManager.getServer((String)serverName)).getDebuggerId()) != null) {
            return serverDebuggerId;
        }
        return PHPDebugPlugin.getCurrentDebuggerId();
    }

    public static boolean getAutoSaveDirtyOption() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
        if (saveDirty == null) {
            return true;
        }
        return Boolean.valueOf(saveDirty);
    }

    public static boolean getOpenDebugViewsOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS);
    }

    public static int getDebugPort(String debuggerId) {
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
        if (debuggerConfiguration == null) {
            return -1;
        }
        return debuggerConfiguration.getPort();
    }

    public static String getDebugHosts() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        return prefs.getString(PHPDebugCorePreferenceNames.CLIENT_IP);
    }

    public static String getWorkspaceDefaultServer() {
        Preferences serverPrefs = Activator.getDefault().getPluginPreferences();
        return serverPrefs.getString("defaultPHPServer");
    }

    public static void createDefaultPHPServer() {
        if (ServersManager.getServers().length == 0) {
            Server server = null;
            try {
                server = ServersManager.createServer((String)IPHPDebugConstants.Default_Server_Name, (String)BASE_URL);
            }
            catch (MalformedURLException malformedURLException) {}
            ServersManager.save();
            ServersManager.setDefaultServer(null, (Server)server);
        }
    }

    public static void log(IStatus status) {
        try {
            PHPDebugPlugin.getDefault().getLog().log(status);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable e) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, "PHPDebug plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static void logWarningMessage(String message) {
        PHPDebugPlugin.log((IStatus)new Status(2, ID, 10002, message, null));
    }

    public static boolean supportsMultipleDebugAllPages() {
        return fIsSupportingMultipleDebugAllPages;
    }

    public static void setMultipleDebugAllPages(boolean supported) {
        fIsSupportingMultipleDebugAllPages = supported;
    }

    public static void setDisableAutoRemoveLaunches(boolean disableAutoRemoveLaunches) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches") == disableAutoRemoveLaunches) {
            fLaunchChangedAutoRemoveLaunches = true;
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", !disableAutoRemoveLaunches);
        }
    }

    public boolean getInitialAutoRemoveLaunches() {
        return this.fInitialAutoRemoveLaunches;
    }

    public static IDebugTarget getActiveDebugTarget() {
        IProcess process;
        IDebugElement element;
        IDebugTarget debugTarget = null;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null && (element = (IDebugElement)adaptable.getAdapter(IDebugElement.class)) != null) {
            debugTarget = element.getDebugTarget();
        }
        if (debugTarget == null && (process = DebugUITools.getCurrentProcess()) instanceof PHPProcess) {
            debugTarget = ((PHPProcess)process).getDebugTarget();
        }
        return debugTarget;
    }

    public static IRemoteDebugger getActiveRemoteDebugger() {
        IDebugTarget debugTarget = PHPDebugPlugin.getActiveDebugTarget();
        if (debugTarget != null && debugTarget instanceof PHPDebugTarget) {
            PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
            return phpDebugTarget.getRemoteDebugger();
        }
        return null;
    }

    public static String getCurrentDebuggerId(IProject project) {
        PHPVersion phpVersion;
        if (project != null && (phpVersion = ProjectOptions.getPhpVersion((IProject)project)) != null) {
            return PHPDebugPlugin.getCurrentDebuggerId(phpVersion);
        }
        return PHPDebugPlugin.getCurrentDebuggerId();
    }

    public static String getCurrentDebuggerId(PHPVersion phpVersion) {
        PHPexeItem item = PHPexes.getInstance().getDefaultItemForPHPVersion(phpVersion);
        if (item != null) {
            return item.getDebuggerID();
        }
        return PHPDebugPlugin.getCurrentDebuggerId();
    }

    public static PHPexeItem getPHPexeItem(IProject project) {
        if (project != null) {
            String phpExe;
            IEclipsePreferences node = PHPDebugPlugin.createPreferenceScopes(project)[0].getNode(PHPProjectPreferences.getPreferenceNodeQualifier());
            if (node != null && (phpExe = node.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, null)) != null) {
                return PHPexes.getInstance().getItem(phpExe);
            }
            PHPVersion phpVersion = ProjectOptions.getPhpVersion((IProject)project);
            if (phpVersion != null) {
                return PHPDebugPlugin.getPHPexeItem(phpVersion);
            }
        }
        return PHPDebugPlugin.getWorkspaceDefaultExe();
    }

    public static PHPexeItem getPHPexeItem(PHPVersion phpVersion) {
        PHPexeItem item = PHPexes.getInstance().getDefaultItemForPHPVersion(phpVersion);
        if (item != null) {
            return item;
        }
        return PHPDebugPlugin.getWorkspaceDefaultExe();
    }

    public static PHPexeItem getWorkspaceDefaultExe() {
        String exeName;
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        if (prefs != null && (exeName = prefs.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP)) != null && !exeName.isEmpty()) {
            return PHPexes.getInstance().getItem(exeName);
        }
        PHPexeItem item = PHPexes.getInstance().getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
        if (item == null) {
            PHPexeItem[] items;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem phpExeItem = pHPexeItemArray[n2];
                if (phpExeItem.isDefault()) {
                    return phpExeItem;
                }
                ++n2;
            }
        } else {
            return item;
        }
        return null;
    }

    public static IScopeContext[] createPreferenceScopes(IProject project) {
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    private class AutoRemoveOldLaunchesListener
    implements IPropertyChangeListener {
        private AutoRemoveOldLaunchesListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.debug.ui.auto_remove_old_launches".equals(event.getProperty())) {
                if (fLaunchChangedAutoRemoveLaunches) {
                    fLaunchChangedAutoRemoveLaunches = false;
                } else {
                    PHPDebugPlugin.this.fInitialAutoRemoveLaunches = Boolean.valueOf(event.getNewValue().toString());
                }
            }
        }
    }

    private class PostStart
    implements BundleListener {
        private PostStart() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() == PHPDebugPlugin.this.getBundle() && event.getType() == 2) {
                Job handler = new Job(PHPDebugCoreMessages.PHPDebugPlugin_PostStartup){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(PHPDebugCoreMessages.PHPDebugPlugin_PerformingPostStartupOperations, -1);
                                PostStart.this.perform();
                            }
                            catch (Exception e) {
                                Logger.logException(MessageFormat.format("Errors occurred while performing ''{0}'' bundle post startup.", PHPDebugPlugin.ID), e);
                                PHPDebugPlugin.this.getBundle().getBundleContext().removeBundleListener((BundleListener)PostStart.this);
                                monitor.done();
                            }
                        }
                        finally {
                            PHPDebugPlugin.this.getBundle().getBundleContext().removeBundleListener((BundleListener)PostStart.this);
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                handler.setUser(false);
                handler.setSystem(true);
                handler.schedule();
            }
        }

        private void perform() {
            IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
            PHPDebugPlugin.this.fInitialAutoRemoveLaunches = preferenceStore.getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)new AutoRemoveOldLaunchesListener());
            Activator.getDefault();
            PHPDebugPlugin.createDefaultPHPServer();
            XDebugPreferenceMgr.setDefaults();
            XDebugLaunchListener.getInstance();
            DBGpProxyHandler.instance.configure();
            DaemonPlugin.getDefault();
        }
    }
}

