/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.daemon;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;

public abstract class AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    protected Object lock = new Object();
    protected ServerSocket serverSocket;
    protected boolean isAlive;
    protected Thread listenerThread;
    private boolean isInitialized;

    public void init() {
        this.resetSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive && this.serverSocket != null) {
                this.startListenThread();
            } else {
                this.isInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListen() {
        Object object = this.lock;
        synchronized (object) {
            block15: {
                this.isAlive = false;
                if (this.serverSocket != null) {
                    try {
                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                        }
                    }
                    catch (SocketException socketException) {
                        this.serverSocket = null;
                        break block15;
                    }
                    catch (IOException e) {
                        try {
                            Logger.logException("Problem while closing the debugger ServerSocket.", e);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.serverSocket = null;
                        }
                    }
                    this.serverSocket = null;
                }
            }
        }
        try {
            if (this.listenerThread != null) {
                this.listenerThread.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAlive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resetSocket() {
        this.stopListen();
        int port = this.getReceiverPort();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.serverSocket = new ServerSocket(port);
                this.startListen();
                return true;
            }
        }
        catch (BindException bindException) {
            this.handleMultipleBindingError();
            return false;
        }
        catch (IOException e) {
            Logger.logException("Error while restting the socket for the debug requests.", e);
        }
        return false;
    }

    public void handleMultipleBindingError() {
        int port = this.getReceiverPort();
        Logger.log(4, "The debug port " + port + " is in use. Please select a different port for the debugger.");
    }

    public abstract int getReceiverPort();

    protected abstract void startConnection(Socket var1);

    public abstract String getDebuggerID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListenThread() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive) {
                return;
            }
            this.isAlive = true;
        }
        String port = " - Port: " + (this.serverSocket != null ? String.valueOf(this.serverSocket.getLocalPort()) : "??");
        this.listenerThread = new Thread((Runnable)new ReceiverThread(), "PHP Debugger Daemon Thread " + port);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInitialized;
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private class ReceiverThread
    implements Runnable {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractDebuggerCommunicationDaemon.this.isInitialized = true;
            try {
                while (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                    Socket socket = AbstractDebuggerCommunicationDaemon.this.serverSocket.accept();
                    socket.setReceiveBufferSize(131072);
                    socket.setSendBufferSize(131072);
                    AbstractDebuggerCommunicationDaemon.this.startConnection(socket);
                }
            }
            catch (IOException e) {
                Object object = AbstractDebuggerCommunicationDaemon.this.lock;
                synchronized (object) {
                    if (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                        Logger.logException("Error while listening to incoming debug requests. Listen thread terminated!", e);
                        AbstractDebuggerCommunicationDaemon.this.isAlive = false;
                    }
                }
            }
        }
    }
}

