/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.XDebugExeLaunchConfigurationDelegate;
import org.eclipse.php.internal.debug.core.launching.XDebugWebLaunchConfigurationDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugConfigurationDialog;
import org.eclipse.swt.widgets.Shell;

public class XDebugDebuggerConfiguration
extends AbstractDebuggerConfiguration {
    private static final String REMOTE_ENABLE = "remote_enable";
    private static final String EXTENSION_MODULE_ID = "Xdebug";

    @Override
    public String getModuleId() {
        return EXTENSION_MODULE_ID;
    }

    @Override
    public void openConfigurationDialog(Shell parentShell) {
        new XDebugConfigurationDialog(this, parentShell).open();
    }

    @Override
    public int getPort() {
        return XDebugPreferenceMgr.getPort(this.preferences);
    }

    @Override
    public void setPort(int port) {
        XDebugPreferenceMgr.setPort(this.preferences, port);
    }

    @Override
    public String getScriptLaunchDelegateClass() {
        return XDebugExeLaunchConfigurationDelegate.class.getName();
    }

    @Override
    public String getWebLaunchDelegateClass() {
        return XDebugWebLaunchConfigurationDelegate.class.getName();
    }

    @Override
    public void applyDefaults() {
        XDebugPreferenceMgr.applyDefaults(this.preferences);
        this.save();
    }

    @Override
    public IStatus validate(PHPexeItem item) {
        block6: {
            File executable = item.getExecutable();
            try {
                PHPexes.changePermissions(executable);
                if (this.isInstalled(item, EXTENSION_MODULE_ID)) {
                    String output = null;
                    File iniFile = item.getINILocation();
                    output = iniFile != null ? PHPExeUtil.exec(executable.getAbsolutePath(), "-c", iniFile.getAbsolutePath(), "--ri", EXTENSION_MODULE_ID) : PHPExeUtil.exec(executable.getAbsolutePath(), "--ri", EXTENSION_MODULE_ID);
                    if (output != null) {
                        String[] properties;
                        String[] stringArray = properties = output.split("\n");
                        int n = properties.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String value;
                            String property = stringArray[n2];
                            String[] columns = property.split("=>");
                            if (columns.length == 3 && "Xdebug.remote_enable".equals(columns[0].trim()) && !"on".equalsIgnoreCase(value = columns[1].trim())) {
                                return new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.XDebugDebuggerConfiguration_XDebugNotEnabledError);
                            }
                            ++n2;
                        }
                    }
                    break block6;
                }
                return new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.XDebugDebuggerConfiguration_XDebugNotInstalledError);
            }
            catch (IOException e) {
                PHPDebugPlugin.log(e);
            }
        }
        return Status.OK_STATUS;
    }
}

