/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.internal.debug.core.zend.debugger.StackVariable;
import org.eclipse.php.internal.debug.core.zend.debugger.StaticMemberExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.StaticsExpression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class DefaultExpressionsManager
implements ExpressionsManager {
    private static final Expression[] EMPTY_VARIABLE_ARRAY = new Expression[0];
    private static final byte[] ILLEGAL_VAR = new byte[]{78};
    private static final String GET_CURRENT_CONTEXT = "eval('if (isset($this)) {$this;}; return array_merge(get_defined_vars(), array(constant(\\'__CLASS__\\')));')";
    private Debugger debugger;
    private Map<String, Object> hashResultDepthOne = new HashMap<String, Object>();
    private Map<String, byte[]> hashResultDepthZero = new HashMap<String, byte[]>();
    private String[] currentContextPath = new String[]{"eval('if (isset($this)) {$this;}; return array_merge(get_defined_vars(), array(constant(\\'__CLASS__\\')));')"};
    private ExpressionsValueDeserializer expressionValueDeserializer;

    public DefaultExpressionsManager(Debugger debugger, String transferEncoding) {
        this.debugger = debugger;
        this.expressionValueDeserializer = new ExpressionsValueDeserializer(transferEncoding);
    }

    public static ExpressionsManager getCurrent() {
        IDebugTarget debugTarget = PHPDebugPlugin.getActiveDebugTarget();
        if (debugTarget != null && debugTarget instanceof PHPDebugTarget) {
            PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
            return phpDebugTarget.getExpressionManager();
        }
        return null;
    }

    @Override
    public byte[] getExpressionValue(Expression expression, int depth) {
        if (!this.debugger.isActive()) {
            return ILLEGAL_VAR;
        }
        if (expression instanceof StackVariable) {
            return this.getStackVariableValue((StackVariable)expression, depth);
        }
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        return this.getVariableValue(name, depth);
    }

    @Override
    public boolean assignValue(Expression expression, String value, int depth) {
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        boolean status = true;
        if (expression instanceof StaticMemberExpression) {
            String member = expression.getLastName();
            DefaultExpression changeStatic = new DefaultExpression(MessageFormat.format("eval(''self::${0}={1};'')", member, value));
            this.update(changeStatic, 1);
        } else {
            status = this.debugger.assignValue(name[0], value, depth, path);
        }
        byte[] eValue = this.debugger.getVariableValue(name[0], depth, path);
        if (status) {
            String key = DefaultExpressionsManager.buildKey(name);
            if (depth == 1) {
                this.hashResultDepthOne.put(key, eValue);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, eValue);
            }
        }
        return status;
    }

    @Override
    public Expression[] getCurrentVariables(int depth) {
        byte[] value = this.getVariableValue(this.currentContextPath, depth);
        ExpressionValue variableValue = this.expressionValueDeserializer.deserializer(null, value);
        Expression[] variables = variableValue.getOriChildren();
        if (variables == null) {
            variables = EMPTY_VARIABLE_ARRAY;
        }
        boolean hasThis = false;
        ArrayList<Expression> currentVariables = new ArrayList<Expression>();
        int i = 0;
        while (i < variables.length - 1) {
            String s = variables[i].getFullName();
            if (!s.equals("$GLOBALS")) {
                if (s.equals("$this")) {
                    hasThis = true;
                }
                currentVariables.add(variables[i]);
            }
            ++i;
        }
        Expression dummyClass = variables[variables.length - 1];
        String className = (String)dummyClass.getValue().getValue();
        if (!hasThis && className != null && !className.isEmpty()) {
            StaticsExpression statics = new StaticsExpression(className);
            this.update(statics, 1);
            Expression[] staticVariables = statics.getValue().getChildren();
            if (staticVariables != null) {
                currentVariables.addAll(Arrays.asList(staticVariables));
            }
        }
        variables = currentVariables.toArray(new Expression[currentVariables.size()]);
        this.hashResultDepthOne.put("LOCALS", variables);
        return variables;
    }

    @Override
    public Expression buildExpression(String name) {
        return new DefaultExpression(name);
    }

    @Override
    public void update(Expression expression, int depth) {
        byte[] value = this.getExpressionValue(expression, depth);
        expression.setValue(this.expressionValueDeserializer.deserializer(expression, value));
    }

    private byte[] getVariableValue(String[] name, int depth) {
        String key = DefaultExpressionsManager.buildKey(name);
        if (this.hashResultDepthOne.containsKey(key)) {
            return (byte[])this.hashResultDepthOne.get(key);
        }
        if (depth == 0 && this.hashResultDepthZero.containsKey(key)) {
            return this.hashResultDepthZero.get(key);
        }
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        byte[] value = this.debugger.getVariableValue(name[0], depth, path);
        if (value != null) {
            if (depth == 1) {
                this.hashResultDepthOne.put(key, value);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, value);
            }
        } else {
            value = new byte[]{78};
        }
        return value;
    }

    private byte[] getStackVariableValue(StackVariable variable, int depth) {
        int layer = variable.getStackDepth();
        String[] name = variable.getName();
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        return this.debugger.getStackVariableValue(layer, name[0], depth, path);
    }

    private static String buildKey(String[] name) {
        StringBuffer buffer = new StringBuffer(name.length * 5);
        int i = 0;
        while (i < name.length) {
            buffer.append(name[i]);
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    private static String[] minimizeArray(String[] name) {
        String firstName = name[0];
        if (firstName.startsWith("$GLOBALS[GLOBALS]")) {
            name[0] = firstName = "$GLOBALS" + firstName.substring(17);
            return DefaultExpressionsManager.minimizeArray(name);
        }
        if (name.length < 2) {
            return name;
        }
        if (name[0].equals("get_defined_vars()") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = "$GLOBALS";
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        if (name[0].equals("$GLOBALS") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = name[0];
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        return name;
    }
}

