/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.StaticsExpression;

public class ObjectExpressionValue
extends ExpressionValue {
    private boolean extended = false;

    public ObjectExpressionValue(Object value, String valueAsString, Expression[] children) {
        super(OBJECT_TYPE, value, valueAsString, children);
    }

    @Override
    public Expression[] getOriChildren() {
        if (!this.extended) {
            this.prependStatics();
        }
        return this.children;
    }

    protected void prependStatics() {
        ArrayList<Expression> extension = new ArrayList<Expression>();
        Expression[] statics = this.fetchStatics();
        if (statics != null) {
            extension.addAll(Arrays.asList(statics));
        }
        if (this.children != null) {
            extension.addAll(Arrays.asList(this.children));
        }
        this.children = extension.toArray(new Expression[extension.size()]);
        this.extended = true;
    }

    protected Expression[] fetchStatics() {
        String className = (String)this.getValue();
        ExpressionsManager expressionsManager = DefaultExpressionsManager.getCurrent();
        if (expressionsManager != null) {
            StaticsExpression statics = new StaticsExpression(className);
            expressionsManager.update(statics, 1);
            return statics.getValue().getChildren();
        }
        return null;
    }
}

