/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.w3c.dom.Node;

public class XDebugTextHover
extends AbstractScriptEditorTextHover
implements IPHPTextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion == null || textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof DBGpStackFrame) {
            DBGpStackFrame context = (DBGpStackFrame)adaptable;
            int offset = hoverRegion.getOffset();
            IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
            ITextRegion region = null;
            if (flatNode != null) {
                region = flatNode.getRegionAtCharacterOffset(offset);
            }
            IStructuredDocumentRegion container = flatNode;
            if (region instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)region;
                region = container.getRegionAtCharacterOffset(offset);
            }
            if (region.getType() == "PHP_CONTENT") {
                String regionType;
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)region;
                try {
                    region = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - region.getStart());
                }
                catch (BadLocationException badLocationException) {
                    region = null;
                }
                if (region != null && ((regionType = region.getType()) == "PHP_VARIABLE" || regionType == "PHP_THIS")) {
                    String variable = null;
                    try {
                        variable = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (variable != null) {
                            variable = variable.trim();
                            variable = "<B>" + variable + " = </B>" + this.getPropertyValue(context, variable);
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.logException("Error retrieving the value\n", e);
                    }
                    return variable;
                }
            }
        }
        return null;
    }

    protected String getValueByEval(DBGpTarget debugTarget, String variable) {
        String value = null;
        Node resp = debugTarget.eval(variable);
        if (resp == null) {
            return "";
        }
        DBGpVariable tempVar = new DBGpVariable(debugTarget, resp, "-2");
        IValue val = null;
        try {
            val = tempVar.getValue();
            if (val != null) {
                value = val.getValueString();
            }
        }
        catch (DebugException debugException) {}
        if (value != null && value.length() == 0) {
            value = PHPDebugUIMessages.XDebugHover_empty;
            return value;
        }
        if (value != null) {
            value = value.replaceAll("\t", "    ").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return value;
    }

    protected String getPropertyValue(DBGpStackFrame context, String variable) {
        String value = null;
        DBGpTarget debugTarget = (DBGpTarget)context.getDebugTarget();
        Node resp = debugTarget.getProperty(variable, context.getStackLevel(), 0);
        if (resp == null) {
            return "";
        }
        DBGpVariable tempVar = new DBGpVariable(debugTarget, resp, "-2");
        IValue val = null;
        try {
            val = tempVar.getValue();
            if (val != null) {
                value = val.getValueString();
            }
        }
        catch (DebugException debugException) {}
        if (value != null && value.length() == 0) {
            value = PHPDebugUIMessages.XDebugHover_empty;
            return value;
        }
        if (value != null) {
            value = value.replaceAll("\t", "    ").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return value;
    }

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }
}

