/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtil;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.debug.ui.preferences.phps.NewPHPsComboBlock;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByPHPExecutableLaunchTab";
    private Text debugFileTextField;
    private Button argumentVariablesButton;
    protected Button breakOnFirstLine;
    protected Text fPrgmArgumentsText;
    private boolean enableDebugInfoOption;
    protected boolean enableFileSelection = true;
    protected boolean enableBreakpointSelection = true;
    protected final IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!"org.eclipse.php.debug.core.zendDebugger".equals(PHPExecutableLaunchTab.this.phpsComboBlock.getSelectedDebuggerId())) {
                PHPExecutableLaunchTab.this.setEnableDebugInfoOption(false);
            } else {
                PHPExecutableLaunchTab.this.setEnableDebugInfoOption(true);
            }
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    private Button fileLocationButton = null;
    protected WidgetListener fListener = new WidgetListener();
    private Text locationField;
    protected NewPHPsComboBlock phpsComboBlock = new NewPHPsComboBlock();
    private Button runWithDebugInfo;
    protected SelectionAdapter selectionAdapter;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            stripped.append(element);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    protected void createArgumentComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = PHPDebugUIMessages.PHP_File;
        group.setText(groupName);
        GridLayout layout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        this.debugFileTextField = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.debugFileTextField.setLayoutData((Object)gd);
        this.debugFileTextField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.debugFileTextField, group.getText());
        this.argumentVariablesButton = this.createPushButton((Composite)group, PHPDebugUIMessages.Browse, null);
        gd = (GridData)this.argumentVariablesButton.getLayoutData();
        gd.horizontalSpan = 1;
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    private void createBreakControl(Composite parent) {
        String mode = this.getLaunchConfigurationDialog().getMode();
        if ("debug".equals(mode) && this.enableBreakpointSelection) {
            Group group = new Group(parent, 0);
            group.setText(PHPDebugUIMessages.Breakpoint_Group_Label);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            GridData gridData = new GridData(768);
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)gridData);
            this.breakOnFirstLine = this.createCheckButton((Composite)group, PHPDebugUIMessages.Breakpoint_Group_BreakAtFirstLine);
            this.breakOnFirstLine.addSelectionListener((SelectionListener)this.fListener);
            if (!this.enableBreakpointSelection) {
                this.setEnableBreakpointSelection(this.enableBreakpointSelection);
            }
        }
    }

    public void createControl(Composite parent) {
        if (this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.setEnableDebugInfoOption(true);
        }
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(parent, 768);
        Composite mainComposite = new Composite((Composite)scrolledCompositeImpl, 0);
        this.setControl((Control)scrolledCompositeImpl);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        scrolledCompositeImpl.setContent((Control)mainComposite);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        if (this.enableFileSelection) {
            this.createArgumentComponent(mainComposite);
        }
        this.createArgumentsControl(mainComposite);
        this.createBreakControl(mainComposite);
        this.createDebugInfoComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.locally_debugging_a_php_script");
    }

    protected void createDebugInfoComponent(Composite parent) {
        this.runWithDebugInfo = new Button(parent, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        this.runWithDebugInfo.setLayoutData((Object)new GridData(768));
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.runWithDebugInfo.setVisible(this.enableDebugInfoOption);
    }

    protected void createLocationComponent(Composite parent) {
        Layout layout;
        this.phpsComboBlock.createControl(parent);
        Control control = this.phpsComboBlock.getControl();
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        this.phpsComboBlock.addPropertyChangeListener(this.fPropertyChangeListener);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
    }

    protected void createArgumentsControl(final Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(PHPDebugUIMessages.PHPExecutableLaunchTab_scriptArguments);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        this.fPrgmArgumentsText.setLayoutData((Object)new GridData(1808));
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addControlAccessibleListener((Control)this.fPrgmArgumentsText, group.getText());
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, PHPDebugUIMessages.PHPExecutableLaunchTab_variables, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(PHPExecutableLaunchTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    PHPExecutableLaunchTab.this.fPrgmArgumentsText.insert(variable);
                    PHPExecutableLaunchTab.this.fPrgmArgumentsText.setFont(parent.getFont());
                }
            }
        });
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected PHPexeDescriptor getDefaultPHPexeDescriptor() {
        return null;
    }

    public String getName() {
        return PHPDebugUIMessages.PHPExecutableLaunchTab_2;
    }

    protected PHPexeDescriptor getSpecificPHPexeDescriptor() {
        return null;
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    private void handleChangeFileToDebug(Text textField) {
        IResource resource = LaunchUtilities.getFileFromDialog(null, this.getShell(), LaunchUtil.getFileExtensions(), LaunchUtil.getRequiredNatures(), true);
        if (resource instanceof IFile) {
            textField.setText(resource.getFullPath().toString());
            String fileLocation = "";
            IPath location = resource.getLocation();
            fileLocation = location != null ? location.toOSString() : resource.getFullPath().toString();
            textField.setData((Object)fileLocation);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateLocation(configuration);
        if (this.enableDebugInfoOption) {
            this.updateDebugInfoOption(configuration);
        }
        if (this.enableFileSelection) {
            this.updateArgument(configuration);
        }
        try {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
            this.fPrgmArgumentsText.setText(configuration.getAttribute("exeDebugArguments", ""));
        }
        catch (CoreException e) {
            Logger.log(4, "Error reading configuration", e);
        }
        this.isValid(configuration);
        this.updatePHPFromConfig(configuration);
    }

    protected void updatePHPFromConfig(ILaunchConfiguration config) {
        if (this.enableFileSelection) {
            this.phpsComboBlock.setProject(this.getFileProject(this.debugFileTextField.getText()));
        }
        try {
            String path = config.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
            if (path != null) {
                this.phpsComboBlock.setPath(Path.fromPortableString((String)path));
            }
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        try {
            PHPexeItem phpExeItem;
            String exeProgramArgs;
            String phpExe = launchConfig.getAttribute("ATTR_LOCATION", "");
            boolean phpExeExists = true;
            try {
                File file = new File(phpExe);
                if (!file.exists()) {
                    phpExeExists = false;
                }
            }
            catch (NullPointerException nullPointerException) {
                phpExeExists = false;
            }
            if (!phpExeExists) {
                this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                return false;
            }
            if (this.enableFileSelection) {
                String phpFile = launchConfig.getAttribute("ATTR_FILE", "");
                if (FileUtils.resourceExists((String)phpFile)) {
                    IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
                    if (fileToData.getType() != 1 || !PHPToolkitUtil.isPhpFile((IFile)((IFile)fileToData))) {
                        this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                        return false;
                    }
                    String dataLocation = "";
                    dataLocation = fileToData.getLocation() == null ? fileToData.getFullPath().toString() : fileToData.getLocation().toOSString();
                    this.debugFileTextField.setData((Object)dataLocation);
                } else {
                    if (!new File(phpFile).exists()) {
                        this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
                        return false;
                    }
                    if (!PHPToolkitUtil.hasPhpExtention((String)phpFile)) {
                        this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                        return false;
                    }
                }
            }
            String string = exeProgramArgs = this.fPrgmArgumentsText != null ? this.fPrgmArgumentsText.getText() : null;
            if (exeProgramArgs == null) {
                exeProgramArgs = launchConfig.getAttribute("exeDebugArguments", "");
            }
            if (exeProgramArgs.isEmpty()) return true;
            PHPexeItem pHPexeItem = phpExeItem = this.phpsComboBlock != null ? this.phpsComboBlock.getPHPexe() : null;
            if (phpExeItem == null) {
                String storedPHPexePath = launchConfig.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
                phpExeItem = storedPHPexePath != null ? PHPRuntime.getPHPexeItem((IPath)Path.fromPortableString((String)storedPHPexePath)) : null;
            }
            if (phpExeItem == null) return true;
            if ("CLI".equals(phpExeItem.getSapiType())) return true;
            this.setWarningMessage(PHPDebugUIMessages.PHPExecutableLaunchTab_argumentsWillNotBePassed);
            return true;
        }
        catch (CoreException coreException) {}
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scriptArguments;
        if (this.phpsComboBlock.isDefaultPHP()) {
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        } else {
            IPath containerPath = this.phpsComboBlock.getPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", portablePath);
        }
        String debuggerID = this.phpsComboBlock.getSelectedDebuggerId();
        String selectedExecutable = this.phpsComboBlock.getSelectedExecutablePath();
        if (selectedExecutable.length() == 0) {
            configuration.setAttribute("ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_LOCATION", selectedExecutable);
        }
        String iniPath = this.phpsComboBlock.getSelectedIniPath();
        if (iniPath.length() == 0) {
            configuration.setAttribute("ATTR_INI_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
        }
        configuration.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        String arguments = null;
        if (!this.enableFileSelection || (arguments = this.debugFileTextField.getText().trim()).length() == 0) {
            configuration.setAttribute("ATTR_FILE", null);
            configuration.setAttribute("ATTR_FILE_FULL_PATH", null);
        } else {
            configuration.setAttribute("ATTR_FILE", arguments);
            configuration.setAttribute("ATTR_FILE_FULL_PATH", this.debugFileTextField.getData().toString());
        }
        boolean debugInfo = this.enableDebugInfoOption ? this.runWithDebugInfo != null && this.runWithDebugInfo.getSelection() : true;
        configuration.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", debugInfo);
        if (this.breakOnFirstLine != null) {
            configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
        configuration.setAttribute("exeDebugArguments", (scriptArguments = this.fPrgmArgumentsText.getText().trim()).length() > 0 ? scriptArguments : null);
        this.applyLaunchDelegateConfiguration(configuration);
    }

    private IProject getFileProject(String phpFile) {
        if (FileUtils.resourceExists((String)phpFile)) {
            IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
            return fileToData.getProject();
        }
        return null;
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        String debuggerID = null;
        try {
            debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerID);
            configuration.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String executableLocation = configuration.getAttribute("ATTR_LOCATION", "");
            if (executableLocation.equals("")) {
                PHPexes phpExes = PHPexes.getInstance();
                PHPexeItem phpExeItem = phpExes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
                if (phpExeItem == null) {
                    return;
                }
                executableLocation = phpExeItem.getExecutable().toString();
                configuration.setAttribute("ATTR_LOCATION", executableLocation);
                String iniPath = phpExeItem.getINILocation() != null ? phpExeItem.getINILocation().toString() : null;
                configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
                configuration.setAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine());
                this.applyLaunchDelegateConfiguration(configuration);
            }
            configuration.setAttribute("exeDebugArguments", null);
        }
        catch (CoreException e) {
            Logger.log(4, "Error setting default configuration", e);
        }
    }

    public void setEnableDebugInfoOption(boolean enabled) {
        if (enabled == this.enableDebugInfoOption) {
            return;
        }
        if (!this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.enableDebugInfoOption = false;
            return;
        }
        this.enableDebugInfoOption = enabled;
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setVisible(enabled);
        }
    }

    public void setEnableFileSelection(boolean enabled) {
        if (enabled == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = enabled;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(enabled);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setVisible(enabled);
        }
    }

    public void setEnableBreakpointSelection(boolean enabled) {
        if (enabled == this.enableBreakpointSelection) {
            return;
        }
        this.enableBreakpointSelection = enabled;
        if (this.breakOnFirstLine != null) {
            this.breakOnFirstLine.setSelection(enabled);
            this.breakOnFirstLine.setEnabled(enabled);
        }
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        String fullPath = "";
        try {
            arguments = configuration.getAttribute("ATTR_FILE", "");
            fullPath = configuration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException ce) {
            Logger.log(4, "Error reading configuration", ce);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setText(arguments);
            this.debugFileTextField.setData((Object)fullPath);
        }
    }

    protected void updateDebugInfoOption(ILaunchConfiguration configuration) {
        boolean runOption = PHPDebugPlugin.getDebugInfoOption();
        try {
            runOption = configuration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", runOption);
        }
        catch (CoreException e) {
            Logger.log(4, "Error reading configuration", e);
        }
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setSelection(runOption);
        }
    }

    protected void updateLocation(ILaunchConfiguration configuration) {
        String location = "";
        String iniPath = "";
        String debuggerID = "";
        try {
            location = configuration.getAttribute("ATTR_LOCATION", "");
            iniPath = configuration.getAttribute("ATTR_INI_LOCATION", "");
            debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
        }
        catch (CoreException ce) {
            Logger.log(4, "Error reading configuration", ce);
        }
        PHPexes exes = PHPexes.getInstance();
        if (location != null && location.length() > 0) {
            exes.getItemForFile(location, iniPath);
        } else {
            exes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
        }
        if (!PHPDebuggersRegistry.getDebuggersIds().contains(debuggerID)) {
            debuggerID = PHPDebugPlugin.getCurrentDebuggerId();
            exes.getDefaultItem(debuggerID);
        }
        if (!"org.eclipse.php.debug.core.zendDebugger".equals(debuggerID)) {
            this.setEnableDebugInfoOption(false);
        }
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            PHPExecutableLaunchTab.this.phpsComboBlock.setProject(PHPExecutableLaunchTab.this.getFileProject(PHPExecutableLaunchTab.this.debugFileTextField.getText()));
        }

        public void widgetSelected(SelectionEvent e) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (source == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleChangeFileToDebug(PHPExecutableLaunchTab.this.debugFileTextField);
            } else if (source == PHPExecutableLaunchTab.this.breakOnFirstLine) {
                PHPExecutableLaunchTab.this.handleBreakButtonSelected();
            }
        }
    }
}

