/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveFileTestCase0031305 {
    private IProject project1;
    private IFile file;
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        this.file = this.project1.getFile("PHPMoveFileTestCase0031305.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php $phpbb_root_path = './'; include($phpbb_root_path . 'common' );?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        this.project2 = FileUtils.createProject("project2");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testMove() {
        StructuredSelection selection = new StructuredSelection((Object)this.project1.getProject().getFile("PHPMoveFileTestCase0031305.php"));
        PHPMoveProcessor processor = new PHPMoveProcessor((IStructuredSelection)selection);
        processor.setDestination((IContainer)this.project2);
        processor.setUpdateReferences(true);
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
        Assert.assertEquals((long)0L, (long)status.getSeverity());
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
        this.project2.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

