/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Zend Technologies
 *******************************************************************************/
package org.eclipse.php.internal.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.osgi.util.NLS;

public final class PHPUIMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.php.internal.ui.PHPUIMessages"; //$NON-NLS-1$

	private static ResourceBundle fResourceBundle;

	private PHPUIMessages() {
	}

	public static ResourceBundle getResourceBundle() {
		try {
			if (fResourceBundle == null)
				fResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
		} catch (MissingResourceException x) {
			fResourceBundle = null;
		}
		return fResourceBundle;
	}

	public static String CodeAssistPreferencePage_autoActivationDelayPositive;
	public static String IncludePathDialogAccess_ExtZIPArchiveDialog_new_title;
	public static String RemoveBlockComment_description;
	public static String ShowInExplorerViewAction_dialog_title;
	public static String PhpSelectAnnotationRulerAction_GotoAnnotation_image;
	public static String AddDescriptionBlockAction_errorMessage_noAction;
	public static String PHPVersionComboName;
	public static String RefreshAction_error_message;
	public static String ShowInNavigator_label;
	public static String DeleteAction_text;
	public static String ToggleLinkingAction_description;
	public static String NewPHPManualSiteDialog_newTitle;
	public static String PHPEditorHoverConfigurationBlock_showAffordance;
	public static String PHPEditorHoverConfigurationBlock_duplicateModifier;
	public static String Search_FindReferencesAction_BinPrimConstWarnDialog_title;
	public static String PHPWorkingSetPage_projectClosedDialog_title;
	public static String RefreshAction_label;
	public static String PHPSearchQuery_status_ok_message;
	public static String NewPHPManualSiteDialog_siteNotSpecified;
	public static String OpenAction_error_message;
	public static String PHPSearchResultPage_groupby_file;
	public static String PHPEditorPreferencePage_smartCaretPositioning;
	public static String ImplementOccurrencesFinder_label_plural;
	public static String IncludePathContainerDefaultPage_description;
	public static String RefactoringAction_refactoring;
	public static String PHPSearchResultPage_filteredWithCount_message;
	public static String FormatAllAction_tooltip;
	public static String IncludePathProjectsPage_Folders_Label;
	public static String moveAction_error_readOnly;
	public static String IncludePath_AddEntryToBuildPathMessage;
	public static String OverrideIndicatorManager_0;

	public static String OverrideIndicatorManager_open_error_title;
	public static String MarkOccurrencesConfigurationBlock_markImplementors;
	public static String CommentAction_label;
	public static String ColorPage_Phpdoc;
	public static String PHPVersionConfigurationBlock_needsprojectbuild_message;
	public static String JavaScriptSupportGroup_OptionBlockTitle;
	public static String CoreUtility_buildall_taskname;
	public static String CodeTemplateBlock_delegatecomment_label;
	public static String RenamePHPElementAction_exception;
	public static String ProjectsWorkbookPage_projects_add_button;
	public static String ColorPage_Underline;
	public static String PerspectiveManager_Switch_Dialog_Message;
	public static String NewPHPManualSiteDialog_name;
	public static String ToggleCommentAction_1;
	public static String TodoTaskInputDialog_priority_high;
	public static String SearchLabelProvider_exact_singular;
	public static String ToggleCommentAction_0;
	public static String VariableCreationDialog_error_invalidname;
	public static String MarkOccurrencesConfigurationBlock_markBreakContinueTargets;
	public static String DropAdapter_errorMessage;
	public static String IncludePathContainerWizard_pagecreationerror_message;
	public static String PHPInterpreterPreferencePage_description;
	public static String SaveFilesHandler_0;
	public static String Search_FindReadReferencesAction_label;
	public static String NewContainerDialog_error_invalidpath;
	public static String ColorPage_BoundryMaker;
	public static String ToggleCommentAction_label;
	public static String CodeAssistPreferencePage_fillParameterNamesOnMethodCompletion;
	public static String RefreshAction_progressMessage;
	public static String SearchParticipant_error_noID;
	public static String Search_FindOccurrencesInFile_tooltip;
	public static String PHPManual_noManual_msg;
	public static String PHPWorkingSetPage_projectClosedDialog_message;
	public static String PHPManualConfigurationBlock_new;
	public static String group_writeReferences;
	public static String CopyToClipboardAction_text;
	public static String CodeTemplateBlock_getterstub_label;
	public static String CodeAssistPreferencePage_insertSignleProposals;
	public static String NewPHPManualSiteDialog_chooseDir;
	public static String OpenProjectAction_dialog_message;
	public static String NewPHPManualSiteDialog_chooseCHMFile;
	public static String ColorPage_Keyword;
	public static String PHPAnnotationHover_multipleMarkersAtThisLine;
	public static String ColorPage_CodeExample_0;
	public static String PasteSourceReferencesFromClipboardAction_paste1;
	public static String IncludePathContainerDefaultPage_path_error_alreadyexists;
	public static String DefaultPHPFoldingPreferenceBlock_PHPdoc;
	public static String DefaultPHPFoldingPreferenceBlock_header_comments;
	public static String PHPTemplateStore_error_message_nameEmpty;
	public static String PHPBasePreferencePage_description;
	public static String ColorPage_PHPDOCComment;
	public static String VariableCreationDialog_error_invalidpath;
	public static String PHPExplorer_gotoTitle;
	public static String OccurrencesFinder_searchfor;
	public static String RemoveBlockCommentAction_label;
	public static String DefaultPHPFoldingPreferenceBlock_classes;
	public static String PHPProjectOutline_nodes_constants;
	public static String Search_FindOccurrencesInFile_shortLabel;
	public static String PHPElementLabels_concat_string;
	public static String PerspectiveManager_PerspectiveError_Message;
	public static String DropAdapter_errorSame;
	public static String VariableCreationDialog_titlenew;
	public static String PHPVersionGroup_EnableProjectSettings;
	public static String TodoTaskInputDialog_error_noSpace;
	public static String SearchLabelProvider_potential_plural;
	public static String ExceptionOccurrencesFinder_label_plural;
	public static String typingPage_autoClose_string;
	public static String CopyToClipboardAction_0;
	public static String IncludePathContainerDefaultPage_path_error_needssegment;
	public static String CopyToClipboardAction_5;
	public static String CopyToClipboardAction_4;
	public static String ConvertToPDTProjectAction_convert_to_PDT_project_tooltip;
	public static String CoreUtility_buildproject_taskname;
	public static String PHPUIHelp_link_label;
	public static String typingPage_smartPaste_title;
	public static String typingPage_smartTab_title;
	public static String PHPWorkingSetPage_workingSet_content;
	public static String PHPExplorer_removeFilters;
	public static String Search_FindDeclarationAction_tooltip;
	public static String newPhpFile_wizard_templatePage_title;
	public static String IncludePathActionGroup_label;
	public static String WorkingSetConfigurationDialog_down_label;
	public static String CodeAssistPreferencePage_completionOverwrites;
	public static String OpenType_GroupFilterTitle;
	public static String WorkingSetConfigurationDialog_up_label;
	public static String IncludePathsPropertyPage_job_title;
	public static String WorkingSetConfigurationDialog_title;
	public static String PHPEditorPreferencePage_0;
	public static String SearchParticipant_error_noNature;
	public static String VariableCreationDialog_titleedit;
	public static String PHPCreationDataModelProvider_5;
	public static String PHPCreationDataModelProvider_4;
	public static String PHPCreationDataModelProvider_3;
	public static String PHPCreationDataModelProvider_2;
	public static String PHPCreationDataModelProvider_1;
	public static String PHPCreationDataModelProvider_0;
	public static String Search_FindHierarchyDeclarationsAction_tooltip;
	public static String IncludePathVariablesPreferencePage_savechanges_title;
	public static String IncludePathsBlock_tab_projects;
	public static String SelectAllAction_tooltip;
	public static String TodoTaskInputDialog_name_label;
	public static String FiltersDialog_limit_error;
	public static String PhpTemplateNumberVariableResolver_2;
	public static String Search_Error_openEditor_message;
	public static String PHPProjectCreationWizard_Page1Title;
	public static String PHPProjectCreationWizard_PageFacetsTitle;
	public static String PHPSearchResultPage_sortByName;
	public static String newPhpFile_wizard_templatePage_usePhpTemplate;
	public static String ShowInNavigatorView_dialog_title;
	public static String RemoveFromIncludePathAction_remove_from_include_path_desc;
	public static String MarkOccurrencesConfigurationBlock_markFunctionOccurrences;
	public static String FoldingConfigurationBlock_combo_caption;
	public static String IncludePathsBlock_includepath_up_button;
	public static String OpenType_DialogTitle;
	public static String PHPProjectOutline_nodes_classes;
	public static String OpenType_FunctionsFilterCheckboxName;
	public static String PHPTextHover_makeStickyHint;
	public static String HoverFocus_message;
	public static String Search_Error_search_title;
	public static String PHPEditorPreferencePage_folding_title;
	public static String PHPInterpreterPreferencePage_title;
	public static String ColorPage_Number;
	public static String GotoResource_dialog_title;
	public static String IncludePathSourcePage_Folders_Label;
	public static String CopyToClipboardProblemDialog_message;
	public static String PHPOutlinePage_Sort_description;
	public static String NewVariableEntryDialog_info_selected;
	public static String ShowInExplorerViewAction_error_message;
	public static String OccurrencesFinder_label_plural;
	public static String IncludeOccurrencesFinder_0;
	public static String PHPImageLabelprovider_assert_wrongImage;
	public static String CodeTemplateBlock_constructorstub_label;
	public static String NewContainerDialog_error_enterpath;
	public static String PhpSelectAnnotationRulerAction_GotoAnnotation_description;
	public static String RefactoringAction_exception;
	public static String Search_FindImplementorsAction_label;
	public static String TodoTaskConfigurationBlock_markers_tasks_remove_button;
	public static String ToggleComment_label;
	public static String CodeTemplateBlock_createcomment_label;
	public static String ColorPage_Normal;
	public static String IncludePathsBlock_tab_order;
	public static String ToggleLinkingAction_tooltip;
	public static String CodeTemplateBlock_annotationbody_label;
	public static String OpenType_matchingResources;
	public static String PHPWorkingSetPage_warning_resourceMustBeChecked;
	public static String ConvertToPDTProjectAction_convert_to_PDT_project_description;
	public static String Search_FindReferencesAction_tooltip;
	public static String PHPWorkingSetPage_workingSet_name;
	public static String PHPSearchResultPage_sortByPath;
	public static String copyAction_description;
	public static String PhpSelectAnnotationRulerAction_OpenSuperImplementation_tooltip;
	public static String SearchPage_searchFor_constant;
	public static String ViewActionGroup_workingSets_label;
	public static String SelectionScope;
	public static String ConvertToPDTProjectAction_converting_project_job_title;
	public static String NewPHPManualSiteDialog_fileDoesntExist;
	public static String PHPElementAction_typeSelectionDialog_message;
	public static String PHPWorkingSetPage_deselectAll_label;
	public static String IncludePath_RemoveEntryFromIncludePathMessage;
	public static String HoverFocus_decoration;
	public static String CodeTemplateBlock_filecomment_label;
	public static String PHPSearchResultPage_groupby_project;
	public static String PHPProjectOutline_nodes_namespaces;
	public static String IncludePathExplorerNode_label;
	public static String PHPEditorPreferencePage_typing_smartPaste;
	public static String PHPEditorPreferencePage_typing_smartTab;
	public static String SearchParticipant_error_noClass;
	public static String OpenTypeAction_errorTitle;
	public static String PHPAppearancePreferencePage_showMehodsReturnType;
	public static String PHPSearchResultPage_groupby_type;
	public static String IncludePathVariablesPreferencePage_savechanges_message;
	public static String moveAction_label;
	public static String CPListLabelProvider_systemlibrary;
	public static String IncludePathsBlock_includepath_checkall_button;
	public static String IncludePathsBlock_includepath_label;
	public static String PHPExplorer_refactoringTitle;
	public static String SmartTypingConfigurationBlock_tabs_message_tab_text;
	public static String OpenAction_label;
	public static String TodoTaskInputDialog_edit_title;
	public static String MarkOccurrencesConfigurationBlock_markLocalVariableOccurrences;
	public static String CodeTemplateBlock_gettercomment_label;
	public static String deleteAction_confirmReadOnly;
	public static String PHPEditorPreferencePage_prefEditorMessage;
	public static String SearchParticipant_error_classCast;
	public static String OpenFunctionsManualAction_label;
	public static String TextSearchLabelProvider_matchCountFormat;
	public static String BreakContinueTargetFinder_0;
	public static String RemoveFromIncludePathAction_remove_from_include_path_title;
	public static String PhpSelectAnnotationRulerAction_GotoAnnotation_tooltip;
	public static String TodoTaskConfigurationBlock_markers_tasks_priority_column;
	public static String SearchLabelProvider_exact_plural;
	public static String CPListLabelProvider_non_modifiable_attribute;
	public static String IncludePathLibrariesPage_Folders_Label;
	public static String IncludePathDialogAccess_IncludePathFolderDialog_new_title;
	public static String PHPProjectCreationWizard_Page2Title;
	public static String PHPContentOutlineConfiguration_3;
	public static String DragAdapter_refreshing;
	public static String PHPContentOutlineConfiguration_2;
	public static String WorkingSetConfigurationDialog_selectAll_label;
	public static String CPListLabelProvider_container;
	public static String PHPExplorer_title;
	public static String NewContainerDialog_error_pathexists;
	public static String Search_FindReferencesInWorkingSetAction_label;
	public static String CopyToClipboardProblemDialog_title;
	public static String IncludePathDialogAccess_ExistingSourceFolderDialog_new_description;
	public static String PHPEditorHoverConfigurationBlock_insertDelimiterAndModifierAndDelimiter;
	public static String Search_FindDeclarationsInWorkingSetAction_tooltip;
	public static String EditWorkingSetAction_toolTip;
	public static String LocalVariableOccurrencesFinder_1;
	public static String IncludePathContainerDefaultPage_title;
	public static String PHPEditorHoverConfigurationBlock_nameColumnTitle;
	public static String RefreshAction_toolTip;
	public static String PHPFormatterConfigurationBlock_indentSizeLabel;
	public static String PHPFormatterConfigurationBlock_tabSizeLabel;
	public static String PHPFormatterConfigurationBlock_indentWrapLineSizeLabel;
	public static String PHPFormatterConfigurationBlock_indentArrayInitSizeLabel;
	public static String PHPProjectWizardBasePage_1;
	public static String PHPProjectWizardBasePage_0;
	public static String ExceptionOccurrencesFinder_label_singular;
	public static String TodoTaskInputDialog_priority_label;
	public static String PHPExplorer_element_not_present;
	public static String Search_FindWriteReferencesInProjectAction_label;
	public static String GotoMatchingBracket_label;
	public static String OptionalMessageDialog_dontShowAgain;
	public static String CodeTemplateBlock_export_exists_message;
	public static String IncludePathDialogAccess_ExistingPHPFolderDialog_new_description;
	public static String OpenAction_tooltip;
	public static String FiltersDialogAction_label;
	public static String PHPFormatterConfigurationBlock_0;
	public static String PHP_Editor_FoldingMenu_name;
	public static String IncludePath_RemoveEntryTitle;
	public static String SelectionTransferDropAdapter_dialog_title;
	public static String DragAdapter_problemTitle;
	public static String CustomFiltersDialog_filterList_label;
	public static String PHPProjectCreationWizard_Page1Description;
	public static String PHPProjectCreationWizard_PageFacetsDescription;
	public static String typingPage_autoAdd_phpDoc_tags;
	public static String PHPBuildPreferencePage_title;
	public static String PHPOutlineElementComparer_2;
	public static String ToggleLinkingAction_label;
	public static String ProjectsWorkbookPage_chooseProjects_title;
	public static String CodeTemplateBlock_setterstub_label;
	public static String OpenCloseWorkingSetAction_open_label;
	public static String CodeAssistPreferencePage_enableAutoActivation;
	public static String IncludePathInfoPage_Identifier;
	public static String GotoMatchingBracket_error_bracketOutsideSelectedElement;
	public static String OpenWithMenu_label;
	public static String AbstractWorkingSetPage_warning_nameWhitespace;
	public static String PHPSearchOperation_singularOccurrencesPostfix;
	public static String group_occurrences;
	public static String ShowInNavigatorView_error_activation_failed;
	public static String ProjectOutlinePart_1;
	public static String ProjectSelectionDialog_filter;
	public static String CustomFiltersDialog_enableUserDefinedPattern;
	public static String PHPTemplateStore_error_title;
	public static String CodeTemplatesPreferencePage_title;
	public static String WorkspaceScope;
	public static String PHPOutlinePage_mode_mixed;
	public static String EnclosingProjectScope;
	public static String ActionFilterContributorsRegistry_0;
	public static String OpenResource_error_message;
	public static String FormatAllAction_status_description;
	public static String ShowPHPDoc_label;
	public static String FilterDescriptor_filterCreationError_message;
	public static String LayoutGroup_OptionBlock_ProjectSrc;
	public static String PHPExplorer_openWith;
	public static String moveAction_checkMove;
	public static String OpenTypeAction_errorMessage;
	public static String ClearWorkingSetAction_text;
	public static String CustomFiltersDialog_title;
	public static String Search_FindReadReferencesInProjectAction_tooltip;
	public static String PHPElementLabels_declseparator_string;
	public static String IncludePathsBlock_warning_EntryMissing;
	public static String PHPEditorHoverConfigurationBlock_modifierIsNotValidForHover;
	public static String IncludePathDialogAccess_IncludePathFolderDialog_new_description;
	public static String TodoTaskConfigurationBlock_casesensitive_label;
	public static String DragAdapter_problem;
	public static String CodeAssistPreferencePage_caseSensitiveForConstants;
	public static String OverrideIndicatorManager_overrides;
	public static String CPListLabelProvider_twopart;
	public static String ShowInExplorerViewAction_label;
	public static String Search_FindReferencesAction_label;
	public static String RemoveBlockComment_label;
	public static String PHPWorkingSetPage_selectAll_label;
	public static String PHPProjectCreationWizard_Page3Title;
	public static String IncludePathsPropertyPage_unsavedchanges_title;
	public static String Search_FindReadReferencesInProjectAction_label;
	public static String NewPHPManualSiteDialog_windowsCHMFile;
	public static String PhpTemplateVariableResolver_2;
	public static String OccurrencesFinder_label_singular;
	public static String PhpSelectAnnotationRulerAction_OpenSuperImplementation_image;
	public static String PhpSelectAnnotationRulerAction_QuickAssist_image;
	public static String IncludePathDialogAccess_ExtZIPArchiveDialog_edit_title;
	public static String PHPSearchQuery_error_participant_search;
	public static String Search_Error_codeResolve;
	public static String NewVariableEntryDialog_vars_label;
	public static String AbstractWorkingSetPage_warning_nameMustNotBeEmpty;
	public static String PHPOutlinePage_Sort_tooltip;
	public static String CodeAssistPreferencePage_optionsSectionLabel;
	public static String WorkingSetConfigurationDialog_edit_label;
	public static String ProjectsWorkbookPage_chooseProjects_message;
	public static String SearchLabelProvider_exact_noCount;
	public static String CodeTemplateBlock_overridecomment_label;
	public static String ShowInNavigator_error;
	public static String RenamePHPElementAction_not_available;
	public static String SmartTypingConfigurationBlock_tabs_message_others_text;
	public static String PHPFoldingStructureProviderDescriptor_0;
	public static String IncludePathContainerDefaultPage_path_error_invalidpath;
	public static String PHPBasePreferencePage_doubleclick_action;
	public static String IncludePathContainerSelectionPage_description;
	public static String Search_FindImplementorsInProjectAction_tooltip;
	public static String CodeTemplateBlock_methodstub_label;
	public static String IncludePathsBlock_operationdesc_php;
	public static String PasteSourceReferencesFromClipboardAction_exception;
	public static String PHPWorkingSetPage_selectAll_toolTip;
	public static String AbstractOccurrencesFinder_1;
	public static String VariableCreationDialog_name_label;
	public static String AbstractOccurrencesFinder_0;
	public static String PhpTemplateFileResolver_1;
	public static String PhpTemplateFileResolver_0;
	public static String SelectionTransferDropAdapter_error_message;
	public static String CollapseAllAction_description;
	public static String CodeAssistPreferencePage_filtersSectionLabel;
	public static String PHPProjectCreationWizard_details;
	public static String PasteResourcesFromClipboardAction_error_message;
	public static String PhpSelectAnnotationRulerAction_GotoAnnotation_label;
	public static String PHPEditorHoverConfigurationBlock_enabled;
	public static String FoldingConfigurationBlock_error_not_exist;
	public static String ImplementOccurrencesFinder_3;
	public static String CopyResourcesToClipboardAction_copy;
	public static String PHPOutlineContentProvider_0;

	public static String PHPOutlineContentProvider_useStatementsNode;
	public static String PHPSearchResultPage_groupby_file_tooltip;
	public static String RenameAction_text;
	public static String IncludePathsPropertyPage_unsavedchanges_message;
	public static String OverrideIndicatorManager_open_error_message;
	public static String NewWizardsActionGroup_new;
	public static String RefreshAction_error_title;
	public static String PHPManualConfigurationBlock_siteName;
	public static String RemoveFromIncludePathAction_remove_from_include_path_tooltip;
	public static String RefactorActionGroup_no_refactoring_available;
	public static String Search_FindHierarchyDeclarationsAction_label;
	public static String WorkingSetConfigurationDialog_message;
	public static String TodoTaskConfigurationBlock_needsbuild_title;
	public static String IncludePathsBlock_operationdesc_project;
	public static String CodeTemplateBlock_newtype_label;
	public static String WorkingSetConfigurationDialog_deselectAll_label;
	public static String GotoType_error_message;
	public static String PHPFormatterPreferencePage_title;
	public static String FiltersDialog_title;
	public static String SearchPage_searchFor_variable;
	public static String PhpTemplateArrayVariableResolver_2;
	public static String PHPProjectCreationWizard_WizardTitle;
	public static String Search_FindWriteReferencesInProjectAction_tooltip;
	public static String GotoMatchingBracket_error_invalidSelection;
	public static String CodeTemplateBlock_import_extension;
	public static String RenameAction_rename;
	public static String VariablePathDialogField_variabledialog_title;
	public static String DragAdapter_deleting;
	public static String PHPProjectCreationWizard_title;
	public static String OpenResource_error_title;
	public static String IncludePathContainerWizard_new_title;
	public static String PHPVersionGroup_ConfigWorkspaceSettings;
	public static String Search_FindDeclarationsInProjectAction_tooltip;
	public static String PHPBasePreferencePage_doubleclick_gointo;
	public static String RefreshAction_locationDeleted_message;
	public static String PHPEncodingField_0;
	public static String OpenCloseWorkingSetAction_open_error_message;
	public static String PHPFileCreationWizardPage_9;
	public static String PHPFileCreationWizardPage_8;
	public static String PHPFileCreationWizardPage_7;
	public static String PHPFileCreationWizardPage_6;
	public static String PHPFileCreationWizardPage_5;
	public static String IncludePathsPropertyPage_error_message;
	public static String FragmentedWizard_1;
	public static String PHPFileCreationWizardPage_4;
	public static String FragmentedWizard_0;

	public static String FragmentedWizard_7;
	public static String PHPFileCreationWizardPage_3;
	public static String PHPManualPreferencePage_0;
	public static String PHPManualConfigurationBlock_url;
	public static String IncludePathsPropertyPage_unsavedchanges_button_ignore;
	public static String ImplementOccurrencesFinder_label_singular;
	public static String PhpSelectAnnotationRulerAction_QuickAssist_tooltip;
	public static String CodeTemplateBlock_export_filename;
	public static String OverrideIndicatorManager_implements;
	public static String WorkingSetModel_others_name;
	public static String AbstractPHPPropertyPreferencePage_4;
	public static String AbstractPHPPropertyPreferencePage_3;
	public static String PHPPreferencePageBlocksRegistry_0;
	public static String AbstractPHPPropertyPreferencePage_2;
	public static String AbstractPHPPropertyPreferencePage_1;
	public static String AbstractPHPPropertyPreferencePage_0;
	public static String MarkOccurrencesConfigurationBlock_markOccurrences;
	public static String PhpSelectAnnotationRulerAction_QuickFix_image;
	public static String SearchPage_searchFor_function;
	public static String PHPFormatterConfigurationBlock_tabsLabel;
	public static String VariableBlock_job_description;
	public static String Search_FindReadReferencesInWorkingSetAction_tooltip;
	public static String PHPProjectCreationWizard_Page2Description;
	public static String ResourceTransferDragAdapter_cannot_delete_resource;
	public static String DefaultPHPFoldingPreferenceBlock_functions;
	public static String PHPElementAction_typeSelectionDialog_title;
	public static String CodeTemplateBlock_catchblock_label;
	public static String PhpTemplateClassResolver_2;
	public static String PHPExplorer_notFound;
	public static String TodoTaskInputDialog_error_enterName;
	public static String Search_FindReferencesInWorkingSetAction_tooltip;
	public static String SearchPage_searchFor_class;
	public static String IncludePathVariablesPreferencePage_description;
	public static String OpenAction_error_messageBadSelection;
	public static String PHPWorkingSetPage_warning_nameMustNotBeEmpty;
	public static String ShowInNavigatorView_label;
	public static String CodeTemplateBlock_error_read_message;
	public static String FilterDescriptor_filterDescriptionCreationError_message;
	public static String CodeTemplateBlock_classbody_label;
	public static String PHPOutlinePage_Sort_label;
	public static String Search_FindImplementorsInWorkingSetAction_label;
	public static String group_declarations;
	public static String SearchPage_expression_label;
	public static String SourceMenu_label;
	public static String OpenCloseWorkingSetAction_close_error_title;
	public static String MarkOccurrencesConfigurationBlock_title;
	public static String ProjectionModelNodeAdapterFactoryPHP_0;
	public static String Search_FindImplementorsInProjectAction_label;
	public static String PHPProjectCreationWizard_Page3Description;
	public static String PHPSearchOperation_pluralOccurrencesPostfix;
	public static String MultipleFolderSelectionDialog_button;
	public static String EditorUtility_concatModifierStrings;
	public static String ProjectsWorkbookPage_projects_label;
	public static String NewVariableEntryDialog_variable_non_existent_location;
	public static String PasteAction_desc;
	public static String ConvertToPDTProjectAction_convert_to_PDT_project_title;
	public static String SearchElementSelectionDialog_message;
	public static String PHPEngine_searching;
	public static String CodeTemplateBlock_error_parse_message;
	public static String WorkingSetConfigurationDialog_new_label;
	public static String BuildPathsBlock_tab_order;
	public static String PHPEditorHoverConfigurationBlock_keyModifier;
	public static String PHPEditorHoverConfigurationBlock_hoverPreferences;
	public static String MarkOccurrencesConfigurationBlock_markGlobalVariableOccurrences;
	public static String PHPEditorHoverConfigurationBlock_annotationRollover;
	public static String FiltersDialog_description_label;
	public static String PHPProjectWizardFirstPage_localServerLabel;
	public static String PHPSearchResultPage_error_marker;
	public static String ConfigureWorkingSetAction_label;
	public static String VersionGroup_OptionBlock_Title;
	public static String PHPSearchQuery_error_participant_estimate;
	public static String GotoResource_action_label;
	public static String IncludePathVariablesPreferencePage_title;
	public static String group_occurrences_quickMenu_noEntriesAvailable;
	public static String group_search;
	public static String PHPUIHelpContext_phpHelpCategory_label;
	public static String PHPValidator_3;
	public static String PHPValidator_2;
	public static String PHPValidator_1;
	public static String PHPValidator_0;
	public static String ConfigureIncludePathAction_tooltip;
	public static String TodoTaskConfigurationBlock_tasks_default;
	public static String RefactoringAction_disabled;
	public static String PHPUI_defaultDialogMessage;
	public static String PHPRootContextField_0;
	public static String CustomFiltersDialog_DeselectAllButton_label;
	public static String IncludePath_AddEntryTitle;
	public static String CodeTemplateBlock_export_error_hidden;
	public static String CodeAssistPreferencePage_autoActivationDelay;
	public static String FormatAllAction_noundo_title;
	public static String VariableCreationDialog_extdirdialog_message;
	public static String IncludePathContainerWizard_pagecreationerror_title;
	public static String SelectionTransferDropAdapter_error_title;
	public static String RenameAction_unavailable;
	public static String PHPExplorer_filteredDialog_title;
	public static String IncludePathContainerSelectionPage_title;
	public static String IncludePathsBlock_tab_libraries;
	public static String Search_FindWriteReferencesAction_tooltip;
	public static String MarkOccurrencesConfigurationBlock_markConstantOccurrences;
	public static String ImplementOccurrencesFinder_invalidTarget;
	public static String ViewActionGroup_show_label;
	public static String AbstractWorkingSetPage_workingSet_name;
	public static String TodoTaskConfigurationBlock_markers_tasks_normal_priority;
	public static String ShowInExplorerViewAction_tooltip;
	public static String CodeTemplateBlock_preview;
	public static String PhpSelectAnnotationRulerAction_QuickFix_tooltip;
	public static String ManualPart_URL;
	public static String CPListLabelProvider_willbecreated;
	public static String deleteAction_description;
	public static String PHPManualConfigurationBlock_openInNewBrowser;
	public static String PHPOutlinePage_show_groups;
	public static String ExceptionDialog_seeErrorLogMessage;
	public static String PHPVersionConfigurationBlock_needsbuild_title;
	public static String FormatAllAction_operation_description;
	public static String PHPExplorer_filters;
	public static String PHPAppearancePreferencePage_appearanceHeader;
	public static String CodeTemplateBlock_import_title;
	public static String FindOccurrencesEngine_cannotParse_text;
	public static String PHPProjectCreationWizard_LoadPagesFailure;
	public static String ShowInNavigator_description;
	public static String WorkingSetConfigurationDialog_remove_label;
	public static String ResourceTransferDragAdapter_cannot_delete_files;
	public static String Search_FindReadReferencesAction_tooltip;
	public static String PHPProjectOutline_nodes_functions;
	public static String copyAction_destination_label;
	public static String NewVariableEntryDialog_configbutton_label;
	public static String HierarchyScope;
	public static String Search_FindReadReferencesInWorkingSetAction_label;
	public static String ProjectScope;
	public static String TodoTaskInputDialog_error_entryExists;
	public static String OpenCloseWorkingSetAction_open_error_title;
	public static String ProjectSelectionDialog_title;
	public static String Search_FindReadReferencesInHierarchyAction_tooltip;
	public static String CodeTemplateBlock_constructorcomment_label;
	public static String deleteAction_checkDeletion;
	public static String PHPEditorTextHoverDescriptor_cannot_create_message_decorator_error;
	public static String NewPHPManualSiteDialog_incorrectUrl;
	public static String CodeTemplateBlock_templates_code_node;
	public static String CodeTemplateBlock_export_error_canNotWrite;
	public static String VariableCreationDialog_error_nameexists;
	public static String PropertyAndPreferencePage_useprojectsettings_label;
	public static String Search_FindReadReferencesInHierarchyAction_label;
	public static String ColorPage_Heredoc;
	public static String PHPExplorer_referencedLibs;
	public static String FormatAllAction_label;
	public static String PHPEditorHoverConfigurationBlock_delimiter;
	public static String PHPWorkingSetPage_deselectAll_toolTip;
	public static String MethodExitsFinder_no_return_type_selected;
	public static String OccurrencesFinder_no_binding;
	public static String ReorgMoveAction_4;
	public static String FiltersDialog_filters_label;
	public static String BuildAction_label;
	public static String ReorgMoveAction_3;
	public static String CPListLabelProvider_none;
	public static String PhpTemplateFunctionContainerResolver_2;
	public static String CutSourceReferencesToClipboardAction_cut;
	public static String NewPHPManualSiteDialog_fileExtension;
	public static String OverrideIndicatorManager_open_error_messageHasLogEntry;
	public static String NewVariableEntryDialog_title;
	public static String typingPage_autoClose_braces;
	public static String NewPHPManualSiteDialog_updateTitle;
	public static String SaveAsDialog_6;

	public static String SaveAsDialog_7;

	public static String SaveAsDialog_createNewProject;
	public static String OpenResource_error_messageArgs;
	public static String deleteAction_confirm_title;
	public static String AddBlockComment_label;
	public static String PHPSearchResultPage_open_editor_error_title;
	public static String AddBlockComment_error_title;
	public static String OpenType_ConstantsFilterCheckboxName;
	public static String Search_FindWriteReferencesInWorkingSetAction_label;
	public static String PHPVersionGroup_OptionBlockTitle;
	public static String DeleteResourceAction_exception;
	public static String IncludePathDialogAccess_ExistingPHPFolderDialog_new_title;
	public static String IncludePathDialogAccess_ExistingSourceFolderDialog_new_title;
	public static String OpenCloseWorkingSetAction_close_label;
	public static String PHPPlugin_internal_error;
	public static String ConfigureIncludePathAction_description;
	public static String CodeTemplateBlock_templates_import_button;
	public static String ProjectSelectionDialog_desciption;
	public static String VariableCreationDialog_warning_pathnotexists;
	public static String EnclosingProjectsScope;
	public static String OpenPHPPerspectiveAction_dialog_title;
	public static String DeleteAction_desc;
	public static String ColorPage_String;
	public static String IncludePathOrderPage_Folders_Label;
	public static String CollapseAllAction_label;
	public static String OpenCustomFiltersDialogAction_text;
	public static String Search_Error_search_message;
	public static String CodeTemplateBlock_templates_comment_node;
	public static String FormatAllAction_error_title;
	public static String VariableCreationDialog_path_dir_button;
	public static String IncludePathDialogAccess_0;
	public static String PHPSearchQuery_label;
	public static String CodeTemplateBlock_export_extension;
	public static String NewVariableEntryDialog_vars_extend;
	public static String VariableBlock_vars_edit_button;
	public static String FormatAllAction_description;
	public static String CPListLabelProvider_unknown_element_label;
	public static String PhpSelectAnnotationRulerAction_QuickAssist_description;
	public static String SearchLabelProvider_exact_and_potential_plural;
	public static String PHPOutlinePage_mode_php;
	public static String VariableCreationDialog_error_whitespace;
	public static String ColorPage_TaskTag;
	public static String IncludePathsBlock_includepath_uncheckall_button;
	public static String PHPStructuredEditor_0;

	public static String PHPStructuredEditor_18;

	public static String PHPStructuredEditor_19;

	public static String PHPStructuredEditor_20;

	public static String PHPStructuredEditor_Source;
	public static String MarkOccurrencesConfigurationBlock_markTypeOccurrences;
	public static String Search_Error_search_notsuccessful_message;
	public static String PHPFormatterConfigurationBlock_indentSizeErrorMessage;
	public static String PHPFormatterConfigurationBlock_tabSizeErrorMessage;
	public static String OpenPHPPerspectiveAction_error_open_failed;
	public static String MarkOccurrencesConfigurationBlock_link;
	public static String PHPManualConfigurationBlock_remove;
	public static String Search_FindDeclarationsInProjectAction_label;
	public static String Search_FindWriteReferencesInHierarchyAction_label;
	public static String VariableBlock_needsbuild_title;
	public static String Preferences_php_editor_useAspTagsAsPhp_label;
	public static String FormatAllAction_error_message;
	public static String ConvertToPDTProjectAction_convert;
	public static String PHPElementAction_error_open_message;
	public static String IncludePathsPropertyPage_error_title;
	public static String CodeTemplateBlock_templates_label;
	public static String SelectionTransferDropAdapter_dialog_preview_label;
	public static String VariableBlock_needsbuild_message;
	public static String EditWorkingSetAction_error_nowizard_title;
	public static String LayoutGroup_OptionBlock_Title;
	public static String VariableBlock_vars_remove_button;
	public static String PHPStructuredTextViewer_1;
	public static String PHPManualConfigurationBlock_edit;
	public static String PHPStructuredTextViewer_0;
	public static String CodeTemplateBlock_fieldcomment_label;
	public static String Search_FindDeclarationsInWorkingSetAction_label;
	public static String PHPSearchResultPage_groupby_type_tooltip;
	public static String CopyToClipboardAction_desc;
	public static String VariableCreationDialog_extjardialog_text;
	public static String PhpSelectAnnotationRulerAction_OpenSuperImplementation_label;
	public static String PHPManual_title;
	public static String PHPWizardPagesRegistry_0;
	public static String PHPFileCreationWizardPage_17;
	public static String FormatAllAction_noundo_message;
	public static String PHPFileCreationWizardPage_16;
	public static String PhpSelectAnnotationRulerAction_QuickAssist_label;
	public static String PHPFileCreationWizardPage_15;
	public static String OpenAction_error_messageProblems;
	public static String ShowInExplorerViewAction_description;
	public static String PHPFileCreationWizardPage_14;
	public static String CodeAssistPreferencePage_insertFullyQualifiedNameForNamespace;
	public static String PHPFileCreationWizardPage_12;
	public static String ResourceTransferDragAdapter_moving_resource;
	public static String PHPFileCreationWizardPage_11;
	public static String PHPFileCreationWizardPage_10;
	public static String InitializeAfterLoadJob_starter_job_name;
	public static String PHPWorkingSetPage_warning_nameWhitespace;
	public static String RemoveTrailingWhitespaceOperation_task_generatingChanges;
	public static String PHPManualConfigurationBlock_fileExtension;
	public static String OpenProjectAction_dialog_title;
	public static String Search_FindImplementorsAction_tooltip;
	public static String OpenAction_error_title;
	public static String NewPHPManualSiteDialog_remoteSiteURL;
	public static String NewVariableEntryDialog_ExtensionDialog_title;
	public static String OpenAction_description;
	public static String PerspectiveManager_PerspectiveError_Title;
	public static String UntitledPHPEditor_documentCannotBeSaved;
	public static String ProjectsWorkbookPage_projects_remove_button;
	public static String CustomFiltersDialog_description_label;
	public static String SearchPage_expression_caseSensitive;
	public static String ExceptionOccurrencesFinder_no_exception;
	public static String CustomFiltersDialog_SelectAllButton_label;
	public static String SelectWorkingSetAction_text;
	public static String TodoTaskConfigurationBlock_needsprojectbuild_message;
	public static String CollapseAllAction_tooltip;
	public static String OpenResource_error_messageProblems;
	public static String DefaultPHPFoldingPreferenceBlock_includes;
	public static String FormatAllAction_failedvalidateedit_message;
	public static String PHPExplorer_binaryProjects;
	public static String SaveFilesDialog_4;
	public static String CodeTemplateBlock_methodcomment_label;
	public static String PHPManualSiteDescriptor_URL;
	public static String SaveFilesDialog_3;
	public static String SaveFilesDialog_2;
	public static String PHPSearchResultPage_sortByParentName;
	public static String SaveFilesDialog_1;
	public static String SearchUtil_workingSetConcatenation;
	public static String MethodExitsFinder_0;
	public static String Search_FindWriteReferencesAction_label;
	public static String OccurrencesFinder_no_element;
	public static String VariableBlock_vars_label;
	public static String IncludePathsPropertyPage_closed_project_message;
	public static String PHPProjectCreationWizard_message;
	public static String MarkOccurrencesConfigurationBlock_markMethodOccurrences;
	public static String PasteResourcesFromClipboardAction_error_title;
	public static String PHPSearchQuery_error_unsupported_pattern;
	public static String VariableCreationDialog_path_label;
	public static String PHPFileCreationWizard_5;
	public static String PHPFileCreationWizard_4;
	public static String VariableCreationDialog_error_entername;
	public static String PHPFileCreationWizard_2;
	public static String SearchElementSelectionDialog_title;
	public static String CodeTemplateBlock_typecomment_label;
	public static String PHPFileCreationWizard_1;
	public static String PHPFileCreationWizard_0;
	public static String Search_FindWriteReferencesInWorkingSetAction_tooltip;
	public static String PerspectiveManager_Switch_Dialog_Title;
	public static String ViewActionGroup_projects_label;
	public static String OverrideIndicatorManager_intallJob;
	public static String CodeTemplateBlock_error_write_message;
	public static String PHPEditorHoverConfigurationBlock_insertDelimiterAndModifier;
	public static String CodeAssistPreferencePage_showStrictOptions;
	public static String Search_Error_phpElementAccess_message;
	public static String typingPage_autoClose_title;
	public static String CoreUtility_job_title;
	public static String CodeTemplateBlock_enumbody_label;
	public static String TodoTaskConfigurationBlock_markers_tasks_setdefault_button;
	public static String CustomFiltersDialog_patternInfo;
	public static String typingPage_autoAdd_phpClose_tags;
	public static String typingPage_autoAdd_php_for_phpstart_tags;
	public static String WorkingSetModel_histroy_name;
	public static String GotoType_action_description;
	public static String GotoMatchingBracket_error_noMatchingBracket;
	public static String AddBlockComment_description;
	public static String OpenAction_select_element;
	public static String Search_FindDeclarationAction_label;
	public static String CodeTemplateBlock_templates_exportall_button;
	public static String PHPProjectCreationWizard_createProjectIn;
	public static String IPListElement_0;
	public static String InitializeAfterLoadJob_real_job_name;
	public static String PHPSearchResultPage_open_editor_error_message;
	public static String IncludePathContainerWizard_edit_title;
	public static String TodoTaskPreferencePage_description;
	public static String PHPSaveActionsPreferencePage_title;
	public static String PhpSelectAnnotationRulerAction_QuickFix_description;
	public static String RemoveFromIncludePathAction_remove_from_include_path_job;
	public static String PhpSelectAnnotationRulerAction_OpenSuperImplementation_description;
	public static String RemoveWorkingSetElementAction_label;
	public static String Search_FindHierarchyReferencesAction_tooltip;
	public static String AbstractWorkingSetPage_warning_workingSetExists;
	public static String Search_FindReferencesAction_BinPrimConstWarnDialog_message;
	public static String PHPEditorHoverConfigurationBlock_modifierIsNotValid;
	public static String LayoutGroup_OptionBlock_SrcResources;
	public static String PHPOutlinePage_mode_html;
	public static String GotoType_dialog_title;
	public static String moveAction_destination_label;
	public static String OpenResource_action_label;
	public static String PHPFormatterConfigurationBlock_spacesLabel;
	public static String PHPExplorerPart_workspace;
	public static String FiltersDialog_limit_label;
	public static String PHPElementProperties_name;
	public static String PHPEditorHoverConfigurationBlock_modifierColumnTitle;
	public static String PHPEditorHoverConfigurationBlock_insertModifierAndDelimiter;
	public static String RemoveTrailingWhitespaceOperation_task_applyingChanges;
	public static String UntitledPHPEditor_deleteFailed;
	public static String StructuredTextFoldingProviderPHP_1;
	public static String StructuredTextFoldingProviderPHP_0;
	public static String CodeTemplateBlock_export_error_title;
	public static String ShowGroupsAction_1;
	public static String TodoTaskConfigurationBlock_markers_tasks_name_column;
	public static String EmptyPHPFoldingPreferenceBlock_emptyCaption;
	public static String PHPSearchResultPage_filtered_message;
	public static String PHPSearchResultPage_sortBylabel;
	public static String PhpSelectAnnotationRulerAction_QuickFix_label;
	public static String SearchPage_searchFor_label;
	public static String TodoTaskConfigurationBlock_markers_tasks_add_button;
	public static String PHPWorkingSetPage_workingSet_description;
	public static String ToggleComment_tooltip;
	public static String TodoTaskConfigurationBlock_markers_tasks_low_priority;
	public static String TodoTaskInputDialog_priority_low;
	public static String UntitledPHPEditor_saveError;
	public static String PHPTextHover_createTextHover;
	public static String VersionGroup_OptionBlock_fCustomValues;
	public static String ExceptionOccurrencesFinder_searchfor;
	public static String PropertyAndPreferencePage_useworkspacesettings_change;
	public static String FormatAllAction_multi_status_title;
	public static String SearchLabelProvider_potential_singular;
	public static String TodoTaskConfigurationBlock_markers_tasks_high_priority;
	public static String CodeTemplateBlock_export_title;
	public static String Search_FindWriteReferencesInHierarchyAction_tooltip;
	public static String SelectWorkingSetAction_toolTip;
	public static String NewVariableEntryDialog_info_noselection;
	public static String PhpTemplateClassContainerResolver_1;
	public static String EditWorkingSetAction_text;
	public static String TodoTaskPreferencePage_title;
	public static String PHPManualConfigurationBlock_default;
	public static String PasteAction_text;
	public static String OpenType_ClassesFilterCheckboxName;
	public static String JavaScriptSupportGroup_EnableSupport;
	public static String ClearWorkingSetAction_toolTip;
	public static String Search_Error_search_notsuccessful_title;
	public static String ElementCreationProxy_1;
	public static String TodoTaskInputDialog_error_comma;
	public static String EditWorkingSetAction_error_nowizard_message;
	public static String ElementCreationProxy_0;
	public static String IncludePathsPropertyPage_unsavedchanges_button_discard;
	public static String IncludePathsBlock_warning_EntriesMissing;
	public static String Search_FindHierarchyReferencesAction_label;
	public static String Search_FindReferencesInProjectAction_tooltip;
	public static String PHPEditorPreferencePage_hoverTab_title;
	public static String CodeTemplateBlock_interfacebody_label;
	public static String PHPActionDelegatorRegistry_1;
	public static String PHPElementLabels_comma_string;
	public static String PHPActionDelegatorRegistry_0;
	public static String CPVariableElementLabelProvider_reserved;
	public static String PHPWorkingSetPage_title;
	public static String TodoTaskInputDialog_priority_normal;
	public static String ColorPage_LineComment;
	public static String OpenProjectAction_error_message;
	public static String AddBlockComment_error_messageBadSelection;
	public static String CodeAssistPreferencePage_autoActivationDelayIntValue;
	public static String ColorPage_Variable;
	public static String DropAdapter_errorSubfolder;
	public static String Search_Error_phpElementAccess_title;
	public static String PHPExplorer_toolTip;
	public static String CodeTemplateBlock_error_write_title;
	public static String ImplementOccurrencesFinder_searchfor;
	public static String RemoveBlockComment_tooltip;
	public static String VariableCreationDialog_path_file_button;
	public static String DropAdapter_errorTitle;
	public static String AddBlockCommentAction_label;
	public static String RenamePHPElementAction_0;
	public static String IncludePathContainerDefaultPage_path_label;
	public static String newPhpFile_create;
	public static String Search_FindReferencesInProjectAction_label;
	public static String PHPBasePreferencePage_doubleclick_expand;
	public static String CutAction_text;
	public static String PHPFunctionsPart_0;
	public static String Search_FindImplementorsInWorkingSetAction_tooltip;
	public static String UncommentAction_label;
	public static String TodoTaskInputDialog_new_title;
	public static String ToggleLinkingAction_link_description;
	public static String ProjectionModelNodeAdapterPHP_4;
	public static String SaveAsDialog_saveFileMessage;
	public static String ProjectionModelNodeAdapterPHP_3;
	public static String ProjectionModelNodeAdapterPHP_2;
	public static String PHPEditorHoverConfigurationBlock_description;
	public static String SmartTypingConfigurationBlock_tabs_message_tooltip;
	public static String ProjectionModelNodeAdapterPHP_1;
	public static String Search_Error_openEditor_title;
	public static String ProjectionModelNodeAdapterPHP_0;
	public static String newPhpFile_wizard_templatePage_phpTemplatesLocation;
	public static String CPListLabelProvider_unbound_library;
	public static String OpenPropertiesWorkingSetAction_label;
	public static String PHPProjectOutline_title_tooltip;
	public static String IncludePathsPropertyPage_unsavedchanges_button_save;
	public static String TreeProvider_1;
	public static String FoldingConfigurationBlock_enable;
	public static String DropAdapter_question;
	public static String TodoTaskConfigurationBlock_needsfullbuild_message;
	public static String RenamePHPElementAction_name;
	public static String RefactorMenu_label;
	public static String IncludePathTreeContent_Node_Name;
	public static String DropAdapter_alreadyExists;
	public static String PHPVersionConfigurationBlock_needsfullbuild_message;
	public static String AddBlockComment_tooltip;
	public static String MarkOccurrencesConfigurationBlock_link_tooltip;
	public static String PHPElementAction_operationUnavailable_generic;
	public static String PHPWorkingSetPage_warning_workingSetExists;
	public static String IncludePathsPropertyPage_no_php_project_message;
	public static String moveAction_name;
	public static String group_implementors;
	public static String CodeAssistPreferencePage_completionInserts;
	public static String OpenType_instructionText;
	public static String PasteAction_0;
	public static String OpenCloseWorkingSetAction_close_error_message;
	public static String copyAction_name;
	public static String PHPExplorer_toolTip2;
	public static String PHPSearchQuery_task_label;
	public static String VersionGroup_OptionBlock_fDefaultValues;
	public static String PHPSearchResultPage_groupby_project_tooltip;
	public static String NewPHPManualSiteDialog_nameAlreadyInUse;
	public static String FindOccurrencesEngine_noSource_text;
	public static String MarkOccurrencesConfigurationBlock_stickyOccurrences;
	public static String PHPExplorer_openPerspective;
	public static String DeleteResourceAction_delete;
	public static String CPVariableElementLabelProvider_empty;
	public static String OpenAction_error_messageArgs;
	public static String InitializeAfterLoadJob_1;
	public static String InitializeAfterLoadJob_0;
	public static String PHPFormatterConfigurationBlock_tabPolicyLabel;
	public static String PHPFormatterPreferencePage_description;
	public static String FormatAllAction_failedvalidateedit_title;
	public static String ShowInNavigatorView_dialog_message;
	public static String SelectionTransferDropAdapter_dialog_question;
	public static String CodeAssistPreferencePage_autoActivationSectionLabel;
	public static String typingPage_autoClose_brackets;
	public static String CodeTemplateBlock_link_tooltip;
	public static String IncludePathsBlock_includepath_down_button;
	public static String CodeTemplateBlock_templates_export_button;
	public static String IncludePath_AddEntryToIncludePathMessage;
	public static String group_references;
	public static String DefaultPHPFoldingPreferenceBlock_title;
	public static String group_readReferences;
	public static String SaveActionsConfigurationBlock_3;
	public static String SaveActionsConfigurationBlock_2;
	public static String FilterDescriptor_filterCreationError_title;
	public static String SaveActionsConfigurationBlock_0;

	public static String SaveActionsConfigurationBlock_1;
	public static String GotoType_dialog_message;
	public static String CodeTemplateBlock_error_read_title;
	public static String ConfigureIncludePathAction_label;

	public static String ContentMergeViewer_0;

	public static String ContentMergeViewer_1;

	public static String ContentMergeViewer_2;
	public static String newPhpFile_openning;
	public static String MarkOccurrencesConfigurationBlock_markMethodExitPoints;
	public static String IncludePathContainerDefaultPage_path_error_enterpath;
	public static String ProjectsWorkbookPage_projects_edit_button;
	public static String CodeTemplateBlock_export_exists_title;
	public static String Search_FindOccurrencesInFile_label;
	public static String Preferences_php_editor_useShortTagsAsPhp_label;
	public static String PropertyAndPreferencePage_showprojectspecificsettings_label;
	public static String StatusBarUpdater_num_elements_selected;
	public static String SearchLabelProvider_potential_noCount;
	public static String ToggleComment_description;
	public static String ColorPage_Comment;
	public static String PHPEditorPreferencePage_prefEditorTooltip;
	public static String OpenResource_action_description;
	public static String newPhpFile_wizard_templatePage_description;
	public static String PHPProjectCreationWizard_folder;
	public static String NewVariableEntryDialog_ExtensionDialog_description;
	public static String CodeTemplateBlock_settercomment_label;
	public static String CPListLabelProvider_new;
	public static String RefreshAction_locationDeleted_title;
	public static String VariableCreationDialog_extdirdialog_text;
	public static String NewPHPManualSiteDialog_dirDoesntExist;
	public static String WorkingSetScope;
	public static String GotoType_action_label;
	public static String CPListLabelProvider_all;
	public static String NewPHPManualSiteDialog_localDirectory;
	public static String PHPElementAction_operationUnavailable_title;
	public static String typingPage_autoClose_phpDoc_and_commens;
	public static String FoldingConfigurationBlock_info_no_preferences;
	public static String VariableBlock_vars_add_button;
	public static String VariableBlock_operation_desc;
	public static String IncludePath_RemoveEntryFromBuildPathMessage;
	public static String TodoTaskConfigurationBlock_markers_tasks_edit_button;
	public static String SelectAllAction_label;
	public static String CodeAssistPreferencePage_showVariablesFromOtherFiles;
	public static String OpenAction_declaration_label;
	public static String CodeTemplateBlock_templates_edit_button;

	public static String CodeAssistPreferencePage_showVariablesFromReferencedFiles;
	public static String CodeAssistPreferencePage_insertGlobalPrefixForFunctionCallInsideNamespace;

	public static String PHPUiPlugin_4;
	public static String PHPUiPlugin_5;

	static {
		NLS.initializeMessages(BUNDLE_NAME, PHPUIMessages.class);
	}
}
