/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.formatter.autoedit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.formatter.FormatterTests;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class FormatterAutoEditTests
extends FormatterTests {
    protected static final char OFFSET_CHAR = '|';
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public FormatterAutoEditTests(PHPVersion version, String[] fileNames) {
        super(version, fileNames);
    }

    @Test
    public void formatter(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        IFile file = this.createFile(pdttFile.getFile().trim());
        ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
        if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
            modelElement.becomeWorkingCopy(new IProblemRequestor(){

                public void acceptProblem(IProblem problem) {
                }

                public void beginReporting() {
                }

                public void endReporting() {
                }

                public boolean isActive() {
                    return false;
                }
            }, null);
        }
        IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
        try {
            IStructuredDocument document = modelForEdit.getStructuredDocument();
            String beforeFormat = document.get();
            String data = document.get();
            int offset = data.lastIndexOf(124);
            if (offset == -1) {
                throw new IllegalArgumentException("Offset character is not set");
            }
            data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
            document.set(data);
            MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
            DocumentCommand cmd = new DocumentCommand(){};
            cmd.offset = offset;
            cmd.length = 0;
            cmd.text = pdttFile.getOther() != null ? pdttFile.getOther() : "\n";
            cmd.doit = true;
            cmd.shiftsCaret = true;
            cmd.caretOffset = -1;
            indentLineAutoEditStrategy.customizeDocumentCommand((IDocument)document, cmd);
            document.replace(cmd.offset, cmd.length, cmd.text);
            PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)document.get());
            document.set(beforeFormat);
            modelForEdit.save();
        }
        finally {
            if (modelForEdit != null) {
                modelForEdit.releaseFromEdit();
            }
        }
    }
}

