/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class CloseTagAutoEditStrategyPHP
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        final IProject[] projects = new IProject[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PHPStructuredEditor phpStructuredEditor;
                IEditorPart editor;
                IWorkbenchPage page = PHPUiPlugin.getActivePage();
                if (page != null && (editor = page.getActiveEditor()) instanceof PHPStructuredEditor && (phpStructuredEditor = (PHPStructuredEditor)editor).getTextViewer() != null && phpStructuredEditor != null) {
                    ISourceModule sourceModule = (ISourceModule)phpStructuredEditor.getModelElement();
                    projects[0] = sourceModule.getScriptProject().getProject();
                }
            }
        });
        if (!TypingPreferences.addPhpCloseTag && !TypingPreferences.addPhpForPhpStartTags) {
            return;
        }
        Object textEditor = this.getActiveTextEditor();
        if (!(textEditor instanceof ITextEditorExtension3) || ((ITextEditorExtension3)textEditor).getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
            return;
        }
        IStructuredModel model = null;
        try {
            IDOMNode node;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && command.text != null && command.text.equals("?") && (node = (IDOMNode)model.getIndexedRegion(command.offset - 1)) != null && this.prefixedWith(document, command.offset, "<")) {
                if (!TypingPreferences.addPhpCloseTag && TypingPreferences.addPhpForPhpStartTags) {
                    command.text = String.valueOf(command.text) + "php ";
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 5;
                    command.doit = false;
                } else if (TypingPreferences.addPhpCloseTag && !TypingPreferences.addPhpForPhpStartTags) {
                    if (!this.closeTagAppears(node.getSource(), command.offset)) {
                        command.text = String.valueOf(command.text) + " ?>";
                        command.caretOffset = command.offset + 1;
                        command.shiftsCaret = false;
                        command.doit = false;
                    }
                } else if (TypingPreferences.addPhpCloseTag && TypingPreferences.addPhpForPhpStartTags && !this.closeTagAppears(node.getSource(), command.offset)) {
                    command.text = String.valueOf(command.text) + "php ?>";
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 5;
                    command.doit = false;
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private final boolean closeTagAppears(String source, int startFrom) {
        return source.indexOf("?>", startFrom) != -1;
    }

    private Object getActiveTextEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            if (editor instanceof ITextEditor) {
                return editor;
            }
            ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                return textEditor;
            }
            return editor;
        }
        return null;
    }

    private boolean prefixedWith(IDocument document, int offset, String string) {
        try {
            return document.getLength() >= string.length() && document.get(offset - string.length(), string.length()).equals(string);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
    }
}

