/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.parser.php5.PhpLexer;

class Util {
    Util() {
    }

    static boolean covers(ISourceRange range, ISourceRange nodeRange) {
        return range.getOffset() <= nodeRange.getOffset() && Util.getEndInclusive(range) >= Util.getEndInclusive(nodeRange);
    }

    static int getEndExclusive(ISourceRange range) {
        return range.getOffset() + range.getLength();
    }

    static int getEndInclusive(ISourceRange range) {
        return Util.getEndExclusive(range) - 1;
    }

    static boolean rangeIncludesNonWhitespaceOutsideRange(ISourceRange selection, ISourceRange nodes, IDocument document) throws BadLocationException {
        if (!Util.covers(selection, nodes)) {
            return false;
        }
        if (!Util.isJustWhitespace(selection.getOffset(), nodes.getOffset(), document)) {
            return true;
        }
        return !Util.isJustWhitespaceOrComment(nodes.getOffset() + nodes.getLength(), selection.getOffset() + selection.getLength(), document);
    }

    private static boolean isJustWhitespace(int start, int end, IDocument buffer) throws BadLocationException {
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        return buffer.get(start, end - start).trim().length() == 0;
    }

    private static boolean isJustWhitespaceOrComment(int start, int end, IDocument document) {
        String trimmedText;
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        try {
            trimmedText = document.get(start, end - start).trim();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (trimmedText.length() == 0) {
            return true;
        }
        PhpLexer scanner = new PhpLexer((Reader)new StringReader(trimmedText));
        scanner.initialize(1);
        try {
            return scanner.yylex() == null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

