/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.AliasMethod;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.IPHPCompletionProposalExtension;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class UseStatementInjector {
    private ScriptCompletionProposal proposal;

    public UseStatementInjector(ScriptCompletionProposal proposal) {
        this.proposal = proposal;
    }

    public int inject(IDocument document, ITextViewer textViewer, int offset) {
        IPHPCompletionProposalExtension phpCompletionProposal;
        FakeConstructor fc;
        IModelElement modelElement = this.proposal.getModelElement();
        if (modelElement instanceof FakeConstructor ? (fc = (FakeConstructor)modelElement).getParent() instanceof AliasType : modelElement instanceof AliasType || modelElement instanceof AliasMethod || modelElement instanceof AliasField) {
            return offset;
        }
        if (modelElement == null) {
            return offset;
        }
        if (this.proposal instanceof IPHPCompletionProposalExtension && ProposalExtraInfo.isNotInsertUse((Object)(phpCompletionProposal = (IPHPCompletionProposalExtension)this.proposal).getExtraInfo())) {
            return offset;
        }
        try {
            IModelElement type;
            if (this.proposal.getReplacementOffset() > 0 && document.getChar(this.proposal.getReplacementOffset() - 1) == '\\') {
                return offset;
            }
            if (modelElement.getElementType() == 7 && PHPFlags.isNamespace((int)((IType)modelElement).getFlags())) {
                if (offset > 0) {
                    IModelElement editorElement;
                    ITextEditor textEditor;
                    String prefix = document.get(this.proposal.getReplacementOffset(), this.proposal.getReplacementLength());
                    String fullName = ((IType)modelElement).getElementName();
                    if (fullName.startsWith(prefix) && prefix.indexOf(92) < 0 && (textEditor = ((PHPStructuredTextViewer)textViewer).getTextEditor()) instanceof PHPStructuredEditor && (editorElement = ((PHPStructuredEditor)textEditor).getModelElement()) != null) {
                        String typeName;
                        ISourceModule sourceModule = ((ModelElement)editorElement).getSourceModule();
                        String namespaceName = fullName;
                        int nsSeparatorIndex = fullName.indexOf(92);
                        if (nsSeparatorIndex > 0) {
                            namespaceName = fullName.substring(0, nsSeparatorIndex);
                        }
                        String usePartName = namespaceName;
                        boolean useAlias = !Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertFullyQualifiedNameForNamespaceCheckBox", true, null);
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                        ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
                        parser.setSource(document.get().toCharArray());
                        Program program = parser.createAST(null);
                        if (this.isSameNamespace(namespaceName, program, sourceModule, offset)) {
                            return offset;
                        }
                        UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)usePartName, (int)offset);
                        List<String> importedTypeName = this.getImportedTypeName(moduleDeclaration, offset);
                        if (!importedTypeName.contains(typeName = namespaceName)) {
                            program.recordModifications();
                            AST ast = program.getAST();
                            NamespaceName newNamespaceName = ast.newNamespaceName(this.createIdentifiers(ast, usePartName), false, false);
                            UseStatementPart newUseStatementPart = ast.newUseStatementPart(newNamespaceName, null);
                            org.eclipse.php.internal.core.ast.nodes.UseStatement newUseStatement = ast.newUseStatement(Arrays.asList(newUseStatementPart), 0);
                            NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
                            if (currentNamespace != null) {
                                List statements = currentNamespace.getBody().statements();
                                this.insertUseStatement(offset, newUseStatement, statements, document);
                            } else {
                                this.insertUseStatement(offset, newUseStatement, program.statements(), document);
                            }
                            ast.setInsertUseStatement(true);
                            TextEdit edits = program.rewrite(document, this.createOptions(modelElement));
                            edits.apply(document);
                            ast.setInsertUseStatement(false);
                            int replacementOffset = this.proposal.getReplacementOffset() + edits.getLength();
                            offset += edits.getLength();
                            this.proposal.setReplacementOffset(replacementOffset);
                        } else if (!(useAlias || usePart != null && usePartName.equals(usePart.getNamespace().getFullyQualifiedName()))) {
                            this.proposal.setReplacementString(String.valueOf('\\') + fullName);
                        }
                    }
                    return offset;
                }
                return offset;
            }
            if (modelElement.getElementType() != 7 && !(modelElement instanceof FakeConstructor) && (type = modelElement.getAncestor(7)) != null && !PHPFlags.isNamespace((int)((IType)type).getFlags())) {
                return offset;
            }
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return this.addUseStatement(modelElement, document, textViewer, offset);
    }

    private int addUseStatement(IModelElement modelElement, IDocument document, ITextViewer textViewer, int offset) {
        IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)modelElement);
        if (namespace == null) {
            return offset;
        }
        if (!(textViewer instanceof PHPStructuredTextViewer)) {
            return offset;
        }
        ITextEditor textEditor = ((PHPStructuredTextViewer)textViewer).getTextEditor();
        if (!(textEditor instanceof PHPStructuredEditor)) {
            return offset;
        }
        IModelElement editorElement = ((PHPStructuredEditor)textEditor).getModelElement();
        if (editorElement == null) {
            return offset;
        }
        ISourceModule sourceModule = ((ModelElement)editorElement).getSourceModule();
        try {
            boolean useAlias;
            String namespaceName;
            String usePartName = namespaceName = namespace.getElementName();
            boolean bl = useAlias = !Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertFullyQualifiedNameForNamespaceCheckBox", true, null);
            if (!useAlias) {
                usePartName = String.valueOf(usePartName) + '\\' + modelElement.getElementName();
            }
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
            parser.setSource(document.get().toCharArray());
            Program program = parser.createAST(null);
            if (this.isSameNamespace(namespaceName, program, sourceModule, offset)) {
                return offset;
            }
            UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)usePartName, (int)offset);
            List<String> importedTypeName = this.getImportedTypeName(moduleDeclaration, offset);
            String typeName = "";
            typeName = !useAlias ? modelElement.getElementName().toLowerCase() : (usePart != null && usePart.getAlias() != null && usePart.getAlias().getName() != null ? usePart.getAlias().getName() : PHPModelUtils.extractElementName((String)namespaceName).toLowerCase());
            PHPVersion phpVersion = ProjectOptions.getPhpVersion((IModelElement)modelElement);
            if (!importedTypeName.contains(typeName) && this.canInsertUseStatement(this.getUseStatementType(modelElement), phpVersion)) {
                program.recordModifications();
                AST ast = program.getAST();
                NamespaceName newNamespaceName = ast.newNamespaceName(this.createIdentifiers(ast, usePartName), false, false);
                UseStatementPart newUseStatementPart = ast.newUseStatementPart(newNamespaceName, null);
                int type = this.getUseStatementType(modelElement);
                org.eclipse.php.internal.core.ast.nodes.UseStatement newUseStatement = ast.newUseStatement(Arrays.asList(newUseStatementPart), type);
                NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
                if (currentNamespace != null) {
                    List statements = currentNamespace.getBody().statements();
                    this.insertUseStatement(offset, newUseStatement, statements, document);
                } else {
                    this.insertUseStatement(offset, newUseStatement, program.statements(), document);
                }
                ast.setInsertUseStatement(true);
                TextEdit edits = program.rewrite(document, this.createOptions(modelElement));
                edits.apply(document);
                ast.setInsertUseStatement(false);
                if (useAlias && this.needsAliasPrepend(modelElement)) {
                    String namespacePrefix = String.valueOf(typeName) + '\\';
                    String replacementString = this.proposal.getReplacementString();
                    String existingNamespacePrefix = this.readNamespacePrefix(sourceModule, document, offset, phpVersion);
                    if (existingNamespacePrefix == null || !usePartName.toLowerCase().equals(existingNamespacePrefix.toLowerCase())) {
                        replacementString = String.valueOf(namespacePrefix) + replacementString;
                    }
                    this.proposal.setReplacementString(replacementString);
                }
                int replacementOffset = this.proposal.getReplacementOffset() + edits.getLength();
                offset += edits.getLength();
                this.proposal.setReplacementOffset(replacementOffset);
            } else if (!(useAlias || usePart != null && usePartName.equals(usePart.getNamespace().getFullyQualifiedName()))) {
                String namespacePrefix = String.valueOf('\\') + namespaceName + '\\';
                String replacementString = this.proposal.getReplacementString();
                String existingNamespacePrefix = this.readNamespacePrefix(sourceModule, document, offset, phpVersion);
                if (existingNamespacePrefix == null || !namespaceName.toLowerCase().equals(existingNamespacePrefix.toLowerCase())) {
                    replacementString = String.valueOf(namespacePrefix) + replacementString;
                }
                this.proposal.setReplacementString(replacementString);
            }
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return offset;
    }

    private Collection<Identifier> createIdentifiers(AST ast, String namespaceName) {
        String[] split = namespaceName.split("\\\\");
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            identifiers.add(ast.newIdentifier(s));
            ++n2;
        }
        return identifiers;
    }

    private NamespaceDeclaration getCurrentNamespace(Program program, ISourceModule sourceModule, int offset) {
        SourceType ns = (SourceType)PHPModelUtils.getPossibleCurrentNamespace((ISourceModule)sourceModule, (int)offset);
        if (ns == null) {
            if (program.statements() != null && !program.statements().isEmpty() && program.statements().get(0) instanceof NamespaceDeclaration) {
                NamespaceDeclaration result = (NamespaceDeclaration)program.statements().get(0);
                for (Statement statement : program.statements()) {
                    if (statement.getStart() >= offset) {
                        return result;
                    }
                    if (!(statement instanceof NamespaceDeclaration)) continue;
                    result = (NamespaceDeclaration)statement;
                }
                return result;
            }
            return null;
        }
        ASTNode node = null;
        try {
            node = program.getElementAt(ns.getSourceRange().getOffset());
        }
        catch (ModelException modelException) {}
        if (node == null) {
            return null;
        }
        do {
            switch (node.getType()) {
                case 64: {
                    return (NamespaceDeclaration)node;
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String getNamespaceName(NamespaceDeclaration namespaceDecl) {
        StringBuilder nameBuf = new StringBuilder();
        NamespaceName name = namespaceDecl.getName();
        if (name == null) {
            return "\\";
        }
        for (Identifier identifier : name.segments()) {
            if (nameBuf.length() > 0) {
                nameBuf.append('\\');
            }
            nameBuf.append(identifier.getName());
        }
        return nameBuf.toString();
    }

    private boolean needsAliasPrepend(IModelElement modelElement) throws ModelException {
        if (modelElement instanceof IMethod) {
            if (modelElement instanceof FakeConstructor) {
                return true;
            }
            IType declaringType = ((IMethod)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        if (modelElement instanceof IField) {
            IField field = (IField)modelElement;
            if (!PHPFlags.isConstant((int)field.getFlags())) {
                return false;
            }
            IType declaringType = ((IField)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        return true;
    }

    private String readNamespacePrefix(ISourceModule sourceModule, IDocument document, int offset, PHPVersion phpVersion) {
        IStructuredDocumentRegion sRegion;
        if (offset > 0) {
            --offset;
        }
        if ((sRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                int endPosition;
                int startPosition;
                String elementName;
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                try {
                    tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                int elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                TextSequence statement = PHPTextSequenceUtilities.getStatement((int)(elementStart + tRegion.getLength()), (IStructuredDocumentRegion)sRegion, (boolean)true);
                if (statement.length() != 0 && (elementName = statement.subSequence(startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((PHPVersion)phpVersion, (CharSequence)statement, (int)(endPosition = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statement, (int)statement.length())), (boolean)true), endPosition).toString()).length() > 0) {
                    return PHPModelUtils.extractNamespaceName((String)elementName, (ISourceModule)sourceModule, (int)offset);
                }
            }
        }
        return null;
    }

    private int getLastUsestatementIndex(List<Statement> statements, int offset) {
        int result = 0;
        int i = 0;
        while (i < statements.size()) {
            Statement statement = statements.get(i);
            if (statement.getEnd() <= offset && statement instanceof org.eclipse.php.internal.core.ast.nodes.UseStatement) {
                result = i + 1;
            }
            ++i;
        }
        return result;
    }

    private List<String> getImportedTypeName(ModuleDeclaration moduleDeclaration, int offset) {
        UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)offset);
        ArrayList<String> importedClass = new ArrayList<String>();
        UseStatement[] useStatementArray = useStatements;
        int n = useStatements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            for (UsePart usePart : statement.getParts()) {
                String name = usePart.getAlias() != null ? usePart.getAlias().getName() : usePart.getNamespace().getName();
                importedClass.add(name.toLowerCase());
            }
            ++n2;
        }
        return importedClass;
    }

    public int getUseStatementType(IModelElement modelElement) throws ModelException {
        if (modelElement.getElementType() != 7 && !(modelElement instanceof FakeConstructor)) {
            if (modelElement.getElementType() == 9) {
                return 1;
            }
            if (modelElement.getElementType() == 8 && PHPFlags.isConstant((int)((IMember)modelElement).getFlags())) {
                return 2;
            }
        }
        return 0;
    }

    private void insertUseStatement(int offset, org.eclipse.php.internal.core.ast.nodes.UseStatement newUseStatement, List<Statement> statements, IDocument document) {
        int index = this.getLastUsestatementIndex(statements, offset);
        if (index > 0) {
            try {
                int beginLine = document.getLineOfOffset(statements.get(index - 1).getEnd()) + 1;
                newUseStatement.setSourceRange(document.getLineOffset(beginLine), 0);
            }
            catch (Exception exception) {}
        }
        statements.add(index, (Statement)newUseStatement);
    }

    private boolean isSameNamespace(String namespaceName, Program program, ISourceModule sourceModule, int offset) {
        NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, sourceModule, offset - 1);
        if (currentNamespace == null) {
            return false;
        }
        return namespaceName.equals(this.getNamespaceName(currentNamespace));
    }

    private boolean canInsertUseStatement(int statementType, PHPVersion phpVersion) {
        return statementType == 0 || phpVersion.isGreaterThan(PHPVersion.PHP5_5);
    }

    private Map<Object, Object> createOptions(IModelElement modelElement) {
        HashMap<Object, Object> options = new HashMap<Object, Object>(PHPCorePlugin.getOptions());
        if (modelElement == null || modelElement.getScriptProject() == null) {
            return options;
        }
        IScopeContext[] contents = new IScopeContext[]{new ProjectScope(modelElement.getScriptProject().getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        int i = 0;
        while (i < contents.length) {
            IScopeContext scopeContext = contents[i];
            IEclipsePreferences node = scopeContext.getNode("org.eclipse.php.core");
            if (node != null) {
                String size;
                String useTabs;
                if (!options.containsKey("org.eclipse.php.core.phpForamtterUseTabs") && (useTabs = node.get("org.eclipse.php.core.phpForamtterUseTabs", null)) != null) {
                    options.put("org.eclipse.php.core.phpForamtterUseTabs", useTabs);
                }
                if (!options.containsKey("org.eclipse.php.core.phpForamtterIndentationSize") && (size = node.get("org.eclipse.php.core.phpForamtterIndentationSize", null)) != null) {
                    options.put("org.eclipse.php.core.phpForamtterIndentationSize", size);
                }
            }
            ++i;
        }
        return options;
    }
}

