/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPVersionConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    public static final String[] PHP_VERSION_VALUES = new String[]{PHPVersion.PHP4.getAlias(), PHPVersion.PHP5.getAlias(), PHPVersion.PHP5_3.getAlias(), PHPVersion.PHP5_4.getAlias(), PHPVersion.PHP5_5.getAlias(), PHPVersion.PHP5_6.getAlias()};
    public static final String[] PHP_VERSION_DESCRIPTIONS = new String[]{PHPUIMessages.PHPCreationDataModelProvider_0, PHPUIMessages.PHPCreationDataModelProvider_1, PHPUIMessages.PHPCreationDataModelProvider_2, PHPUIMessages.PHPCreationDataModelProvider_3, PHPUIMessages.PHPCreationDataModelProvider_4, PHPUIMessages.PHPCreationDataModelProvider_5};
    private static final Key PREF_PHP_VERSION = PHPVersionConfigurationBlock.getPHPCoreKey("phpVersion");
    private static final Key PREF_ASP_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("use_asp_tags_as_php");
    private static final Key PREF_SHORT_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("useShortTags");
    private IStatus fTaskTagsStatus;
    protected ValuedCombo versionCombo;
    protected Button useShortTagsButton;
    protected Label nameLabel;
    protected PHPVersion minimumVersion = null;
    private boolean hideShortTags;

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPVersionConfigurationBlock.getKeys(), container);
    }

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, boolean hideShortTags) {
        this(context, project, container);
        this.hideShortTags = hideShortTags;
    }

    public void setMinimumVersion(PHPVersion version) {
        this.minimumVersion = version;
    }

    public void setEnabled(boolean isEnabled) {
        this.versionCombo.setEnabled(isEnabled);
        if (!this.hideShortTags) {
            this.useShortTagsButton.setEnabled(isEnabled);
        }
        this.nameLabel.setEnabled(isEnabled);
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_PHP_VERSION, PREF_SHORT_TAGS};
    }

    @Override
    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createVersionContent(composite);
        this.unpackPHPVersion();
        if (!this.hideShortTags) {
            this.createUseShortTagsContent(composite);
            this.unpackUseShortTags();
        }
        this.validateSettings(null, null, null);
        return composite;
    }

    private void createUseShortTagsContent(Composite composite) {
        this.useShortTagsButton = new Button(composite, 131104);
        this.useShortTagsButton.setText(PHPUIMessages.Preferences_php_editor_useShortTagsAsPhp_label);
        this.useShortTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPVersionConfigurationBlock.this.setUseShortTagsValue(Boolean.toString(PHPVersionConfigurationBlock.this.useShortTagsButton.getSelection()));
            }
        });
    }

    private Composite createVersionContent(Composite parent) {
        Composite composite = new Composite(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText(PHPUIMessages.PHPVersionComboName);
        GC gc = new GC((Drawable)this.nameLabel);
        gc.setFont(this.nameLabel.getFont());
        gc.dispose();
        List entryList = this.prepareVersionEntryList();
        this.versionCombo = new ValuedCombo(composite, 8, entryList);
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = PHPVersionConfigurationBlock.this.versionCombo.getSelectionValue();
                PHPVersionConfigurationBlock.this.setPhpVersionValue(selectedValue);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        if (changedKey != null) {
            if (PREF_PHP_VERSION.equals(changedKey)) {
                this.fTaskTagsStatus = this.validatePHPVersion();
            } else {
                if (!PREF_SHORT_TAGS.equals(changedKey)) return;
                this.fTaskTagsStatus = this.validatePHPVersion();
            }
        } else {
            this.fTaskTagsStatus = this.validatePHPVersion();
        }
        this.fContext.statusChanged(this.fTaskTagsStatus);
    }

    private IStatus validatePHPVersion() {
        return new StatusInfo();
    }

    private List prepareVersionEntryList() {
        ArrayList<ValuedCombo.Entry> entryList = new ArrayList<ValuedCombo.Entry>();
        int i = 0;
        while (i < PHP_VERSION_DESCRIPTIONS.length) {
            if (this.minimumVersion == null || !PHPVersion.byAlias((String)PHP_VERSION_VALUES[i]).isLessThan(this.minimumVersion)) {
                String description = PHP_VERSION_DESCRIPTIONS[i];
                String value = PHP_VERSION_VALUES[i];
                ValuedCombo.Entry entry = new ValuedCombo.Entry(value, description);
                entryList.add(entry);
            }
            ++i;
        }
        return entryList;
    }

    private void setPhpVersionValue(String value) {
        String[] values = PHP_VERSION_VALUES;
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                this.versionCombo.setText(PHP_VERSION_DESCRIPTIONS[i]);
                this.setValue(PREF_PHP_VERSION, values[i]);
                this.validateSettings(PREF_PHP_VERSION, null, null);
                return;
            }
            ++i;
        }
    }

    private void setUseShortTagsValue(String value) {
        this.setValue(PREF_SHORT_TAGS, value);
        this.validateSettings(PREF_SHORT_TAGS, null, null);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PHPUIMessages.PHPVersionConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PHPUIMessages.PHPVersionConfigurationBlock_needsfullbuild_message : PHPUIMessages.PHPVersionConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    @Override
    protected void updateControls() {
        this.unpackPHPVersion();
        if (!this.hideShortTags) {
            this.unpackUseShortTags();
        }
    }

    private void unpackPHPVersion() {
        String currTags = this.getValue(PREF_PHP_VERSION);
        this.versionCombo.selectValue(currTags);
    }

    private void unpackUseShortTags() {
        String value = this.getValue(PREF_SHORT_TAGS);
        this.useShortTagsButton.setSelection(Boolean.valueOf(value).booleanValue());
    }

    public PHPVersion getPHPVersionValue() {
        return PHPVersion.byAlias((String)this.getValue(PREF_PHP_VERSION));
    }

    public boolean getUseShortTagsValue() {
        return this.getBooleanValue(PREF_SHORT_TAGS);
    }

    public boolean getUseAspTagsValue() {
        return this.getBooleanValue(PREF_ASP_TAGS);
    }
}

