/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.locator.NodeFinder;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.Assert;

public abstract class AbstraceConciliatorTest {
    protected Program createProgram(IFile file) {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        Program program = null;
        try {
            program = this.createProgramFromSource(sourceModule);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return program;
    }

    public Program createProgramFromSource(IFile file) throws Exception {
        ISourceModule source = DLTKCore.createSourceModuleFrom((IFile)file);
        return this.createProgramFromSource(source);
    }

    public Program createProgramFromSource(ISourceModule source) throws Exception {
        IResource resource = source.getResource();
        IProject project = null;
        if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        }
        PHPVersion version = project != null ? ProjectOptions.getPhpVersion((IProject)project) : ProjectOptions.getDefaultPhpVersion();
        ASTParser newParser = ASTParser.newParser((PHPVersion)version, (ISourceModule)source);
        return newParser.createAST(null);
    }

    protected ASTNode locateNode(Program program, int start, int end) {
        ASTNode locateNode = NodeFinder.perform((ASTNode)program, start, end);
        return locateNode;
    }

    public IProject createProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            return project;
        }
        try {
            project.create(null);
            project.open(128, (IProgressMonitor)new NullProgressMonitor());
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
            project.setDescription(desc, null);
            project.refreshLocal(2, null);
            project.build(6, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return project;
    }

    public IProject createProject(String name, PHPVersion version) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            return project;
        }
        try {
            project.create(null);
            project.open(128, (IProgressMonitor)new NullProgressMonitor());
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
            project.setDescription(desc, null);
            ProjectOptions.setPhpVersion((PHPVersion)version, (IProject)project);
            project.refreshLocal(2, null);
            project.build(6, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return project;
    }
}

