/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.facet;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.Messages;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class PHPFacets {
    public static IStatus setFacetedVersion(IProject project, PHPVersion version) {
        if (PHPFacets.isFacetedProject(project)) {
            try {
                IProjectFacetVersion facetedVersion = PHPFacets.convertToFacetVersion(version);
                IProjectFacet phpFacet = ProjectFacetsManager.getProjectFacet((String)"php.component");
                IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
                if (!facetedVersion.equals(faceted.getInstalledVersion(phpFacet))) {
                    HashSet<IFacetedProject.Action> actions2 = new HashSet<IFacetedProject.Action>();
                    actions2.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, facetedVersion, null));
                    faceted.modify(actions2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException ex) {
                return new Status(4, "org.eclipse.php.core", Messages.PHPFacets_SettingVersionFailed, (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                return new Status(4, "org.eclipse.php.core", Messages.PHPFacets_SettingVersionFailed, (Throwable)ex);
            }
        }
        return Status.OK_STATUS;
    }

    public static boolean isFacetedProject(IProject project) {
        try {
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null) {
                IProjectFacet coreFacet = ProjectFacetsManager.getProjectFacet((String)"php.core.component");
                IProjectFacet phpFacet = ProjectFacetsManager.getProjectFacet((String)"php.component");
                if (faceted.hasProjectFacet(coreFacet) && faceted.hasProjectFacet(phpFacet)) {
                    return true;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static PHPVersion getPhpVersionFromFacets(IProject project) {
        try {
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null) {
                IProjectFacet phpFacet = ProjectFacetsManager.getProjectFacet((String)"php.component");
                IProjectFacetVersion version = faceted.getInstalledVersion(phpFacet);
                if ("5".equals(version.getVersionString())) {
                    return PHPVersion.PHP5;
                }
                if ("5.3".equals(version.getVersionString())) {
                    return PHPVersion.PHP5_3;
                }
                if ("5.4".equals(version.getVersionString())) {
                    return PHPVersion.PHP5_4;
                }
                if ("5.5".equals(version.getVersionString())) {
                    return PHPVersion.PHP5_5;
                }
                if ("5.6".equals(version.getVersionString())) {
                    return PHPVersion.PHP5_6;
                }
            }
        }
        catch (CoreException coreException) {}
        return PHPVersion.PHP5_4;
    }

    public static IProjectFacetVersion convertToFacetVersion(PHPVersion version) {
        IProjectFacet phpFacet = ProjectFacetsManager.getProjectFacet((String)"php.component");
        switch (version) {
            case PHP5: {
                return phpFacet.getVersion("5");
            }
            case PHP5_3: {
                return phpFacet.getVersion("5.3");
            }
            case PHP5_4: {
                return phpFacet.getVersion("5.4");
            }
            case PHP5_5: {
                return phpFacet.getVersion("5.5");
            }
        }
        return phpFacet.getVersion("5.6");
    }

    public static void createFacetedProject(IProject project, PHPVersion phpVersion, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        IProjectFacet coreFacet = ProjectFacetsManager.getProjectFacet((String)"php.core.component");
        fixedFacets.add(coreFacet);
        IProjectFacet phpFacet = ProjectFacetsManager.getProjectFacet((String)"php.component");
        fixedFacets.add(phpFacet);
        facetedProject.setFixedProjectFacets(fixedFacets);
        facetedProject.installProjectFacet(coreFacet.getDefaultVersion(), null, monitor);
        facetedProject.installProjectFacet(PHPFacets.convertToFacetVersion(phpVersion), null, monitor);
    }

    public static IProjectFacetVersion getCoreVersion() {
        IProjectFacet coreFacet = ProjectFacetsManager.getProjectFacet((String)"php.core.component");
        return coreFacet.getDefaultVersion();
    }
}

