/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            String[] typeNames = null;
            if (method instanceof IPHPDocAwareElement) {
                typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
            } else {
                LinkedList<String> returnTypeList = new LinkedList<String>();
                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                if (docBlock == null) {
                    return IGoal.NO_GOALS;
                }
                this.evaluateReturnType(returnTypeList, docBlock, method);
                typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
            }
            if (typeNames != null) {
                AbstractMethodReturnTypeGoal goal = (AbstractMethodReturnTypeGoal)this.getGoal();
                IType space = currentNamespace != null ? currentNamespace : method.getSourceModule();
                this.evaluated.addAll(Arrays.asList(PHPEvaluationUtils.evaluatePHPDocType(typeNames, (IModelElement)space, PHPModelUtils.getDocBlock(method).sourceStart(), goal.getTypes())));
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private void evaluateReturnType(List<String> returnTypeList, PHPDocBlock docBlock, IMethod method) {
        int n;
        int n2;
        IType[] iTypeArray;
        IType type;
        PHPDocTag[] tags = docBlock.getTags(6);
        PHPDocTag[] inherit = docBlock.getTags(35);
        if (inherit != null && inherit.length == 1 && (type = method.getDeclaringType()) != null) {
            try {
                IType[] superClasses;
                IContext context = this.goal.getContext();
                IModelAccessCache cache = null;
                if (context instanceof IModelCacheContext) {
                    cache = ((IModelCacheContext)context).getCache();
                }
                iTypeArray = superClasses = PHPModelUtils.getSuperClasses(type, cache == null ? null : cache.getSuperTypeHierarchy(type, null));
                n2 = superClasses.length;
                n = 0;
                while (n < n2) {
                    PHPDocBlock superDocBlock;
                    IType superClass = iTypeArray[n];
                    IMethod superClassMethod = superClass.getMethod(method.getElementName());
                    if (superClassMethod != null && (superDocBlock = PHPModelUtils.getDocBlock(superClassMethod)) != null) {
                        this.evaluateReturnType(returnTypeList, superDocBlock, superClassMethod);
                    }
                    ++n;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        if (tags != null && tags.length > 0) {
            PHPDocTag[] pHPDocTagArray = tags;
            int n3 = tags.length;
            int n4 = 0;
            while (n4 < n3) {
                PHPDocTag phpDocTag = pHPDocTagArray[n4];
                if (phpDocTag.getReferences() != null && phpDocTag.getReferences().length > 0) {
                    iTypeArray = phpDocTag.getReferences();
                    n2 = iTypeArray.length;
                    n = 0;
                    while (n < n2) {
                        IType ref = iTypeArray[n];
                        String type2 = ref.getName();
                        if (type2 != null) {
                            returnTypeList.add(type2);
                        }
                        ++n;
                    }
                }
                ++n4;
            }
        }
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

