/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XDebugWebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] startStopURLs;
        IProject proj;
        Server server;
        block18: {
            if (mode.equals("debug")) {
                if (XDebugLaunchListener.getInstance().isWebLaunchActive()) {
                    this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_0);
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
                PHPLaunchUtilities.showDebugView();
            }
            if ((server = ServersManager.getServer((String)configuration.getAttribute("name", ""))) == null) {
                Logger.log(4, "Launch configuration could not find server");
                this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_1);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            String fileName = configuration.getAttribute("file_name", null);
            Path filePath = new Path(fileName);
            proj = null;
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable t) {
                if (proj != null) break block18;
                Logger.logException("Could not execute the debug (Project is null).", t);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String project = proj.getFullPath().toString();
        wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(proj));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(proj));
        wc.doSave();
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(proj);
        stopAtFirstLine = wc.getAttribute("firstLineBreakpoint", stopAtFirstLine);
        String baseURL = new String(configuration.getAttribute("base_url", "").getBytes());
        IDBGpDebugTarget target = null;
        SSHTunnel tunnel = null;
        if (mode.equals("debug")) {
            String sessionId = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            DBGpProxyHandler proxyHandler = DBGpProxyHandlersManager.INSTANCE.getHandler(server.getUniqueId());
            if (proxyHandler != null && proxyHandler.useProxy()) {
                ideKey = proxyHandler.getCurrentIdeKey();
                if (!proxyHandler.registerWithProxy()) {
                    this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_2) + proxyHandler.getErrorMsg());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            startStopURLs = this.generateStartStopDebugURLs(baseURL, sessionId, ideKey);
            String launchScript = configuration.getAttribute("file_name", null);
            tunnel = PHPLaunchUtilities.getSSHTunnel(configuration);
            if (XDebugPreferenceMgr.useMultiSession()) {
                target = new DBGpMultiSessionTarget(launch, launchScript, startStopURLs[1], ideKey, stopAtFirstLine);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
                launch.addDebugTarget((IDebugTarget)target);
            } else {
                target = new DBGpTarget(launch, launchScript, startStopURLs[1], ideKey, null, stopAtFirstLine);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
            }
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)((Object)target));
            int requestPort = this.getDebugPort(server);
            if (!PHPLaunchUtilities.isDebugDaemonActive(requestPort, "org.eclipse.php.debug.core.xdebugDebugger")) {
                PHPLaunchUtilities.showLaunchErrorMessage(NLS.bind((String)PHPDebugCoreMessages.WebLaunchConfigurationDelegate_PortInUse, (Object)requestPort, (Object)server.getName()));
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = baseURL;
            startStopURLs = stringArray;
        }
        String startURL = startStopURLs[0];
        monitor.beginTask("", 10);
        monitor.subTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_3);
        try {
            PHPDebugUtil.openLaunchURL(startURL);
        }
        catch (Exception exception) {
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)((Object)target));
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            monitor.done();
            return;
        }
        monitor.worked(5);
        if (mode.equals("debug")) {
            launch.addDebugTarget(target);
            monitor.subTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_4);
            target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
        } else {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        monitor.worked(5);
        monitor.done();
    }

    protected String[] generateStartStopDebugURLs(String baseURL, String sessionId, String ideKey) {
        String[] startStopURLs = new String[2];
        baseURL = baseURL.indexOf("?") > -1 ? String.valueOf(baseURL) + "&" : String.valueOf(baseURL) + "?";
        startStopURLs[0] = String.valueOf(baseURL) + "XDEBUG_SESSION_START=" + ideKey + "&KEY=" + sessionId;
        startStopURLs[1] = String.valueOf(baseURL) + "XDEBUG_SESSION_STOP_NO_EXEC=" + ideKey + "&KEY=" + sessionId;
        return startStopURLs;
    }

    protected int getDebugPort(Server server) {
        int customRequestPort = XDebugDebuggerSettingsUtil.getDebugPort(server.getUniqueId());
        if (customRequestPort != -1) {
            return customRequestPort;
        }
        return PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.xdebugDebugger");
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)message);
            }
        });
    }
}

