/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.php.internal.core.IUniqueIdentityElement;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.UniqueIdentityElementUtil;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPExeException;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPexeItem
implements IUniqueIdentityElement,
Cloneable {
    public static final String SAPI_CLI = "CLI";
    public static final String SAPI_CGI = "CGI";
    public static final String ID_PREFIX = "php-exe";
    protected String sapiType;
    protected String name;
    protected File config;
    protected File detectedConfig;
    protected File executable;
    protected String version;
    protected boolean editable = true;
    protected boolean loadDefaultINI = false;
    protected String debuggerID;
    private String uniqueId;
    private List<PHPVersion> defaultForPHPVersionList = new ArrayList<PHPVersion>();

    public PHPexeItem() {
        this.createUniqueId();
        this.debuggerID = "org.eclipse.php.debug.core.noneDebugger";
    }

    public PHPexeItem(String name, File executable, File iniLocation, String debuggerID, boolean editable) {
        this();
        this.name = name;
        this.executable = executable;
        this.config = iniLocation;
        this.debuggerID = debuggerID;
        this.editable = editable;
        this.detectFromPHPExe();
    }

    public PHPexeItem(String name, String executable, String config, String debuggerID, boolean loadDefaultINI) {
        this();
        this.name = name;
        this.debuggerID = debuggerID;
        this.executable = new File(executable);
        if (config != null && config.length() > 0) {
            this.config = new File(config);
        }
        this.loadDefaultINI = loadDefaultINI;
        this.detectFromPHPExe();
    }

    private final void createUniqueId() {
        this.setUniqueId(UniqueIdentityElementUtil.generateId((String)ID_PREFIX));
    }

    final void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    protected void detectFromPHPExe() {
        PHPExeUtil.PHPExeInfo phpInfo;
        try {
            phpInfo = PHPExeUtil.getPHPInfo(this.executable, false);
        }
        catch (PHPExeException e) {
            Logger.logException("Could not obtain PHP executable info.", e);
            return;
        }
        if (this.name == null) {
            this.name = phpInfo.getName();
        }
        if (this.sapiType == null) {
            this.sapiType = phpInfo.getSapiType();
        }
        if (this.detectedConfig == null) {
            this.detectedConfig = phpInfo.getSystemINIFile();
        }
        if (this.version == null) {
            this.version = phpInfo.getVersion();
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getDebuggerID() {
        return this.debuggerID;
    }

    public void setDebuggerID(String debuggerID) {
        this.debuggerID = debuggerID;
    }

    public File getINILocation() {
        return this.config;
    }

    public File getDetectedINILocation() {
        return this.detectedConfig;
    }

    public void setINILocation(File location) {
        this.config = location;
    }

    public String getSapiType() {
        return this.sapiType;
    }

    public void setSapiType(String sapiType) {
        this.sapiType = sapiType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        if (executable == null) {
            throw new IllegalArgumentException("PHP executable path is null");
        }
        if (executable.equals(this.executable)) {
            return;
        }
        this.executable = executable;
        this.config = null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPexeItem other = (PHPexeItem)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf.append(" [path: ").append(this.executable.getAbsolutePath());
        buf.append(", config file: ").append(this.config.getAbsolutePath());
        buf.append(", sapi: ").append(this.sapiType);
        buf.append("]");
        return buf.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDefault() {
        return this.name.equals(PHPProjectPreferences.getModelPreferences().getString(PHPDebugCorePreferenceNames.DEFAULT_PHP));
    }

    public boolean isLoadDefaultINI() {
        return this.loadDefaultINI;
    }

    public void setLoadDefaultINI(boolean loadDefaultINI) {
        this.loadDefaultINI = loadDefaultINI;
    }

    public void setDefaultForPHPVersion(PHPexes phpexes, PHPVersion phpVersion) {
        phpexes.setItemDefaultForPHPVersion(this, phpVersion);
    }

    void addPHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.add(phpVersion);
    }

    void removePHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.remove(phpVersion);
    }

    public int geDefaultForPHPVersionSize() {
        return this.defaultForPHPVersionList.size();
    }

    public PHPVersion getPHPVersionAtDefaultList(int index) {
        assert (this.geDefaultForPHPVersionSize() > index);
        return this.defaultForPHPVersionList.get(index);
    }

    public boolean execPhpScript(IProject project, String scriptFile) {
        boolean status = false;
        if (this.executable == null) {
            throw new IllegalStateException("PHP executable path is null");
        }
        File tempPHPIni = PHPINIUtil.createPhpIniByProject(this.getDetectedINILocation(), project);
        try {
            PHPexes.changePermissions(this.executable);
            PHPExeUtil.exec(this.executable.getAbsolutePath(), this.loadDefaultINI ? "" : "-n", "-c", tempPHPIni.getParentFile().getAbsolutePath(), "-v", scriptFile);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
            status = false;
        }
        return status;
    }

    public PHPexeItem makeCopy() {
        PHPexeItem copy = new PHPexeItem();
        copy.uniqueId = this.uniqueId;
        copy.sapiType = this.sapiType;
        copy.name = this.name;
        if (this.config != null) {
            copy.config = new File(this.config.toURI());
        }
        if (this.detectedConfig != null) {
            copy.detectedConfig = new File(this.detectedConfig.toURI());
        }
        if (this.executable != null) {
            copy.executable = new File(this.executable.toURI());
        }
        copy.version = this.version;
        copy.editable = this.editable;
        copy.loadDefaultINI = this.loadDefaultINI;
        copy.debuggerID = this.debuggerID;
        copy.defaultForPHPVersionList = new ArrayList<PHPVersion>(this.defaultForPHPVersionList);
        return copy;
    }
}

