/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;

public class ExpressionValue {
    public static final int NULL_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int STRING_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    public static final int DOUBLE_TYPE = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int OBJECT_TYPE = 6;
    public static final int RESOURCE_TYPE = 7;
    public static final int VIRTUAL_CLASS_TYPE = 8;
    public static final ExpressionValue NULL_VALUE = new ExpressionValue(0, null, "null", null);
    protected int type;
    protected Expression[] children;
    protected int childrenCount = 0;
    protected Object value;
    protected String valueAsString;

    public ExpressionValue(int type, Object value, String valueAsString, Expression[] children) {
        this.type = type;
        this.value = value;
        this.valueAsString = valueAsString;
        this.children = children;
    }

    public ExpressionValue(int type, Object value, String valueAsString, Expression[] children, int childrenCount) {
        this.type = type;
        this.value = value;
        this.valueAsString = valueAsString;
        this.children = children;
        this.childrenCount = childrenCount;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public Expression[] getOriChildren() {
        return this.children;
    }

    public Expression[] getChildren() {
        return ExpressionValue.sort(this.children);
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public static Expression[] sort(Expression[] children) {
        if (PHPProjectPreferences.isSortByName()) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            Expression[] expressionArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                list.add(expression);
                ++n2;
            }
            Collections.sort(list, new Comparator<Expression>(){

                @Override
                public int compare(Expression o1, Expression o2) {
                    String o2name;
                    int o2idx;
                    String o1name = o1.getLastName();
                    int o1idx = o1name.lastIndexOf(58);
                    if (o1idx != -1) {
                        o1name = o1name.substring(o1idx + 1);
                    }
                    if ((o2idx = (o2name = o2.getLastName()).lastIndexOf(58)) != -1) {
                        o2name = o2name.substring(o2idx + 1);
                    }
                    return o1name.compareToIgnoreCase(o2name);
                }
            });
            return list.toArray(new Expression[list.size()]);
        }
        return children;
    }

    public boolean isNull() {
        return this.type == 0;
    }

    public boolean isPrimitive() {
        return this.type == 0 || this.type != 5 && this.type != 6 && this.type != 8;
    }
}

