/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;

public class PHPMultiDebugTarget
extends PHPDebugElement
implements IPHPDebugTarget,
IDebugEventSetListener {
    private ILaunch fLaunch;
    private IProcess fProcess;
    private boolean fTerminated = false;
    protected DebugOutput fDebugOutput = new DebugOutput();
    private CopyOnWriteArrayList<PHPThread> fThreads = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<PHPDebugTarget> fDebugTargets = new CopyOnWriteArrayList();

    public PHPMultiDebugTarget(ILaunch launch, IProcess process) throws CoreException {
        super(null);
        this.fLaunch = launch;
        this.fProcess = process;
        this.fProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
        ((PHPProcess)this.fProcess).setDebugTarget(this);
        this.fireCreationEvent();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() throws DebugException {
        ArrayList<IThread> threads = new ArrayList<IThread>();
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.hasThreads()) continue;
            IThread[] iThreadArray = target.getThreads();
            int n = iThreadArray.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                threads.add(thread);
                ++n2;
            }
        }
        return threads.toArray(new IThread[this.fThreads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.hasThreads()) continue;
            return true;
        }
        return false;
    }

    public String getName() throws DebugException {
        return null;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        boolean supports = false;
        if (breakpoint.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            for (PHPDebugTarget target : this.fDebugTargets) {
                if (!target.supportsBreakpoint(breakpoint)) continue;
                supports = true;
            }
        }
        return supports;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public synchronized void terminate() throws DebugException {
        if (!this.fTerminated) {
            for (PHPDebugTarget target : this.fDebugTargets) {
                target.terminate();
            }
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fProcess.terminate();
        this.fireTerminateEvent();
        this.fTerminated = true;
    }

    public boolean canResume() {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.canResume()) continue;
            return true;
        }
        return false;
    }

    public boolean canSuspend() {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.canSuspend()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.isSuspended()) continue;
            return true;
        }
        return false;
    }

    public void resume() throws DebugException {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.canResume()) continue;
            target.resume();
        }
    }

    public void suspend() throws DebugException {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (!target.canSuspend()) continue;
            target.suspend();
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        for (PHPDebugTarget target : this.fDebugTargets) {
            target.breakpointAdded(breakpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        for (PHPDebugTarget target : this.fDebugTargets) {
            target.breakpointRemoved(breakpoint, delta);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        for (PHPDebugTarget target : this.fDebugTargets) {
            target.breakpointChanged(breakpoint, delta);
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    @Override
    public DebugOutput getOutputBuffer() {
        return this.fDebugOutput;
    }

    @Override
    public boolean isWaiting() {
        return false;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            PHPDebugTarget target;
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (event.getKind() == 8 && source instanceof PHPDebugTarget && this.fDebugTargets.contains(target = (PHPDebugTarget)source)) {
                this.shutdown();
            }
            ++i;
        }
    }

    public void addSubTarget(PHPDebugTarget target) {
        this.fDebugTargets.add(target);
    }

    private void shutdown() {
        for (PHPDebugTarget target : this.fDebugTargets) {
            if (target.isTerminated()) continue;
            return;
        }
        try {
            this.terminate();
        }
        catch (DebugException e) {
            Logger.logException(e);
        }
    }
}

