/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtil;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.debug.ui.preferences.phps.NewPHPsComboBlock;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    protected final IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!"org.eclipse.php.debug.core.zendDebugger".equals(PHPExecutableLaunchTab.this.phpsComboBlock.getSelectedDebuggerId())) {
                PHPExecutableLaunchTab.this.setEnableDebugInfoOption(false);
            } else {
                PHPExecutableLaunchTab.this.setEnableDebugInfoOption(true);
            }
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    protected Text debugFileTextField;
    protected Button argumentVariablesButton;
    protected Button breakOnFirstLine;
    protected Text fPrgmArgumentsText;
    protected boolean enableDebugInfoOption;
    protected boolean enableFileSelection = true;
    protected Button fileLocationButton = null;
    protected WidgetListener fListener = new WidgetListener();
    protected Text locationField;
    protected NewPHPsComboBlock phpsComboBlock = new NewPHPsComboBlock();
    protected Button runWithDebugInfo;
    protected Label debuggerType;
    private Button configureDebugger;
    protected SelectionAdapter selectionAdapter;
    private Group debuggerGroup;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void createControl(Composite parent) {
        if (this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.setEnableDebugInfoOption(true);
        }
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(parent, 768);
        Composite mainComposite = new Composite((Composite)scrolledCompositeImpl, 0);
        this.setControl((Control)scrolledCompositeImpl);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        scrolledCompositeImpl.setContent((Control)mainComposite);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        this.createDebuggerComponent(mainComposite);
        if (this.enableFileSelection) {
            this.createFileSelectionComponent(mainComposite);
        }
        this.createArgumentsComponent(mainComposite);
        this.createDebugInfoComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.locally_debugging_a_php_script");
    }

    public Image getImage() {
        return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE_LAUNCH");
    }

    public String getName() {
        return PHPDebugUIMessages.PHPExecutableLaunchTab_2;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateLocation(configuration);
        if (this.enableDebugInfoOption) {
            this.updateDebugInfoOption(configuration);
        }
        if (this.enableFileSelection) {
            this.updateArgument(configuration);
        }
        try {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
            this.fPrgmArgumentsText.setText(configuration.getAttribute("exeDebugArguments", ""));
        }
        catch (CoreException e) {
            Logger.log(4, "Error reading configuration", e);
        }
        this.isValid(configuration);
        this.updatePHPFromConfig(configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        try {
            String exeProgramArgs;
            PHPexeItem phpExeItem;
            String phpExe = launchConfig.getAttribute("ATTR_LOCATION", "");
            boolean phpExeExists = true;
            try {
                File file = new File(phpExe);
                if (!file.exists()) {
                    phpExeExists = false;
                }
            }
            catch (NullPointerException nullPointerException) {
                phpExeExists = false;
            }
            if (!phpExeExists) {
                this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                return false;
            }
            if (this.enableFileSelection) {
                String phpFile = launchConfig.getAttribute("ATTR_FILE", "");
                if (FileUtils.resourceExists((String)phpFile)) {
                    IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
                    if (fileToData.getType() != 1 || !PHPToolkitUtil.isPhpFile((IFile)((IFile)fileToData))) {
                        this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                        return false;
                    }
                    String dataLocation = "";
                    dataLocation = fileToData.getLocation() == null ? fileToData.getFullPath().toString() : fileToData.getLocation().toOSString();
                    this.debugFileTextField.setData((Object)dataLocation);
                } else {
                    if (!new File(phpFile).exists()) {
                        this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
                        return false;
                    }
                    if (!PHPToolkitUtil.hasPhpExtention((String)phpFile)) {
                        this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                        return false;
                    }
                }
            }
            PHPexeItem pHPexeItem = phpExeItem = this.phpsComboBlock != null ? this.phpsComboBlock.getPHPexe() : null;
            if (phpExeItem == null) {
                String storedPHPexePath = launchConfig.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
                PHPexeItem pHPexeItem2 = phpExeItem = storedPHPexePath != null ? PHPRuntime.getPHPexeItem((IPath)Path.fromPortableString((String)storedPHPexePath)) : null;
            }
            if (phpExeItem != null && this.isLaunchMode("debug") && "org.eclipse.php.debug.core.noneDebugger".equals(phpExeItem.getDebuggerID())) {
                this.setErrorMessage(MessageFormat.format(PHPDebugUIMessages.PHPExecutableLaunchTab_No_debugger_is_attached, phpExeItem.getName()));
                return false;
            }
            String string = exeProgramArgs = this.fPrgmArgumentsText != null ? this.fPrgmArgumentsText.getText() : null;
            if (exeProgramArgs == null) {
                exeProgramArgs = launchConfig.getAttribute("exeDebugArguments", "");
            }
            if (exeProgramArgs.isEmpty()) return true;
            if (phpExeItem == null) return true;
            if ("CLI".equals(phpExeItem.getSapiType())) return true;
            this.setWarningMessage(PHPDebugUIMessages.PHPExecutableLaunchTab_argumentsWillNotBePassed);
            return true;
        }
        catch (CoreException coreException) {}
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scriptArguments;
        if (this.phpsComboBlock.isDefaultPHP()) {
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        } else {
            IPath containerPath = this.phpsComboBlock.getPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", portablePath);
        }
        String debuggerID = this.phpsComboBlock.getSelectedDebuggerId();
        String selectedExecutable = this.phpsComboBlock.getSelectedExecutablePath();
        if (selectedExecutable.length() == 0) {
            configuration.setAttribute("ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_LOCATION", selectedExecutable);
        }
        String iniPath = this.phpsComboBlock.getSelectedIniPath();
        if (iniPath.length() == 0) {
            configuration.setAttribute("ATTR_INI_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
        }
        configuration.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        String arguments = null;
        if (!this.enableFileSelection || (arguments = this.debugFileTextField.getText().trim()).length() == 0) {
            configuration.setAttribute("ATTR_FILE", null);
            configuration.setAttribute("ATTR_FILE_FULL_PATH", null);
        } else {
            configuration.setAttribute("ATTR_FILE", arguments);
            configuration.setAttribute("ATTR_FILE_FULL_PATH", this.debugFileTextField.getData().toString());
        }
        boolean debugInfo = this.enableDebugInfoOption ? this.runWithDebugInfo != null && this.runWithDebugInfo.getSelection() : true;
        configuration.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", debugInfo);
        if (this.breakOnFirstLine != null) {
            configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
        configuration.setAttribute("exeDebugArguments", (scriptArguments = this.fPrgmArgumentsText.getText().trim()).length() > 0 ? scriptArguments : null);
        this.applyLaunchDelegateConfiguration(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String executableLocation = configuration.getAttribute("ATTR_LOCATION", "");
            if (executableLocation.equals("")) {
                PHPexes phpExes = PHPexes.getInstance();
                PHPexeItem phpExeItem = phpExes.getDefaultItem();
                if (phpExeItem == null) {
                    return;
                }
                executableLocation = phpExeItem.getExecutable().toString();
                configuration.setAttribute("ATTR_LOCATION", executableLocation);
                String iniPath = phpExeItem.getINILocation() != null ? phpExeItem.getINILocation().toString() : null;
                configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
                configuration.setAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine());
                this.applyLaunchDelegateConfiguration(configuration);
            }
            configuration.setAttribute("exeDebugArguments", null);
        }
        catch (CoreException e) {
            Logger.log(4, "Error setting default configuration", e);
        }
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            stripped.append(element);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public void setEnableDebugInfoOption(boolean enabled) {
        if (enabled == this.enableDebugInfoOption) {
            return;
        }
        if (!this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.enableDebugInfoOption = false;
            return;
        }
        this.enableDebugInfoOption = enabled;
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setVisible(enabled);
        }
    }

    public void setEnableFileSelection(boolean enabled) {
        if (enabled == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = enabled;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(enabled);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setVisible(enabled);
        }
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        String debuggerID = null;
        try {
            debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            IDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerID);
            configuration.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected void createFileSelectionComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = PHPDebugUIMessages.PHP_File;
        group.setText(groupName);
        GridLayout layout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        this.debugFileTextField = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.debugFileTextField.setLayoutData((Object)gd);
        this.debugFileTextField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.debugFileTextField, group.getText());
        this.argumentVariablesButton = this.createPushButton((Composite)group, PHPDebugUIMessages.Browse, null);
        gd = (GridData)this.argumentVariablesButton.getLayoutData();
        gd.horizontalSpan = 1;
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    protected void createDebuggerComponent(Composite parent) {
        if (!this.isLaunchMode("debug")) {
            return;
        }
        this.debuggerGroup = SWTFactory.createGroup((Composite)parent, (String)PHPDebugUIMessages.PHPExecutableLaunchTab_Debugger_group_name, (int)3, (int)1, (int)768);
        this.debuggerType = new Label((Composite)this.debuggerGroup, 0);
        this.debuggerType.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Label separator = new Label((Composite)this.debuggerGroup, 0);
        GridData sGridData = new GridData(1);
        sGridData.widthHint = 5;
        separator.setLayoutData((Object)sGridData);
        this.configureDebugger = this.createPushButton((Composite)this.debuggerGroup, "Configure...", null);
        this.configureDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPExecutableLaunchTab.this.handleConfigureDebuggerSelected();
            }
        });
        this.breakOnFirstLine = this.createCheckButton((Composite)this.debuggerGroup, PHPDebugUIMessages.Breakpoint_Group_BreakAtFirstLine);
        this.breakOnFirstLine.setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        this.breakOnFirstLine.addSelectionListener((SelectionListener)this.fListener);
        this.updateDebugger();
        this.updateLaunchConfigurationDialog();
    }

    protected void handleConfigureDebuggerSelected() {
        PHPexeItem phpExe = this.phpsComboBlock.getPHPexe();
        if (phpExe != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            NullProgressMonitor monitor = new NullProgressMonitor();
            PHPExeEditDialog dialog = new PHPExeEditDialog(shell, phpExe, PHPexes.getInstance().getAllItems(), "org.eclipse.php.internal.ui.fragments.debuggerCompositeFragment");
            if (dialog.open() == 1) {
                monitor.setCanceled(true);
                return;
            }
            this.updateDebugger();
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void createDebugInfoComponent(Composite parent) {
        this.runWithDebugInfo = new Button(parent, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        this.runWithDebugInfo.setLayoutData((Object)new GridData(768));
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.runWithDebugInfo.setVisible(this.enableDebugInfoOption);
    }

    protected void createLocationComponent(Composite parent) {
        Layout layout;
        this.phpsComboBlock.createControl(parent);
        Control control = this.phpsComboBlock.getControl();
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        this.phpsComboBlock.addPropertyChangeListener(this.fPropertyChangeListener);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
    }

    protected void createArgumentsComponent(final Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(PHPDebugUIMessages.PHPExecutableLaunchTab_scriptArguments);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        this.fPrgmArgumentsText.setLayoutData((Object)new GridData(1808));
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addControlAccessibleListener((Control)this.fPrgmArgumentsText, group.getText());
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, PHPDebugUIMessages.PHPExecutableLaunchTab_variables, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(PHPExecutableLaunchTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    PHPExecutableLaunchTab.this.fPrgmArgumentsText.insert(variable);
                    PHPExecutableLaunchTab.this.fPrgmArgumentsText.setFont(parent.getFont());
                }
            }
        });
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateDebugger();
        this.updateLaunchConfigurationDialog();
    }

    protected void handleChangeFileToDebug(Text textField) {
        IResource resource = LaunchUtilities.getFileFromDialog(null, this.getShell(), LaunchUtil.getFileExtensions(), LaunchUtil.getRequiredNatures(), true);
        if (resource instanceof IFile) {
            textField.setText(resource.getFullPath().toString());
            String fileLocation = "";
            IPath location = resource.getLocation();
            fileLocation = location != null ? location.toOSString() : resource.getFullPath().toString();
            textField.setData((Object)fileLocation);
        }
    }

    protected void updatePHPFromConfig(ILaunchConfiguration config) {
        if (this.enableFileSelection) {
            this.phpsComboBlock.setProject(this.getFileProject(this.debugFileTextField.getText()));
        }
        try {
            String path = config.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
            if (path != null) {
                this.phpsComboBlock.setPath(Path.fromPortableString((String)path));
            }
        }
        catch (CoreException coreException) {}
    }

    protected IProject getFileProject(String phpFile) {
        if (FileUtils.resourceExists((String)phpFile)) {
            IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
            return fileToData.getProject();
        }
        return null;
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        String fullPath = "";
        try {
            arguments = configuration.getAttribute("ATTR_FILE", "");
            fullPath = configuration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException ce) {
            Logger.log(4, "Error reading configuration", ce);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setText(arguments);
            this.debugFileTextField.setData((Object)fullPath);
        }
    }

    protected void updateDebugInfoOption(ILaunchConfiguration configuration) {
        boolean runOption = PHPDebugPlugin.getDebugInfoOption();
        try {
            runOption = configuration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", runOption);
        }
        catch (CoreException e) {
            Logger.log(4, "Error reading configuration", e);
        }
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setSelection(runOption);
        }
    }

    protected void updateLocation(ILaunchConfiguration configuration) {
        String debuggerID = "";
        try {
            debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
        }
        catch (CoreException ce) {
            Logger.log(4, "Error reading configuration", ce);
        }
        if (!"org.eclipse.php.debug.core.zendDebugger".equals(debuggerID)) {
            this.setEnableDebugInfoOption(false);
        }
    }

    protected void updateDebugger() {
        if (!this.isLaunchMode("debug")) {
            return;
        }
        PHPexeItem exeItem = this.phpsComboBlock.getPHPexe();
        String debuggerID = exeItem.getDebuggerID();
        if (PHPDebuggersRegistry.isNoneDebugger((String)debuggerID)) {
            this.breakOnFirstLine.setEnabled(false);
        } else {
            this.breakOnFirstLine.setEnabled(true);
        }
        String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)debuggerID);
        this.debuggerType.setText(String.valueOf(PHPDebugUIMessages.PHPExecutableLaunchTab_PHP_debugger_type) + debuggerName);
        this.debuggerGroup.layout();
    }

    protected boolean isLaunchMode(String mode) {
        return mode.equals(this.getLaunchConfigurationDialog().getMode());
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            PHPExecutableLaunchTab.this.phpsComboBlock.setProject(PHPExecutableLaunchTab.this.getFileProject(PHPExecutableLaunchTab.this.debugFileTextField.getText()));
        }

        public void widgetSelected(SelectionEvent e) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (source == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleChangeFileToDebug(PHPExecutableLaunchTab.this.debugFileTextField);
            } else if (source == PHPExecutableLaunchTab.this.breakOnFirstLine) {
                PHPExecutableLaunchTab.this.handleBreakButtonSelected();
            }
        }
    }
}

