/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.core.IUniqueIdentityElement;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsProviderRegistry;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.wizards.DebuggerSettingsSectionBuildersRegistry;
import org.eclipse.php.internal.debug.ui.wizards.DebuggerUnsupportedSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSectionBuilder;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DebuggerCompositeFragment
extends CompositeFragment {
    public static final String ID = "org.eclipse.php.internal.ui.fragments.debuggerCompositeFragment";
    private List<String> debuggersIds;
    private Combo debuggerCombo;
    private Button debuggerTest;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;
    private IDebuggerSettingsSection debuggerSettingsSection;
    private IDebuggerSettingsWorkingCopy debuggerSettingsWC;
    private Map<String, IDebuggerSettingsWorkingCopy> settingsWCBuffer = new HashMap<String, IDebuggerSettingsWorkingCopy>();
    private String detectedDebuggerId = null;
    private Composite debuggerSettingsComposite;
    private Composite mainComposite;

    public DebuggerCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
    }

    public String getId() {
        return ID;
    }

    public boolean performOk() {
        boolean isOK;
        if (this.debuggerSettingsSection != null && !(isOK = this.debuggerSettingsSection.performOK())) {
            return isOK;
        }
        if (this.debuggerSettingsWC != null) {
            if (this.debuggerSettingsWC.isDirty()) {
                DebuggerSettingsManager.INSTANCE.save(this.debuggerSettingsWC);
            }
            DebuggerSettingsManager.INSTANCE.dropWorkingCopy(this.debuggerSettingsWC);
        }
        return true;
    }

    public boolean performCancel() {
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsSection.performCancel();
        }
        if (this.debuggerSettingsWC != null) {
            DebuggerSettingsManager.INSTANCE.dropWorkingCopy(this.debuggerSettingsWC);
        }
        return super.performCancel();
    }

    public void validate() {
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsSection.validate();
        }
    }

    public void setData(Object debuggerOwner) throws IllegalArgumentException {
        if (debuggerOwner != null && !(debuggerOwner instanceof IUniqueIdentityElement)) {
            throw new IllegalArgumentException("The given object is not a PHP Server or Executable");
        }
        this.createDescription(debuggerOwner);
        super.setData(debuggerOwner);
        this.init();
        this.validate();
    }

    public IUniqueIdentityElement getDebuggerOwner() {
        return (IUniqueIdentityElement)this.getData();
    }

    void createSettings(String debuggerId) {
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner == null || debuggerId == null) {
            return;
        }
        IDebuggerSettings settings = DebuggerSettingsManager.INSTANCE.findSettings(debuggerOwner.getUniqueId(), debuggerId);
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsComposite.dispose();
        }
        this.debuggerSettingsComposite = new Composite(this.mainComposite, 0);
        this.debuggerSettingsComposite.setLayout((Layout)new GridLayout());
        this.debuggerSettingsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        if ("org.eclipse.php.debug.core.noneDebugger".equals(debuggerId)) {
            this.debuggerSettingsSection = new EmptySettingsSection(this.debuggerSettingsComposite);
        } else if (settings == null) {
            this.debuggerSettingsSection = new DebuggerUnsupportedSettingsSection(this, this.debuggerSettingsComposite);
        } else {
            this.debuggerSettingsWC = this.getSettingsWC(debuggerId, settings);
            IDebuggerSettingsProvider provider = DebuggerSettingsProviderRegistry.getProvider((String)debuggerId);
            IDebuggerSettingsSectionBuilder sectionBuilder = DebuggerSettingsSectionBuildersRegistry.getBuilder(provider.getId());
            this.debuggerSettingsSection = sectionBuilder.build(this, this.debuggerSettingsComposite, this.debuggerSettingsWC);
        }
        if (!this.debuggerSettingsSection.canTest()) {
            this.debuggerTest.setVisible(false);
        } else {
            this.debuggerTest.setVisible(true);
        }
        this.getParent().layout(true, true);
    }

    IDebuggerSettingsWorkingCopy getSettingsWC(String debuggerId, IDebuggerSettings settings) {
        IDebuggerSettingsWorkingCopy debuggerSettingsWC = this.settingsWCBuffer.get(debuggerId);
        if (debuggerSettingsWC == null) {
            debuggerSettingsWC = DebuggerSettingsManager.INSTANCE.fetchWorkingCopy(settings);
            this.settingsWCBuffer.put(debuggerId, debuggerSettingsWC);
        }
        return debuggerSettingsWC;
    }

    protected void createDescription(Object owner) {
        if (owner instanceof PHPexeItem) {
            this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_DEBUG_PHPEXE"));
            this.setDescription(Messages.DebuggerCompositeFragment_Configure_exe_debugger_settings);
        } else if (owner instanceof Server) {
            this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_DEBUG_SERVER"));
            this.setDescription(Messages.DebuggerCompositeFragment_Configure_server_debugger_settings);
        }
        this.setDisplayName(Messages.DebuggerCompositeFragment_Debugger);
        this.setTitle(Messages.DebuggerCompositeFragment_Debugger_settings);
        this.controlHandler.setTitle(this.getTitle());
        this.controlHandler.setImageDescriptor(this.getImageDescriptor());
        this.controlHandler.setDescription(this.getDescription());
    }

    protected void createContents(Composite parent) {
        this.debuggersIds = new LinkedList<String>(PHPDebuggersRegistry.getDebuggersIds());
        this.mainComposite = parent;
        Composite debuggerChoice = new Composite(parent, 0);
        GridLayout dcLayout = new GridLayout();
        dcLayout.numColumns = 3;
        debuggerChoice.setLayout((Layout)dcLayout);
        debuggerChoice.setLayoutData((Object)new GridData(4, 4, true, false));
        Label debuggerLabel = new Label(debuggerChoice, 0);
        debuggerLabel.setText("Debugger:");
        debuggerLabel.setLayoutData((Object)new GridData());
        this.debuggerCombo = new Combo(debuggerChoice, 12);
        GridData dcData = new GridData(16384, 4, false, false);
        this.debuggerCombo.setLayoutData((Object)dcData);
        this.debuggerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DebuggerCompositeFragment.this.getDebuggerOwner() != null) {
                    ((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId = (String)DebuggerCompositeFragment.this.debuggersIds.get(DebuggerCompositeFragment.this.debuggerCombo.getSelectionIndex());
                    DebuggerCompositeFragment.this.updateItem();
                    DebuggerCompositeFragment.this.createSettings(((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId);
                    DebuggerCompositeFragment.this.validate();
                }
            }
        });
        this.debuggerTest = SWTFactory.createPushButton((Composite)debuggerChoice, (String)Messages.DebuggerCompositeFragment_Test_button, null);
        this.debuggerTest.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DebuggerCompositeFragment.this.debuggerSettingsSection != null) {
                    DebuggerCompositeFragment.this.debuggerSettingsSection.performTest();
                }
            }
        });
        int i = 0;
        while (i < this.debuggersIds.size()) {
            String id = this.debuggersIds.get(i);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)id);
            this.debuggerCombo.add(debuggerName, i);
            ++i;
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
        this.debuggerCombo.forceFocus();
    }

    protected void init() {
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner == null) {
            return;
        }
        if (debuggerOwner instanceof Server) {
            this.originalValuesCache.debuggerId = ((Server)debuggerOwner).getDebuggerId();
        } else if (debuggerOwner instanceof PHPexeItem) {
            this.originalValuesCache.debuggerId = ((PHPexeItem)debuggerOwner).getDebuggerID();
        }
        if (this.modifiedValuesCache == null) {
            this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        }
        this.setDebugger();
    }

    private void setDebugger() {
        String debuggerId = null;
        if (this.modifiedValuesCache.debuggerId != null) {
            debuggerId = this.modifiedValuesCache.debuggerId;
        } else {
            this.detectDebugger();
            debuggerId = this.detectedDebuggerId == null ? PHPDebugPlugin.getCurrentDebuggerId() : (this.modifiedValuesCache.debuggerId = this.detectedDebuggerId);
        }
        String name = PHPDebuggersRegistry.getDebuggerName((String)debuggerId);
        String[] values = this.debuggerCombo.getItems();
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(name)) {
                this.debuggerCombo.select(i);
                break;
            }
            ++i;
        }
    }

    private void detectDebugger() {
        IUniqueIdentityElement data = (IUniqueIdentityElement)this.getData();
        if (data instanceof PHPexeItem) {
            AbstractDebuggerConfiguration[] debuggers;
            PHPexeItem exeItem = (PHPexeItem)data;
            List modules = PHPExeUtil.getModules((PHPexeItem)exeItem);
            AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
            int n = debuggers.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                for (PHPExeUtil.PHPModuleInfo module : modules) {
                    if (!module.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                    this.detectedDebuggerId = debugger.getDebuggerId();
                    break;
                }
                ++n2;
            }
            if (this.detectedDebuggerId == null) {
                this.detectedDebuggerId = "org.eclipse.php.debug.core.noneDebugger";
            }
        }
    }

    private void updateItem() {
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner instanceof Server) {
            ((Server)debuggerOwner).setDebuggerId(this.modifiedValuesCache.debuggerId);
        } else if (debuggerOwner instanceof PHPexeItem) {
            ((PHPexeItem)debuggerOwner).setDebuggerID(this.modifiedValuesCache.debuggerId);
        }
    }

    private class EmptySettingsSection
    implements IDebuggerSettingsSection {
        private EmptySettingsSection(Composite settingsComposite) {
            Composite empty = new Composite(settingsComposite, 0);
            empty.setLayoutData((Object)new GridData(4, 4, true, true));
        }

        @Override
        public boolean performOK() {
            return true;
        }

        @Override
        public boolean performCancel() {
            return true;
        }

        @Override
        public void validate() {
            DebuggerCompositeFragment.this.setMessage(DebuggerCompositeFragment.this.getDescription(), 0);
        }

        @Override
        public boolean canTest() {
            return false;
        }

        @Override
        public void performTest() {
        }
    }

    private class ValuesCache {
        String debuggerId;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache cache) {
            this.debuggerId = cache.debuggerId;
        }
    }
}

